/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hellominecraft.launcher.core.service;

import java.io.File;
import java.util.Collection;
import org.jackhuang.hellominecraft.launcher.core.GameException;
import org.jackhuang.hellominecraft.launcher.core.service.IMinecraftService;
import org.jackhuang.hellominecraft.launcher.core.version.DecompressLibraryJob;
import org.jackhuang.hellominecraft.launcher.core.version.MinecraftVersion;
import org.jackhuang.hellominecraft.util.EventHandler;
import org.jackhuang.hellominecraft.util.func.Consumer;
import org.jackhuang.hellominecraft.util.func.Predicate;

public abstract class IMinecraftProvider {
    protected IMinecraftService service;
    public final EventHandler<IMinecraftService> onRefreshingVersions = new EventHandler(this);
    public final EventHandler<IMinecraftService> onRefreshedVersions = new EventHandler(this);
    public final EventHandler<String> onLoadedVersion = new EventHandler(this);

    public IMinecraftProvider(IMinecraftService service) {
        this.service = service;
    }

    public abstract void initializeMiencraft();

    public abstract File getRunDirectory(String var1);

    public abstract File versionRoot(String var1);

    public File getRunDirectory(String id, String subFolder) {
        return new File(this.getRunDirectory(id), subFolder);
    }

    public abstract void open(String var1, String var2);

    public abstract boolean install(String var1, Consumer<MinecraftVersion> var2);

    public abstract DecompressLibraryJob getDecompressLibraries(MinecraftVersion var1) throws GameException;

    public abstract File getDecompressNativesToLocation(MinecraftVersion var1);

    public abstract File getMinecraftJar(String var1);

    public abstract boolean renameVersion(String var1, String var2);

    public abstract boolean removeVersionFromDisk(String var1);

    public abstract MinecraftVersion getOneVersion(Predicate<MinecraftVersion> var1);

    public abstract Collection<MinecraftVersion> getVersions();

    public abstract MinecraftVersion getVersionById(String var1);

    public abstract int getVersionCount();

    public abstract void refreshVersions();

    public abstract void cleanFolder();

    public abstract boolean onLaunch(String var1);

    public File baseDirectory() {
        return this.service.baseDirectory();
    }
}

