/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hellominecraft.launcher.core.mod;

import java.awt.Dimension;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.file.FileSystemException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.zip.ZipFile;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import org.jackhuang.hellominecraft.launcher.core.GameException;
import org.jackhuang.hellominecraft.launcher.core.mod.ModpackManager$$Lambda$1;
import org.jackhuang.hellominecraft.launcher.core.mod.ModpackManager$$Lambda$2;
import org.jackhuang.hellominecraft.launcher.core.mod.ModpackManager$$Lambda$3;
import org.jackhuang.hellominecraft.launcher.core.mod.ModpackManager$1$$Lambda$1;
import org.jackhuang.hellominecraft.launcher.core.service.IMinecraftProvider;
import org.jackhuang.hellominecraft.launcher.core.service.IMinecraftService;
import org.jackhuang.hellominecraft.launcher.core.version.MinecraftVersion;
import org.jackhuang.hellominecraft.util.C;
import org.jackhuang.hellominecraft.util.MinecraftVersionRequest;
import org.jackhuang.hellominecraft.util.func.BiFunction;
import org.jackhuang.hellominecraft.util.func.CallbackIO;
import org.jackhuang.hellominecraft.util.logging.HMCLog;
import org.jackhuang.hellominecraft.util.system.Compressor;
import org.jackhuang.hellominecraft.util.system.FileUtils;
import org.jackhuang.hellominecraft.util.system.ZipEngine;
import org.jackhuang.hellominecraft.util.tasks.NoShownTaskException;
import org.jackhuang.hellominecraft.util.tasks.Task;
import org.jackhuang.hellominecraft.util.ui.WebPage;

public final class ModpackManager {
    public static final List<String> MODPACK_BLACK_LIST = Arrays.asList("usernamecache.json", "asm", "logs", "backups", "versions", "assets", "usercache.json", "libraries", "crash-reports", "launcher_profiles.json", "NVIDIA", "AMD", "TCNodeTracker", "screenshots", "natives", "native", "$native", "pack.json", "launcher.jar", "minetweaker.log", "launcher.pack.lzma", "hmclmc.log");
    public static final List<String> MODPACK_SUGGESTED_BLACK_LIST = Arrays.asList("fonts", "saves", "servers.dat", "options.txt", "optionsof.txt", "journeymap", "optionsshaders.txt", "mods/VoxelMods");
    public static final BiFunction<String, Boolean, Integer> MODPACK_PREDICATE = ModpackManager$$Lambda$3.lambdaFactory$();
    public static final BiFunction<String, Boolean, Boolean> MODPACK_BLACK_LIST_PREDICATE = ModpackManager.modpackPredicateMaker(MODPACK_BLACK_LIST);
    public static final BiFunction<String, Boolean, Boolean> MODPACK_SUGGESTED_BLACK_LIST_PREDICATE = ModpackManager.modpackPredicateMaker(MODPACK_SUGGESTED_BLACK_LIST);

    public static Task install(final JFrame parFrame, final File input, final IMinecraftService service, final String idFUCK) {
        return new Task(){
            Collection<Task> c = new ArrayList<Task>();

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void executeTask() throws Throwable {
                String id = idFUCK;
                String description = C.i18n("modpack.task.install.will", new Object[0]);
                ZipFile zip = new ZipFile(input);
                Throwable throwable = null;
                try {
                    HashMap map = C.GSON.fromJson((Reader)new InputStreamReader(zip.getInputStream(zip.getEntry("modpack.json")), "UTF-8"), HashMap.class);
                    if (map != null) {
                        if (id == null && map.containsKey("name") && map.get("name") instanceof String) {
                            id = (String)map.get("name");
                        }
                        if (id != null) {
                            description = description + id;
                        }
                        if (map.containsKey("description") && map.get("description") instanceof String) {
                            description = description + "\n" + (String)map.get("description");
                        }
                    }
                    if (id == null) {
                        throw new IllegalStateException("Illegal modpack id!");
                    }
                }
                catch (Throwable map) {
                    throwable = map;
                    throw map;
                }
                finally {
                    if (zip != null) {
                        if (throwable != null) {
                            try {
                                zip.close();
                            }
                            catch (Throwable map) {
                            }
                        } else {
                            zip.close();
                        }
                    }
                }
                Object[] msgs = new Object[]{C.i18n("modpack.task.install", new Object[0]), new WebPage(description)};
                ((WebPage)msgs[1]).setPreferredSize(new Dimension(800, 350));
                int result = JOptionPane.showOptionDialog(parFrame, msgs, (String)msgs[0], 0, 3, null, null, null);
                if (result == 1) {
                    throw new NoShownTaskException("Operation was canceled by user.");
                }
                File versions = new File(service.baseDirectory(), "versions");
                File oldFile = new File(versions, "minecraft");
                File newFile = null;
                if (oldFile.exists()) {
                    newFile = new File(versions, "minecraft-" + System.currentTimeMillis());
                    if (newFile.isDirectory()) {
                        FileUtils.deleteDirectory(newFile);
                    } else if (newFile.isFile() && !newFile.delete()) {
                        HMCLog.warn("Failed to delete file " + newFile);
                    }
                    if (!oldFile.renameTo(newFile)) {
                        HMCLog.warn("Failed to rename " + oldFile + " to " + newFile);
                    }
                }
                File preVersion = new File(versions, id);
                File preVersionRenamed = null;
                if (preVersion.exists()) {
                    HMCLog.log("Backing up the game");
                    String preId = id + "-" + System.currentTimeMillis();
                    preVersionRenamed = new File(versions, preId);
                    if (!preVersion.renameTo(preVersionRenamed)) {
                        HMCLog.warn("Failed to rename pre-version folder " + preVersion + " to a temp folder " + preVersionRenamed);
                    }
                    if (!new File(preVersionRenamed, id + ".json").renameTo(new File(preVersionRenamed, preId + ".json"))) {
                        HMCLog.warn("Failed to rename pre json to new json");
                    }
                    if (!new File(preVersionRenamed, id + ".jar").renameTo(new File(preVersionRenamed, preId + ".jar"))) {
                        HMCLog.warn("Failed to rename pre jar to new jar");
                    }
                }
                try {
                    AtomicInteger b = new AtomicInteger(0);
                    HMCLog.log("Decompressing modpack");
                    Compressor.unzip(input, versions, ModpackManager$1$$Lambda$1.lambdaFactory$(b), true);
                    if (b.get() < 1) {
                        throw new FileNotFoundException(C.i18n("modpack.incorrect_format.no_json", new Object[0]));
                    }
                    File nowFile = new File(versions, id);
                    if (oldFile.exists() && !oldFile.renameTo(nowFile)) {
                        HMCLog.warn("Failed to rename incorrect json " + oldFile + " to " + nowFile);
                    }
                    File json = new File(nowFile, "pack.json");
                    MinecraftVersion mv = C.GSON.fromJson(FileUtils.read(json), MinecraftVersion.class);
                    if (mv.jar == null) {
                        throw new FileNotFoundException(C.i18n("modpack.incorrect_format.no_jar", new Object[0]));
                    }
                    this.c.add(service.download().downloadMinecraftJar(mv, new File(nowFile, id + ".jar")));
                    mv.jar = null;
                    FileUtils.write(json, C.GSON.toJson(mv));
                    if (!json.renameTo(new File(nowFile, id + ".json"))) {
                        HMCLog.warn("Failed to rename pack.json to new id");
                    }
                    if (preVersionRenamed != null) {
                        HMCLog.log("Restoring saves");
                        File presaves = new File(preVersionRenamed, "saves");
                        File saves = new File(nowFile, "saves");
                        if (presaves.exists()) {
                            FileUtils.deleteDirectory(saves);
                            FileUtils.copyDirectory(presaves, saves);
                        }
                    }
                }
                finally {
                    FileUtils.deleteDirectoryQuietly(oldFile);
                    if (newFile != null) {
                        newFile.renameTo(oldFile);
                    }
                }
            }

            @Override
            public String getInfo() {
                return C.i18n("modpack.task.install", new Object[0]);
            }

            @Override
            public Collection<Task> getAfterTasks() {
                return this.c;
            }

            private static /* synthetic */ boolean lambda$executeTask$9(AtomicInteger b, String t) {
                if (t.equals("minecraft/pack.json")) {
                    b.incrementAndGet();
                }
                return true;
            }

            static /* synthetic */ boolean access$lambda$0(AtomicInteger atomicInteger, String string) {
                return 1.lambda$executeTask$9(atomicInteger, string);
            }
        };
    }

    private static BiFunction<String, Boolean, Boolean> modpackPredicateMaker(List<String> l) {
        return ModpackManager$$Lambda$1.lambdaFactory$(l);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void export(File output, IMinecraftProvider provider, String version, List<String> blacklist, Map modpackJson, CallbackIO<ZipEngine> callback) throws IOException, GameException {
        ArrayList<String> b = new ArrayList<String>(MODPACK_BLACK_LIST);
        if (blacklist != null) {
            b.addAll(blacklist);
        }
        b.add(version + ".jar");
        b.add(version + ".json");
        HMCLog.log("Compressing game files without some files in blacklist, including files or directories: usernamecache.json, asm, logs, backups, versions, assets, usercache.json, libraries, crash-reports, launcher_profiles.json, NVIDIA, TCNodeTracker");
        ZipEngine zip = null;
        try {
            zip = new ZipEngine(output);
            zip.putDirectory(provider.getRunDirectory(version), ModpackManager$$Lambda$2.lambdaFactory$(b));
            MinecraftVersion mv = provider.getVersionById(version).resolve(provider);
            MinecraftVersionRequest r = MinecraftVersionRequest.minecraftVersion(provider.getMinecraftJar(version));
            if (r.type != 4) {
                throw new FileSystemException(C.i18n("modpack.cannot_read_version", new Object[0]) + ": " + MinecraftVersionRequest.getResponse(r));
            }
            mv.jar = r.version;
            mv.runDir = "version";
            zip.putTextFile(C.GSON.toJson(mv), "minecraft/pack.json");
            zip.putTextFile(C.GSON.toJson(modpackJson), "modpack.json");
            if (callback != null) {
                callback.call(zip);
            }
        }
        finally {
            if (zip != null) {
                zip.closeFile();
            }
        }
    }

    private static /* synthetic */ String lambda$export$12(ArrayList b, String x, Boolean y) {
        for (String s : b) {
            if (!(y != false ? x.startsWith(s + "/") : x.equals(s))) continue;
            return null;
        }
        return "minecraft/" + x;
    }

    private static /* synthetic */ Boolean lambda$modpackPredicateMaker$11(List l, String x, Boolean y) {
        for (String s : l) {
            if (!(y != false ? x.startsWith(s + "/") : x.equals(s))) continue;
            return true;
        }
        return false;
    }

    private static /* synthetic */ Integer lambda$static$10(String x, Boolean y) {
        if (MODPACK_BLACK_LIST_PREDICATE.apply(x, y).booleanValue()) {
            return 1;
        }
        if (MODPACK_SUGGESTED_BLACK_LIST_PREDICATE.apply(x, y).booleanValue()) {
            return 2;
        }
        return 0;
    }

    static /* synthetic */ Boolean access$lambda$0(List list, String string, Boolean bl) {
        return ModpackManager.lambda$modpackPredicateMaker$11(list, string, bl);
    }

    static /* synthetic */ String access$lambda$1(ArrayList arrayList, String string, Boolean bl) {
        return ModpackManager.lambda$export$12(arrayList, string, bl);
    }

    static /* synthetic */ Integer access$lambda$2(String string, Boolean bl) {
        return ModpackManager.lambda$static$10(string, bl);
    }
}

