/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hellominecraft.launcher.core.mod;

import com.google.gson.JsonSyntaxException;
import com.google.gson.reflect.TypeToken;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.reflect.Type;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.jackhuang.hellominecraft.util.C;
import org.jackhuang.hellominecraft.util.StrUtils;
import org.jackhuang.hellominecraft.util.logging.HMCLog;
import org.jackhuang.hellominecraft.util.system.FileUtils;

public class ModInfo
implements Comparable<ModInfo> {
    public File location;
    public String modid;
    public String name;
    public String description;
    public String author;
    public String version;
    public String mcversion;
    public String url;
    public String updateUrl;
    public String credits;
    public String[] authorList;
    private static final Type TYPE = new TypeToken<List<ModInfo>>(){}.getType();

    public boolean isActive() {
        return !this.location.getName().endsWith(".disabled");
    }

    public void reverseModState() {
        File f;
        File newf = (f = this.location).getName().endsWith(".disabled") ? new File(f.getParentFile(), f.getName().substring(0, f.getName().length() - ".disabled".length())) : new File(f.getParentFile(), f.getName() + ".disabled");
        if (f.renameTo(newf)) {
            this.location = newf;
        }
    }

    @Override
    public int compareTo(ModInfo o) {
        return this.getFileName().compareToIgnoreCase(o.getFileName());
    }

    public String getName() {
        return this.name == null ? FileUtils.removeExtension(this.location.getName()) : this.name;
    }

    public String getAuthor() {
        if (this.authorList != null && this.authorList.length > 0) {
            return StrUtils.parseParams("", (Object[])this.authorList, ", ");
        }
        if (StrUtils.isNotBlank(this.author)) {
            return this.author;
        }
        return "Unknown";
    }

    public boolean equals(Object obj) {
        return obj != null && obj instanceof ModInfo && (((ModInfo)obj).location == this.location || ((ModInfo)obj).location.equals(this.location));
    }

    public int hashCode() {
        return this.location.hashCode();
    }

    public String toString() {
        return this.getFileName();
    }

    public String getFileName() {
        String n = this.location.getName();
        return FileUtils.removeExtension(this.isActive() ? n : n.substring(0, n.length() - ".disabled".length()));
    }

    public static boolean isFileMod(File file) {
        if (file == null) {
            return false;
        }
        String name = file.getName();
        boolean disabled = name.endsWith(".disabled");
        if (disabled) {
            name = name.substring(0, name.length() - ".disabled".length());
        }
        return name.endsWith(".zip") || name.endsWith(".jar") || name.endsWith("litemod");
    }

    private static ModInfo getForgeModInfo(File f, ZipFile jar, ZipEntry entry) throws IOException {
        ModInfo i = new ModInfo();
        i.location = f;
        List m = (List)C.GSON.fromJson((Reader)new InputStreamReader(jar.getInputStream(entry), "UTF-8"), TYPE);
        if (m != null && m.size() > 0) {
            i = (ModInfo)m.get(0);
            i.location = f;
        }
        return i;
    }

    private static ModInfo getLiteLoaderModInfo(File f, ZipFile jar, ZipEntry entry) throws IOException {
        ModInfo m = C.GSON.fromJson((Reader)new InputStreamReader(jar.getInputStream(entry), "UTF-8"), ModInfo.class);
        if (m == null) {
            m = new ModInfo();
        }
        m.location = f;
        return m;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static ModInfo readModInfo(File f) {
        ModInfo i = new ModInfo();
        i.location = f;
        try {
            ZipFile jar = new ZipFile(f);
            Throwable throwable = null;
            try {
                ZipEntry entry = jar.getEntry("mcmod.info");
                if (entry != null) {
                    ModInfo modInfo = ModInfo.getForgeModInfo(f, jar, entry);
                    return modInfo;
                }
                entry = jar.getEntry("litemod.json");
                if (entry != null) {
                    ModInfo modInfo = ModInfo.getLiteLoaderModInfo(f, jar, entry);
                    return modInfo;
                }
                ModInfo modInfo = i;
                return modInfo;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (jar != null) {
                    if (throwable != null) {
                        try {
                            jar.close();
                        }
                        catch (Throwable throwable3) {
                        }
                    } else {
                        jar.close();
                    }
                }
            }
        }
        catch (IOException ex) {
            HMCLog.warn("File " + f + " is not a jar.", ex);
            return i;
        }
        catch (JsonSyntaxException jsonSyntaxException) {
            // empty catch block
        }
        return i;
    }
}

