/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hellominecraft.launcher.core.launch;

import java.io.File;
import java.net.URL;
import org.jackhuang.hellominecraft.launcher.core.download.DownloadLibraryJob;
import org.jackhuang.hellominecraft.util.C;
import org.jackhuang.hellominecraft.util.tasks.download.FileDownloadTask;

public class LibraryDownloadTask
extends FileDownloadTask {
    DownloadLibraryJob job;

    public LibraryDownloadTask(DownloadLibraryJob job) {
        this.job = job;
    }

    @Override
    public void executeTask() throws Throwable {
        String[] s;
        String name = this.job.lib.name;
        if (name.startsWith("net.minecraftforge:forge:") && (s = name.split(":")).length == 3) {
            this.job.url = "http://files.minecraftforge.net/maven/net/minecraftforge/forge/" + s[2] + "/forge-" + s[2] + "-universal.jar";
        }
        if (name.startsWith("com.mumfrey:liteloader:") && (s = name.split(":")).length == 3 && s[2].length() > 3) {
            this.job.url = "http://dl.liteloader.com/versions/com/mumfrey/liteloader/" + s[2].substring(0, s[2].length() - 3) + "/liteloader-" + s[2] + ".jar";
        }
        this.download(new URL(this.job.url), this.job.path);
    }

    void download(URL url, File filePath) throws Throwable {
        this.url = url;
        this.filePath = filePath;
        super.executeTask();
    }

    @Override
    public String getInfo() {
        return C.i18n("download", new Object[0]) + ": " + this.job.lib.name;
    }
}

