/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hellominecraft.launcher.core.launch;

import java.io.File;
import java.io.IOException;
import java.util.HashSet;
import java.util.List;
import org.jackhuang.hellominecraft.launcher.core.auth.IAuthenticator;
import org.jackhuang.hellominecraft.launcher.core.auth.LoginInfo;
import org.jackhuang.hellominecraft.launcher.core.download.DownloadLibraryJob;
import org.jackhuang.hellominecraft.launcher.core.launch.DefaultGameLauncher$$Lambda$1;
import org.jackhuang.hellominecraft.launcher.core.launch.DefaultGameLauncher$$Lambda$2;
import org.jackhuang.hellominecraft.launcher.core.launch.DefaultGameLauncher$$Lambda$3;
import org.jackhuang.hellominecraft.launcher.core.launch.GameLauncher;
import org.jackhuang.hellominecraft.launcher.core.launch.LaunchOptions;
import org.jackhuang.hellominecraft.launcher.core.launch.LibraryDownloadTask;
import org.jackhuang.hellominecraft.launcher.core.service.IMinecraftService;
import org.jackhuang.hellominecraft.launcher.core.version.DecompressLibraryJob;
import org.jackhuang.hellominecraft.launcher.core.version.Extract;
import org.jackhuang.hellominecraft.util.C;
import org.jackhuang.hellominecraft.util.MessageBox;
import org.jackhuang.hellominecraft.util.logging.HMCLog;
import org.jackhuang.hellominecraft.util.system.Compressor;
import org.jackhuang.hellominecraft.util.tasks.ParallelTask;
import org.jackhuang.hellominecraft.util.tasks.TaskWindow;

public class DefaultGameLauncher
extends GameLauncher {
    public DefaultGameLauncher(LaunchOptions options, IMinecraftService service, LoginInfo info, IAuthenticator lg) {
        super(options, service, info, lg);
        this.register();
    }

    private void register() {
        this.downloadLibrariesEvent.register(DefaultGameLauncher$$Lambda$1.lambdaFactory$());
        this.decompressNativesEvent.register(DefaultGameLauncher$$Lambda$2.lambdaFactory$());
    }

    private static /* synthetic */ boolean lambda$register$7(Object sender, DecompressLibraryJob value) {
        if (value == null) {
            return false;
        }
        for (int i = 0; i < value.decompressFiles.length; ++i) {
            try {
                File file = value.decompressFiles[i];
                File file2 = value.getDecompressTo();
                Extract extract = value.extractRules[i];
                extract.getClass();
                Compressor.unzip(file, file2, DefaultGameLauncher$$Lambda$3.lambdaFactory$(extract), false);
                continue;
            }
            catch (IOException ex) {
                HMCLog.err("Unable to decompress library: " + value.decompressFiles[i] + " to " + value.getDecompressTo(), ex);
            }
        }
        return true;
    }

    private static /* synthetic */ boolean lambda$register$6(Object sender, List t) {
        TaskWindow.TaskWindowFactory dw = TaskWindow.factory();
        ParallelTask parallelTask = new ParallelTask();
        HashSet<String> names = new HashSet<String>();
        for (DownloadLibraryJob s : t) {
            if (names.contains(s.lib.name)) continue;
            names.add(s.lib.name);
            parallelTask.addDependsTask(new LibraryDownloadTask(s));
        }
        dw.append(parallelTask);
        boolean flag = true;
        if (t.size() > 0) {
            flag = dw.create();
        }
        if (!flag && MessageBox.Show(C.i18n("launch.not_finished_downloading_libraries", new Object[0]), 10) == 0) {
            flag = true;
        }
        return flag;
    }

    static /* synthetic */ boolean access$lambda$0(Object object, List list) {
        return DefaultGameLauncher.lambda$register$6(object, list);
    }

    static /* synthetic */ boolean access$lambda$1(Object object, DecompressLibraryJob decompressLibraryJob) {
        return DefaultGameLauncher.lambda$register$7(object, decompressLibraryJob);
    }
}

