/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hellominecraft.launcher.core.install.optifine.bmcl;

import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jackhuang.hellominecraft.launcher.core.install.InstallerVersionList;
import org.jackhuang.hellominecraft.launcher.core.install.optifine.OptiFineVersion;
import org.jackhuang.hellominecraft.util.ArrayUtils;
import org.jackhuang.hellominecraft.util.C;
import org.jackhuang.hellominecraft.util.StrUtils;
import org.jackhuang.hellominecraft.util.tasks.Task;
import org.jackhuang.hellominecraft.util.tasks.TaskInfo;
import org.jackhuang.hellominecraft.util.tasks.download.HTTPGetTask;

public class OptiFineBMCLVersionList
extends InstallerVersionList {
    private static OptiFineBMCLVersionList instance;
    public ArrayList<OptiFineVersion> root;
    public Map<String, List<InstallerVersionList.InstallerVersion>> versionMap;
    public List<InstallerVersionList.InstallerVersion> versions;
    private static final Type TYPE;

    public static OptiFineBMCLVersionList getInstance() {
        if (null == instance) {
            instance = new OptiFineBMCLVersionList();
        }
        return instance;
    }

    @Override
    public Task refresh(String[] needed) {
        return new TaskInfo(C.i18n("install.optifine.get_list", new Object[0])){
            HTTPGetTask task;
            {
                this.task = new HTTPGetTask("http://bmclapi.bangbang93.com/optifine/versionlist");
            }

            @Override
            public Collection<Task> getDependTasks() {
                return Arrays.asList(this.task);
            }

            @Override
            public void executeTask() throws Throwable {
                String s = this.task.getResult();
                OptiFineBMCLVersionList.this.versionMap = new HashMap<String, List<InstallerVersionList.InstallerVersion>>();
                OptiFineBMCLVersionList.this.versions = new ArrayList<InstallerVersionList.InstallerVersion>();
                if (s == null) {
                    return;
                }
                OptiFineBMCLVersionList.this.root = (ArrayList)C.GSON.fromJson(s, TYPE);
                for (OptiFineVersion v : OptiFineBMCLVersionList.this.root) {
                    v.setMirror(v.getMirror().replace("http://optifine.net/http://optifine.net/", "http://optifine.net/"));
                    if (StrUtils.isBlank(v.getMCVersion())) {
                        Pattern p = Pattern.compile("OptiFine (.*) HD");
                        Matcher m = p.matcher(v.getVersion());
                        while (m.find()) {
                            v.setMCVersion(m.group(1));
                        }
                    }
                    InstallerVersionList.InstallerVersion iv = new InstallerVersionList.InstallerVersion(v.getVersion(), StrUtils.formatVersion(v.getMCVersion()));
                    List al = ArrayUtils.tryGetMapWithList(OptiFineBMCLVersionList.this.versionMap, StrUtils.formatVersion(v.getMCVersion()));
                    iv.installer = iv.universal = v.getMirror();
                    al.add(iv);
                    OptiFineBMCLVersionList.this.versions.add(iv);
                }
                Collections.sort(OptiFineBMCLVersionList.this.versions, InstallerVersionList.InstallerVersionComparator.INSTANCE);
            }
        };
    }

    @Override
    public List<InstallerVersionList.InstallerVersion> getVersionsImpl(String mcVersion) {
        if (this.versions == null || this.versionMap == null) {
            return null;
        }
        if (StrUtils.isBlank(mcVersion)) {
            return this.versions;
        }
        List<InstallerVersionList.InstallerVersion> c = this.versionMap.get(mcVersion);
        if (c == null) {
            return this.versions;
        }
        Collections.sort(c, InstallerVersionList.InstallerVersionComparator.INSTANCE);
        return c;
    }

    @Override
    public String getName() {
        return "OptiFine - BMCLAPI(By: bangbang93)";
    }

    static {
        TYPE = new TypeToken<ArrayList<OptiFineVersion>>(){}.getType();
    }
}

