/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hellominecraft.launcher.core.install.liteloader;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jackhuang.hellominecraft.launcher.core.install.InstallerVersionList;
import org.jackhuang.hellominecraft.launcher.core.install.InstallerVersionNewerComparator;
import org.jackhuang.hellominecraft.launcher.core.install.liteloader.LiteLoaderMCVersions;
import org.jackhuang.hellominecraft.launcher.core.install.liteloader.LiteLoaderVersion;
import org.jackhuang.hellominecraft.launcher.core.install.liteloader.LiteLoaderVersionsRoot;
import org.jackhuang.hellominecraft.launcher.core.version.MinecraftLibrary;
import org.jackhuang.hellominecraft.util.C;
import org.jackhuang.hellominecraft.util.StrUtils;
import org.jackhuang.hellominecraft.util.tasks.Task;
import org.jackhuang.hellominecraft.util.tasks.TaskInfo;
import org.jackhuang.hellominecraft.util.tasks.download.HTTPGetTask;

public class LiteLoaderVersionList
extends InstallerVersionList {
    private static volatile LiteLoaderVersionList instance = null;
    public LiteLoaderVersionsRoot root;
    public Map<String, List<InstallerVersionList.InstallerVersion>> versionMap;
    public List<InstallerVersionList.InstallerVersion> versions;

    public static LiteLoaderVersionList getInstance() {
        if (instance == null) {
            instance = new LiteLoaderVersionList();
        }
        return instance;
    }

    @Override
    public Task refresh(String[] needed) {
        if (this.root != null) {
            return null;
        }
        return new TaskInfo(C.i18n("install.liteloader.get_list", new Object[0])){
            HTTPGetTask task;
            {
                this.task = new HTTPGetTask("http://dl.liteloader.com/versions/versions.json");
            }

            @Override
            public Collection<Task> getDependTasks() {
                return Arrays.asList(this.task);
            }

            @Override
            public void executeTask() throws Throwable {
                if (!this.areDependTasksSucceeded) {
                    return;
                }
                String s = this.task.getResult();
                LiteLoaderVersionList.this.root = C.GSON.fromJson(s, LiteLoaderVersionsRoot.class);
                LiteLoaderVersionList.this.versionMap = new HashMap<String, List<InstallerVersionList.InstallerVersion>>();
                LiteLoaderVersionList.this.versions = new ArrayList<InstallerVersionList.InstallerVersion>();
                for (Map.Entry<String, LiteLoaderMCVersions> arr : LiteLoaderVersionList.this.root.versions.entrySet()) {
                    ArrayList<LiteLoaderInstallerVersion> al = new ArrayList<LiteLoaderInstallerVersion>();
                    LiteLoaderMCVersions mcv = arr.getValue();
                    if (mcv == null || mcv.artefacts == null || mcv.artefacts.get("com.mumfrey:liteloader") == null) continue;
                    for (Map.Entry<String, LiteLoaderVersion> entry : mcv.artefacts.get("com.mumfrey:liteloader").entrySet()) {
                        if ("latest".equals(entry.getKey())) continue;
                        LiteLoaderVersion v = entry.getValue();
                        LiteLoaderInstallerVersion iv = new LiteLoaderInstallerVersion(v.version, StrUtils.formatVersion(arr.getKey()));
                        iv.universal = "http://dl.liteloader.com/versions/com/mumfrey/liteloader/" + arr.getKey() + "/" + v.file;
                        iv.tweakClass = v.tweakClass;
                        iv.libraries = Arrays.copyOf(v.libraries, v.libraries.length);
                        iv.installer = "http://dl.liteloader.com/redist/" + iv.mcVersion + "/liteloader-installer-" + iv.selfVersion.replace("_", "-") + ".jar";
                        al.add(iv);
                        LiteLoaderVersionList.this.versions.add(iv);
                    }
                    Collections.sort(al, new InstallerVersionNewerComparator());
                    LiteLoaderVersionList.this.versionMap.put(StrUtils.formatVersion(arr.getKey()), al);
                }
                Collections.sort(LiteLoaderVersionList.this.versions, InstallerVersionList.InstallerVersionComparator.INSTANCE);
            }
        };
    }

    @Override
    public List<InstallerVersionList.InstallerVersion> getVersionsImpl(String mcVersion) {
        if (this.versions == null || this.versionMap == null) {
            return null;
        }
        if (StrUtils.isBlank(mcVersion)) {
            return this.versions;
        }
        List<InstallerVersionList.InstallerVersion> c = this.versionMap.get(mcVersion);
        if (c == null) {
            return this.versions;
        }
        Collections.sort(c, InstallerVersionList.InstallerVersionComparator.INSTANCE);
        return c;
    }

    @Override
    public String getName() {
        return "LiteLoader - LiteLoader Official Site(By: Mumfrey)";
    }

    public static class LiteLoaderInstallerVersion
    extends InstallerVersionList.InstallerVersion {
        public MinecraftLibrary[] libraries;
        public String tweakClass;

        public LiteLoaderInstallerVersion(String selfVersion, String mcVersion) {
            super(selfVersion, mcVersion);
        }
    }
}

