/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hellominecraft.launcher.core.install.forge;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jackhuang.hellominecraft.launcher.core.download.DownloadType;
import org.jackhuang.hellominecraft.launcher.core.install.InstallerVersionList;
import org.jackhuang.hellominecraft.launcher.core.install.InstallerVersionNewerComparator;
import org.jackhuang.hellominecraft.launcher.core.install.forge.MinecraftForgeVersion;
import org.jackhuang.hellominecraft.launcher.core.install.forge.MinecraftForgeVersionRoot;
import org.jackhuang.hellominecraft.util.C;
import org.jackhuang.hellominecraft.util.StrUtils;
import org.jackhuang.hellominecraft.util.tasks.Task;
import org.jackhuang.hellominecraft.util.tasks.TaskInfo;
import org.jackhuang.hellominecraft.util.tasks.download.HTTPGetTask;

public class MinecraftForgeVersionList
extends InstallerVersionList {
    private static volatile MinecraftForgeVersionList instance;
    public MinecraftForgeVersionRoot root;
    public Map<String, List<InstallerVersionList.InstallerVersion>> versionMap;
    public List<InstallerVersionList.InstallerVersion> versions;

    public static MinecraftForgeVersionList getInstance() {
        if (instance == null) {
            instance = new MinecraftForgeVersionList();
        }
        return instance;
    }

    @Override
    public Task refresh(String[] needed) {
        if (this.root != null) {
            return null;
        }
        return new TaskInfo(C.i18n("install.forge.get_list", new Object[0])){
            HTTPGetTask task;
            {
                this.task = new HTTPGetTask(DownloadType.getSuggestedDownloadType().getProvider().getParsedDownloadURL("http://files.minecraftforge.net/maven/net/minecraftforge/forge/json"));
            }

            @Override
            public Collection<Task> getDependTasks() {
                return Arrays.asList(this.task);
            }

            @Override
            public void executeTask() throws Throwable {
                if (!this.areDependTasksSucceeded) {
                    return;
                }
                String s = this.task.getResult();
                MinecraftForgeVersionList.this.root = C.GSON.fromJson(s, MinecraftForgeVersionRoot.class);
                MinecraftForgeVersionList.this.versionMap = new HashMap<String, List<InstallerVersionList.InstallerVersion>>();
                MinecraftForgeVersionList.this.versions = new ArrayList<InstallerVersionList.InstallerVersion>();
                for (Map.Entry<String, int[]> arr : MinecraftForgeVersionList.this.root.mcversion.entrySet()) {
                    String mcver = StrUtils.formatVersion(arr.getKey());
                    ArrayList<InstallerVersionList.InstallerVersion> al = new ArrayList<InstallerVersionList.InstallerVersion>();
                    for (int num : arr.getValue()) {
                        MinecraftForgeVersion v = MinecraftForgeVersionList.this.root.number.get(num);
                        InstallerVersionList.InstallerVersion iv = new InstallerVersionList.InstallerVersion(v.version, StrUtils.formatVersion(v.mcversion));
                        block12: for (String[] f : v.files) {
                            String ver = v.mcversion + "-" + v.version;
                            if (!StrUtils.isBlank(v.branch)) {
                                ver = ver + "-" + v.branch;
                            }
                            String filename = MinecraftForgeVersionList.this.root.artifact + "-" + ver + "-" + f[1] + "." + f[0];
                            String url = DownloadType.getSuggestedDownloadType().getProvider().getParsedDownloadURL(MinecraftForgeVersionList.this.root.webpath + ver + "/" + filename);
                            String string = f[1];
                            int n = -1;
                            switch (string.hashCode()) {
                                case 29046664: {
                                    if (!string.equals("installer")) break;
                                    n = 0;
                                    break;
                                }
                                case -409534901: {
                                    if (!string.equals("universal")) break;
                                    n = 1;
                                    break;
                                }
                                case 1455272340: {
                                    if (!string.equals("changelog")) break;
                                    n = 2;
                                }
                            }
                            switch (n) {
                                case 0: {
                                    iv.installer = url;
                                    continue block12;
                                }
                                case 1: {
                                    iv.universal = url;
                                    continue block12;
                                }
                                case 2: {
                                    iv.changelog = url;
                                    continue block12;
                                }
                            }
                        }
                        if (StrUtils.isBlank(iv.installer) || StrUtils.isBlank(iv.universal)) continue;
                        Collections.sort(al, new InstallerVersionNewerComparator());
                        al.add(iv);
                        MinecraftForgeVersionList.this.versions.add(iv);
                    }
                    MinecraftForgeVersionList.this.versionMap.put(StrUtils.formatVersion(mcver), al);
                }
                Collections.sort(MinecraftForgeVersionList.this.versions, new InstallerVersionList.InstallerVersionComparator());
            }
        };
    }

    @Override
    public List<InstallerVersionList.InstallerVersion> getVersionsImpl(String mcVersion) {
        if (this.versions == null || this.versionMap == null) {
            return null;
        }
        if (StrUtils.isBlank(mcVersion)) {
            return this.versions;
        }
        List<InstallerVersionList.InstallerVersion> c = this.versionMap.get(mcVersion);
        if (c == null) {
            return this.versions;
        }
        Collections.sort(c, InstallerVersionList.InstallerVersionComparator.INSTANCE);
        return c;
    }

    @Override
    public String getName() {
        return "Forge - MinecraftForge Offical Site";
    }
}

