/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hellominecraft.launcher.core.install.forge;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.jackhuang.hellominecraft.launcher.core.install.InstallProfile;
import org.jackhuang.hellominecraft.launcher.core.service.IMinecraftService;
import org.jackhuang.hellominecraft.launcher.core.version.MinecraftLibrary;
import org.jackhuang.hellominecraft.util.C;
import org.jackhuang.hellominecraft.util.MessageBox;
import org.jackhuang.hellominecraft.util.NetUtils;
import org.jackhuang.hellominecraft.util.logging.HMCLog;
import org.jackhuang.hellominecraft.util.system.FileUtils;
import org.jackhuang.hellominecraft.util.tasks.Task;

public class ForgeInstaller
extends Task {
    public File gameDir;
    public File forgeInstaller;
    public IMinecraftService mp;

    public ForgeInstaller(IMinecraftService mp, File forgeInstaller) {
        this.gameDir = mp.baseDirectory();
        this.forgeInstaller = forgeInstaller;
        this.mp = mp;
    }

    @Override
    public void executeTask() throws Exception {
        HMCLog.log("Extracting install profiles...");
        ZipFile zipFile = new ZipFile(this.forgeInstaller);
        Throwable throwable = null;
        try {
            File to;
            ZipEntry entry = zipFile.getEntry("install_profile.json");
            String content = NetUtils.getStreamContent(zipFile.getInputStream(entry));
            InstallProfile profile = C.GSON.fromJson(content, InstallProfile.class);
            File from = new File(this.gameDir, "versions" + File.separator + profile.install.getMinecraft());
            if (!from.exists()) {
                if (MessageBox.Show(C.i18n("install.no_version_if_intall", new Object[0])) == 0) {
                    if (!this.mp.version().install(profile.install.getMinecraft(), null)) {
                        throw new IllegalStateException(C.i18n("install.no_version", new Object[0]));
                    }
                } else {
                    throw new IllegalStateException(C.i18n("install.no_version", new Object[0]));
                }
            }
            if (!(to = new File(this.gameDir, "versions" + File.separator + profile.install.getTarget())).exists() && !to.mkdirs()) {
                HMCLog.warn("Failed to make new version folder " + to);
            }
            HMCLog.log("Copying jar..." + profile.install.getMinecraft() + ".jar to " + profile.install.getTarget() + ".jar");
            FileUtils.copyFile(new File(from, profile.install.getMinecraft() + ".jar"), new File(to, profile.install.getTarget() + ".jar"));
            HMCLog.log("Creating new version profile..." + profile.install.getTarget() + ".json");
            FileUtils.write(new File(to, profile.install.getTarget() + ".json"), C.GSON.toJson(profile.versionInfo));
            HMCLog.log("Extracting universal forge pack..." + profile.install.getFilePath());
            entry = zipFile.getEntry(profile.install.getFilePath());
            InputStream is = zipFile.getInputStream(entry);
            MinecraftLibrary forge = new MinecraftLibrary(profile.install.getPath());
            File file = new File(this.gameDir, "libraries/" + forge.getDownloadInfo().path);
            if (file.getParentFile().mkdirs()) {
                HMCLog.warn("Failed to make library directory " + file.getParent());
            }
            FileOutputStream fos = new FileOutputStream(file);
            Throwable throwable2 = null;
            try {
                BufferedOutputStream bos = new BufferedOutputStream(fos);
                Throwable throwable3 = null;
                try {
                    int c;
                    while ((c = is.read()) != -1) {
                        bos.write((byte)c);
                    }
                }
                catch (Throwable throwable4) {
                    throwable3 = throwable4;
                    throw throwable4;
                }
                finally {
                    if (bos != null) {
                        if (throwable3 != null) {
                            try {
                                bos.close();
                            }
                            catch (Throwable throwable5) {
                            }
                        } else {
                            bos.close();
                        }
                    }
                }
            }
            catch (Throwable throwable6) {
                throwable2 = throwable6;
                throw throwable6;
            }
            finally {
                if (fos != null) {
                    if (throwable2 != null) {
                        try {
                            fos.close();
                        }
                        catch (Throwable throwable7) {
                        }
                    } else {
                        fos.close();
                    }
                }
            }
            this.mp.version().refreshVersions();
        }
        catch (Throwable throwable8) {
            throwable = throwable8;
            throw throwable8;
        }
        finally {
            if (zipFile != null) {
                if (throwable != null) {
                    try {
                        zipFile.close();
                    }
                    catch (Throwable throwable9) {
                    }
                } else {
                    zipFile.close();
                }
            }
        }
    }

    @Override
    public String getInfo() {
        return C.i18n("install.forge.install", new Object[0]);
    }
}

