/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hellominecraft.launcher.core.install;

import java.io.File;
import org.jackhuang.hellominecraft.launcher.core.install.InstallerType;
import org.jackhuang.hellominecraft.launcher.core.install.InstallerVersionList;
import org.jackhuang.hellominecraft.launcher.core.install.forge.ForgeInstaller;
import org.jackhuang.hellominecraft.launcher.core.install.liteloader.LiteLoaderInstaller;
import org.jackhuang.hellominecraft.launcher.core.install.liteloader.LiteLoaderVersionList;
import org.jackhuang.hellominecraft.launcher.core.install.optifine.OptiFineInstaller;
import org.jackhuang.hellominecraft.launcher.core.install.optifine.vanilla.OptiFineDownloadFormatter;
import org.jackhuang.hellominecraft.launcher.core.service.IMinecraftInstallerService;
import org.jackhuang.hellominecraft.launcher.core.service.IMinecraftService;
import org.jackhuang.hellominecraft.util.system.IOUtils;
import org.jackhuang.hellominecraft.util.tasks.DeleteFileTask;
import org.jackhuang.hellominecraft.util.tasks.Task;
import org.jackhuang.hellominecraft.util.tasks.communication.PreviousResult;
import org.jackhuang.hellominecraft.util.tasks.download.FileDownloadTask;

public final class MinecraftInstallerService
extends IMinecraftInstallerService {
    public MinecraftInstallerService(IMinecraftService service) {
        super(service);
    }

    @Override
    public Task download(String installId, InstallerVersionList.InstallerVersion v, InstallerType type) {
        switch (type) {
            case Forge: {
                return this.downloadForge(installId, v);
            }
            case OptiFine: {
                return this.downloadOptiFine(installId, v);
            }
            case LiteLoader: {
                return this.downloadLiteLoader(installId, v);
            }
        }
        return null;
    }

    @Override
    public Task downloadForge(String installId, InstallerVersionList.InstallerVersion v) {
        File filepath = IOUtils.tryGetCanonicalFile("forge-installer.jar");
        if (v.installer == null) {
            return null;
        }
        return new FileDownloadTask(this.service.getDownloadType().getProvider().getParsedDownloadURL(v.installer), filepath).setTag("forge").after(new ForgeInstaller(this.service, filepath)).after(new DeleteFileTask(filepath));
    }

    @Override
    public Task downloadOptiFine(String installId, InstallerVersionList.InstallerVersion v) {
        File filepath = IOUtils.tryGetCanonicalFile("optifine-installer.jar");
        if (v.installer == null) {
            return null;
        }
        OptiFineDownloadFormatter task = new OptiFineDownloadFormatter(v.installer);
        return task.after(new FileDownloadTask(filepath).registerPreviousResult(task).setTag("optifine")).after(new OptiFineInstaller(this.service, installId, v, filepath)).after(new DeleteFileTask(filepath));
    }

    @Override
    public Task downloadLiteLoader(String installId, InstallerVersionList.InstallerVersion v) {
        File filepath = IOUtils.tryGetCanonicalFile("liteloader-universal.jar");
        FileDownloadTask task = (FileDownloadTask)new FileDownloadTask(v.universal, filepath).setTag("LiteLoader");
        return task.after(new LiteLoaderInstaller(this.service, installId, (LiteLoaderVersionList.LiteLoaderInstallerVersion)v).registerPreviousResult((PreviousResult)task)).after(new DeleteFileTask(filepath));
    }
}

