/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hellominecraft.launcher.core.download;

import org.jackhuang.hellominecraft.launcher.core.download.BMCLAPIDownloadProvider;
import org.jackhuang.hellominecraft.launcher.core.download.CurseDownloadProvider;
import org.jackhuang.hellominecraft.launcher.core.download.IDownloadProvider;
import org.jackhuang.hellominecraft.launcher.core.download.MojangDownloadProvider;
import org.jackhuang.hellominecraft.util.C;
import org.jackhuang.hellominecraft.util.tasks.TaskWindow;

public enum DownloadType {
    Mojang("download.mojang", new MojangDownloadProvider()),
    BMCL("download.BMCL", new BMCLAPIDownloadProvider()),
    Curse("Curse CDN", new CurseDownloadProvider());

    private final String name;
    private final IDownloadProvider provider;
    private static DownloadType suggestedDownloadType;

    private DownloadType(String a, IDownloadProvider provider) {
        this.name = a;
        this.provider = provider;
    }

    public IDownloadProvider getProvider() {
        return this.provider;
    }

    public String getName() {
        return C.i18n(this.name, new Object[0]);
    }

    public static DownloadType getSuggestedDownloadType() {
        return suggestedDownloadType;
    }

    public static void setSuggestedDownloadType(DownloadType suggestedDownloadType) {
        if (suggestedDownloadType == null) {
            throw new IllegalArgumentException("download type should not be null.");
        }
        TaskWindow.downloadSource = suggestedDownloadType.getName();
        DownloadType.suggestedDownloadType = suggestedDownloadType;
    }

    static {
        suggestedDownloadType = Mojang;
    }
}

