/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hellominecraft.launcher.core.auth.yggdrasil;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonParseException;
import java.io.IOException;
import java.lang.reflect.Type;
import java.net.Proxy;
import java.net.URL;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.jackhuang.hellominecraft.launcher.core.auth.AuthenticationException;
import org.jackhuang.hellominecraft.launcher.core.auth.yggdrasil.AuthenticationRequest;
import org.jackhuang.hellominecraft.launcher.core.auth.yggdrasil.GameProfile;
import org.jackhuang.hellominecraft.launcher.core.auth.yggdrasil.PropertyMap;
import org.jackhuang.hellominecraft.launcher.core.auth.yggdrasil.RefreshRequest;
import org.jackhuang.hellominecraft.launcher.core.auth.yggdrasil.Response;
import org.jackhuang.hellominecraft.launcher.core.auth.yggdrasil.UUIDTypeAdapter;
import org.jackhuang.hellominecraft.launcher.core.auth.yggdrasil.User;
import org.jackhuang.hellominecraft.util.C;
import org.jackhuang.hellominecraft.util.NetUtils;
import org.jackhuang.hellominecraft.util.StrUtils;
import org.jackhuang.hellominecraft.util.logging.HMCLog;

public class YggdrasilAuthentication {
    public static final Gson GSON = new GsonBuilder().registerTypeAdapter((Type)((Object)GameProfile.class), new GameProfile.GameProfileSerializer()).registerTypeAdapter((Type)((Object)PropertyMap.class), new PropertyMap.Serializer()).registerTypeAdapter((Type)((Object)UUID.class), new UUIDTypeAdapter()).create();
    protected static final String BASE_URL = "https://authserver.mojang.com/";
    protected static final URL ROUTE_AUTHENTICATE = NetUtils.constantURL("https://authserver.mojang.com/authenticate");
    protected static final URL ROUTE_REFRESH = NetUtils.constantURL("https://authserver.mojang.com/refresh");
    protected static final String STORAGE_KEY_ACCESS_TOKEN = "accessToken";
    protected static final String STORAGE_KEY_PROFILE_NAME = "displayName";
    protected static final String STORAGE_KEY_PROFILE_ID = "uuid";
    protected static final String STORAGE_KEY_PROFILE_PROPERTIES = "profileProperties";
    protected static final String STORAGE_KEY_USER_NAME = "username";
    protected static final String STORAGE_KEY_USER_ID = "userid";
    protected static final String STORAGE_KEY_USER_PROPERTIES = "userProperties";
    private final Proxy proxy;
    private final String clientToken;
    private final PropertyMap userProperties = new PropertyMap();
    private String userid;
    private String username;
    private String password;
    private String accessToken;
    private GameProfile selectedProfile;
    private GameProfile[] profiles;
    private boolean isOnline;

    public YggdrasilAuthentication(Proxy proxy, String clientToken) {
        this.proxy = proxy;
        this.clientToken = clientToken;
    }

    public void setUserName(String username) {
        if (this.isLoggedIn() && this.canPlayOnline()) {
            throw new IllegalStateException("Cannot change username while logged in & online");
        }
        this.username = username;
    }

    public void setPassword(String password) {
        if (this.isLoggedIn() && this.canPlayOnline() && StrUtils.isNotBlank(password)) {
            throw new IllegalStateException("Cannot set password while logged in & online");
        }
        this.password = password;
    }

    public GameProfile getSelectedProfile() {
        return this.selectedProfile;
    }

    public String getUserId() {
        return this.userid;
    }

    public PropertyMap getUserProperties() {
        if (this.isLoggedIn()) {
            return (PropertyMap)this.userProperties.clone();
        }
        return new PropertyMap();
    }

    public GameProfile[] getAvailableProfiles() {
        if (this.profiles == null) {
            return null;
        }
        return (GameProfile[])this.profiles.clone();
    }

    public String getAuthenticatedToken() {
        return this.accessToken;
    }

    public boolean canPlayOnline() {
        return this.isLoggedIn() && this.getSelectedProfile() != null && this.isOnline;
    }

    public boolean canLogIn() {
        return !this.canPlayOnline() && StrUtils.isNotBlank(this.username) && (StrUtils.isNotBlank(this.password) || StrUtils.isNotBlank(this.getAuthenticatedToken()));
    }

    public boolean isLoggedIn() {
        return StrUtils.isNotBlank(this.accessToken);
    }

    public void logIn() throws AuthenticationException {
        if (StrUtils.isBlank(this.username)) {
            throw new AuthenticationException(C.i18n("login.invalid_username", new Object[0]));
        }
        if (StrUtils.isNotBlank(this.getAuthenticatedToken())) {
            if (StrUtils.isBlank(this.getUserId())) {
                if (StrUtils.isBlank(this.username)) {
                    this.userid = this.username;
                } else {
                    throw new AuthenticationException(C.i18n("login.invalid_uuid_and_username", new Object[0]));
                }
            }
            this.loggedIn(ROUTE_REFRESH, new RefreshRequest(this.getAuthenticatedToken(), this.clientToken));
        } else if (StrUtils.isNotBlank(this.password)) {
            this.loggedIn(ROUTE_AUTHENTICATE, new AuthenticationRequest(this.username, this.password, this.clientToken));
        } else {
            throw new AuthenticationException(C.i18n("login.invalid_password", new Object[0]));
        }
    }

    private void loggedIn(URL url, Object input) throws AuthenticationException {
        try {
            String jsonResult = input == null ? NetUtils.get(url) : NetUtils.post(url, GSON.toJson(input), "application/json", this.proxy);
            Response response = GSON.fromJson(jsonResult, Response.class);
            if (response == null) {
                throw new AuthenticationException("No valid response here");
            }
            if (StrUtils.isNotBlank(response.error)) {
                HMCLog.err("Failed to log in, the auth server returned an error: " + response.error + ", message: " + response.errorMessage + ", cause: " + response.cause);
                if (response.errorMessage.contains("Invalid token")) {
                    response.errorMessage = C.i18n("login.invalid_token", new Object[0]);
                }
                throw new AuthenticationException("Request error: " + response.errorMessage);
            }
            if (!this.clientToken.equals(response.clientToken)) {
                throw new AuthenticationException(C.i18n("login.changed_client_token", new Object[0]));
            }
            User user = response.user;
            this.userid = user != null && user.getId() != null ? user.getId() : this.username;
            this.isOnline = true;
            this.profiles = response.availableProfiles;
            this.selectedProfile = response.selectedProfile;
            this.userProperties.clear();
            this.accessToken = response.accessToken;
            if (user != null && user.getProperties() != null) {
                this.userProperties.putAll(user.getProperties());
            }
        }
        catch (JsonParseException | IOException | IllegalStateException e) {
            throw new AuthenticationException(C.i18n("login.failed.connect_authentication_server", new Object[0]), e);
        }
    }

    public void logOut() {
        this.password = null;
        this.userid = null;
        this.selectedProfile = null;
        this.userProperties.clear();
        this.accessToken = null;
        this.profiles = null;
        this.isOnline = false;
    }

    public void loadFromStorage(Map<String, Object> credentials) {
        this.logOut();
        this.setUserName((String)credentials.get(STORAGE_KEY_USER_NAME));
        this.userid = credentials.containsKey(STORAGE_KEY_USER_ID) ? (String)credentials.get(STORAGE_KEY_USER_ID) : this.username;
        if (credentials.containsKey(STORAGE_KEY_USER_PROPERTIES)) {
            this.userProperties.fromList((List)credentials.get(STORAGE_KEY_USER_PROPERTIES));
        }
        if (credentials.containsKey(STORAGE_KEY_PROFILE_NAME) && credentials.containsKey(STORAGE_KEY_PROFILE_ID)) {
            GameProfile profile = new GameProfile(UUIDTypeAdapter.fromString((String)credentials.get(STORAGE_KEY_PROFILE_ID)), (String)credentials.get(STORAGE_KEY_PROFILE_NAME));
            if (credentials.containsKey(STORAGE_KEY_PROFILE_PROPERTIES)) {
                profile.properties.fromList((List)credentials.get(STORAGE_KEY_PROFILE_PROPERTIES));
            }
            this.selectedProfile = profile;
        }
        this.accessToken = (String)credentials.get(STORAGE_KEY_ACCESS_TOKEN);
    }

    public Map<String, Object> saveForStorage() {
        GameProfile sel;
        HashMap<String, Object> result = new HashMap<String, Object>();
        if (this.username != null) {
            result.put(STORAGE_KEY_USER_NAME, this.username);
        }
        if (this.getUserId() != null) {
            result.put(STORAGE_KEY_USER_ID, this.getUserId());
        }
        if (!this.getUserProperties().isEmpty()) {
            result.put(STORAGE_KEY_USER_PROPERTIES, this.getUserProperties().list());
        }
        if ((sel = this.getSelectedProfile()) != null) {
            result.put(STORAGE_KEY_PROFILE_NAME, sel.name);
            result.put(STORAGE_KEY_PROFILE_ID, sel.id);
            if (!sel.properties.isEmpty()) {
                result.put(STORAGE_KEY_PROFILE_PROPERTIES, sel.properties.list());
            }
        }
        if (StrUtils.isNotBlank(this.getAuthenticatedToken())) {
            result.put(STORAGE_KEY_ACCESS_TOKEN, this.getAuthenticatedToken());
        }
        return result;
    }
}

