/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hellominecraft.launcher.core.auth;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jackhuang.hellominecraft.launcher.api.IPlugin;
import org.jackhuang.hellominecraft.launcher.api.PluginManager;
import org.jackhuang.hellominecraft.launcher.core.auth.AuthenticationException;
import org.jackhuang.hellominecraft.launcher.core.auth.IAuthenticator$$Lambda$1;
import org.jackhuang.hellominecraft.launcher.core.auth.LoginInfo;
import org.jackhuang.hellominecraft.launcher.core.auth.UserProfileProvider;

public abstract class IAuthenticator {
    public static final List<IAuthenticator> LOGINS = new ArrayList<IAuthenticator>();
    protected String clientToken;
    protected String username;
    protected String password;

    public IAuthenticator(String clientToken) {
        this.clientToken = clientToken;
    }

    public String getClientToken() {
        return this.clientToken;
    }

    public abstract UserProfileProvider login(LoginInfo var1) throws AuthenticationException;

    public abstract String id();

    public abstract String getName();

    public boolean hasPassword() {
        return true;
    }

    public boolean isLoggedIn() {
        return false;
    }

    public void setRememberMe(boolean is) {
    }

    public abstract UserProfileProvider loginBySettings() throws AuthenticationException;

    public abstract void logOut();

    public Map onSaveSettings() {
        HashMap<String, String> m = new HashMap<String, String>();
        m.put("IAuthenticator_UserName", this.username);
        return m;
    }

    public void onLoadSettings(Map m) {
        if (m == null) {
            return;
        }
        Object o = m.get("IAuthenticator_UserName");
        this.username = o instanceof String ? (String)o : "";
    }

    public String getUserName() {
        return this.username;
    }

    public void setUserName(String s) {
        this.username = s;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    static {
        IPlugin iPlugin = PluginManager.plugin();
        List<IAuthenticator> list = LOGINS;
        list.getClass();
        iPlugin.onRegisterAuthenticators(IAuthenticator$$Lambda$1.lambdaFactory$(list));
    }
}

