/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hellominecraft.launcher.core.asset;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jackhuang.hellominecraft.launcher.core.asset.AssetsMojangLoader;
import org.jackhuang.hellominecraft.launcher.core.asset.Contents;
import org.jackhuang.hellominecraft.launcher.core.download.IDownloadProvider;
import org.jackhuang.hellominecraft.launcher.core.service.IMinecraftAssetService;
import org.jackhuang.hellominecraft.launcher.core.version.MinecraftVersion;
import org.jackhuang.hellominecraft.util.C;
import org.jackhuang.hellominecraft.util.NetUtils;
import org.jackhuang.hellominecraft.util.code.DigestUtils;
import org.jackhuang.hellominecraft.util.logging.HMCLog;
import org.jackhuang.hellominecraft.util.system.IOUtils;
import org.jackhuang.hellominecraft.util.tasks.Task;
import org.jackhuang.hellominecraft.util.tasks.TaskInfo;
import org.jackhuang.hellominecraft.util.tasks.download.FileDownloadTask;

public abstract class IAssetsHandler {
    protected ArrayList<String> assetsDownloadURLs;
    protected ArrayList<File> assetsLocalNames;
    protected final String name;
    protected List<Contents> contents;
    public static final IAssetsHandler ASSETS_HANDLER = new AssetsMojangLoader(C.i18n("assets.list.1_7_3_after", new Object[0]));

    public IAssetsHandler(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public abstract Task getList(MinecraftVersion var1, IMinecraftAssetService var2);

    public abstract Task getDownloadTask(IDownloadProvider var1);

    public abstract boolean isVersionAllowed(String var1);

    protected class AssetsTask
    extends TaskInfo {
        ArrayList<Task> al;
        String u;

        public AssetsTask(String url) {
            super(C.i18n("assets.download", new Object[0]));
            this.u = url;
        }

        @Override
        public void executeTask() {
            if (IAssetsHandler.this.assetsDownloadURLs == null || IAssetsHandler.this.assetsLocalNames == null || IAssetsHandler.this.contents == null) {
                throw new IllegalStateException(C.i18n("assets.not_refreshed", new Object[0]));
            }
            int max = IAssetsHandler.this.assetsDownloadURLs.size();
            this.al = new ArrayList();
            int hasDownloaded = 0;
            for (int i = 0; i < max; ++i) {
                String mark = IAssetsHandler.this.assetsDownloadURLs.get(i);
                String url = this.u + mark;
                File location = IAssetsHandler.this.assetsLocalNames.get(i);
                if (!location.getParentFile().exists() && !location.getParentFile().mkdirs()) {
                    HMCLog.warn("Failed to make directories: " + location.getParent());
                }
                if (location.isDirectory()) continue;
                boolean need = true;
                try {
                    if (location.exists()) {
                        FileInputStream fis = new FileInputStream(location);
                        String sha = DigestUtils.sha1Hex(NetUtils.getBytesFromStream(fis));
                        IOUtils.closeQuietly(fis);
                        if (IAssetsHandler.this.contents.get(i).geteTag().equals(sha)) {
                            ++hasDownloaded;
                            HMCLog.log("File " + IAssetsHandler.this.assetsLocalNames.get(i) + " has been downloaded successfully, skipped downloading.");
                            if (this.ppl == null) continue;
                            this.ppl.setProgress(this, hasDownloaded, max);
                            continue;
                        }
                    }
                }
                catch (IOException e) {
                    HMCLog.warn("Failed to get hash: " + location, e);
                    boolean bl = need = !location.exists();
                }
                if (!need) continue;
                this.al.add(new FileDownloadTask(url, location).setTag(mark));
            }
        }

        @Override
        public Collection<Task> getAfterTasks() {
            return this.al;
        }
    }
}

