#version 120

/*

	##########	##########	##########	##########	##
	##				##		##		##	##		##	##
	##				##		##		##	##		##	##
	##########		##		##		##	##########	##
			##		##		##		##	##			##
			##		##		##		##	##
	##########		##		##########	##			##

Before you do anything here, make sure you've read my agreement!

Otherwise, notice that you are ONLY allowed to modify my shaderpack
for your OWN USE!

*/


#define	useDynamicTonemapping

varying vec4 color;
varying vec3 normal;
varying vec2 texcoord;
varying float ambientNdotL;
varying float weatherRatio;
varying float skyLightmap;
varying float torchLightmap;

uniform sampler2D texture;
uniform sampler2DShadow shadow;

uniform mat4 gbufferProjection;
uniform mat4 gbufferProjectionInverse;
uniform mat4 gbufferModelViewInverse;
uniform mat4 gbufferModelView;
uniform mat4 shadowProjection;
uniform mat4 shadowModelView;

uniform ivec2 eyeBrightnessSmooth;

uniform vec3 sunPosition;
uniform vec3 moonPosition;
uniform vec3 upPosition;
uniform int fogMode;
uniform int worldTime;
uniform float wetness;
uniform float viewWidth;
uniform float viewHeight;
uniform float rainStrength;

uniform int heldBlockLightValue;
uniform int isEyeInWater;

// Calculate Time of Day.
float time = worldTime;
float TimeSunrise		= ((clamp(time, 23000.0, 24000.0) - 23000.0) / 1000.0) + (1.0 - (clamp(time, 0.0, 3000.0)/3000.0));
float TimeNoon			= ((clamp(time, 0.0, 3000.0)) / 3000.0) - ((clamp(time, 9000.0, 12000.0) - 9000.0) / 3000.0);
float TimeSunset		= ((clamp(time, 9000.0, 12000.0) - 9000.0) / 3000.0) - ((clamp(time, 12000.0, 12750.0) - 12000.0) / 750.0);
float TimeMidnight		= ((clamp(time, 12000.0, 12750.0) - 12000.0) / 750.0) - ((clamp(time, 23000.0, 24000.0) - 23000.0) / 1000.0);
float TimeDay			= TimeSunrise + TimeNoon + TimeSunset;
float DayToNightFading	= 1.0 - (clamp((time - 12000.0) / 300.0, 0.0, 1.0) - clamp((time - 13000.0) / 300.0, 0.0, 1.0)
							  +  clamp((time - 22800.0) / 200.0, 0.0, 1.0) - clamp((time - 23400.0) / 200.0, 0.0, 1.0));
							  
float vec3ToFloat(vec3 vec3Input) {

	float floatValue  = 0.0;
		  floatValue += vec3Input.x;
		  floatValue += vec3Input.y;
		  floatValue += vec3Input.z;

		  floatValue /= 3.0;

	return floatValue;

}

vec3 doEmissiveLight(vec3 clr, vec3 originalClr) {

	float exposure	= 2.5;
	float cover		= 0.3;
	
	if (heldBlockLightValue > 0.9) clr = mix(clr.rgb, originalClr.rgb * exposure, vec3ToFloat(max(originalClr.rgb - cover, 0.0)));
	
	return clr;

}


void main() {

	vec4 baseColor = texture2D(texture, texcoord.xy) * color;


	vec4 fragposition	= gbufferProjectionInverse * (vec4(gl_FragCoord.xy / vec2(viewWidth, viewHeight), gl_FragCoord.z, 1.0) * 2.0 - 1.0);
	vec4 worldposition	= gbufferModelViewInverse * fragposition;
		 
	vec3 torch_Color = vec3(1.0, 0.65, 0.4);

	vec3 newTorchLightmap	= baseColor.rgb * torch_Color * torchLightmap;

	vec3 newLightmap		= baseColor.rgb * skyLightmap + newTorchLightmap;
		 newLightmap		= doEmissiveLight(newLightmap.rgb, baseColor.rgb);

/* DRAWBUFFERS:526 */

	gl_FragData[0] = vec4(newLightmap, baseColor.a);

}
