#version 120

/*

	##########	##########	##########	##########	##
	##				##		##		##	##		##	##
	##				##		##		##	##		##	##
	##########		##		##		##	##########	##
			##		##		##		##	##			##
			##		##		##		##	##
	##########		##		##########	##			##

Before you do anything here, make sure you've read my agreement!

Otherwise, notice that you are ONLY allowed to modify my shaderpack
for your OWN USE!

*/


//#define	waterRefraction
//#define	screenSpaceReflections

varying vec4 texcoord;
varying vec3 lightVector;
varying float weatherRatio;

uniform sampler2D gcolor;
uniform sampler2D gdepth;
uniform sampler2D depthtex0;
uniform sampler2D depthtex1;
uniform sampler2D depthtex2;
uniform sampler2D noisetex;
uniform sampler2D gaux1;
uniform sampler2D gaux2;
uniform sampler2D gnormal;

uniform mat4 gbufferProjection;
uniform mat4 gbufferProjectionInverse;
uniform mat4 gbufferModelViewInverse;
uniform mat4 gbufferModelView;

uniform vec3 cameraPosition;
uniform vec3 sunPosition;
uniform vec3 upPosition;

uniform ivec2 eyeBrightness;
uniform ivec2 eyeBrightnessSmooth;

uniform float near;
uniform float far;
uniform float frameTimeCounter;
uniform float centerDepthSmooth;
uniform float aspectRatio;
uniform float rainStrength;

uniform int isEyeInWater;
uniform int worldTime;

// Calculate Time of Day.
float time = worldTime;
float TimeSunrise		= ((clamp(time, 23000.0, 24000.0) - 23000.0) / 1000.0) + (1.0 - (clamp(time, 0.0, 3000.0)/3000.0));
float TimeNoon			= ((clamp(time, 0.0, 3000.0)) / 3000.0) - ((clamp(time, 9000.0, 12000.0) - 9000.0) / 3000.0);
float TimeSunset		= ((clamp(time, 9000.0, 12000.0) - 9000.0) / 3000.0) - ((clamp(time, 12000.0, 13000.0) - 12000.0) / 1000.0);
float TimeMidnight		= ((clamp(time, 12000.0, 13000.0) - 12000.0) / 1000.0) - ((clamp(time, 23000.0, 24000.0) - 23000.0) / 1000.0);
float TimeDay			= TimeSunrise + TimeNoon + TimeSunset;
float DayToNightFading	= 1.0 - (clamp((time - 12000.0) / 300.0, 0.0, 1.0) - clamp((time - 13000.0) / 300.0, 0.0, 1.0)
							  +  clamp((time - 22800.0) / 200.0, 0.0, 1.0) - clamp((time - 23400.0) / 200.0, 0.0, 1.0));

vec3	normal			= texture2D(gnormal, texcoord.xy).xyz * 2.0 - 1.0;
float	getDepth0		= texture2D(depthtex0, texcoord.xy).x;
float	getDepth1		= texture2D(depthtex1, texcoord.xy).x;
float	comp			= 1.0 - near / far / far;

bool	isWater			= (length(normal) > 0.94 && length(normal) < 0.96);
bool	land			= getDepth0 < comp;
bool	land2			= getDepth1 < comp;
bool	sky				= getDepth0 > comp;

float cdist(vec2 coord) {
	return max(abs(coord.s-0.5),abs(coord.t-0.5))*2.0;
}

float linearDepth(float depth) {
    return (2.0 * near) / (far + near - depth * (far - near));
}

float subSurfaceScattering(vec3 vec,vec3 pos, float N) {
	return pow(max(dot(vec, normalize(pos)), 0.0), N) * (N + 1.0) / 6.28;
}

float subSurfaceScattering2(vec3 vec,vec3 pos, float N) {
	return pow(max(dot(vec, normalize(pos)) * 0.5 + 0.5, 0.0), N) * (N + 1.0)/ 6.28;
}

float dynamicTonemapping(float exposureStrength, bool reserveLightmap, bool addExposure, bool dayOnly) {

	float dTlightmap	= pow(eyeBrightnessSmooth.y / 240.0, 2.0);		if (reserveLightmap)	dTlightmap 	= 1.0 - dTlightmap;
	float dTonemap		= dTlightmap * exposureStrength;				if (addExposure)		dTonemap	= 1.0 + dTonemap;		if (dayOnly)	dTonemap = mix(dTonemap, 1.0, TimeMidnight);	// Full exposure on midnight.

	return dTonemap;

}

float vec3ToFloat(vec3 vec3Input) {

	float floatValue  = 0.0;
		  floatValue += vec3Input.x;
		  floatValue += vec3Input.y;
		  floatValue += vec3Input.z;

		  floatValue /= 3.0;

	return floatValue;

}

vec3 nvec3(vec4 pos) {
    return pos.xyz/pos.w;
}

vec3 calcFog(vec3 clr, vec3 fogClr, vec3 fragpos) {

	float fogExposure 			= 1.0;
	float fogStartDistance		= 100.0;	// Higher -> far.
	float fogDensity 			= 0.35;

	float fogFactor = 1.0 - exp(-pow(length(fragpos.xyz) / fogStartDistance, 2.0));
		  fogFactor *= fogDensity;

	clr = mix(clr.rgb, fogClr * fogExposure, fogFactor);

	return clr;

}

vec4 raytrace(vec3 fragpos, vec3 rVector, vec3 normal, vec3 fogClr) {

	const int maxf = 6;				//number of refinements
	const float stp = 1.0;			//size of one step for raytracing algorithm
	const float ref = 0.1;			//refinement multiplier
	const float inc = 2.0;			//increasement factor at each step

	vec4 color = vec4(0.0);

	#ifdef screenSpaceReflections

		vec3 start = fragpos;
		vec3 vector = stp * rVector;

		fragpos += vector;
		vec3 tvector = vector;
		
		int sr = 0;

		for (int i = 0; i < 30; i++) {

			vec3 pos = nvec3(gbufferProjection * vec4(fragpos, 1.0)) * 0.5 + 0.5;
			if (pos.x < 0 || pos.x > 1 || pos.y < 0 || pos.y > 1 || pos.z < 0 || pos.z > 1.0) break;

				vec3 spos = vec3(pos.st, texture2D(depthtex1, pos.st).r);
					 spos = nvec3(gbufferProjectionInverse * vec4(spos * 2.0 - 1.0, 1.0));

				float err = length(fragpos.xyz-spos.xyz);

				if (err < length(vector) * pow(length(tvector), 0.11) * 1.75) {

					sr++;

					if (sr >= maxf) {

						bool rLand = texture2D(depthtex1, pos.st).r < comp;

						float border = clamp(1.0 - pow(cdist(pos.st), 5.0), 0.0, 1.0);
						color = texture2D(gcolor, pos.st);
						
						// Make the sky black.
						if (!rLand) color.rgb = vec3(0.0);

						color.rgb = calcFog(color.rgb, fogClr, fragpos);	// Recalculate fog.

						color.a = 1.0;
						color.a *= border;

						break;

					}

				tvector -=vector;
				vector *=ref;

			}

			vector *= inc;
			tvector += vector;
			fragpos = start + tvector;

		}

	#endif

	return color;

}

float waterWaves(vec3 worldPos) {

	float waveSpeed = 0.75;

	vec2 coord = fract(vec2(worldPos.xz / 2000.0));

	float noise =  texture2D(noisetex, coord * 1.5 + vec2(frameTimeCounter / 1000.0 * waveSpeed)).x / 1.5;
		  noise += texture2D(noisetex, coord * 1.5 - vec2(frameTimeCounter / 1000.0 * waveSpeed)).x / 1.5;
		  noise += texture2D(noisetex, coord * 3.5 + vec2(frameTimeCounter / 600.0 * waveSpeed)).x / 3.5;
		  noise += texture2D(noisetex, coord * 3.5 - vec2(frameTimeCounter / 600.0 * waveSpeed)).x / 3.5;
		  noise += texture2D(noisetex, coord * 7.0 + vec2(frameTimeCounter / 300.0 * waveSpeed)).x / 7.0;
		  noise += texture2D(noisetex, coord * 7.0 - vec2(frameTimeCounter / 300.0 * waveSpeed)).x / 7.0;

	return noise;

}

vec3 drawAlphaColor(vec3 clr) {

	// For colored glass and ice.
	vec4 aColor = texture2D(gaux2, texcoord.xy);
	
	return mix(clr, aColor.rgb, aColor.a) + aColor.rgb * (1.0 - aColor.a);

}

void main() {

	// Get main color.
	vec3 color = texture2D(gcolor, texcoord.st).rgb;

	// Set up positions.
	vec4 fragposition = gbufferProjectionInverse * vec4(texcoord.s * 2.0f - 1.0f, texcoord.t * 2.0f - 1.0f, 2.0f * getDepth0 - 1.0f, 1.0f);
	fragposition /= fragposition.w;

	vec4 skyFragposition = gbufferProjectionInverse * vec4(texcoord.s * 2.0f - 1.0f, texcoord.t * 2.0f - 1.0f, 2.0f - 1.0f, 1.0f);
	skyFragposition /= skyFragposition.w;

	vec4 worldposition   = gbufferModelViewInverse * fragposition;
	vec4 skyWorldPos	 = gbufferModelViewInverse * skyFragposition / far * 128.0;		// Without depth.
	
	// Set up colors.
	vec3 fog_Color = vec3(0.5, 0.2, 0.1);
	
	if (isWater) {	// Water
	
		float exposureFix = 0.3;	// Should have the same value like in gbuffers_water.fsh -> watercolor.a;

		vec2 waterTexcoord = texcoord.st;

		#ifdef waterRefraction

			// By Chocapic13.

			float	waterRefractionStrength = 0.01;

			float deltaPos = 0.1;
			float h0 = waterWaves(worldposition.xyz + cameraPosition.xyz);
			float h1 = waterWaves(worldposition.xyz + cameraPosition.xyz - vec3(deltaPos, 0.0, 0.0));
			float h2 = waterWaves(worldposition.xyz + cameraPosition.xyz - vec3(0.0, 0.0, deltaPos));

			float dX = ((h0-h1))/deltaPos;
			float dY = ((h0-h2))/deltaPos;

			vec3 refract = normalize(vec3(dX,dY,1.0));
			float refMult = sqrt(1.0-dot(normal,normalize(fragposition).xyz)*dot(normal,normalize(fragposition).xyz)) * waterRefractionStrength * (1.0 - linearDepth(getDepth0));

			waterTexcoord = texcoord.xy + refract.xy*refMult;
			vec3 mask = texture2D(gnormal, waterTexcoord.st).xyz*2.0-1.0;
			bool watermask = length(mask) > 0.94 && length(mask) < 0.98;
			waterTexcoord.st = watermask? waterTexcoord.st : texcoord.st;

		#endif

		// Get main color.
		vec3 watercolor = texture2D(gcolor, waterTexcoord.st).rgb * vec3(0.8, 0.9, 1.0);
		color.rgb = watercolor;
		
		vec3 reflectedVector	= reflect(normalize(fragposition.xyz), normal);		// Overwrites fragposition and flips the image.

		float normalDotEye		= dot(normal, normalize(fragposition.xyz));
		float fresnel			= pow(1.0 + normalDotEye, 2.0);

		vec4 reflection = raytrace(fragposition.xyz, reflectedVector, normal, fog_Color);
			 reflection.rgb = mix(color.rgb, reflection.rgb, reflection.a);

		color.rgb = mix(color.rgb, reflection.rgb, fresnel);
		
		// Exposure fix.
		color.rgb += color.rgb * exposureFix;

	}

	color = drawAlphaColor(color);
	
	// Make the sky black.
	if (sky) color.rgb = vec3(0.0);
	
	color.rgb = calcFog(color.rgb, fog_Color, fragposition.xyz);


/* DRAWBUFFERS:4 */

	gl_FragData[0] = vec4(color, 0.0);

}
