#version 120
#extension GL_ARB_shader_texture_lod : enable
#define MAX_COLOR_RANGE 48.0

/*
!! DO NOT REMOVE !!
This code is from  CYBOXshaders
Read the terms of modification and sharing before changing something below please !
!! DO NOT REMOVE !!
*/

//////////////////////////////ADJUSTABLE VARIABLES//////////////////////////////
//////////////////////////////ADJUSTABLE VARIABLES//////////////////////////////
//////////////////////////////ADJUSTABLE VARIABLES//////////////////////////////

#define VIGNETTE
#define VIGNETTE_STRENGTH 1.0 
#define VIGNETTE_START 0.15	      //distance from the center of the screen where the vignette effect start (0-1)
#define VIGNETTE_END 0.95	     //distance from the center of the screen where the vignette effect end (0-1), bigger than VIGNETTE_START

#define LENS_EFFECTS		     
	#define LENS_STRENGTH 0.0		  //default 0.6
	#define DIRTYLENS_BRIGHTNESS 0.0
	//#define LENS_FLARE                    //Just for testing not recommended    
	//#define LENS_FLARE2                  //Just for testing not recommended 
	

    #define RAIN_DROPS
	//#define RAIN_DROPS_COLOR			// Recommended off

//#define MOTIONBLUR     //(doesn't work with dof use only one)
	#define MOTIONBLUR_AMOUNT 2.0

#define BASIC_DOF 	          //(doesn't work with motionblur use only one)			
	const float focal = 0.03;
	float aperture = 0.05;	
	const float sizemult = 10.0;

// Bloom By Airlock42 // 

#define BLOOM	
	const float b_intensity = 4.0;	

		
//tonemapping constants			
float A = 1.0;		//brightness multiplier
float B = 0.37;		//black level (lower means darker and more constrasted, higher make the image whiter and less constrasted)
float C = 0.1;		//constrast level 

//////////////////////////////END OF ADJUSTABLE VARIABLES//////////////////////////////
//////////////////////////////END OF ADJUSTABLE VARIABLES//////////////////////////////
//////////////////////////////END OF ADJUSTABLE VARIABLES//////////////////////////////

varying vec4 texcoord;

varying vec3 lightVector;
varying vec3 sunVec;
varying vec3 moonVec;
varying vec3 upVec;

varying vec3 sunlight;
varying vec3 moonlight;
varying vec3 ambient_color;

varying float eyeAdapt;

varying float SdotU;
varying float MdotU;
varying float sunVisibility;
varying float moonVisibility;


uniform sampler2D depthtex0;
uniform sampler2D depthtex1;
uniform sampler2D depthtex2;
uniform sampler2D noisetex;
uniform sampler2D gaux1;
uniform sampler2D gaux2;
uniform sampler2D gaux4;
uniform sampler2D composite;
uniform vec3 cameraPosition;
uniform vec3 previousCameraPosition;
uniform vec3 sunPosition;
uniform vec3 moonPosition;
uniform mat4 gbufferProjection;
uniform mat4 gbufferProjectionInverse;
uniform mat4 gbufferPreviousProjection;
uniform mat4 gbufferModelViewInverse;
uniform mat4 gbufferPreviousModelView;
uniform ivec2 eyeBrightness;
uniform int isEyeInWater;
uniform int worldTime;
uniform float aspectRatio;
uniform float near;
uniform float far;
uniform float viewWidth;
uniform float viewHeight;
uniform float rainStrength;
uniform float wetness;
uniform float frameTimeCounter;
uniform int fogMode;
vec3 sunPos = sunPosition;
float pw = 1.0/ viewWidth;
float ph = 1.0/ viewHeight;
float timefract = worldTime;

//Raining
float rainx = clamp(rainStrength, 0.0f, 2.0f)/2.0f;
float wetx  = clamp(wetness, 0.0f, 2.0f);

//Calculate Time of Day
float TimeSunrise  = ((clamp(timefract, 23000.0, 24000.0) - 23000.0) / 1000.0) + (1.0 - (clamp(timefract, 0.0, 4000.0)/4000.0));
float TimeNoon     = ((clamp(timefract, 0.0, 4000.0)) / 4000.0) - ((clamp(timefract, 8000.0, 12000.0) - 8000.0) / 4000.0);
float TimeSunset   = ((clamp(timefract, 8000.0, 12000.0) - 8000.0) / 4000.0) - ((clamp(timefract, 12000.0, 12750.0) - 12000.0) / 750.0);
float TimeMidnight = ((clamp(timefract, 12000.0, 12750.0) - 12000.0) / 750.0) - ((clamp(timefract, 23000.0, 24000.0) - 23000.0) / 1000.0);

const vec2 circle_offsets[25] = vec2[25](vec2(-0.4894566f,-0.3586783f),
									vec2(-0.1717194f,0.6272162f),
									vec2(-0.4709477f,-0.01774091f),
									vec2(-0.9910634f,0.03831699f),
									vec2(-0.2101292f,0.2034733f),
									vec2(-0.7889516f,-0.5671548f),
									vec2(-0.1037751f,-0.1583221f),
									vec2(-0.5728408f,0.3416965f),
									vec2(-0.1863332f,0.5697952f),
									vec2(0.3561834f,0.007138769f),
									vec2(0.2868255f,-0.5463203f),
									vec2(-0.4640967f,-0.8804076f),
									vec2(0.1969438f,0.6236954f),
									vec2(0.6999109f,0.6357007f),
									vec2(-0.3462536f,0.8966291f),
									vec2(0.172607f,0.2832828f),
									vec2(0.4149241f,0.8816f),
									vec2(0.136898f,-0.9716249f),
									vec2(-0.6272043f,0.6721309f),
									vec2(-0.8974028f,0.4271871f),
									vec2(0.5551881f,0.324069f),
									vec2(0.9487136f,0.2605085f),
									vec2(0.7140148f,-0.312601f),
									vec2(0.0440252f,0.9363738f),
									vec2(0.620311f,-0.6673451f)
									);

// Standard depth function.
float getDepth(float depth) {
    return 2.0 * near * far / (far + near - (2.0 * depth - 1.0) * (far - near));
}

float ld(float depth) {
    return (2.0 * near) / (far + near - depth * (far - near));
}

float luma(vec3 color) {
	return dot(color,vec3(0.299, 0.587, 0.114));
}



#ifdef LENS_EFFECTS

	float distratio(vec2 pos, vec2 pos2, float ratio) {
		float xvect = pos.x*ratio-pos2.x*ratio;
		float yvect = pos.y-pos2.y;
		return sqrt(xvect*xvect + yvect*yvect);
	}
	
	//circle position pattern (vec2 coordinate, size)
	const vec3 pattern[16] = vec3[16](	vec3(0.1,0.1,0.02),
										vec3(-0.12,0.07,0.02),
										vec3(-0.11,-0.13,0.02),
										vec3(0.1,-0.1,0.02),
									
										vec3(0.07,0.15,0.02),
										vec3(-0.08,0.17,0.02),
										vec3(-0.14,-0.07,0.02),
										vec3(0.15,-0.19,0.02),
									
										vec3(0.012,0.15,0.02),
										vec3(-0.08,0.17,0.02),
										vec3(-0.14,-0.07,0.02),
										vec3(0.02,-0.17,0.021),
									
										vec3(0.10,0.05,0.02),
										vec3(-0.13,0.09,0.02),
										vec3(-0.05,-0.1,0.02),
										vec3(0.1,0.01,0.02)
									);	
									

	
	float yDistAxis (in float degrees) {
		vec4 tpos = vec4(sunPosition,1.0)*gbufferProjection;
			 tpos = vec4(tpos.xyz/tpos.w,1.0);
		vec2 lightPos = tpos.xy/tpos.z;
			 lightPos = (lightPos + 1.0f)/2.0f;
			 
		return abs((lightPos.y-lightPos.x*(degrees))-(texcoord.y-texcoord.x*(degrees)));
		
	}
	
	float smoothCircleDist (in float lensDist) {

		vec4 tpos = vec4(sunPosition,1.0)*gbufferProjection;
			 tpos = vec4(tpos.xyz/tpos.w,1.0);
		vec2 lightPos = tpos.xy/tpos.z*lensDist;
			 lightPos = (lightPos + 1.0f)/2.0f;
			 
		return distratio(lightPos.xy, texcoord.xy, aspectRatio);
		
	}
	
	float cirlceDist (float lensDist, float size) {
	
		vec4 tpos = vec4(sunPosition,1.0)*gbufferProjection;
			 tpos = vec4(tpos.xyz/tpos.w,1.0);
		vec2 lightPos = tpos.xy/tpos.z*lensDist;
			 lightPos = (lightPos + 1.0f)/2.0f;
			 
		return pow(min(distratio(lightPos.xy, texcoord.xy, aspectRatio),size)/size,10.);
	}
	
	float hash( float n ) {
		return fract(sin(n)*43758.5453);
	}
 
	float noise( in vec2 x ) {
		vec2 p = floor(x);
		vec2 f = fract(x);
    	f = f*f*(3.0-2.0*f);
    	float n = p.x + p.y*57.0;
    	float res = mix(mix( hash(n+  0.0), hash(n+  1.0),f.x), mix( hash(n+ 57.0), hash(n+ 58.0),f.x),f.y);
    	return res;
	}
 
	float fbm( vec2 p ) {
    	float f = 0.0;
    	f += 0.50000*noise( p ); p = p*2.02;
    	f += 0.25000*noise( p ); p = p*2.03;
    	f += 0.12500*noise( p ); p = p*2.01;
    	f += 0.06250*noise( p ); p = p*2.04;
    	f += 0.03125*noise( p );
		
    	return f/0.984375;
	}

	vec2 texel = vec2(1.0/viewWidth,1.0/viewHeight);
 #ifdef LENS_FLARE
 #define deg1rad 1.14159 / 180.
 #define deg2rad 2.14159 / 180.
 #define deg3rad 3.14159 / 180.
 #define deg4rad 4.14159 / 180.

 
 float dia(float lensDist, float size) {
 
  vec4 tpos = vec4(sunPosition,1.0)*gbufferProjection;
    tpos = vec4(tpos.xyz/tpos.w,1.0);
  vec2 lightPos = tpos.xy/tpos.z*lensDist;
    lightPos = (lightPos + 1.0f)/2.0f;
 
  vec2 uv = texcoord.xy;
  
  // Normalize dia size on different screen-resolutions.
  size *= (viewHeight + viewWidth) / 1920.0;
  
  float r = 10.0;
  
  vec2 v = (lightPos / texel) - (uv / texel);
   
  vec2 topBottomCorner = vec2(1.0, 1.0);
  vec2 leftCorner = vec2(cos(30.*deg1rad), sin(30.*deg2rad));
  vec2 rightCorner = vec2(cos(30.*deg3rad), sin(30.*deg4rad));

  
  float dot1 = dot(abs(v), topBottomCorner);
  float dot2 = dot(abs(v), leftCorner);
  float dot3 = dot(abs(v), rightCorner);


  float dotMax = max(max((dot1), (dot2)), (dot3));
  
  return max(0.0, mix(0.0, mix(1.0, 1.0, floor(size - dotMax*1.1 + 0.99 )), floor(size - dotMax + 0.99 ))) * 0.1;
 }
#endif

#endif


 #ifdef LENS_FLARE2
 #define deg2rad 3.14159 / 180. 
 #define deg3rad 0.0 / 1200.
 float oct(float lensDist, float size) {
 
  vec4 tpos = vec4(sunPosition,1.0)*gbufferProjection;
    tpos = vec4(tpos.xyz/tpos.w,1.0);
  vec2 lightPos = tpos.xy/tpos.z*lensDist;
    lightPos = (lightPos + 1.0f)/2.0f;
 
  vec2 uv = texcoord.xy;
  
  // Normalize oct size on different screen-resolutions.
  size *= (viewHeight + viewWidth) / 1920.0;
  
  float r = 10.0;
  
  vec2 v = (lightPos / texel) - (uv / texel);
   
  vec2 topBottomCorner = vec2(0., 1.);
  vec2 leftCorner = vec2(cos(50.*deg2rad), sin(50.*deg2rad));
  vec2 rightCorner = vec2(cos(30.*deg3rad), sin(30.*deg3rad));

  
  float dot1 = dot(abs(v), topBottomCorner);
  float dot2 = dot(abs(v), leftCorner);
  float dot3 = dot(abs(v), rightCorner);


  float dotMax = max(max((dot1), (dot2)), (dot3));
  
  return max(0.0, mix(0.0, mix(1.0, 1.0, floor(size - dotMax*1.1 + 0.99 )), floor(size - dotMax + 0.99 ))) * 0.1;
 }
#endif

vec3 Uncharted2Tonemap(vec3 x) {
	float D = 0.2;		
	float E = 0.02;
	float F = 0.3;
	float W = MAX_COLOR_RANGE;
	return ((x*(A*x+C*B)+D*E)/(x*(A*x+B)+D*F))-E/F;
}

float distratio(vec2 pos, vec2 pos2) {
	float xvect = pos.x*aspectRatio-pos2.x*aspectRatio;
	float yvect = pos.y-pos2.y;
	return sqrt(xvect*xvect + yvect*yvect);
}
								
float gen_circular_lens(vec2 center, float size) {
	float dist=distratio(center,texcoord.xy)/size;
	return exp(-dist*dist);
}

vec2 noisepattern(vec2 pos) {
	return vec2(abs(fract(sin(dot(pos ,vec2(18.9898f,28.633f))) * 4378.5453f)),abs(fract(sin(dot(pos.yx ,vec2(18.9898f,28.633f))) * 4378.5453f)));
}

float getnoise(vec2 pos) {
	return abs(fract(sin(dot(pos ,vec2(18.9898f,28.633f))) * 4378.5453f));
}

float cdist(vec2 coord) {
	return max(abs(coord.s-0.5),abs(coord.t-0.5))*2.0;
}



vec3 alphablend(vec3 c, vec3 ac, float a) {
vec3 n_ac = normalize(ac)*(1/sqrt(3.));
vec3 nc = sqrt(c*n_ac);
return mix(c,nc,a);
}

float smStep (float edge0,float edge1,float x) {

float t = clamp((x - edge0) / (edge1 - edge0), 0.0, 1.0);
return t * t * (3.0 - 2.0 * t); 
}
float dirtPattern (vec2 tc) {
	float noise = texture2D(noisetex,tc).x;
	noise += texture2D(noisetex,tc*3.5).x/3.5;
	noise += texture2D(noisetex,tc*12.25).x/12.25;
	noise += texture2D(noisetex,tc*42.87).x/42.87;	
	return noise / 1.4472;
}
float matflag = texture2D(gaux1,texcoord.xy).g;

//////////////////////////////VOID MAIN//////////////////////////////
//////////////////////////////VOID MAIN//////////////////////////////
//////////////////////////////VOID MAIN//////////////////////////////
//////////////////////////////VOID MAIN//////////////////////////////
//////////////////////////////VOID MAIN//////////////////////////////

void main() {

	        const float pi = 3.14159265359;
                float rainlens = 0.0;
                const float lifetime = 4.0;		//water drop lifetime in seconds
	        float ftime = frameTimeCounter*2.0/lifetime;  
                vec2 drop = vec2(0.0,fract(frameTimeCounter/20.0));            				int hand  = int(matflag > 0.75 && matflag < 0.85);	

#ifdef RAIN_DROPS
		if (rainStrength > 0.02) {
		float gen = 1.0-fract((ftime+0.5)*0.5);
		vec2 pos = (noisepattern(vec2(-0.94386347*floor(ftime*0.5+0.25),floor(ftime*0.5+0.25))))*0.8+0.1 - drop;
		rainlens += gen_circular_lens(fract(pos),0.04)*gen*rainStrength;

		gen = 1.0-fract((ftime+1.0)*0.5);
		pos = (noisepattern(vec2(0.9347*floor(ftime*0.5+0.5),-0.2533282*floor(ftime*0.5+0.5))))*0.8+0.1- drop;
		rainlens += gen_circular_lens(fract(pos),0.023)*gen*rainStrength;

		gen = 1.0-fract((ftime+1.5)*0.5);
		pos = (noisepattern(vec2(0.785282*floor(ftime*0.5+0.75),-0.285282*floor(ftime*0.5+0.75))))*0.8+0.1- drop;
		rainlens += gen_circular_lens(fract(pos),0.03)*gen*rainStrength;

		gen =  1.0-fract(ftime*0.5);
		pos = (noisepattern(vec2(-0.347*floor(ftime*0.5),0.6847*floor(ftime*0.5))))*0.8+0.1- drop;
		rainlens += gen_circular_lens(fract(pos),0.05)*gen*rainStrength;
		
		gen = 1.0-fract((ftime+1.0)*0.5);
		pos = (noisepattern(vec2(0.8514*floor(ftime*0.5+0.5),-0.456874*floor(ftime*0.5+0.5))))*0.8+0.1- drop;
		rainlens += gen_circular_lens(fract(pos),0.020)*gen*rainStrength;

		gen = 1.0-fract((ftime+1.5)*0.5);
		pos = (noisepattern(vec2(0.845156*floor(ftime*0.5+0.75),-0.2457854*floor(ftime*0.5+0.75))))*0.8+0.1- drop;
		rainlens += gen_circular_lens(fract(pos),0.033)*gen*rainStrength;

		gen =  1.0-fract(ftime*0.5);
		pos = (noisepattern(vec2(-0.368*floor(ftime*0.5),0.8654*floor(ftime*0.5))))*0.8+0.1- drop;
		rainlens += gen_circular_lens(fract(pos),0.05)*gen*rainStrength*5;
		
		gen =  1.0-fract(ftime*0.5);
		pos = (noisepattern(vec2(-0.458*floor(ftime*0.5),0.7546*floor(ftime*0.5))))*0.8+0.1- drop;
		rainlens += gen_circular_lens(fract(pos),0.055)*gen*rainStrength*5;
		
		gen = 1.0-fract((ftime+1.0)*0.5);
		pos = (noisepattern(vec2(0.7532*floor(ftime*0.5+0.5),-0.54275*floor(ftime*0.5+0.5))))*0.8+0.1- drop;
		rainlens += gen_circular_lens(fract(pos),0.029)*gen*rainStrength*5;
	
		rainlens *= clamp((eyeBrightness.y-220)/15.0,0.0,1.0);
	}
#endif
	vec2 fake_refract = vec2(sin(frameTimeCounter + texcoord.x*100.0 + texcoord.y*50.0),cos(frameTimeCounter + texcoord.y*100.0 + texcoord.x*50.0)) ;
	vec2 newTC = texcoord.st + fake_refract * 0.01 * (rainlens+isEyeInWater*0.25);
	
	vec3 color = pow(texture2D(gaux2, newTC).rgb,vec3(2.2))*MAX_COLOR_RANGE;

	float fog = 1-(exp(-pow(ld(texture2D(depthtex0, newTC.st).r)/256.0*far,4.0-(2.7*rainStrength))*4.0));

#ifdef MOTIONBLUR


	float depth = texture2D(depthtex0, texcoord.st).x, num = 0.0075 * MOTIONBLUR_AMOUNT;
	
		vec4 currentPosition = vec4(texcoord.x * 2.0 - 1.0, texcoord.y * 2.0 - 1.0, 2.0 * depth - 1.0, 1.0);
	
		vec4 fragposition = gbufferProjectionInverse * currentPosition;
		fragposition = gbufferModelViewInverse * fragposition;
		fragposition /= fragposition.w;
		fragposition.xyz += cameraPosition;
	
		vec4 previousPosition = fragposition;
		previousPosition.xyz -= previousCameraPosition;
		previousPosition = gbufferPreviousModelView * previousPosition;
		previousPosition = gbufferPreviousProjection * previousPosition;
		previousPosition /= previousPosition.w;
	
		vec2 velocity = (currentPosition - previousPosition).st * num;

		int samples = 1;

		vec3 motion = color.rgb;
		vec2 coord = texcoord.st + velocity;

		for (int i = 0; i < 15; ++i, coord += velocity) {
		if (coord.s > 1.0 || coord.t > 1.0 || coord.s < 0.0 || coord.t < 0.0) {
		break;
		}
		motion += pow(texture2D(gaux2, coord).rgb, vec3(2.2));
		++samples;
		}
		color.rgb = motion/vec3(2.2);

	
	#endif
	
	#ifdef BASIC_DOF

	//Circle Offset Pattern (Modified From Airlock42)

	float z = ld(texture2D(depthtex0, newTC.st).r)*far;
	float focus = ld(texture2D(depthtex0, vec2(0.5)).r)*far;
	float pcoc = min(abs(aperture * (focal * (z - focus)) / (z * (focus - focal)))*sizemult,pw*5.0);

	vec3 bcolor = color/MAX_COLOR_RANGE;

        if (pcoc > pw && hand < 0.9) {
		for ( int i = 0; i < 25; i++) {

	vec2 aspt = vec2(1.0,aspectRatio);
	vec2 shape = circle_offsets[i]*1.2;

	bcolor += pow(texture2D(gaux2, newTC.xy + shape*aspt*pcoc).rgb,vec3(2.2));	
		}
	color.rgb = bcolor/26.0*MAX_COLOR_RANGE;	
	}
	#endif

	//Bloom By AirLoocke42 

	vec3 csample = vec3(0.0); float scale = length(vec2(pw,ph));

	for (int i = 0; i < 25; i++) {

	    vec2 coords = (circle_offsets[i]*4);
	    vec2 aspect = vec2(1.0,aspectRatio);

	    float weight = exp(-length(circle_offsets[i]));

	   csample += pow(texture2D(gaux2, texcoord.xy + coords*1.5*scale* aspect).rgb*weight,vec3(2.2))*4;
	}	
	color = mix(color, csample*8, fog*rainStrength);

	color.xyz = ((1-(1-color.xyz/48.0)*(1-(color.rgb/48.0)*sqrt(luma(color.rgb/48.0))))*48.0);

	//draw rain
	vec4 rain = pow(texture2D(gaux4,newTC.xy)+0.0001,vec4(vec3(2.2),0.4))*vec4(ambient_color*0.4,1.0);
	color.rgb = alphablend(color,rain.rgb,rain.a);
	vec3 bloom = csample/25.0;
	vec3 c_rain = rainlens*ambient_color;

	#ifdef RAIN_DROPS_COLOR
		color += rainlens*vec3(0.25,0.3,0.84)*length(ambient_color);
	#endif

	#ifdef BLOOM	
	color += clamp(pow(max(bloom, 0.0), vec3(1.0))*b_intensity, 0.0, 1.0);
	#endif
	
	float dirt = dirtPattern(texcoord.xy/100.);

	
	//Tonemapping
	vec3 curr = Uncharted2Tonemap(color);
	
	vec3 whiteScale = 1.0f/Uncharted2Tonemap(vec3(MAX_COLOR_RANGE));
	color = curr*whiteScale;
	
		
	#ifdef VIGNETTE
	float len = length(texcoord.xy-vec2(.5));
	float len2 = distratio(texcoord.xy,vec2(.5));
	float dc = mix(len,len2,0.3);
    float vignette = smStep(VIGNETTE_END, VIGNETTE_START,  dc);
	
	color = mix(color,color*vignette,VIGNETTE_STRENGTH);
	#endif

	
	
#ifdef LENS_EFFECTS


	vec4 tpos = vec4(sunPosition,1.0)*gbufferProjection;
		tpos = vec4(tpos.xyz/tpos.w,1.0);
	vec2 lightPos = tpos.xy/tpos.z;
		lightPos = (lightPos + 1.0f)/2.0f;

    float distof = min(min(1.0-lightPos.x,lightPos.x),min(1.0-lightPos.y,lightPos.y));
	float fading = clamp(1.0-step(distof,0.1)+pow(distof*10.0,5.0),0.0,1.0);

    float time = float(worldTime);

    float sunvisibility = min(texture2D(gaux2,vec2(pw,ph)).a,1.0) * fading ;
	float sunvisibility2 = min(texture2D(gaux2,vec2(pw,ph)).a,1.0);
	float centerVisibility = 1.0 - clamp(distance(lightPos.xy, vec2(0.5, 0.5)) * 2.0, 0.0, 1.0);
		  centerVisibility *= sunvisibility;
	
	float lensBrightness = 0.17*LENS_STRENGTH;
	
	
	// Fix, that the particles are visible on the moon position at daytime
	float truepos = 0.99*sign(sunPosition.z);		//1 -> sun / -1 -> moon
	vec3 rainc = mix(vec3(1.),vec3(0.2,0.25,0.3),rainStrength);
	vec3 lightColor = mix(sunlight*sunVisibility*rainc,6*moonlight*moonVisibility*rainc,(truepos+1.0)/3300000.0);
	

	// Dirty Lens
		// Set up domain
		vec2 q = texcoord.xy + texcoord.x * 0.4;
		vec2 p = -1.0 + 3.0 * q;
		vec2 p2 = -1.0 + 3.0 * q + vec2(10.0, 10.0);
		
		// Create noise using fBm
		float f = fbm(5.0 * p);
		float f2 = fbm(20.0 * p2);
	 
		float cover = 0.35f;
		float sharpness = 0.99*DIRTYLENS_BRIGHTNESS * sunvisibility2;	// Brightness
		
		float c = f - (1.0 - cover);
		if ( c < 0.0 )
			 c = 0.0;
		
		f = 1.0 - (pow(1.0 - sharpness, c));
				
				
		float c2 = f2 - (1.0 - cover);
		if ( c2 < 0.0 )
			 c2 = 0.0;
		
		f2 = 1.0 - (pow(1.0 - sharpness, c2));
				
		float dirtylens = (f * 2.0) + (f2 / 1);

	
		float visibility = max(pow(max(1.0 - smoothCircleDist(1.0)/0.8,0.1),2.0)-0.1,0.0);

				
		vec3 lenscolor = pow(normalize(lightColor),vec3(2.2))*length(lightColor);
			
		float lens_strength = 1.3 * lensBrightness;
		lenscolor *= lens_strength;
				
		color += (dirtylens*visibility)*lenscolor*(1.0-rainStrength*1.0)*2.;


	// Anamorphic Lens
	if (sunvisibility > 0.01) {
		
		float visibility = max(pow(max(1.0 - smoothCircleDist(1.0)/1.5,0.1),1.0)-0.1,0.0);
		
			
		vec3 lenscolor = length(lightColor)*vec3(0.2, 0.8, 2.55);

		float lens_strength = 0.8 * lensBrightness;
		lenscolor *= lens_strength;
			
		float anamorphic_lens = max(pow(max(1.0 - yDistAxis(0.0)/1.4,0.1),10.0)-0.5,0.0);
		color += anamorphic_lens * lenscolor * visibility  * sunvisibility * (1.0-rainStrength*1.0);
	}
	

	
		float dist = distance(texcoord.st, vec2(0.5, 0.5));
		
		float sunvisValue = 0.0;
		


		
		// Sunrays
		if (sunvisibility > sunvisValue) {
		
			float visibility = max(pow(max(1.0 - smoothCircleDist(1.0)/1.0,0.1),5.0)-0.1,0.0);
			
			vec3 lenscolor = pow(normalize(lightColor),vec3(2.2))*length(lightColor);
			
			float lens_strength = 0.7 * lensBrightness;
			lenscolor *= lens_strength;
			
			float sunray1 = max(pow(max(1.0 - yDistAxis(1.5)/0.7,0.1),10.0)-0.6,0.0);
			float sunray2 = max(pow(max(1.0 - yDistAxis(-1.3)/0.7,0.1),10.0)-0.6,0.0);
			float sunray3 = max(pow(max(1.0 - yDistAxis(5.0)/1.5,0.1),10.0)-0.6,0.0);
			float sunray4 = max(pow(max(1.0 - yDistAxis(-4.8)/1.5,0.1),10.0)-0.6,0.0);
			
			float sunrays = sunray1 + sunray2 + sunray3 + sunray4;
			
			color += lenscolor * sunrays * visibility * sunvisibility * (1.0-rainStrength*1.0)*2.;
		}
		
		// Sun Glow
		

			
		lenscolor = pow(normalize(lightColor),vec3(2.2))*length(lightColor)* vec3(0.7, 0.75, 1.);
			
		lens_strength = 0.6 * lensBrightness;
		lenscolor *= lens_strength;
			
		float lensFlare = max(pow(max(1.0 - smoothCircleDist(1.0)/2.4,0.1),5.0)-0.1,0.0);
			
		color += lensFlare * lenscolor * sunvisibility2 * (1.0-rainStrength*1.0);



	
	#ifdef LENS_FLARE
		if (sunvisibility > 0.01) {
		
			if (sunvisibility > 0.01) {
		
			// Diamond lens flare.  D  /  S				   // D=distance & S=Size
			float dia1 = clamp(dia(0.3, 20.0), 0.0, 0.40);
			float dia2 = clamp(dia(0.1, 26.0), 0.0, 0.40);		
			float dia3 = clamp(dia(-0.1, 32.0), 0.0, 0.40);

			float dia4 = clamp(dia(-0.3, 38.0), 0.0, 0.40);
			
			float dia5 = clamp(dia(-0.5, 44.0), 0.0, 0.40);
			float dia6 = clamp(dia(-0.7, 50.0), 0.0, 0.40);
			float dia7 = clamp(dia(-0.9, 56.0), 0.0, 0.40);
		
		
								//COLOR   R /  G /  B
			vec3 dia1Color = dia1 * vec3(3.0, 1.0, 0.0);
			vec3 dia2Color = dia2 * vec3(3.0, 2.0, 0.0);
			vec3 dia3Color = dia3 * vec3(3.0, 3.0, 0.0);
			
			vec3 dia4Color = dia4 * vec3(3.0, 4.0, 0.0);
		
			vec3 dia5Color = dia5 * vec3(3.0, 4.2, 3.0);
			vec3 dia6Color = dia6 * vec3(3.0, 4.4, 3.0);
			vec3 dia7Color = dia7 * vec3(3.0, 4.6, 3.0);

			
			vec3 diamond = dia1Color + dia2Color +dia3Color + dia4Color + dia5Color + dia6Color + dia7Color;
			
			
			color += diamond*diamond * lenscolor * sunvisibility * (1.0-rainStrength*1.0)*1.3;
		}
	#endif
			
	#ifdef LENS_FLARE2
			if (sunvisibility > 0.01) {
		
			// Octagon lens flare.  D  /  S				   // D=distance & S=Size
			float oct1 = clamp(oct(0.3, 20.0), 0.0, 0.40);
			float oct2 = clamp(oct(0.1, 26.0), 0.0, 0.40);		
			float oct3 = clamp(oct(-0.1, 32.0), 0.0, 0.40);

			float oct4 = clamp(oct(-0.3, 38.0), 0.0, 0.40);
			
			float oct5 = clamp(oct(-0.5, 44.0), 0.0, 0.40);
			float oct6 = clamp(oct(-0.7, 50.0), 0.0, 0.40);
			float oct7 = clamp(oct(-0.9, 56.0), 0.0, 0.40);
		
		
								//COLOR   R /  G /  B
			vec3 oct1Color = oct1 * vec3(3.0, 1.0, 0.0);
			vec3 oct2Color = oct2 * vec3(3.0, 2.0, 0.0);
			vec3 oct3Color = oct3 * vec3(3.0, 3.0, 0.0);
			
			vec3 oct4Color = oct4 * vec3(3.0, 4.0, 0.0);
		
			vec3 oct5Color = oct5 * vec3(3.0, 4.2, 3.0);
			vec3 oct6Color = oct6 * vec3(3.0, 4.4, 3.0);
			vec3 oct7Color = oct7 * vec3(3.0, 4.6, 3.0);

			
			vec3 octagon = oct1Color + oct2Color + oct3Color + oct4Color + oct5Color + oct6Color + oct7Color;
			
			
			color += octagon*octagon * lenscolor * sunvisibility * (1.0-rainStrength*1.0)*1.3;
		}		
	#endif
	
#endif
	
        
        
         float saturation = 1.015;   
	
       
        float avg = (color.r + color.g + color.b);
       
        color = (((color - avg )*saturation)+avg) ;
		color /= saturation;

 
       
	color = clamp(pow(color,vec3(1.0/2.2)),0.0,1.0);

	     color.r = color.r*1.0;
         
	     color.g = color.g*1.0; 
         
	     color.b = color.b*1.0;


	     
	gl_FragColor = vec4(color,1.0);
}

