var transformerName = "VoxelMap Watch For Changes Transformer";
var targetClass = "net.minecraft.client.renderer.WorldRenderer";
clinit();
start("Initialisation");

start("fieldsToAdd");
// Params: int access, String name, String descriptor, String signature, Object value
var fieldsToAdd = [
];
finish(); // end fieldsToAdd

start("methodsToAdd");
var methodsToAdd = [
];
finish(); // end methodsToAdd

start("targetMethods");
var targetMethods = [
  //markForRerender
	new TargetMethod("func_215319_a", "(IIIZ)V",
		new MethodTransformer(injectScheduleChunkRenderHook, "injectScheduleChunkRenderHook")
	)
];
finish(); // end targetMethods

finish(); // end Initialisation




// 1) Find first label
// 2) inject right after first label
function injectScheduleChunkRenderHook(instructions) {

//      this.viewFrustum.func_217628_a(p_215319_1_, p_215319_2_, p_215319_3_, p_215319_4_);
//	// VoxelMap Start
//    	VoxelMap.instance.getWorldUpdateListener().notifyObservers(p_215319_1_, p_215319_3_);
//	// VoxelMap End


//  private func_215319_a(IIIZ)V
//   L0
//    LINENUMBER 1714 L0
//    ALOAD 0
//    GETFIELD net/minecraft/client/renderer/WorldRenderer.viewFrustum : Lnet/minecraft/client/renderer/ViewFrustum;
//    ILOAD 1
//    ILOAD 2
//    ILOAD 3
//    ILOAD 4
//    INVOKEVIRTUAL net/minecraft/client/renderer/ViewFrustum.func_217628_a(IIIZ)V
//   L1
//    LINENUMBER 1715 L1
//    RETURN
//   L2
//    LOCALVARIABLE this Lnet/minecraft/client/renderer/WorldRenderer; L0 L2 0
//    LOCALVARIABLE p_215319_1_ I L0 L2 1
//    LOCALVARIABLE p_215319_2_ I L0 L2 2
//    LOCALVARIABLE p_215319_3_ I L0 L2 3
//    LOCALVARIABLE p_215319_4_ Z L0 L2 4
//    MAXSTACK = 5
//    MAXLOCALS = 5


//  private func_215319_a(IIIZ)V
//   L0
//    LINENUMBER 1715 L0
//    ALOAD 0
//    GETFIELD net/minecraft/client/renderer/WorldRenderer.viewFrustum : Lnet/minecraft/client/renderer/ViewFrustum;
//    ILOAD 1
//    ILOAD 2
//    ILOAD 3
//    ILOAD 4
//    INVOKEVIRTUAL net/minecraft/client/renderer/ViewFrustum.func_217628_a(IIIZ)V
//   L1
//    LINENUMBER 1716 L1
//    GETSTATIC com/mamiyaotaru/voxelmap/VoxelMap.instance : Lcom/mamiyaotaru/voxelmap/interfaces/AbstractVoxelMap;
//    INVOKEVIRTUAL com/mamiyaotaru/voxelmap/interfaces/AbstractVoxelMap.getWorldUpdateListener()Lcom/mamiyaotaru/voxelmap/util/WorldUpdateListener;
//    ILOAD 1
//    ILOAD 3
//    INVOKEVIRTUAL com/mamiyaotaru/voxelmap/util/WorldUpdateListener.notifyObservers(II)V
//   L2
//    LINENUMBER 1717 L2
//    RETURN
//   L3
//    LOCALVARIABLE this Lnet/minecraft/client/renderer/WorldRenderer; L0 L3 0
//    LOCALVARIABLE p_215319_1_ I L0 L3 1
//    LOCALVARIABLE p_215319_2_ I L0 L3 2
//    LOCALVARIABLE p_215319_3_ I L0 L3 3
//    LOCALVARIABLE p_215319_4_ Z L0 L3 4
//    MAXSTACK = 5
//    MAXLOCALS = 5


	var secondLabel;
	var arrayLength = instructions.size();
	var labelCount = 0;
	for (var i = 0; i < arrayLength; ++i) {
		var instruction = instructions.get(i);
		if (instruction.getType() == AbstractInsnNode.LABEL) {
			labelCount++;
			if (labelCount == 2) {
				secondLabel = instruction;
				log("Found injection point " + instruction);
				break;
			}
		}
	}
	if (!secondLabel) {
		throw "Error: Couldn't find injection point!";
	}

	var toInject = new InsnList();

	// Labels n stuff
	var originalInstructionsLabel = new LabelNode();
		
	//var instructionsLabel = new LabelNode();
	//toInject.add(new FieldInsnNode(Opcodes.GETSTATIC, "java/lang/System", "out", "Ljava/io/PrintStream;"));
    //toInject.add(new LdcInsnNode("Hello World!"));
    //toInject.add(new MethodInsnNode(Opcodes.INVOKEVIRTUAL, "java/io/PrintStream", "println", "(Ljava/lang/String;)V"));
    //toInject.add(instructionsLabel);
    
    // Make list of instructions to inject        
	toInject.add(new FieldInsnNode(Opcodes.GETSTATIC, "com/mamiyaotaru/voxelmap/VoxelMap", "instance", "Lcom/mamiyaotaru/voxelmap/interfaces/AbstractVoxelMap;"));
	toInject.add(new MethodInsnNode(
			//int opcode
			Opcodes.INVOKEVIRTUAL,
			//String owner
			"com/mamiyaotaru/voxelmap/interfaces/AbstractVoxelMap",
			//String name
			"getWorldUpdateListener",
			//String descriptor
			"()Lcom/mamiyaotaru/voxelmap/util/WorldUpdateListener;",
			//boolean isInterface
			false
	));
	//would be INVOKEINTERFACE, , ,true if the class was an interface
	toInject.add(new VarInsnNode(Opcodes.ILOAD, 1)); // x
	toInject.add(new VarInsnNode(Opcodes.ILOAD, 3)); // z
	toInject.add(new MethodInsnNode(
			//int opcode
			Opcodes.INVOKEVIRTUAL,
			//String owner
			"com/mamiyaotaru/voxelmap/util/WorldUpdateListener",
			//String name
			"notifyObservers",
			//String descriptor
			"(II)V",
			//boolean isInterface
			false
	));
	toInject.add(originalInstructionsLabel);

	// Inject instructions
	instructions.insert(secondLabel, toInject);

}











function initializeCoreMod() {
	log("Initialising " + transformerName);
	return {
		transformerName: {
			'target': {
				'type': 'CLASS',
				'name': targetClass
			},
			'transformer': function(classNode) {

				log("Starting");
				var hasFinished = false;
				try {

					if (fieldsToAdd.length > 0) {
						start("Adding Fields");
						var fields = classNode.fields;
						for (var i in fieldsToAdd) {
							var field = fieldsToAdd[i];
							log("Adding Field \"" + field.name + "\"");
							fields.add(field);
						}
						finish();
					}

					if (methodsToAdd.length > 0) {
						start("Adding Methods");
						var methods = classNode.methods;
						for (var i in methodsToAdd) {
							var method = methodsToAdd[i];
							log("Adding Method \"" + method.name + "\"");
							methods.add(method);
						}
						finish();
					}

					if (targetMethods.length > 0) {
						var targetMethodsToFind = targetMethods.length;
						start("Transforming Methods");
						for (var j in targetMethods) {
							var targetMethod = targetMethods[j];
							log("Target Method \"" + targetMethod.name + "\" - \"" + targetMethod.desc + "\"");
						}
						var methods = classNode.methods;
						for (var i in methods) {
							if (targetMethodsToFind == 0) {
								break;
							}
							var method = methods[i];
							var methodName = method.name;
							var methodDesc = method.desc;
							var methodInstructions = method.instructions;
							log("Examining Method \"" + methodName + "\" - \"" + methodDesc + "\"");
							for (var j in targetMethods) {
								var targetMethod = targetMethods[j];
								var targetMethodName = targetMethod.name;
								var targetMethodDesc = targetMethod.desc;
								if (targetMethodName.equals(methodName) && targetMethodDesc.equals(methodDesc)) {
									log("Target Method \"" + targetMethodName + "\" - \"" + targetMethodDesc + "\" matched");
									--targetMethodsToFind;
									targetMethod.found = true;
									var methodTransformers = targetMethod.transformers;
									for (var k in methodTransformers) {
										var methodTransformer = methodTransformers[k];
										start("Apply " + methodTransformer.name);
										methodTransformer.func(methodInstructions);
										finish();
									}
								}
							}
						}
						if (targetMethodsToFind != 0) {
							for (var j in targetMethods) {
    							var targetMethod = targetMethods[j];
    							if (!targetMethod.found) {
    								log("Failed to find Target Method \"" + targetMethod.name + "\" - \"" + targetMethod.desc + "\"!");
    							}
    						}
    						throw "Failed to find all Target Methods!";
						}
						finish();
					}
					hasFinished = true;
				} finally {
          // bug in bundled JRE:
					// the break in the for loop brings us here immediately.  It's before hasFinished set, so we log an exception 
					// (and pop currentlyRunning).  We then return to the end of the for loop, and finish() gets an undefined value
					// because of the pop in finally.  Then hasFinished gets set and then the finally block happens a second time.
					// this bug does not happen in up to date JRE8.  It was supposedly fixed in u60 
					// (see https://wiki.openjdk.java.net/pages/viewpage.action?pageId=22937606 )
					// while my bundled JRE is u51, so this happens with the bundled JRE but not my up to date non-bundled JRE
					if(!hasFinished) {
						log("Caught exception from " + currentlyRunning.pop());
					}
				}
				log("Finished");

				return classNode;
			}
		}
	}
}

function TargetMethod(name, desc, transformer1, transformer2, transformer3) { // Varargs seems not to work :/
	this.name = ASMAPI.mapMethod(name);
	this.desc = desc;
	this.found = false;
	this.transformers = [];
	if (transformer1 != undefined) this.transformers.push(transformer1);
	if (transformer2 != undefined) this.transformers.push(transformer2);
	if (transformer3 != undefined) this.transformers.push(transformer3);
}

function MethodTransformer(func, name) {
	this.func = func;
	this.name = name;
}

function removeBetweenInclusive(instructions, startInstruction, endInstruction) {
	var start = instructions.indexOf(startInstruction);
	var end = instructions.indexOf(endInstruction);
	for (var i = start; i < end; ++i) {
		instructions.remove(instructions.get(start));
	}
}

function start(name) {
	log("Starting " + name);
	currentlyRunning.push(name);
}

function finish() {
	var name = currentlyRunning.pop();
	log("Finished " + name);
}

function log(msg) {
	var str = "[" + transformerName + "]";
	for (var i in currentlyRunning) {
		str += " [" + currentlyRunning[i] + "]";
	}
	print(str + ": " + msg);
}

function clinit() {
	currentlyRunning = [];

	/*Class/Interface*/ Opcodes = Java.type('org.objectweb.asm.Opcodes');
	/*Class*/ ASMAPI = Java.type('net.minecraftforge.coremod.api.ASMAPI');

	/*Class*/ InsnList = Java.type('org.objectweb.asm.tree.InsnList');
	/*Class*/ LabelNode = Java.type('org.objectweb.asm.tree.LabelNode');

	/*Class*/ FieldNode = Java.type('org.objectweb.asm.tree.FieldNode');
	/*Class*/ MethodNode = Java.type('org.objectweb.asm.tree.MethodNode');

	/*Class*/ AbstractInsnNode = Java.type('org.objectweb.asm.tree.AbstractInsnNode');
	/*Class*/ InsnNode = Java.type('org.objectweb.asm.tree.InsnNode');
	/*Class*/ LdcInsnNode = Java.type('org.objectweb.asm.tree.LdcInsnNode');
	/*Class*/ VarInsnNode = Java.type('org.objectweb.asm.tree.VarInsnNode');
	/*Class*/ FieldInsnNode = Java.type('org.objectweb.asm.tree.FieldInsnNode');
	/*Class*/ MethodInsnNode = Java.type('org.objectweb.asm.tree.MethodInsnNode');
	/*Class*/ JumpInsnNode = Java.type('org.objectweb.asm.tree.JumpInsnNode');
	/*Class*/ TypeInsnNode = Java.type('org.objectweb.asm.tree.TypeInsnNode');
}
