#version 120
#define MAX_COLOR_RANGE 48.0

/*
!! DO NOT REMOVE !!
BSL Shaders is derived from Chocapic13 v5 test 2

This code is from Chocapic13' shaders
Read the terms of modification and sharing before changing something below please !
!! DO NOT REMOVE !!
*/

/*
Disable an effect by putting "//" before "#define" when there is no number after
You can tweak the numbers, the impact on the shaders is self-explained in the variable's name or in a comment
*/

//ADJUSTABLE VARIABLES//

	#define VIGNETTE
		#define VIGNETTE_STRENGTH 0.8			//default 0.8
		#define VIGNETTE_START 0.1				//distance from the center of the screen where the vignette effect start (0-1), default 0.1
		#define VIGNETTE_END 1.5				//distance from the center of the screen where the vignette effect end (0-1), default 1.5
  
	#define LENS_EFFECTS		
		#define LENS_STRENGTH 2					//default 2
		//#define DIRTY_LENS
		//#define SUN_RAYS
		#define ANAMORPHIC_LENS
	
	#define RAIN_DROPS

	//#define BLOOM								//Also enable in composite2.fsh
		#define BLOOM_STRENGTH 64.0

	//#define DOF								//enable depth of field (blur on non-focused objects)
		//#define CIRCLE_BOKEH					//enabled : circular blur shape
		//#define HEXAGONAL_BOKEH				//enabled : hexagonal blur shape
		#define LOW_BOKEH						//enabled : low quality circular blur shape
		
		//#define DISTANT_BLUR					//blurs everything far away
			#define DISTANT_BLUR_RANGE 304			//blur distance from player position (best : render distance(in block) * 2.5 - 16)
		//#define HAND_BLUR	
		#define DUAL_BLUR						//normal dof + distant blur

		const float focal = 0.025;
		float aperture = 0.01;
		const float sizemult = 100.0;
		
		#define MAX_BLUR_SIZE 4
		

	//#define MOTION_BLUR
		#define MOTION_BLUR_PASS 4

	#define COLOR_BOOST
		#define BOOST 0.2	
	
	#define SATURATION
		#define SATURATE 0.9

	//#define BLACK_BORDER
		#define BORDER_RATIO 2.333				//aspect ratio for border : width/height
		#define BORDER_OPACITY 1
		
	//#define FILM_GRAIN
		#define GRAIN_CHECK 0.5					//lower value makes grain appears in darker area.
		#define GRAIN_DENSITY 0.25
	
//TONEMAP		
float A = 1.0;		//brightness multiplier
float B = 0.37;		//black level (lower means darker and more constrasted, higher make the image whiter and less constrasted)
float C = 0.1;		//constrast level 
	
//ADJUSTABLE VARIABLES//



varying vec4 texcoord;

varying vec3 lightVector;
varying vec3 sunVec;
varying vec3 moonVec;
varying vec3 upVec;

varying vec3 sunlight;
varying vec3 moonlight;
varying vec3 ambient_color;

varying float eyeAdapt;

varying float SdotU;
varying float MdotU;
varying float sunVisibility;
varying float moonVisibility;

uniform sampler2D gaux1;
vec3 aux = texture2D(gaux1, texcoord.st).rgb;
uniform sampler2D depthtex0;
uniform sampler2D depthtex1;
uniform sampler2D depthtex2;
uniform sampler2D noisetex;
uniform sampler2D gaux2;
uniform sampler2D gaux4;
uniform sampler2D composite;
uniform vec3 cameraPosition;
uniform vec3 previousCameraPosition;
uniform vec3 sunPosition;
uniform vec3 moonPosition;
uniform mat4 gbufferProjection;
uniform mat4 gbufferProjectionInverse;
uniform mat4 gbufferPreviousProjection;
uniform mat4 gbufferModelViewInverse;
uniform mat4 gbufferPreviousModelView;
uniform ivec2 eyeBrightness;
uniform int isEyeInWater;
uniform int worldTime;
uniform float aspectRatio;
uniform float near;
uniform float far;
uniform float viewWidth;
uniform float viewHeight;
uniform float rainStrength;
uniform float wetness;
uniform float frameTimeCounter;
uniform int fogMode;
vec3 sunPos = sunPosition;
float pw = 1.0/ viewWidth;
float ph = 1.0/ viewHeight;
float timefract = worldTime;

//Raining
float rainx = clamp(rainStrength, 0.0f, 1.0f)/1.0f;
float wetx  = clamp(wetness, 0.0f, 1.0f);

//Calculate Time of Day
float TimeSunrise  = ((clamp(timefract, 23000.0, 24000.0) - 23000.0) / 1000.0) + (1.0 - (clamp(timefract, 0.0, 4000.0)/4000.0));
float TimeNoon     = ((clamp(timefract, 0.0, 4000.0)) / 4000.0) - ((clamp(timefract, 8000.0, 12000.0) - 8000.0) / 4000.0);
float TimeSunset   = ((clamp(timefract, 8000.0, 12000.0) - 8000.0) / 4000.0) - ((clamp(timefract, 12000.0, 12750.0) - 12000.0) / 750.0);
float TimeMidnight = ((clamp(timefract, 12000.0, 12750.0) - 12000.0) / 750.0) - ((clamp(timefract, 23000.0, 24000.0) - 23000.0) / 1000.0);

// Standard depth function.
float getDepth(float depth) {
    return 2.0 * near * far / (far + near - (2.0 * depth - 1.0) * (far - near));
}

float ld(float depth) {
    return (2.0 * near) / (far + near - depth * (far - near));
}

float luma(vec3 color) {
	return dot(color,vec3(0.299, 0.587, 0.114));
}



	//hexagon pattern
	const vec2 hex_offsets[60] = vec2[60] (	vec2(  0.2165,  0.1250 ),
											vec2(  0.0000,  0.2500 ),
											vec2( -0.2165,  0.1250 ),
											vec2( -0.2165, -0.1250 ),
											vec2( -0.0000, -0.2500 ),
											vec2(  0.2165, -0.1250 ),
											vec2(  0.4330,  0.2500 ),
											vec2(  0.0000,  0.5000 ),
											vec2( -0.4330,  0.2500 ),
											vec2( -0.4330, -0.2500 ),
											vec2( -0.0000, -0.5000 ),
											vec2(  0.4330, -0.2500 ),
											vec2(  0.6495,  0.3750 ),
											vec2(  0.0000,  0.7500 ),
											vec2( -0.6495,  0.3750 ),
											vec2( -0.6495, -0.3750 ),
											vec2( -0.0000, -0.7500 ),
											vec2(  0.6495, -0.3750 ),
											vec2(  0.8660,  0.5000 ),
											vec2(  0.0000,  1.0000 ),
											vec2( -0.8660,  0.5000 ),
											vec2( -0.8660, -0.5000 ),
											vec2( -0.0000, -1.0000 ),
											vec2(  0.8660, -0.5000 ),
											vec2(  0.2163,  0.3754 ),
											vec2( -0.2170,  0.3750 ),
											vec2( -0.4333, -0.0004 ),
											vec2( -0.2163, -0.3754 ),
											vec2(  0.2170, -0.3750 ),
											vec2(  0.4333,  0.0004 ),
											vec2(  0.4328,  0.5004 ),
											vec2( -0.2170,  0.6250 ),
											vec2( -0.6498,  0.1246 ),
											vec2( -0.4328, -0.5004 ),
											vec2(  0.2170, -0.6250 ),
											vec2(  0.6498, -0.1246 ),
											vec2(  0.6493,  0.6254 ),
											vec2( -0.2170,  0.8750 ),
											vec2( -0.8663,  0.2496 ),
											vec2( -0.6493, -0.6254 ),
											vec2(  0.2170, -0.8750 ),
											vec2(  0.8663, -0.2496 ),
											vec2(  0.2160,  0.6259 ),
											vec2( -0.4340,  0.5000 ),
											vec2( -0.6500, -0.1259 ),
											vec2( -0.2160, -0.6259 ),
											vec2(  0.4340, -0.5000 ),
											vec2(  0.6500,  0.1259 ),
											vec2(  0.4325,  0.7509 ),
											vec2( -0.4340,  0.7500 ),
											vec2( -0.8665, -0.0009 ),
											vec2( -0.4325, -0.7509 ),
											vec2(  0.4340, -0.7500 ),
											vec2(  0.8665,  0.0009 ),
											vec2(  0.2158,  0.8763 ),
											vec2( -0.6510,  0.6250 ),
											vec2( -0.8668, -0.2513 ),
											vec2( -0.2158, -0.8763 ),
											vec2(  0.6510, -0.6250 ),
											vec2(  0.8668,  0.2513 ));
											
	const vec2 offsets[60] = vec2[60]  (  vec2( 0.0000, 0.2500 ),
									vec2( -0.2165, 0.1250 ),
									vec2( -0.2165, -0.1250 ),
									vec2( -0.0000, -0.2500 ),
									vec2( 0.2165, -0.1250 ),
									vec2( 0.2165, 0.1250 ),
									vec2( 0.0000, 0.5000 ),
									vec2( -0.2500, 0.4330 ),
									vec2( -0.4330, 0.2500 ),
									vec2( -0.5000, 0.0000 ),
									vec2( -0.4330, -0.2500 ),
									vec2( -0.2500, -0.4330 ),
									vec2( -0.0000, -0.5000 ),
									vec2( 0.2500, -0.4330 ),
									vec2( 0.4330, -0.2500 ),
									vec2( 0.5000, -0.0000 ),
									vec2( 0.4330, 0.2500 ),
									vec2( 0.2500, 0.4330 ),
									vec2( 0.0000, 0.7500 ),
									vec2( -0.2565, 0.7048 ),
									vec2( -0.4821, 0.5745 ),
									vec2( -0.6495, 0.3750 ),
									vec2( -0.7386, 0.1302 ),
									vec2( -0.7386, -0.1302 ),
									vec2( -0.6495, -0.3750 ),
									vec2( -0.4821, -0.5745 ),
									vec2( -0.2565, -0.7048 ),
									vec2( -0.0000, -0.7500 ),
									vec2( 0.2565, -0.7048 ),
									vec2( 0.4821, -0.5745 ),
									vec2( 0.6495, -0.3750 ),
									vec2( 0.7386, -0.1302 ),
									vec2( 0.7386, 0.1302 ),
									vec2( 0.6495, 0.3750 ),
									vec2( 0.4821, 0.5745 ),
									vec2( 0.2565, 0.7048 ),
									vec2( 0.0000, 1.0000 ),
									vec2( -0.2588, 0.9659 ),
									vec2( -0.5000, 0.8660 ),
									vec2( -0.7071, 0.7071 ),
									vec2( -0.8660, 0.5000 ),
									vec2( -0.9659, 0.2588 ),
									vec2( -1.0000, 0.0000 ),
									vec2( -0.9659, -0.2588 ),
									vec2( -0.8660, -0.5000 ),
									vec2( -0.7071, -0.7071 ),
									vec2( -0.5000, -0.8660 ),
									vec2( -0.2588, -0.9659 ),
									vec2( -0.0000, -1.0000 ),
									vec2( 0.2588, -0.9659 ),
									vec2( 0.5000, -0.8660 ),
									vec2( 0.7071, -0.7071 ),
									vec2( 0.8660, -0.5000 ),
									vec2( 0.9659, -0.2588 ),
									vec2( 1.0000, -0.0000 ),
									vec2( 0.9659, 0.2588 ),
									vec2( 0.8660, 0.5000 ),
									vec2( 0.7071, 0.7071 ),
									vec2( 0.5000, 0.8660 ),
									vec2( 0.2588, 0.9659 ));
const vec2 fast_offsets[20] = vec2[20](vec2(1,0),
									vec2(-1,0),
									vec2(0,1),
									vec2(0,-1),
									vec2(0.7,0.7),
									vec2(-0.7,0.7),
									vec2(0.7,-0.7),
									vec2(-0.7,-0.7),
									vec2(0.5,0),
									vec2(-0.5,0),
									vec2(0,0.5),
									vec2(0,-0.5),
									vec2(0.35,0.35),
									vec2(-0.35,0.35),
									vec2(0.35,-0.35),
									vec2(-0.35,-0.35),
									vec2(0.25,0),
									vec2(-0.25,0),
									vec2(0,0.25),
									vec2(0,-0.25)
									);									

vec3 Uncharted2Tonemap(vec3 x) {
	float D = 0.2;		
	float E = 0.02;
	float F = 0.3;
	float W = MAX_COLOR_RANGE;
	return ((x*(A*x+C*B)+D*E)/(x*(A*x+B)+D*F))-E/F;
}

float distratio(vec2 pos, vec2 pos2) {
	float xvect = pos.x*aspectRatio-pos2.x*aspectRatio;
	float yvect = pos.y-pos2.y;
	return sqrt(xvect*xvect + yvect*yvect);
}
								
float gen_circular_lens(vec2 center, float size) {
	float dist=distratio(center,texcoord.xy)/size;
	return exp(-dist*dist);
}

vec2 noisepattern(vec2 pos) {
	return vec2(abs(fract(sin(dot(pos ,vec2(18.9898f,28.633f))) * 4378.5453f)),abs(fract(sin(dot(pos.yx ,vec2(18.9898f,28.633f))) * 4378.5453f)));
}

float getnoise(vec2 pos) {
	return abs(fract(sin(dot(pos ,vec2(18.9898f,28.633f))) * 4378.5453f));
}

float cdist(vec2 coord) {
	return max(abs(coord.s-0.5),abs(coord.t-0.5))*2.0;
}


float distratio(vec2 pos, vec2 pos2, float ratio) {
	float xvect = pos.x*ratio-pos2.x*ratio;
	float yvect = pos.y-pos2.y;
	return sqrt(xvect*xvect + yvect*yvect);
}
	
//circle position pattern (vec2 coordinate, size)
const vec3 pattern[16] = vec3[16](	vec3(0.1,0.1,0.02),
									vec3(-0.12,0.07,0.02),
									vec3(-0.11,-0.13,0.02),
									vec3(0.1,-0.1,0.02),
								
									vec3(0.07,0.15,0.02),
									vec3(-0.08,0.17,0.02),
									vec3(-0.14,-0.07,0.02),
								vec3(0.15,-0.19,0.02),
								
									vec3(0.012,0.15,0.02),
									vec3(-0.08,0.17,0.02),
									vec3(-0.14,-0.07,0.02),
									vec3(0.02,-0.17,0.021),
								
									vec3(0.10,0.05,0.02),
									vec3(-0.13,0.09,0.02),
									vec3(-0.05,-0.1,0.02),
									vec3(0.1,0.01,0.02)
								);	

float yDistAxis (in float degrees) {
	vec4 tpos = vec4(sunPosition,1.0)*gbufferProjection;
		 tpos = vec4(tpos.xyz/tpos.w,1.0);
	vec2 lightPos = tpos.xy/tpos.z;
		 lightPos = (lightPos + 1.0f)/2.0f;
		 
	return abs((lightPos.y-lightPos.x*(degrees))-(texcoord.y-texcoord.x*(degrees)));
	
}

float smoothCircleDist (in float lensDist) {
		vec4 tpos = vec4(sunPosition,1.0)*gbufferProjection;
		 tpos = vec4(tpos.xyz/tpos.w,1.0);
	vec2 lightPos = tpos.xy/tpos.z*lensDist;
		 lightPos = (lightPos + 1.0f)/2.0f;
		 
	return distratio(lightPos.xy, texcoord.xy, aspectRatio);
	
}

float cirlceDist (float lensDist, float size) {

	vec4 tpos = vec4(sunPosition,1.0)*gbufferProjection;
		 tpos = vec4(tpos.xyz/tpos.w,1.0);
	vec2 lightPos = tpos.xy/tpos.z*lensDist;
		 lightPos = (lightPos + 1.0f)/2.0f;
		 
	return pow(min(distratio(lightPos.xy, texcoord.xy, aspectRatio),size)/size,10.);
}

float hash( float n ) {
	return fract(sin(n)*43758.5453);
}

float noise( in vec2 x ) {
	vec2 p = floor(x);
	vec2 f = fract(x);
   	f = f*f*(3.0-2.0*f);
   	float n = p.x + p.y*57.0;
	float res = mix(mix( hash(n+  0.0), hash(n+  1.0),f.x), mix( hash(n+ 57.0), hash(n+ 58.0),f.x),f.y);
   	return res;
}
 
float fbm( vec2 p ) {
   	float f = 0.0;
   	f += 0.50000*noise( p ); p = p*2.02;
   	f += 0.25000*noise( p ); p = p*2.03;
   	f += 0.12500*noise( p ); p = p*2.01;
   	f += 0.06250*noise( p ); p = p*2.04;
   	f += 0.03125*noise( p );
	
   	return f/0.984375;
}

vec3 alphablend(vec3 c, vec3 ac, float a) {
vec3 n_ac = normalize(ac)*(1/sqrt(3.));
vec3 nc = sqrt(c*n_ac);
return mix(c,nc,a);
}
float smStep (float edge0,float edge1,float x) {
float t = clamp((x - edge0) / (edge1 - edge0), 0.0, 1.0);
return t * t * (3.0 - 2.0 * t); }
float dirtPattern (vec2 tc) {
	float noise = texture2D(noisetex,tc).x;
	noise += texture2D(noisetex,tc*3.5).x/3.5;
	noise += texture2D(noisetex,tc*12.25).x/12.25;
	noise += texture2D(noisetex,tc*42.87).x/42.87;	
	return noise / 1.4472;
}
//////////////////////////////VOID MAIN//////////////////////////////
//////////////////////////////VOID MAIN//////////////////////////////
//////////////////////////////VOID MAIN//////////////////////////////
//////////////////////////////VOID MAIN//////////////////////////////
//////////////////////////////VOID MAIN//////////////////////////////

void main() {


		const float pi = 3.14159265359;
		float rainlens = 0.0;
		const float lifetime = 4.0;		//water drop lifetime in seconds
		float ftime = frameTimeCounter*2.0/lifetime;  
		vec2 drop = vec2(0.0,fract(frameTimeCounter/20.0));
#ifdef RAIN_DROPS
		if (rainStrength > 0.02) {
		float gen = 1.0-fract((ftime+0.5)*0.5);
		vec2 pos = (noisepattern(vec2(-0.94386347*floor(ftime*0.5+0.25),floor(ftime*0.5+0.25))))*0.8+0.1 - drop;
		rainlens += gen_circular_lens(fract(pos),0.04)*gen*rainStrength;

		gen = 1.0-fract((ftime+1.0)*0.5);
		pos = (noisepattern(vec2(0.9347*floor(ftime*0.5+0.5),-0.2533282*floor(ftime*0.5+0.5))))*0.8+0.1- drop;
		rainlens += gen_circular_lens(fract(pos),0.023)*gen*rainStrength;

		gen = 1.0-fract((ftime+1.5)*0.5);
		pos = (noisepattern(vec2(0.785282*floor(ftime*0.5+0.75),-0.285282*floor(ftime*0.5+0.75))))*0.8+0.1- drop;
		rainlens += gen_circular_lens(fract(pos),0.03)*gen*rainStrength;

		gen =  1.0-fract(ftime*0.5);
		pos = (noisepattern(vec2(-0.347*floor(ftime*0.5),0.6847*floor(ftime*0.5))))*0.8+0.1- drop;
		rainlens += gen_circular_lens(fract(pos),0.05)*gen*rainStrength;
	
		rainlens *= clamp((eyeBrightness.y-220)/15.0,0.0,1.0);
	}
#endif
	vec2 fake_refract = vec2(sin(frameTimeCounter + texcoord.x*100.0 + texcoord.y*50.0),cos(frameTimeCounter + texcoord.y*100.0 + texcoord.x*50.0)) ;
	vec2 newTC = texcoord.st + fake_refract * 0.01 * (rainlens+isEyeInWater*0.25);
	#ifdef CAM_SHIFT
	vec2 camshift = vec2(0.37,0.25);
	newTC = newTC/2+camshift;
	#endif
	
	vec3 color = pow(texture2D(gaux2, newTC).rgb,vec3(2.2))*MAX_COLOR_RANGE;
	vec3 aux = texture2D(gaux1, newTC).rgb;
	
		float hand  = float(aux.g > 0.75 && aux.g < 0.85);
		float land = float(aux.g > 0.04);
		
	float fog = 1-(exp(-pow(ld(texture2D(depthtex0, newTC.st).r)/DISTANT_BLUR_RANGE*far,4.0-(rainStrength))*4.0));
	
float pcoc = 0;	
#ifdef DOF
	float z = ld(texture2D(depthtex0, newTC.st).r)*far;
	float focus = ld(texture2D(depthtex0, vec2(0.5)).r)*far;
	float blursize = MAX_BLUR_SIZE*viewWidth/1280;
	pcoc = min(abs(aperture * (focal * (z - focus)) / (z * (focus - focal)))*sizemult,pw*blursize);
	
	#ifdef DISTANT_BLUR
	if (land > 0.9)
	pcoc = min(fog*pw*sizemult,pw*blursize);
	else
	pcoc = min(fog*pw*sizemult,pw*blursize)*(fog*(1-rainStrength)+rainStrength);
	#endif
	
	#ifdef DUAL_BLUR
	pcoc = min((abs(aperture * (focal * (z - focus)) / (z * (focus - focal)))+fog*pw*land)*sizemult,pw*blursize);
	#endif
	
	#ifndef HAND_BLUR
	pcoc = pcoc*(1-hand);
	#endif
	
	
	vec4 sample = vec4(0.0);
	vec3 bcolor = color/MAX_COLOR_RANGE;
	float nb = 0.0;
	vec2 bcoord = vec2(0.0);
	
{
	if (pcoc > pw) {
	#ifdef HEXAGONAL_BOKEH
	
		for ( int i = 0; i < 60; i++) {
			bcolor += pow(texture2D(gaux2, newTC.xy + hex_offsets[i]*pcoc*vec2(1.0,aspectRatio)).rgb,vec3(2.2));
			
		}
		color.rgb = bcolor/(61)*MAX_COLOR_RANGE;
	#endif
	#ifdef LOW_BOKEH
	for ( int i = 0; i < 20; i++) {
		bcolor += pow(texture2D(gaux2, newTC.xy + fast_offsets[i]*pcoc*vec2(1.0,aspectRatio)).rgb,vec3(2.2));
		}
		color.rgb = bcolor/(21)*MAX_COLOR_RANGE;
	#endif
	#ifdef CIRCLE_BOKEH
	for ( int i = 0; i < 60; i++) {
		bcolor += pow(texture2D(gaux2, newTC.xy + offsets[i]*pcoc*vec2(1.0,aspectRatio)).rgb,vec3(2.2));
		}
		color.rgb = bcolor/(61)*MAX_COLOR_RANGE;
	#endif
	}	
	}
#endif

#ifdef MOTION_BLUR
	
	vec4 motionblur  = texture2D(depthtex2, newTC.st);
	vec3 mblur = pow(texture2D(gaux2,newTC.st).rgb,vec3(2.2))*MAX_COLOR_RANGE;
	
	vec4 currentPosition = vec4(newTC.x * 2.0 - 1.0, newTC.y * 2.0 - 1.0, 2.0 * motionblur.x - 1.0, 1.0);
	
	vec4 fragposition = gbufferProjectionInverse * currentPosition;
	fragposition = gbufferModelViewInverse * fragposition;
	fragposition /= fragposition.w;
	fragposition.xyz += cameraPosition;
	
	vec4 previousPosition = fragposition;
	previousPosition.xyz -= previousCameraPosition;
	previousPosition = gbufferPreviousModelView * previousPosition;
	previousPosition = gbufferPreviousProjection * previousPosition;
	previousPosition /= previousPosition.w;

	vec2 velocity = (currentPosition - previousPosition).st * 0.12 / MOTION_BLUR_PASS;

	vec2 coord = newTC.st + velocity;
	for (int i = 0; i < MOTION_BLUR_PASS; ++i, coord += velocity) {
		if (coord.s > 1.0 || coord.t > 1.0 || coord.s < 0.0 || coord.t < 0.0 || hand > 0.9)
		mblur += pow(texture2D(gaux2, newTC).rgb,vec3(2.2))*MAX_COLOR_RANGE;
		if (hand < 0.9)
		mblur += pow(texture2D(gaux2, coord).rgb,vec3(2.2))*MAX_COLOR_RANGE;
	}
	mblur /= (MOTION_BLUR_PASS+1);
float pcoc1 = clamp(pcoc/2,0,pw*2)/pw/2;
color.rgb = color*pcoc1 + mblur.rgb*(1-pcoc1);
//color = vec3(pcoc1);
#endif

#ifdef BLOOM
const float rMult = 0.0025;
const int nSteps = 15;
int center = (nSteps-1)/2;
float radius = center*rMult;
float sigma = 0.3;

vec3 blur = vec3(0.0);
float tw = 0.0;

for (int i = 0; i < nSteps; i++) {
	float dist = (i-float(center))/center;
	float weight = A*exp(-(dist*dist)/(2.0*sigma));
	
	blur += pow(texture2DLod(composite,texcoord.xy + rMult*vec2(1.0,aspectRatio)*vec2(0.0,i-center)*viewWidth/1280,2).rgb,vec3(2.2))*weight;
	tw += weight;
}
blur /= tw;
color.xyz += blur*BLOOM_STRENGTH;
#endif

	color.xyz = ((1-(1-color.xyz/48.0)*(1-(color.rgb/48.0)*sqrt(luma(color.rgb/48.0))))*48.0);


	//draw rain
	vec4 rain = pow(texture2D(gaux4,newTC.xy),vec4(vec3(2.2),0.4));
	color.rgb = alphablend(color,color,rain.a/2);


	


	//rain drops on screen
	#ifdef RAIN_DROPS
	vec3 c_rain = rainlens*ambient_color;
	color = alphablend(color,ambient_color,rainlens);
	#endif


	
	
	//Tonemapping
	vec3 curr = Uncharted2Tonemap(color);
	
	vec3 whiteScale = 1.0f/Uncharted2Tonemap(vec3(MAX_COLOR_RANGE));
	color = curr*whiteScale;
	
		
	#ifdef VIGNETTE
	float len = length(texcoord.xy-vec2(.5));
	float len2 = distratio(texcoord.xy,vec2(.5));
	float dc = mix(len,len2,0.3);
    float vignette = smStep(VIGNETTE_END, VIGNETTE_START,  dc);
	
	color = mix(color,color*vignette,VIGNETTE_STRENGTH);
	#endif
	
	#ifdef LENS_EFFECTS
	vec4 tpos = vec4(sunPosition,1.0)*gbufferProjection;
		tpos = vec4(tpos.xyz/tpos.w,1.0);
	vec2 lightPos = tpos.xy/tpos.z;
		lightPos = (lightPos + 1.0f)/2.0f;

    float distof = min(min(1.0-lightPos.x,lightPos.x),min(1.0-lightPos.y,lightPos.y));
	float fading = clamp(1.0-step(distof,0.1)+pow(distof*10.0,5.0),0.0,1.0);

    float time = float(worldTime);

    float sunvisibility = min(texture2D(gaux2,vec2(0.0)).a,1.0) * fading ;
	float sunvisibility2 = min(texture2D(gaux2,vec2(0.0)).a,1.0);
	float centerVisibility = 1.0 - clamp(distance(lightPos.xy, vec2(0.5, 0.5)) * 2.0, 0.0, 1.0);
		  centerVisibility *= sunvisibility;
	
	float lensBrightness = 1.2;
	
	
	// Fix, that the particles are visible on the moon position at daytime
	float truepos = sign(sunPosition.z);		//1 -> sun / -1 -> moon
	vec3 rainc = mix(vec3(1.),vec3(0.2,0.25,0.3),rainStrength);
	vec3 lightColor = mix(sunlight*sunVisibility*rainc,12.0*moonlight*moonVisibility*rainc,truepos*0.5+0.5);
	
	
	#ifdef DIRTY_LENS
		// Set up domain
		vec2 q = texcoord.xy + texcoord.x * 0.4;
		vec2 p = -1.0 + 3.0 * q;
		vec2 p2 = -1.0 + 3.0 * q + vec2(10.0, 10.0);
		
		// Create noise using fBm
		float f = fbm(5.0 * p);
		float f2 = fbm(20.0 * p2);
	 
		float cover = 0.35f;
		float sharpness = 0.99 * sunvisibility2;	// Brightness
		
		float c = f - (1.0 - cover);
		if ( c < 0.0 )
			 c = 0.0;
		
		f = 1.0 - (pow(1.0 - sharpness, c));
				
				
		float c2 = f2 - (1.0 - cover);
		if ( c2 < 0.0 )
			 c2 = 0.0;
		
		f2 = 1.0 - (pow(1.0 - sharpness, c2));
				
		float dirtylens = (f * 2.0) + (f2 / 1);

	
		float visibility = max(pow(max(1.0 - smoothCircleDist(1.0)/0.8,0.1),2.0)-0.1,0.0);
		vec3 lenscolor = vec3(0.0);
		if (length(lightColor) > 0.001)	lenscolor = pow(normalize(lightColor),vec3(2.2))*length(lightColor);
		
		float lens_strength = 1.3 * lensBrightness;
		lenscolor *= lens_strength;
				
		color += (dirtylens*visibility)*lenscolor*(1.0-rainStrength*1.0)*2.;

	#endif
	
	// Anamorphic Lens
	if (sunvisibility > 0.01) {
		
		float visibility = max(pow(max(1.0 - smoothCircleDist(1.0)/1.5,0.1),1.0)-0.1,0.0);
		
			
		vec3 lenscolor = length(lightColor)*vec3(0.2, 0.4, 1.25)*(1+moonVisibility)/2;

		float lens_strength = 0.8 * lensBrightness;
		lenscolor *= lens_strength;
		
		#ifdef ANAMORPHIC_LENS
		float anamorphic_lens = max(pow(max(1.0 - yDistAxis(0.0)/1.4,0.1),10.0),0.0);
		color += anamorphic_lens * lenscolor * visibility  * sunvisibility * (1.0-rainStrength*1.0);
		#endif
	

		#ifdef SUN_RAYS
		float dist = distance(texcoord.st, vec2(0.5, 0.5));
		

		
			visibility = max(pow(max(1.0 - smoothCircleDist(1.0)/1.0,0.1),5.0)-0.1,0.0);
		lenscolor = vec3(0.0);	
			if (length(lightColor) > 0.001)	
		lenscolor = pow(normalize(lightColor),vec3(2.2))*length(lightColor);

			
			lens_strength = 0.7 * lensBrightness;
			lenscolor *= lens_strength;
			
			float sunray1 = max(pow(max(1.0 - yDistAxis(1.5)/0.7,0.1),10.0)-0.6,0.0);
			float sunray2 = max(pow(max(1.0 - yDistAxis(-1.3)/0.7,0.1),10.0)-0.6,0.0);
			float sunray3 = max(pow(max(1.0 - yDistAxis(5.0)/1.5,0.1),10.0)-0.6,0.0);
			float sunray4 = max(pow(max(1.0 - yDistAxis(-4.8)/1.5,0.1),10.0)-0.6,0.0);
			
			float sunrays = sunray1 + sunray2 + sunray3 + sunray4;
			
			color += lenscolor * sunrays * visibility * sunvisibility * (1.0-rainStrength*1.0)*2.;
		#endif
		
		//Sun Glow
		if (length(lightColor) > 0.001)
		lenscolor = pow(normalize(lightColor),vec3(2.2))*length(lightColor)*vec3(0.7,0.75,1.);

			
		lens_strength = 0.6 * lensBrightness;
		lenscolor *= lens_strength;
		
		float lensFlare = max(pow(max(1.0 - smoothCircleDist(1.0)/2.4,0.1),5.0)-0.1,0.0);
			
		//color += lensFlare * lenscolor * sunvisibility2 * (1.0-rainStrength*1.0);
		
		
				// Circle Lens 1
		
		
			lenscolor =  vec3(2.52, 1.8, 0.4) * lightColor;
			
			lens_strength = 0.2 * lensBrightness;
			lenscolor *= lens_strength;
			
			float lensFlare1 = max(pow(max(1.0 - cirlceDist(-0.15, 0.07)/1.0,0.1),5.0)-0.1,0.0);
			float lensFlare2 = max(pow(max(1.0 - cirlceDist(-0.2, 0.07)/1.0,0.1),5.0)-0.1,0.0);
			float lensFlare3 = max(pow(max(1.0 - cirlceDist(-0.25, 0.07)/1.0,0.1),5.0)-0.1,0.0);
			
			lensFlare = clamp(lensFlare1 * lensFlare2 * lensFlare3, 0.0, 1.0);
			
			color += lensFlare * lenscolor * sunvisibility * (1.0-rainStrength*1.0)*0.7;
		
		
		// Circle Lens 2
		
		
			lenscolor =  vec3(0.7, 2.55, 0.4) * lightColor;
			
			lens_strength = 0.2 * lensBrightness;
			lenscolor *= lens_strength;
			
			lensFlare1 = max(pow(max(1.0 - cirlceDist(-0.4, 0.13)/1.0,0.1),5.0)-0.1,0.0);
			lensFlare2 = max(pow(max(1.0 - cirlceDist(-0.5, 0.13)/1.0,0.1),5.0)-0.1,0.0);
			lensFlare3 = max(pow(max(1.0 - cirlceDist(-0.6, 0.13)/1.0,0.1),5.0)-0.1,0.0);
			
			lensFlare = clamp(lensFlare1 * lensFlare2 * lensFlare3, 0.0, 1.0);
			
			color += lensFlare * lenscolor * sunvisibility * (1.0-rainStrength*1.0)*0.7;
		
		
		// Circle Lens 3
		
		
			lenscolor =  vec3(0.4, 1.95, 2.55) * lightColor;
			
			lens_strength = 0.1 * lensBrightness;
			lenscolor *= lens_strength;
			
			lensFlare1 = max(pow(max(1.0 - cirlceDist(-0.75, 0.09)/1.0,0.1),5.0)-0.1,0.0);
			lensFlare2 = max(pow(max(1.0 - cirlceDist(-0.8, 0.09)/1.0,0.1),5.0)-0.1,0.0);
			lensFlare3 = max(pow(max(1.0 - cirlceDist(-0.85, 0.09)/1.0,0.1),5.0)-0.1,0.0);
			
			lensFlare = clamp(lensFlare1 * lensFlare2 * lensFlare3, 0.0, 1.0);
			
			color += lensFlare * lenscolor * sunvisibility * (1.0-rainStrength*1.0)*0.7;
		
		
		
		// Small point 1

		
			lenscolor = vec3(2.55, 2.55, 0.0) * lightColor;
			
			lens_strength = 150.0 * lensBrightness;
			lenscolor *= lens_strength;
			
			lensFlare1 = max(pow(max(1.0 - smoothCircleDist(-0.27)/1.0,0.1),5.0)-0.85,0.0);
			lensFlare2 = max(pow(max(1.0 - smoothCircleDist(-0.3)/1.0,0.1),5.0)-0.85,0.0);
			lensFlare3 = max(pow(max(1.0 - smoothCircleDist(-0.33)/1.0,0.1),5.0)-0.85,0.0);
			
			lensFlare = clamp(lensFlare1 * lensFlare2 * lensFlare3, 0.0, 1.0);
			
			color += lensFlare * lenscolor * sunvisibility * (1.0-rainStrength*1.0);
		
		// Small point 2
		
		
			lenscolor = vec3(0.0, 2.55, 1.52) * lightColor;
			
			lens_strength = 150.0 * lensBrightness;
			lenscolor *= lens_strength;
			
			lensFlare1 = max(pow(max(1.0 - smoothCircleDist(-0.62)/1.0,0.1),5.0)-0.85,0.0);
			lensFlare2 = max(pow(max(1.0 - smoothCircleDist(-0.65)/1.0,0.1),5.0)-0.85,0.0);
			lensFlare3 = max(pow(max(1.0 - smoothCircleDist(-0.68)/1.0,0.1),5.0)-0.85,0.0);
			
			lensFlare = clamp(lensFlare1 * lensFlare2 * lensFlare3, 0.0, 1.0);
			
			color += lensFlare * lenscolor * sunvisibility * (1.0-rainStrength*1.0);
		
		
		// Ring Lens 

		
			lenscolor = vec3(0.2, 0.8, 2.55) * length(lightColor);
			
			lens_strength = 0.3 * lensBrightness;
			lenscolor *= lens_strength;
			
			lensFlare1 = max(pow(max(1.0 - cirlceDist(-0.7, 0.5)/1.0,0.1),5.0)-0.1,0.0);
			lensFlare2 = max(pow(max(1.0 - cirlceDist(-0.9, 0.5)/1.0,0.1),5.0)-0.1,0.0);
			
			lensFlare = clamp(lensFlare2 - lensFlare1, 0.0, 1.0);
			color += lensFlare*lensFlare * lenscolor * sunvisibility * (1.0-rainStrength*1.0)*1.3;
		
		
	}

	
#endif
		
	color = clamp(pow(color,vec3(1.0/2.2)),0.0,1.0);

	#ifdef COLOR_BOOST
	color =  (color*(1+BOOST) + (color*color-BOOST/2)*BOOST*(1-land));
	#endif
	#ifdef SATURATION
	color = color*(SATURATE)-(color.r+color.g+color.b)/3*(SATURATE-1);
	#endif
	#ifdef FILM_GRAIN
	float fgr = clamp(GRAIN_CHECK-(color.r+color.g+color.b),0,1);
	fgr = fgr*fgr;
	vec2 grcoord = vec2(getnoise(newTC.xy/2),getnoise(-newTC.xy/2));
	color += normalize(color)*(getnoise(grcoord)*1.5-0.75)*GRAIN_DENSITY*fgr;
	#endif
	#ifdef BLACK_BORDER
	float bsize = 0;
	if (BORDER_RATIO > aspectRatio)
	{
	if (texcoord.y > 0.5-0.5*aspectRatio/BORDER_RATIO && texcoord.y < 0.5+0.5*aspectRatio/BORDER_RATIO) color *= 1;
	else color *= (1-BORDER_OPACITY);
	}
	if (BORDER_RATIO < aspectRatio)
	{
	if (texcoord.x > 0.5-0.5*BORDER_RATIO/aspectRatio && texcoord.x < 0.5+0.5*BORDER_RATIO/aspectRatio) color *= 1;
	else color *= (1-BORDER_OPACITY);
	}
	#endif
	gl_FragColor = vec4(color,1.0);
}

