#version 120


/*
!! DO NOT REMOVE !!
BSL Shaders is derived from Chocapic13 v5 test 2

This code is from Chocapic13' shaders
Read the terms of modification and sharing before changing something below please !
!! DO NOT REMOVE !!
*/

/*
Disable an effect by putting "//" before "#define" when there is no number after
You can tweak the numbers, the impact on the shaders is self-explained in the variable's name or in a comment
*/

//ADJUSTABLE VARIABLES//

#define WavingLeaves				//Enable waving for leaves.
#define WavingVines					//Enable waving for vines.
#define WavingGrass					//Enable waving for tall grass.
#define WavingCrops					//Enable waving for wheats, potatoes, and carrots.
#define WavingFlowers				//Enable waving for flowers.
#define WavingTallPlants			//Enable waving for 2 block plants such as sunflower, double tallgrass, etc.
#define WavingFire					//Enable waving for fire.
#define WavingLava					//Enable waving for lava.
#define WavingLilypad				//Enable waving for lilypad.

//#define WorldTimeAnimation

//ADJUSTABLE VARIABLES//

#define ENTITY_LEAVES       	   18.0
#define ENTITY_VINES        	  106.0
#define ENTITY_TALLGRASS   	  	   31.0
#define ENTITY_DOUBLEPLANTS    	  175.0
#define ENTITY_DANDELION     	   37.0
#define ENTITY_ROSE        		   38.0
#define ENTITY_WHEAT      		   59.0
#define ENTITY_CARROT     		  141.0
#define ENTITY_POTATO     		  142.0
#define ENTITY_LILYPAD    		  111.0
#define ENTITY_FIRE       		   51.0
#define ENTITY_LAVAFLOWING  	   10.0
#define ENTITY_LAVASTILL    	   11.0

#define SHADOW_MAP_BIAS 0.85
const float PI = 3.1415927;
varying vec4 texcoord;

attribute vec4 mc_midTexCoord;
attribute vec4 mc_Entity;

uniform mat4 shadowProjectionInverse;
uniform mat4 shadowProjection;
uniform mat4 shadowModelViewInverse;
uniform mat4 shadowModelView;
uniform mat4 gbufferModelView;
uniform mat4 gbufferModelViewInverse;
uniform float frameTimeCounter;
uniform int worldTime;
uniform float rainStrength;
uniform vec3 cameraPosition;

varying float makecolor;
//////////////////////////////VOID MAIN//////////////////////////////
//////////////////////////////VOID MAIN//////////////////////////////
//////////////////////////////VOID MAIN//////////////////////////////
//////////////////////////////VOID MAIN//////////////////////////////
//////////////////////////////VOID MAIN//////////////////////////////

#ifdef WorldTimeAnimation
float frametime = worldTime/20.0;
#else
float frametime = frameTimeCounter;
#endif

float pi2wt = PI*2*(frametime*24);
float rainmult = 1.0+rainStrength*0.3;

vec3 calcWave(in vec3 pos, in float fm, in float mm, in float ma, in float f0, in float f1, in float f2, in float f3, in float f4, in float f5) {
    vec3 ret;
    float magnitude,d0,d1,d2,d3;
    magnitude = sin(pi2wt*fm + pos.x*0.5 + pos.z*0.5 + pos.y*0.5) * mm + ma;
    d0 = sin(pi2wt*f0);
    d1 = sin(pi2wt*f1);
    d2 = sin(pi2wt*f2);
    ret.x = sin(pi2wt*f3 + d0 + d1 - pos.x + pos.z + pos.y) * magnitude;
    ret.z = sin(pi2wt*f4 + d1 + d2 + pos.x - pos.z + pos.y) * magnitude;
	ret.y = sin(pi2wt*f5 + d2 + d0 + pos.z + pos.y - pos.y) * magnitude;
    return ret*rainmult;
}

vec3 calcMove(in vec3 pos, in float f0, in float f1, in float f2, in float f3, in float f4, in float f5, in vec3 amp1, in vec3 amp2) {
    vec3 move1 = calcWave(pos      , 0.0027, 0.0400, 0.0400, 0.0127, 0.0089, 0.0114, 0.0063, 0.0224, 0.0015) * amp1;
	vec3 move2 = calcWave(pos+move1, 0.0348, 0.0400, 0.0400, f0, f1, f2, f3, f4, f5) * amp2;
    return (move1+move2)*rainmult;
}
vec3 calcWaterMove(in vec3 pos)
{
	float fy = fract(pos.y + 0.001);
	if (fy > 0.002)
	{
		float wave = 0.05 * sin(2*PI/4*frametime + 2*PI*2/16*pos.x + 2*PI*5/16*pos.z)
				   + 0.05 * sin(2*PI/3*frametime - 2*PI*3/16*pos.x + 2*PI*4/16*pos.z);
		return vec3(0, clamp(wave, -fy, 1.0-fy), 0);
	}
	else
	{
		return vec3(0);
	}
}

void main() {
gl_Position = ftransform();
makecolor = 0.0;
	float istopv = 0.0;
		if (gl_MultiTexCoord0.t < mc_midTexCoord.t) istopv = 1.0;
		vec4 position = gl_Position;

		 //position *= position.w;

		 position = shadowProjectionInverse * position;
		 position = shadowModelViewInverse * position;
		 position.xyz += cameraPosition.xyz;
	
	if (istopv > 0.9) {
	#ifdef WavingGrass
	if ( mc_Entity.x == ENTITY_TALLGRASS)
			position.xyz += calcMove(position.xyz, 0.0041, 0.0070, 0.0044, 0.0038, 0.0063, 0.0000, vec3(1.2,0.4,1.2), vec3(0.8,0.2,0.8));
	#endif
	#ifdef WavingFlowers
	if (mc_Entity.x == ENTITY_DANDELION || mc_Entity.x == ENTITY_ROSE)
			position.xyz += calcMove(position.xyz, 0.0041, 0.005, 0.0044, 0.0038, 0.0240, 0.0000, vec3(0.8,0.0,0.8), vec3(0.4,0.0,0.4));
	#endif
	#ifdef WavingCrops
	if ( mc_Entity.x == ENTITY_WHEAT || mc_Entity.x == ENTITY_CARROT || mc_Entity.x == ENTITY_POTATO)
			position.xyz += calcMove(position.xyz, 0.0041, 0.0070, 0.0044, 0.0038, 0.0240, 0.0000, vec3(1.2,0.4,1.2), vec3(0.8,0.2,0.8));
	#endif
	#ifdef WavingFire
	if ( mc_Entity.x == ENTITY_FIRE)
			position.xyz += calcMove(position.xyz, 0.0105, 0.0096, 0.0087, 0.0063, 0.0097, 0.0156, vec3(1.2,0.4,1.2), vec3(0.8,0.8,0.8));
	#endif
	}
	#ifdef WavingTallPlants
	if ( mc_Entity.x == ENTITY_DOUBLEPLANTS)
			position.xyz += calcMove(position.xyz, 0.0041, 0.0070, 0.0044, 0.0038, 0.0063, 0.0000, vec3(0.8,0.2,0.8), vec3(0.4,0.1,0.4));
	#endif
	#ifdef WavingLeaves
	if ( mc_Entity.x == ENTITY_LEAVES || mc_Entity.x == 161)
			position.xyz += calcMove(position.xyz, 0.0040, 0.0064, 0.0043, 0.0035, 0.0037, 0.0041, vec3(1.0,1.0,1.0), vec3(0.5,0.5,0.5));
	#endif
	#ifdef WavingVines
	if ( mc_Entity.x == ENTITY_VINES )
			position.xyz += calcMove(position.xyz, 0.0040, 0.0064, 0.0043, 0.0035, 0.0037, 0.0041, vec3(0.3,0.5,0.3), vec3(0.15,0.25,0.15));
	#endif
	#ifdef WavingLava
	if ( mc_Entity.x == ENTITY_LAVAFLOWING || mc_Entity.x == ENTITY_LAVASTILL )
			position.xyz += calcWaterMove(position.xyz) * 0.25;
	#endif
	#ifdef WavingLilypad
	if ( mc_Entity.x == ENTITY_LILYPAD ) {
			position.xyz += calcWaterMove(position.xyz);
			}
	#endif
	
	position.xyz -= cameraPosition.xyz;
	if (mc_Entity.x == 8.0 || mc_Entity.x == 9.0 || mc_Entity.x == 51.0 || mc_Entity.x == 79.0) position *= 0.0;
	position = shadowModelView * position;
	position = shadowProjection * position;

	if (mc_Entity.x == 95 || mc_Entity.x == 160 || mc_Entity.x == 79 || mc_Entity.x == 165) makecolor = 1.0;

	gl_Position = position;

	float dist = sqrt(gl_Position.x * gl_Position.x + gl_Position.y * gl_Position.y);
	float distortFactor = (1.0f - SHADOW_MAP_BIAS) + dist * SHADOW_MAP_BIAS;
	
	gl_Position.xy *= 1./distortFactor;
	//gl_Position.xy *= 0.5;
	texcoord = gl_MultiTexCoord0;

	gl_FrontColor = gl_Color;
}
