#version 120
/*
Sildur's enhanced default, before editing, remember the agreement you've accepted by downloading this shaderpack:
http://www.minecraftforum.net/forums/mapping-and-modding/minecraft-mods/1291396-1-6-4-1-12-1-sildurs-shaders-pc-mac-intel

You are allowed to:
- Modify it for your own personal use only, so don't share it online.

You are not allowed to:
- Rename and/or modify this shaderpack and upload it with your own name on it.
- Provide mirrors by reuploading my shaderpack, if you want to link it, use the link to my thread found above.
- Copy and paste code or even whole files into your "own" shaderpack.
*/
/*---------------------------
/////ADJUSTABLE VARIABLES/////
----------------------------*/							
//#define Colorboost		//Gives default colors a little kick
#define Fog					//Toggle default fog.
#define MobsFlashRed
/*---------------------------
//END OF ADJUSTABLE VARIABLES//
----------------------------*/	

varying vec4 color;
varying vec2 texcoord;
varying vec2 lmcoord;

uniform sampler2D texture;
uniform sampler2D lightmap;
uniform vec4 entityColor;

#ifdef Fog
const int GL_LINEAR = 9729;
const int GL_EXP = 2048;
uniform int fogMode;
#endif

void main() {

	vec4 tex = texture2D(texture, texcoord.st) * texture2D(lightmap, lmcoord.st) * color;

#ifdef Colorboost
	tex.rgb = pow(tex.rgb*1.20, vec3(1.20));
#endif
#ifdef MobsFlashRed
	tex.rgb = mix(tex.rgb,entityColor.rgb,entityColor.a);
#endif	

	gl_FragData[0] = tex;
	
#ifdef Fog
	vec3 fogC = gl_Fog.color.rgb;
	if (fogMode == GL_EXP) {
		gl_FragData[0].rgb = mix(gl_FragData[0].rgb, fogC, 1.0 - clamp(exp(-gl_Fog.density * gl_FogFragCoord), 0.0, 1.0));
	} else if (fogMode == GL_LINEAR) {
		gl_FragData[0].rgb = mix(gl_FragData[0].rgb, fogC, clamp((gl_FogFragCoord - gl_Fog.start) * gl_Fog.scale, 0.0, 1.0));
	}
#endif
}