#version 120
/* DRAWBUFFERS:02 */ //0=gcolor, 2=gnormal for normals
/*
Sildur's enhanced default, before editing, remember the agreement you've accepted by downloading this shaderpack:
http://www.minecraftforum.net/forums/mapping-and-modding/minecraft-mods/1291396-1-6-4-1-12-1-sildurs-shaders-pc-mac-intel

You are allowed to:
- Modify it for your own personal use only, so don't share it online.

You are not allowed to:
- Rename and/or modify this shaderpack and upload it with your own name on it.
- Provide mirrors by reuploading my shaderpack, if you want to link it, use the link to my thread found above.
- Copy and paste code or even whole files into your "own" shaderpack.
*/
/*---------------------------
/////ADJUSTABLE VARIABLES/////
----------------------------*/							
//#define Colorboost		//Gives default colors a little kick

#define MobsFlashRed

#define Fog					//Toggle default fog.

#define Reflections			//Toggle reflections, also adjust in composite.fsh

#define Shadows				//Also adjust in vertex, SHADOW_MAP_BIAS is also in vertex
#define Colored_Shadows
#define slight 0.55			//[0.50 0.55 0.60 0.65 0.70 0.75 0.80]
#define SHADOW_MAP_BIAS 0.80

#define waterTex			//Toggle water texture

#define nMap 0				//[0 1 2]0=Off 1=Bumpmapping, 2=Parallax, also adjust in vertex
#define POM_RES 32			//Texture / Resourcepack resolution. [32 64 128 256 512]
#define POM_DIST 16.0		//[8.0 16.0 24.0 32.0 40.0 48.0 56.0 64.0]
#define POM_DEPTH 0.30		//[0.10 0.20 0.30 0.40 0.50 0.60 0.70 0.80 0.90 1.0]
//#define draw_bmap			//Draw bmap normals
/*---------------------------
//END OF ADJUSTABLE VARIABLES//
----------------------------*/

//Const
const float ambientOcclusionLevel = 1.0f;
const int	noiseTextureResolution = 512;
const int 	shadowMapResolution = 1024;		//Shadows resolution. [512 1024 2048 3072 4096 8192]
const float shadowDistance = 90.0;			//Draw distance of shadows.[60.0 90.0 120.0 150.0 180.0 210.0]
const float shadowDistanceRenderMul = 1.0f;
const bool 	shadowHardwareFiltering0 = true;
const bool 	shadowHardwareFiltering1 = true;
const float	sunPathRotation	= -40.0f;		//[-0.15f -40.0f] //-0.15f to prevent a shadowtex1 glitch at tick 6000
//----------------------------------------------------------------

varying vec4 color;
varying vec3 getShadowpos;
varying vec3 vworldpos;
varying mat3 tbnMatrix;
varying vec2 texcoord;
varying vec2 lmcoord;
varying float NdotL;
varying float iswater;
varying float isreflective;
varying float mat;

uniform sampler2D normals;
uniform sampler2D texture;
uniform sampler2D lightmap;
uniform sampler2DShadow shadowtex0;	//normal shadows
uniform sampler2DShadow shadowtex1; //colored shadows
uniform sampler2D shadowcolor0;
uniform float rainStrength;
uniform vec4 entityColor;
uniform int isEyeInWater;
uniform ivec2 eyeBrightnessSmooth;
uniform vec3 shadowLightPosition;

#ifdef Fog
const int GL_LINEAR = 9729;
const int GL_EXP = 2048;
uniform int fogMode;
#endif

//Setup emissive lighting
float modlmap = 13.0-lmcoord.s*12.35; 
float torch_lightmap = max(1.5/(modlmap*modlmap)-0.00945,0.0);
vec3 emissiveLight = clamp(vec3(1.25)*torch_lightmap, 0.0, 1.0); //emissive lightmap

#ifdef Reflections
uniform sampler2D noisetex;
uniform float frameTimeCounter;

float noisetexture(vec2 coord, float offset, float speed){
return clamp(texture2D(noisetex, fract((coord*0.0005)*offset + frameTimeCounter*speed*isreflective)).x/offset, 0.0, 1.0);
}
float genWaves(vec2 pos){
	float wave = noisetexture(pos, 0.5, 0.00225);
		  wave -= noisetexture(pos, 0.5, -0.00225);
		  wave += noisetexture(pos, 2.0, 0.003375);
		  wave -= noisetexture(pos, 2.0, -0.003375);

	return wave;
}
vec3 calcBump(vec2 pos){
	const vec2 deltaPos = vec2(0.3, 0.0);
	float h0 = genWaves(pos);
	float h1 = genWaves(pos + deltaPos.xy);
	float h2 = genWaves(pos - deltaPos.xy);
	float h3 = genWaves(pos + deltaPos.yx);
	float h4 = genWaves(pos - deltaPos.yx);

	vec2 delta = vec2((h1-h0)+(h0-h2),(h3-h0)+(h0-h4))*0.16;

	return vec3(delta, 0.84f); //z = 1.0-0.16
}
#endif

#ifdef Shadows
float shadowfilter(sampler2DShadow shadowtexture){
	vec2 offset = vec2(0.25, -0.25) / shadowMapResolution;	
	return clamp(dot(vec4(shadow2D(shadowtexture,vec3(getShadowpos.xy + offset.xx, getShadowpos.z)).x,
						  shadow2D(shadowtexture,vec3(getShadowpos.xy + offset.yx, getShadowpos.z)).x,
						  shadow2D(shadowtexture,vec3(getShadowpos.xy + offset.xy, getShadowpos.z)).x,
						  shadow2D(shadowtexture,vec3(getShadowpos.xy + offset.yy, getShadowpos.z)).x),vec4(0.25))*NdotL,0.0,1.0);
}

vec3 calcShadows(vec3 c){
	vec3 finalShading = vec3(0.0);

if(NdotL > 0.0 && rainStrength < 0.9){ //optimization, disable shadows during rain for performance boost
		float shading = shadowfilter(shadowtex0);
	#ifdef Colored_Shadows
		float cshading = shadowfilter(shadowtex1);
		finalShading = texture2D(shadowcolor0, getShadowpos.xy).rgb*(cshading-shading) + shading;
	#else
		finalShading = vec3(shading);
	#endif
	
	//avoid light leaking underground
	finalShading *= mix(max(lmcoord.t-2.0/16.0,0.0)*1.14285714286,1.0,clamp((eyeBrightnessSmooth.y/255.0-2.0/16.)*4.0,0.0,1.0));
	
	finalShading *= (1.0 - rainStrength);		//smoother transition while disabling shadows during rain
	finalShading *= (1.0 - iswater);			//disable shadows on water plane(not fully, 1.0-0.95)
}
	
return c * (1.0+finalShading+emissiveLight) * slight;
}
#endif

#if nMap == 2
#extension GL_ARB_shader_texture_lod : enable
varying float dist;
varying vec3 viewVector;
varying vec4 vtexcoordam; // .st for add, .pq for mul
varying vec2 vtexcoord;
varying float isblock; //mc_Entity.x, hack to only apply pom to blocks
#if MC_VERSION >= 11300
bool block = isblock < 0.0; //in 1.13+ only defined ids in block.properties are checked by mc_Entity.x those won't support pom but the rest will.
#else
bool block = isblock > 0.0;	//only apply pom to blocks, might not be needed for 1.12.2 and below..
#endif
mat2 dFdxy = mat2(dFdx(vtexcoord.xy*vtexcoordam.pq), dFdy(vtexcoord.xy*vtexcoordam.pq));	
vec4 readNormal(in vec2 coord){
	return texture2DGradARB(normals,fract(coord)*vtexcoordam.pq+vtexcoordam.st,dFdxy[0],dFdxy[1]);
}

vec4 calcPOM(vec4 albedo){
	vec2 newCoord = vtexcoord.xy*vtexcoordam.pq+vtexcoordam.st;

	if (block && dist < POM_DIST && viewVector.z < 0.0 && readNormal(vtexcoord.xy).a < 1.0){
		const float res_stepths = 0.33 * POM_RES;
		vec2 pstepth = viewVector.xy * POM_DEPTH / (-viewVector.z * POM_RES);
		vec2 coord = vtexcoord.xy;
		for (int i= 0; i < res_stepths && (readNormal(coord.xy).a < 1.0-float(i)/POM_RES); ++i) coord += pstepth;
	
		newCoord = fract(coord.xy)*vtexcoordam.pq+vtexcoordam.st;
	}
	albedo = texture2DGradARB(texture, newCoord, dFdxy[0],dFdxy[1])* texture2D(lightmap, lmcoord.st)*color;

	//vec4 specularity = texture2DGradARB(specular, newCoord, dcdx, dcdy);
	vec3 bmap = normalize((texture2DGradARB(normals, newCoord, dFdxy[0],dFdxy[1]).rgb*2.0-1.0) * tbnMatrix);
	float bmaplight = max(dot(bmap, normalize(shadowLightPosition)),0.0);
	#ifdef Shadows
		albedo.rgb *= (1.0 + bmaplight + (1.0 - NdotL)) * 0.5; //normalize lighting with shadows enabled
	#else
		albedo.rgb *= (1.0 + bmaplight) * 0.6;
	#endif
	#ifdef draw_bmap
		if(block)albedo.rgb = bmap;
	#endif
return albedo;
}
#endif

void main() {

	vec4 tex = texture2D(texture, texcoord.st) * texture2D(lightmap, lmcoord.st) * color;
	vec4 normal = vec4(0.0); //fill the buffer with 0.0 if not needed, improves performance

#if nMap == 1
	vec3 bmap = normalize((texture2D(normals, texcoord.xy).xyz*2.0-1.0) * tbnMatrix);
	float bmaplight = max(dot(bmap, normalize(shadowLightPosition)),0.0);
	#ifdef Shadows
		tex.rgb *= (1.0 + bmaplight + (1.0 - NdotL)) * 0.5; //normalize lighting with shadows enabled
	#else
		tex.rgb *= (1.0 + bmaplight) * 0.6;
	#endif
	#ifdef draw_bmap
		tex.rgb = bmap;
	#endif	
#elif nMap == 2
	tex = calcPOM(tex);
#endif

#ifdef Shadows
	tex.rgb = calcShadows(tex.rgb);
#endif

#ifdef Colorboost
	tex.rgb = pow(tex.rgb*1.20, vec3(1.20));
#endif

#ifdef MobsFlashRed
	tex.rgb = mix(tex.rgb,entityColor.rgb,entityColor.a);
#endif	

#ifdef Reflections	
	vec2 waterpos = vworldpos.xz*7.0;
	if(mat > 0.9)normal = vec4(normalize(calcBump(waterpos) * tbnMatrix)*0.5+0.5, 1.0); //mat > 0.9 so that only reflective blocks alter normals, boosts performance by about 30%. mat=reflective
#endif

if(iswater > 0.1){
	if(isEyeInWater > 0.9)tex.a = 0.9;	//improve alpha underwater, default is 1 (opaque)
#ifdef waterTex	
	tex.rgb *= 1.25;					//improve colors on water
#else
	tex.rgb = mix(tex.rgb, color.rgb*0.5, 1.0) * texture2D(lightmap, lmcoord.st).rgb;
#endif
}
	gl_FragData[0] = tex;
	gl_FragData[1] = normal;
	
#ifdef Fog
	if (fogMode == GL_EXP) {
		gl_FragData[0].rgb = mix(gl_FragData[0].rgb, gl_Fog.color.rgb, 1.0 - clamp(exp(-gl_Fog.density * gl_FogFragCoord), 0.0, 1.0));
	} else if (fogMode == GL_LINEAR) {
		gl_FragData[0].rgb = mix(gl_FragData[0].rgb, gl_Fog.color.rgb, clamp((gl_FogFragCoord - gl_Fog.start) * gl_Fog.scale, 0.0, 1.0));
	} else if (isEyeInWater == 1.0 || isEyeInWater == 2.0){
		gl_FragData[0].rgb = mix(gl_FragData[0].rgb, gl_Fog.color.rgb, 1.0 - clamp(exp(-gl_Fog.density * gl_FogFragCoord), 0.0, 1.0));
	}
#endif
}