/*
 * Decompiled with CFR 0.152.
 */
package com.mamiyaotaru.voxelmap.gui.overridden;

import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.widget.TextFieldWidget;
import net.minecraft.client.gui.widget.button.Button;

public class GuiButtonText
extends Button {
    private boolean editing = false;
    private TextFieldWidget textField;

    public GuiButtonText(FontRenderer fontRenderer, int x, int y, String buttonText, Button.IPressable press) {
        this(fontRenderer, x, y, 200, 20, buttonText, press);
    }

    public GuiButtonText(FontRenderer fontRenderer, int x, int y, int widthIn, int heightIn, String buttonText, Button.IPressable press) {
        super(x, y, widthIn, heightIn, buttonText, press);
        this.textField = new TextFieldWidget(fontRenderer, x + 1, y + 1, widthIn - 2, heightIn - 2, "");
    }

    public void render(int mouseX, int mouseY, float partialTicks) {
        if (!this.editing) {
            super.render(mouseX, mouseY, partialTicks);
        } else {
            this.textField.renderButton(mouseX, mouseY, partialTicks);
        }
    }

    public boolean mouseClicked(double mouseX, double mouseY, int mouseButton) {
        boolean pressed = super.mouseClicked(mouseX, mouseY, mouseButton);
        this.setEditing(pressed);
        return pressed;
    }

    public void setEditing(boolean editing) {
        this.editing = editing;
        if (editing) {
            this.setFocused(true);
        }
        this.textField.func_146195_b(editing);
    }

    public boolean keyPressed(int keysm, int scancode, int b) {
        boolean ok = false;
        if (this.editing) {
            if (keysm == 257 || keysm == 335 || keysm == 258) {
                this.setEditing(false);
            } else {
                ok = this.textField.keyPressed(keysm, scancode, b);
            }
        } else {
            ok = super.keyPressed(keysm, scancode, b);
        }
        return ok;
    }

    public boolean charTyped(char character, int keycode) {
        boolean ok = false;
        if (this.editing) {
            if (character == '\r') {
                this.setEditing(false);
            } else {
                ok = this.textField.charTyped(character, keycode);
            }
        } else {
            ok = super.charTyped(character, keycode);
        }
        return ok;
    }

    public boolean isEditing() {
        return this.editing;
    }

    public void tick() {
        this.textField.func_146178_a();
    }

    public void setText(String textIn) {
        this.textField.func_146180_a(textIn);
    }

    public String getText() {
        return this.textField.func_146179_b();
    }
}

