/*
 * Decompiled with CFR 0.152.
 */
package com.mamiyaotaru.voxelmap.gui;

import com.mamiyaotaru.voxelmap.MapSettingsManager;
import com.mamiyaotaru.voxelmap.gui.GuiAddWaypoint;
import com.mamiyaotaru.voxelmap.gui.GuiSlotWaypoints;
import com.mamiyaotaru.voxelmap.gui.GuiWaypointsOptions;
import com.mamiyaotaru.voxelmap.gui.IGuiWaypoints;
import com.mamiyaotaru.voxelmap.gui.overridden.GuiScreenMinimap;
import com.mamiyaotaru.voxelmap.interfaces.AbstractVoxelMap;
import com.mamiyaotaru.voxelmap.interfaces.IVoxelMap;
import com.mamiyaotaru.voxelmap.interfaces.IWaypointManager;
import com.mamiyaotaru.voxelmap.util.CommandUtils;
import com.mamiyaotaru.voxelmap.util.DimensionContainer;
import com.mamiyaotaru.voxelmap.util.GameVariableAccessShim;
import com.mamiyaotaru.voxelmap.util.I18nUtils;
import com.mamiyaotaru.voxelmap.util.Waypoint;
import it.unimi.dsi.fastutil.booleans.BooleanConsumer;
import java.util.Random;
import java.util.TreeSet;
import net.minecraft.client.gui.IGuiEventListener;
import net.minecraft.client.gui.screen.ConfirmScreen;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.TextFieldWidget;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.dimension.DimensionType;

public class GuiWaypoints
extends GuiScreenMinimap
implements IGuiWaypoints {
    private final Screen parentScreen;
    private IVoxelMap master;
    protected final MapSettingsManager options;
    protected final IWaypointManager waypointManager;
    protected String screenTitle = "Waypoints";
    private GuiSlotWaypoints waypointList;
    private Button buttonEdit;
    private boolean editClicked = false;
    private Button buttonDelete;
    private boolean deleteClicked = false;
    private Button buttonHighlight;
    private Button buttonShare;
    private Button buttonTeleport;
    private Button buttonSortName;
    private Button buttonSortCreated;
    private Button buttonSortDistance;
    private Button buttonSortColor;
    protected TextFieldWidget filter;
    private boolean addClicked = false;
    private String tooltip = null;
    protected Waypoint selectedWaypoint = null;
    protected Waypoint highlightedWaypoint = null;
    protected Waypoint newWaypoint = null;
    private Random generator = new Random();
    private boolean changedSort = false;
    private final int EDIT = -1;
    private final int DELETE = -2;
    private final int HIGHLIGHT = -3;
    private final int TELEPORT = -4;
    private final int SHARE = -5;
    private final int NEW = -6;
    private final int OPTIONS = -7;

    public GuiWaypoints(Screen parentScreen, IVoxelMap master) {
        this.master = master;
        this.parentScreen = parentScreen;
        this.options = master.getMapOptions();
        this.waypointManager = master.getWaypointManager();
        this.highlightedWaypoint = this.waypointManager.getHighlightedWaypoint();
    }

    public void tick() {
        this.filter.func_146178_a();
    }

    public void init() {
        boolean isSomethingSelected;
        this.screenTitle = I18nUtils.getString("minimap.waypoints.title", new Object[0]);
        this.getMinecraft().field_195559_v.func_197967_a(true);
        this.waypointList = new GuiSlotWaypoints(this);
        this.buttonSortName = new Button(this.getWidth() / 2 - 154, 34, 77, 20, I18nUtils.getString("minimap.waypoints.sortbyname", new Object[0]), null){

            public void onPress() {
                GuiWaypoints.this.options.getClass();
                GuiWaypoints.this.actionPerformed(this, 2);
            }
        };
        this.addButton((Widget)this.buttonSortName);
        this.buttonSortDistance = new Button(this.getWidth() / 2 - 77, 34, 77, 20, I18nUtils.getString("minimap.waypoints.sortbydistance", new Object[0]), null){

            public void onPress() {
                GuiWaypoints.this.options.getClass();
                GuiWaypoints.this.actionPerformed(this, 3);
            }
        };
        this.addButton((Widget)this.buttonSortDistance);
        this.buttonSortCreated = new Button(this.getWidth() / 2, 34, 77, 20, I18nUtils.getString("minimap.waypoints.sortbycreated", new Object[0]), null){

            public void onPress() {
                GuiWaypoints.this.options.getClass();
                GuiWaypoints.this.actionPerformed(this, 1);
            }
        };
        this.addButton((Widget)this.buttonSortCreated);
        this.buttonSortColor = new Button(this.getWidth() / 2 + 77, 34, 77, 20, I18nUtils.getString("minimap.waypoints.sortbycolor", new Object[0]), null){

            public void onPress() {
                GuiWaypoints.this.options.getClass();
                GuiWaypoints.this.actionPerformed(this, 4);
            }
        };
        this.addButton((Widget)this.buttonSortColor);
        int filterStringWidth = this.getFontRenderer().func_78256_a(I18nUtils.getString("minimap.waypoints.filter", new Object[0]) + ":");
        this.filter = new TextFieldWidget(this.getFontRenderer(), this.getWidth() / 2 - 153 + filterStringWidth + 5, this.getHeight() - 80, 305 - filterStringWidth - 5, 20, "");
        this.filter.func_146203_f(35);
        this.addButton((Widget)this.filter);
        this.buttonEdit = new Button(this.getWidth() / 2 - 154, this.getHeight() - 52, 74, 20, I18nUtils.getString("selectServer.edit", new Object[0]), null){

            public void onPress() {
                GuiWaypoints.this.actionPerformed(this, -1);
            }
        };
        this.addButton((Widget)this.buttonEdit);
        this.buttonDelete = new Button(this.getWidth() / 2 - 76, this.getHeight() - 52, 74, 20, I18nUtils.getString("selectServer.delete", new Object[0]), null){

            public void onPress() {
                GuiWaypoints.this.actionPerformed(this, -2);
            }
        };
        this.addButton((Widget)this.buttonDelete);
        this.buttonHighlight = new Button(this.getWidth() / 2 + 2, this.getHeight() - 52, 74, 20, I18nUtils.getString("minimap.waypoints.highlight", new Object[0]), null){

            public void onPress() {
                GuiWaypoints.this.actionPerformed(this, -3);
            }
        };
        this.addButton((Widget)this.buttonHighlight);
        this.buttonTeleport = new Button(this.getWidth() / 2 + 80, this.getHeight() - 52, 74, 20, I18nUtils.getString("minimap.waypoints.teleportto", new Object[0]), null){

            public void onPress() {
                GuiWaypoints.this.actionPerformed(this, -4);
            }
        };
        this.addButton((Widget)this.buttonTeleport);
        this.buttonShare = new Button(this.getWidth() / 2 - 154, this.getHeight() - 28, 74, 20, I18nUtils.getString("minimap.waypoints.share", new Object[0]), null){

            public void onPress() {
                GuiWaypoints.this.actionPerformed(this, -5);
            }
        };
        this.addButton((Widget)this.buttonShare);
        this.addButton((Widget)new Button(this.getWidth() / 2 - 76, this.getHeight() - 28, 74, 20, I18nUtils.getString("minimap.waypoints.newwaypoint", new Object[0]), null){

            public void onPress() {
                GuiWaypoints.this.actionPerformed(this, -6);
            }
        });
        this.addButton((Widget)new Button(this.getWidth() / 2 + 2, this.getHeight() - 28, 74, 20, I18nUtils.getString("menu.options", new Object[0]), null){

            public void onPress() {
                GuiWaypoints.this.actionPerformed(this, -7);
            }
        });
        this.addButton((Widget)new Button(this.getWidth() / 2 + 80, this.getHeight() - 28, 74, 20, I18nUtils.getString("gui.done", new Object[0]), null){

            public void onPress() {
                GuiWaypoints.this.actionPerformed(this, -200);
            }
        });
        this.setFocused((IGuiEventListener)this.filter);
        this.filter.func_146195_b(true);
        this.buttonEdit.active = isSomethingSelected = this.selectedWaypoint != null;
        this.buttonDelete.active = isSomethingSelected;
        this.buttonHighlight.active = isSomethingSelected;
        this.buttonShare.active = isSomethingSelected;
        this.buttonTeleport.active = isSomethingSelected && this.canTeleport();
        this.sort();
    }

    private void sort() {
        int sortKey = Math.abs(this.options.sort);
        boolean ascending = this.options.sort > 0;
        this.waypointList.sortBy(sortKey, ascending);
        String arrow = ascending ? "\u2191" : "\u2193";
        this.options.getClass();
        if (sortKey == 2) {
            this.buttonSortName.setMessage(arrow + " " + I18nUtils.getString("minimap.waypoints.sortbyname", new Object[0]) + " " + arrow);
        } else {
            this.buttonSortName.setMessage(I18nUtils.getString("minimap.waypoints.sortbyname", new Object[0]));
        }
        this.options.getClass();
        if (sortKey == 3) {
            this.buttonSortDistance.setMessage(arrow + " " + I18nUtils.getString("minimap.waypoints.sortbydistance", new Object[0]) + " " + arrow);
        } else {
            this.buttonSortDistance.setMessage(I18nUtils.getString("minimap.waypoints.sortbydistance", new Object[0]));
        }
        this.options.getClass();
        if (sortKey == 1) {
            this.buttonSortCreated.setMessage(arrow + " " + I18nUtils.getString("minimap.waypoints.sortbycreated", new Object[0]) + " " + arrow);
        } else {
            this.buttonSortCreated.setMessage(I18nUtils.getString("minimap.waypoints.sortbycreated", new Object[0]));
        }
        this.options.getClass();
        if (sortKey == 4) {
            this.buttonSortColor.setMessage(arrow + " " + I18nUtils.getString("minimap.waypoints.sortbycolor", new Object[0]) + " " + arrow);
        } else {
            this.buttonSortColor.setMessage(I18nUtils.getString("minimap.waypoints.sortbycolor", new Object[0]));
        }
    }

    protected void actionPerformed(Button par1GuiButton, int id) {
        if (par1GuiButton.active) {
            String var2;
            if (id > 0) {
                this.options.setSort(id);
                this.changedSort = true;
                this.sort();
            }
            if (id == -1) {
                this.editWaypoint(this.selectedWaypoint);
            }
            if (id == -2 && (var2 = this.selectedWaypoint.name) != null) {
                this.deleteClicked = true;
                String title = I18nUtils.getString("minimap.waypoints.deleteconfirm", new Object[0]);
                TranslationTextComponent explanation = new TranslationTextComponent("selectServer.deleteWarning", new Object[]{var2});
                String affirm = I18nUtils.getString("selectServer.deleteButton", new Object[0]);
                String deny = I18nUtils.getString("gui.cancel", new Object[0]);
                ConfirmScreen var8 = new ConfirmScreen((BooleanConsumer)this, (ITextComponent)new StringTextComponent(title), (ITextComponent)explanation, affirm, deny);
                this.getMinecraft().func_147108_a((Screen)var8);
            }
            if (id == -3) {
                this.setHighlightedWaypoint();
            }
            if (id == -5) {
                CommandUtils.sendWaypoint(this.selectedWaypoint);
            }
            if (id == -4) {
                boolean mp;
                boolean bl = mp = !this.minecraft.func_71387_A();
                int y = this.selectedWaypoint.getY() > 0 ? this.selectedWaypoint.getY() : (this.options.game.field_71439_g.field_71093_bK != DimensionType.field_223228_b_ ? 128 : 64);
                this.options.game.field_71439_g.func_71165_d("/tp " + this.options.game.field_71439_g.func_200200_C_().func_150261_e() + " " + this.selectedWaypoint.getX() + " " + y + " " + this.selectedWaypoint.getZ());
                if (mp) {
                    this.options.game.field_71439_g.func_71165_d("/tppos " + this.selectedWaypoint.getX() + " " + y + " " + this.selectedWaypoint.getZ());
                }
                this.getMinecraft().func_147108_a((Screen)null);
            }
            if (id == -6) {
                this.addWaypoint();
            }
            if (id == -7) {
                this.getMinecraft().func_147108_a((Screen)new GuiWaypointsOptions(this, this.options));
            }
            if (id == -200) {
                this.getMinecraft().func_147108_a(this.parentScreen);
            }
        }
    }

    public boolean keyPressed(int keysm, int scancode, int b) {
        boolean OK = super.keyPressed(keysm, scancode, b);
        if (this.filter.isFocused()) {
            this.waypointList.updateFilter(this.filter.func_146179_b().toLowerCase());
        }
        return OK;
    }

    public boolean charTyped(char character, int keycode) {
        boolean OK = super.charTyped(character, keycode);
        if (this.filter.isFocused()) {
            this.waypointList.updateFilter(this.filter.func_146179_b().toLowerCase());
        }
        return OK;
    }

    public boolean mouseClicked(double mouseX, double mouseY, int mouseButton) {
        this.waypointList.mouseClicked(mouseX, mouseY, mouseButton);
        return super.mouseClicked(mouseX, mouseY, mouseButton);
    }

    public boolean mouseReleased(double mouseX, double mouseY, int mouseButton) {
        this.waypointList.mouseReleased(mouseX, mouseY, mouseButton);
        return super.mouseReleased(mouseX, mouseY, mouseButton);
    }

    public boolean mouseDragged(double mouseX, double mouseY, int mouseEvent, double deltaX, double deltaY) {
        return this.waypointList.mouseDragged(mouseX, mouseY, mouseEvent, deltaX, deltaY);
    }

    public boolean mouseScrolled(double mouseX, double mouseY, double amount) {
        return this.waypointList.mouseScrolled(mouseX, mouseY, amount);
    }

    @Override
    public boolean isEditing() {
        return this.editClicked;
    }

    public void accept(boolean par1) {
        if (this.deleteClicked) {
            this.deleteClicked = false;
            if (par1) {
                this.waypointManager.deleteWaypoint(this.selectedWaypoint);
                this.selectedWaypoint = null;
            }
            this.getMinecraft().func_147108_a((Screen)this);
        }
        if (this.editClicked) {
            this.editClicked = false;
            if (par1) {
                this.waypointManager.saveWaypoints();
            }
            this.getMinecraft().func_147108_a((Screen)this);
        }
        if (this.addClicked) {
            this.addClicked = false;
            if (par1) {
                this.waypointManager.addWaypoint(this.newWaypoint);
                this.setSelectedWaypoint(this.newWaypoint);
            }
            this.getMinecraft().func_147108_a((Screen)this);
        }
    }

    protected void setSelectedWaypoint(Waypoint waypoint) {
        boolean isSomethingSelected;
        this.selectedWaypoint = waypoint;
        this.buttonEdit.active = isSomethingSelected = this.selectedWaypoint != null;
        this.buttonDelete.active = isSomethingSelected;
        this.buttonHighlight.active = isSomethingSelected;
        this.buttonHighlight.setMessage(I18nUtils.getString(isSomethingSelected && this.selectedWaypoint == this.highlightedWaypoint ? "minimap.waypoints.removehighlight" : "minimap.waypoints.highlight", new Object[0]));
        this.buttonShare.active = isSomethingSelected;
        this.buttonTeleport.active = isSomethingSelected && this.canTeleport();
    }

    protected void setHighlightedWaypoint() {
        this.waypointManager.setHighlightedWaypoint(this.selectedWaypoint, true);
        this.highlightedWaypoint = this.waypointManager.getHighlightedWaypoint();
        boolean isSomethingSelected = this.selectedWaypoint != null;
        this.buttonHighlight.setMessage(I18nUtils.getString(isSomethingSelected && this.selectedWaypoint == this.highlightedWaypoint ? "minimap.waypoints.removehighlight" : "minimap.waypoints.highlight", new Object[0]));
    }

    protected void editWaypoint(Waypoint waypoint) {
        this.editClicked = true;
        this.getMinecraft().func_147108_a((Screen)new GuiAddWaypoint(this, this.master, waypoint, true));
    }

    protected void addWaypoint() {
        float b;
        float g;
        float r;
        this.addClicked = true;
        if (this.waypointManager.getWaypoints().size() == 0) {
            r = 0.0f;
            g = 1.0f;
            b = 0.0f;
        } else {
            r = this.generator.nextFloat();
            g = this.generator.nextFloat();
            b = this.generator.nextFloat();
        }
        TreeSet<DimensionContainer> dimensions = new TreeSet<DimensionContainer>();
        dimensions.add(AbstractVoxelMap.getInstance().getDimensionManager().getDimensionContainerByDimension(this.getMinecraft().field_71441_e.field_73011_w));
        this.newWaypoint = new Waypoint("", this.options.game.field_71439_g.field_71093_bK != DimensionType.field_223228_b_ ? GameVariableAccessShim.xCoord() : GameVariableAccessShim.xCoord() * 8, this.options.game.field_71439_g.field_71093_bK != DimensionType.field_223228_b_ ? GameVariableAccessShim.zCoord() : GameVariableAccessShim.zCoord() * 8, GameVariableAccessShim.yCoord(), true, r, g, b, "", this.master.getWaypointManager().getCurrentSubworldDescriptor(false), dimensions);
        this.getMinecraft().func_147108_a((Screen)new GuiAddWaypoint(this, this.master, this.newWaypoint, false));
    }

    protected void toggleWaypointVisibility() {
        this.selectedWaypoint.enabled = !this.selectedWaypoint.enabled;
        this.waypointManager.saveWaypoints();
    }

    public void render(int mouseX, int mouseY, float partialTicks) {
        super.drawMap();
        this.tooltip = null;
        this.waypointList.render(mouseX, mouseY, partialTicks);
        this.drawCenteredString(this.getFontRenderer(), this.screenTitle, this.getWidth() / 2, 20, 0xFFFFFF);
        super.render(mouseX, mouseY, partialTicks);
        this.drawString(this.getFontRenderer(), I18nUtils.getString("minimap.waypoints.filter", new Object[0]) + ":", this.getWidth() / 2 - 153, this.getHeight() - 75, 0xA0A0A0);
        this.filter.render(mouseX, mouseY, partialTicks);
        if (this.tooltip != null) {
            this.renderTooltip(this.tooltip, mouseX, mouseY);
        }
    }

    public void renderTooltip(String par1Str, int par2, int par3) {
        if (par1Str != null) {
            int var4 = par2 + 12;
            int var5 = par3 - 12;
            int var6 = this.getFontRenderer().func_78256_a(par1Str);
            this.fillGradient(var4 - 3, var5 - 3, var4 + var6 + 3, var5 + 8 + 3, -1073741824, -1073741824);
            this.getFontRenderer().func_175063_a(par1Str, (float)var4, (float)var5, -1);
        }
    }

    static String setTooltip(GuiWaypoints par0GuiWaypoints, String par1Str) {
        par0GuiWaypoints.tooltip = par1Str;
        return par0GuiWaypoints.tooltip;
    }

    public boolean canTeleport() {
        boolean allowed = false;
        boolean singlePlayer = this.options.game.func_71387_A();
        if (singlePlayer) {
            try {
                allowed = this.getMinecraft().func_71401_C().func_184103_al().func_152596_g(this.getMinecraft().field_71439_g.func_146103_bH());
            }
            catch (Exception e) {
                allowed = this.getMinecraft().func_71401_C().func_71218_a(DimensionType.field_223227_a_).func_72912_H().func_76086_u();
            }
        } else {
            allowed = true;
        }
        return allowed;
    }

    @Override
    public void removed() {
        this.minecraft.field_195559_v.func_197967_a(false);
        if (this.changedSort) {
            super.removed();
        }
    }
}

