/*
 * Decompiled with CFR 0.152.
 */
package com.mamiyaotaru.voxelmap.gui;

import com.mamiyaotaru.voxelmap.MapSettingsManager;
import com.mamiyaotaru.voxelmap.gui.GuiMinimapControls;
import com.mamiyaotaru.voxelmap.gui.GuiMinimapPerformance;
import com.mamiyaotaru.voxelmap.gui.GuiRadarOptions;
import com.mamiyaotaru.voxelmap.gui.overridden.EnumOptionsMinimap;
import com.mamiyaotaru.voxelmap.gui.overridden.GuiOptionButtonMinimap;
import com.mamiyaotaru.voxelmap.gui.overridden.GuiScreenMinimap;
import com.mamiyaotaru.voxelmap.interfaces.IVoxelMap;
import com.mamiyaotaru.voxelmap.persistent.GuiPersistentMapOptions;
import com.mamiyaotaru.voxelmap.util.I18nUtils;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.Button;

public class GuiMinimapOptions
extends GuiScreenMinimap {
    private Screen parent;
    private IVoxelMap master;
    private static EnumOptionsMinimap[] relevantOptions;
    private final MapSettingsManager options;
    protected String screenTitle = "Minimap Options";

    public GuiMinimapOptions(Screen parent, IVoxelMap master) {
        this.parent = parent;
        this.master = master;
        this.options = master.getMapOptions();
    }

    public void init() {
        relevantOptions = new EnumOptionsMinimap[]{EnumOptionsMinimap.COORDS, EnumOptionsMinimap.HIDE, EnumOptionsMinimap.LOCATION, EnumOptionsMinimap.SIZE, EnumOptionsMinimap.SQUARE, EnumOptionsMinimap.ROTATES, EnumOptionsMinimap.BEACONS, EnumOptionsMinimap.CAVEMODE};
        int var2 = 0;
        this.screenTitle = I18nUtils.getString("options.minimap.title", new Object[0]);
        for (int t = 0; t < relevantOptions.length; ++t) {
            final EnumOptionsMinimap option = relevantOptions[t];
            GuiOptionButtonMinimap var7 = new GuiOptionButtonMinimap(this.getWidth() / 2 - 155 + var2 % 2 * 160, this.getHeight() / 6 + 24 * (var2 >> 1), option, this.options.getKeyText(option), null){

                @Override
                public void onPress() {
                    GuiMinimapOptions.this.actionPerformed(this, option.returnEnumOrdinal());
                }
            };
            this.addButton((Widget)var7);
            if (option.equals((Object)EnumOptionsMinimap.CAVEMODE)) {
                var7.active = this.options.cavesAllowed;
            }
            ++var2;
        }
        Button radarOptionsButton = new Button(this.getWidth() / 2 - 155, this.getHeight() / 6 + 120 - 6, 150, 20, I18nUtils.getString("options.minimap.radar", new Object[0]), null){

            public void onPress() {
                GuiMinimapOptions.this.actionPerformed(this, 101);
            }
        };
        radarOptionsButton.active = this.master.getRadarOptions().radarAllowed != false || this.master.getRadarOptions().radarMobsAllowed != false || this.master.getRadarOptions().radarPlayersAllowed != false;
        this.addButton((Widget)radarOptionsButton);
        this.addButton((Widget)new Button(this.getWidth() / 2 + 5, this.getHeight() / 6 + 120 - 6, 150, 20, I18nUtils.getString("options.minimap.detailsperformance", new Object[0]), null){

            public void onPress() {
                GuiMinimapOptions.this.actionPerformed(this, 103);
            }
        });
        this.addButton((Widget)new Button(this.getWidth() / 2 - 155, this.getHeight() / 6 + 144 - 6, 150, 20, I18nUtils.getString("options.controls", new Object[0]), null){

            public void onPress() {
                GuiMinimapOptions.this.actionPerformed(this, 102);
            }
        });
        this.addButton((Widget)new Button(this.getWidth() / 2 + 5, this.getHeight() / 6 + 144 - 6, 150, 20, I18nUtils.getString("options.minimap.worldmap", new Object[0]), null){

            public void onPress() {
                GuiMinimapOptions.this.actionPerformed(this, 100);
            }
        });
        this.addButton((Widget)new Button(this.getWidth() / 2 - 100, this.getHeight() / 6 + 168, 200, 20, I18nUtils.getString("gui.done", new Object[0]), null){

            public void onPress() {
                GuiMinimapOptions.this.actionPerformed(this, 200);
            }
        });
    }

    protected void actionPerformed(Button par1GuiButton, int id) {
        if (par1GuiButton.active) {
            if (id < 100 && par1GuiButton instanceof GuiOptionButtonMinimap) {
                this.options.setOptionValue(((GuiOptionButtonMinimap)par1GuiButton).returnEnumOptions(), 1);
                par1GuiButton.setMessage(this.options.getKeyText(EnumOptionsMinimap.getEnumOptions(id)));
                if (((GuiOptionButtonMinimap)par1GuiButton).returnEnumOptions() == EnumOptionsMinimap.OLDNORTH) {
                    this.master.getWaypointManager().setOldNorth(this.options.oldNorth);
                }
            }
            if (id == 103) {
                this.getMinecraft().func_147108_a((Screen)new GuiMinimapPerformance(this, this.master));
            }
            if (id == 102) {
                this.getMinecraft().func_147108_a((Screen)new GuiMinimapControls(this, this.master));
            }
            if (id == 101) {
                this.getMinecraft().func_147108_a((Screen)new GuiRadarOptions(this, this.master));
            }
            if (id == 100) {
                this.getMinecraft().func_147108_a((Screen)new GuiPersistentMapOptions(this, this.master));
            }
            if (id == 200) {
                this.getMinecraft().func_147108_a(this.parent);
            }
        }
    }

    public void render(int mouseX, int mouseY, float partialTicks) {
        super.drawMap();
        this.renderBackground();
        this.drawCenteredString(this.getFontRenderer(), this.screenTitle, this.getWidth() / 2, 20, 0xFFFFFF);
        super.render(mouseX, mouseY, partialTicks);
    }
}

