/*
 * Decompiled with CFR 0.152.
 */
package com.mamiyaotaru.voxelmap.gui;

import com.mamiyaotaru.voxelmap.MapSettingsManager;
import com.mamiyaotaru.voxelmap.gui.overridden.GuiScreenMinimap;
import com.mamiyaotaru.voxelmap.interfaces.IVoxelMap;
import com.mamiyaotaru.voxelmap.util.I18nUtils;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.client.util.InputMappings;

public class GuiMinimapControls
extends GuiScreenMinimap {
    private Screen parentScreen;
    protected String screenTitle = "Controls";
    private MapSettingsManager options;
    public KeyBinding buttonId = null;

    public GuiMinimapControls(Screen par1GuiScreen, IVoxelMap master) {
        this.parentScreen = par1GuiScreen;
        this.options = master.getMapOptions();
    }

    private int getLeftBorder() {
        return this.getWidth() / 2 - 155;
    }

    public void init() {
        int var2 = this.getLeftBorder();
        for (int var3 = 0; var3 < this.options.keyBindings.length; ++var3) {
            final int id = var3;
            this.addButton((Widget)new Button(var2 + var3 % 2 * 160, this.getHeight() / 6 + 24 * (var3 >> 1), 70, 20, this.options.getKeybindDisplayString(var3), null){

                public void onPress() {
                    GuiMinimapControls.this.actionPerformed(this, id);
                }
            });
        }
        this.addButton((Widget)new Button(this.getWidth() / 2 - 100, this.getHeight() / 6 + 168, 200, 20, I18nUtils.getString("gui.done", new Object[0]), null){

            public void onPress() {
                GuiMinimapControls.this.actionPerformed(this, 200);
            }
        });
        this.screenTitle = I18nUtils.getString("controls.minimap.title", new Object[0]);
    }

    protected void actionPerformed(Button par1GuiButton, int id) {
        for (int buttonListIndex = 0; buttonListIndex < this.options.keyBindings.length; ++buttonListIndex) {
            ((Button)this.getButtonList().get(buttonListIndex)).setMessage(this.options.getKeybindDisplayString(buttonListIndex));
        }
        if (id == 200) {
            this.getMinecraft().func_147108_a(this.parentScreen);
        } else {
            this.buttonId = this.options.keyBindings[id];
            par1GuiButton.setMessage("> " + this.options.getKeybindDisplayString(id) + " <");
        }
    }

    public boolean mouseClicked(double mouseX, double mouseY, int mouseButton) {
        if (this.buttonId != null) {
            this.options.setKeyBinding(this.buttonId, InputMappings.Type.MOUSE.func_197944_a(mouseButton));
            this.buttonId = null;
            KeyBinding.func_74508_b();
            return true;
        }
        return super.mouseClicked(mouseX, mouseY, mouseButton);
    }

    public boolean keyPressed(int keysm, int scancode, int b) {
        if (this.buttonId != null) {
            if (keysm == 256) {
                this.options.setKeyBinding(this.buttonId, InputMappings.field_197958_a);
            } else {
                this.options.setKeyBinding(this.buttonId, InputMappings.func_197954_a((int)keysm, (int)scancode));
            }
            this.buttonId = null;
            KeyBinding.func_74508_b();
            return true;
        }
        return super.keyPressed(keysm, scancode, b);
    }

    public void render(int mouseX, int mouseY, float partialTicks) {
        super.drawMap();
        this.renderBackground();
        this.drawCenteredString(this.getFontRenderer(), this.screenTitle, this.getWidth() / 2, 20, 0xFFFFFF);
        int leftBorder = this.getLeftBorder();
        for (int keyCounter = 0; keyCounter < this.options.keyBindings.length; ++keyCounter) {
            boolean keycodeCollision = false;
            KeyBinding keyBinding = this.options.keyBindings[keyCounter];
            for (int compareKeyCounter = 0; compareKeyCounter < this.options.game.field_71474_y.field_74324_K.length; ++compareKeyCounter) {
                KeyBinding compareBinding;
                if (compareKeyCounter < this.options.keyBindings.length && keyBinding != (compareBinding = this.options.keyBindings[compareKeyCounter]) && keyBinding.equals(compareBinding)) {
                    keycodeCollision = true;
                    break;
                }
                if (compareKeyCounter >= this.options.game.field_71474_y.field_74324_K.length || keyBinding == (compareBinding = this.options.game.field_71474_y.field_74324_K[compareKeyCounter]) || !keyBinding.equals(compareBinding)) continue;
                keycodeCollision = true;
                break;
            }
            if (this.buttonId == this.options.keyBindings[keyCounter]) {
                ((Button)this.getButtonList().get(keyCounter)).setMessage("\u00a7f> \u00a7e??? \u00a7f<");
            } else if (keycodeCollision) {
                ((Button)this.getButtonList().get(keyCounter)).setMessage("\u00a7c" + this.options.getKeybindDisplayString(keyCounter));
            } else {
                ((Button)this.getButtonList().get(keyCounter)).setMessage(this.options.getKeybindDisplayString(keyCounter));
            }
            this.drawString(this.getFontRenderer(), this.options.getKeyBindingDescription(keyCounter), leftBorder + keyCounter % 2 * 160 + 70 + 6, this.getHeight() / 6 + 24 * (keyCounter >> 1) + 7, -1);
        }
        this.drawCenteredString(this.getFontRenderer(), I18nUtils.getString("controls.minimap.unbind1", new Object[0]), this.getWidth() / 2, this.getHeight() / 6 + 115, 0xFFFFFF);
        this.drawCenteredString(this.getFontRenderer(), I18nUtils.getString("controls.minimap.unbind2", new Object[0]), this.getWidth() / 2, this.getHeight() / 6 + 129, 0xFFFFFF);
        super.render(mouseX, mouseY, partialTicks);
    }
}

