/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.network.packets;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import mezz.jei.network.IPacketId;
import mezz.jei.network.PacketIdServer;
import mezz.jei.network.packets.PacketJei;
import mezz.jei.transfer.BasicRecipeTransferHandlerServer;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.network.PacketBuffer;

public class PacketRecipeTransfer
extends PacketJei {
    public final Map<Integer, Integer> recipeMap;
    public final List<Integer> craftingSlots;
    public final List<Integer> inventorySlots;
    private final boolean maxTransfer;
    private final boolean requireCompleteSets;

    public PacketRecipeTransfer(Map<Integer, Integer> recipeMap, List<Integer> craftingSlots, List<Integer> inventorySlots, boolean maxTransfer, boolean requireCompleteSets) {
        this.recipeMap = recipeMap;
        this.craftingSlots = craftingSlots;
        this.inventorySlots = inventorySlots;
        this.maxTransfer = maxTransfer;
        this.requireCompleteSets = requireCompleteSets;
    }

    @Override
    public IPacketId getPacketId() {
        return PacketIdServer.RECIPE_TRANSFER;
    }

    @Override
    public void writePacketData(PacketBuffer buf) {
        buf.func_150787_b(this.recipeMap.size());
        for (Map.Entry<Integer, Integer> recipeMapEntry : this.recipeMap.entrySet()) {
            buf.func_150787_b(recipeMapEntry.getKey().intValue());
            buf.func_150787_b(recipeMapEntry.getValue().intValue());
        }
        buf.func_150787_b(this.craftingSlots.size());
        for (Integer craftingSlot : this.craftingSlots) {
            buf.func_150787_b(craftingSlot.intValue());
        }
        buf.func_150787_b(this.inventorySlots.size());
        for (Integer inventorySlot : this.inventorySlots) {
            buf.func_150787_b(inventorySlot.intValue());
        }
        buf.writeBoolean(this.maxTransfer);
        buf.writeBoolean(this.requireCompleteSets);
    }

    public static void readPacketData(PacketBuffer buf, PlayerEntity player) {
        int recipeMapSize = buf.func_150792_a();
        HashMap<Integer, Integer> recipeMap = new HashMap<Integer, Integer>(recipeMapSize);
        for (int i = 0; i < recipeMapSize; ++i) {
            int slotIndex = buf.func_150792_a();
            int recipeItem = buf.func_150792_a();
            recipeMap.put(slotIndex, recipeItem);
        }
        int craftingSlotsSize = buf.func_150792_a();
        ArrayList<Integer> craftingSlots = new ArrayList<Integer>(craftingSlotsSize);
        for (int i = 0; i < craftingSlotsSize; ++i) {
            int slotIndex = buf.func_150792_a();
            craftingSlots.add(slotIndex);
        }
        int inventorySlotsSize = buf.func_150792_a();
        ArrayList<Integer> inventorySlots = new ArrayList<Integer>(inventorySlotsSize);
        for (int i = 0; i < inventorySlotsSize; ++i) {
            int slotIndex = buf.func_150792_a();
            inventorySlots.add(slotIndex);
        }
        boolean maxTransfer = buf.readBoolean();
        boolean requireCompleteSets = buf.readBoolean();
        BasicRecipeTransferHandlerServer.setItems(player, recipeMap, craftingSlots, inventorySlots, maxTransfer, requireCompleteSets);
    }
}

