/*
 * Decompiled with CFR 0.152.
 */
package atomicstryker.ruins.common;

import atomicstryker.ruins.common.RuinsMod;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.BlockState;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.JsonToNBT;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.tileentity.TileEntity;
import org.apache.logging.log4j.Level;

public class RuleStringNbtHelper {
    private static int throttleEntityWarning = 4;

    public static String StringFromBlockState(BlockState blockState, TileEntity tileEntity) {
        CompoundNBT tagCompound = NBTUtil.func_190009_a((BlockState)blockState);
        if (tileEntity != null) {
            CompoundNBT parameters = new CompoundNBT();
            CompoundNBT tagTileEntity = tileEntity.func_189515_b(new CompoundNBT());
            tagTileEntity.func_82580_o("id");
            tagTileEntity.func_82580_o("x");
            tagTileEntity.func_82580_o("y");
            tagTileEntity.func_82580_o("z");
            parameters.func_218657_a("entity", (INBT)tagTileEntity);
            tagCompound.func_218657_a("Ruins", (INBT)parameters);
        }
        return tagCompound.toString();
    }

    public static BlockState blockStateFromCompound(CompoundNBT input) {
        CompoundNBT nbtTagCompound = input.func_74737_b();
        nbtTagCompound.func_82580_o("ruinsTE");
        return NBTUtil.func_190008_d((CompoundNBT)nbtTagCompound);
    }

    public static CompoundNBT tileEntityNBTFromCompound(CompoundNBT defaultValue, CompoundNBT input) {
        CompoundNBT teNbt = defaultValue;
        if (input.func_150297_b("ruinsTE", 10)) {
            Level level = throttleEntityWarning > 0 ? Level.WARN : Level.DEBUG;
            RuinsMod.LOGGER.log(level, "{ruinsTE:{...}} is deprecated; use {Ruins:{entity:{...}}} instead");
            if (throttleEntityWarning > 0 && --throttleEntityWarning < 1) {
                RuinsMod.LOGGER.warn("suppressing ruinsTE deprecation warnings; limit reached");
            }
            if (defaultValue == null) {
                teNbt = input.func_74775_l("ruinsTE").func_74737_b();
                teNbt.func_82580_o("id");
                teNbt.func_82580_o("x");
                teNbt.func_82580_o("y");
                teNbt.func_82580_o("z");
            }
        }
        return teNbt;
    }

    public static List<CompoundNBT> splitRuleByBrackets(String rule) {
        ArrayList<CompoundNBT> result = new ArrayList<CompoundNBT>();
        int currentBracketStartIndex = 0;
        int bracketCounter = 0;
        char quote = '\u0000';
        for (int i = 0; i < rule.length(); ++i) {
            char c = rule.charAt(i);
            if (quote != '\u0000') {
                if (quote == c) {
                    quote = '\u0000';
                    continue;
                }
                if ('\\' != c) continue;
                ++i;
                continue;
            }
            if ('{' == c) {
                if (++bracketCounter != 1) continue;
                currentBracketStartIndex = i;
                continue;
            }
            if ('}' == c) {
                CompoundNBT nbtTagCompound;
                if (--bracketCounter < 0) {
                    RuinsMod.LOGGER.error("Error in rule {} at character {}: unbalanced brackets!", (Object)rule, (Object)i);
                    return null;
                }
                if (bracketCounter != 0) continue;
                try {
                    nbtTagCompound = JsonToNBT.func_180713_a((String)rule.substring(currentBracketStartIndex, i + 1));
                }
                catch (CommandSyntaxException e) {
                    RuinsMod.LOGGER.error("Error in rule {} starting at character {}: unbalanced brackets!", (Object)rule, (Object)currentBracketStartIndex);
                    return null;
                }
                result.add(nbtTagCompound);
                continue;
            }
            if ('\"' != c && '\'' != c) continue;
            quote = c;
        }
        if (quote != '\u0000') {
            RuinsMod.LOGGER.error("Error in rule {} unbalanced quotes!", (Object)rule);
            return null;
        }
        if (bracketCounter > 0) {
            RuinsMod.LOGGER.error("Error in rule {} unbalanced brackets!", (Object)rule);
            return null;
        }
        return result;
    }
}

