/*
 * Decompiled with CFR 0.152.
 */
package atomicstryker.ruins.common;

import atomicstryker.ruins.common.FileHandler;
import atomicstryker.ruins.common.RuinData;
import atomicstryker.ruins.common.RuinStats;
import atomicstryker.ruins.common.RuinTemplate;
import atomicstryker.ruins.common.RuinsMod;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Random;
import java.util.concurrent.ConcurrentSkipListSet;
import java.util.concurrent.atomic.AtomicBoolean;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.dimension.OverworldDimension;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.registries.IForgeRegistry;

class RuinGenerator {
    static final int WORLD_MAX_HEIGHT = 256;
    private static final String fileName = "RuinsPositionsFile.txt";
    private static IForgeRegistry<Biome> biomeRegistry = null;
    private final FileHandler fileHandler;
    private final RuinStats stats;
    private final ConcurrentSkipListSet<RuinData> registeredRuins;
    private final File ruinsDataFile;
    private final File ruinsDataFileWriting;
    private int numTries = 0;
    private int LastNumTries = 0;
    private AtomicBoolean flushing;

    public RuinGenerator(FileHandler rh, World world) {
        this.fileHandler = rh;
        this.stats = new RuinStats();
        this.registeredRuins = new ConcurrentSkipListSet();
        this.flushing = new AtomicBoolean(false);
        this.ruinsDataFile = new File(rh.saveFolder, fileName);
        this.ruinsDataFileWriting = new File(rh.saveFolder, "RuinsPositionsFile.txt_writing");
        new LoadThread().start();
    }

    void flushPosFile(String worldName) {
        if (this.registeredRuins.isEmpty() || worldName.equals("MpServer")) {
            return;
        }
        if (this.flushing.compareAndSet(false, true)) {
            new FlushThread().start();
        }
    }

    private void loadPosFile(File file) {
        try {
            if (!file.exists() && !file.createNewFile()) {
                throw new RuntimeException("Ruins crashed trying to access file " + file);
            }
            int lineNumber = 1;
            BufferedReader br = new BufferedReader(new FileReader(file));
            String line = br.readLine();
            while (line != null) {
                if (!(line = line.trim()).startsWith("#") && !line.isEmpty()) {
                    try {
                        this.registeredRuins.add(new RuinData(line));
                    }
                    catch (Exception e) {
                        RuinsMod.LOGGER.error("Ruins positions file is invalid in line {}}, skipping...", (Object)lineNumber);
                    }
                }
                ++lineNumber;
                line = br.readLine();
            }
            br.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    void generateNormal(World world, Random random, int xBase, int zBase) {
        for (int c = 0; c < this.fileHandler.triesPerChunkNormal; ++c) {
            if (!(random.nextFloat() * 100.0f < this.fileHandler.chanceToSpawnNormal)) continue;
            this.createBuilding(world, random, xBase + random.nextInt(16), zBase + random.nextInt(16), false);
        }
    }

    void generateNether(World world, Random random, int xBase, int zBase) {
        for (int c = 0; c < this.fileHandler.triesPerChunkNether; ++c) {
            if (!(random.nextFloat() * 100.0f < this.fileHandler.chanceToSpawnNether)) continue;
            this.createBuilding(world, random, xBase + random.nextInt(16), zBase + random.nextInt(16), true);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private void createBuilding(World world, Random random, int x, int z, boolean nether) {
        Integer i;
        int rotate = random.nextInt(4);
        Biome biome = world.func_180494_b(new BlockPos(x, 0, z));
        String biomeID = biome.getRegistryName().func_110623_a();
        if (this.fileHandler.useGeneric(random, biomeID)) {
            biomeID = "generic";
        }
        i = (i = this.stats.biomes.get(biomeID)) != null ? Integer.valueOf(i + 1) : Integer.valueOf(1);
        this.stats.biomes.put(biomeID, i);
        RuinTemplate ruinTemplate = this.fileHandler.getTemplate(random, biomeID);
        if (ruinTemplate == null) {
            return;
        }
        ++this.numTries;
        int y = this.findSuitableY(world, ruinTemplate, x, z, nether);
        if (y > 0) {
            if (!this.checkMinDistance(world, ruinTemplate, ruinTemplate.getRuinData(x, y, z, rotate))) {
                ++this.stats.minDistFails;
                return;
            }
            if ((y = ruinTemplate.checkArea(world, x, y, z, rotate)) < 0) {
                ++this.stats.LevelingFails;
                return;
            }
            int finalY = ruinTemplate.doBuild(world, random, x, y, z, rotate, false, false);
            if (finalY >= 0) {
                if (!this.fileHandler.disableLogging) {
                    RuinsMod.LOGGER.info("Creating ruin {} of Biome {} at [{}|{}|{}]\n", (Object)ruinTemplate.getName(), (Object)biome.getRegistryName().func_110623_a(), (Object)x, (Object)y, (Object)z);
                }
                ++this.stats.NumCreated;
                this.registeredRuins.add(ruinTemplate.getRuinData(x, y, z, rotate));
            }
        } else {
            ++this.stats.LevelingFails;
        }
        if (this.numTries > this.LastNumTries + 1000) {
            this.LastNumTries = this.numTries;
            this.printStats();
        }
    }

    private IForgeRegistry<Biome> getBiomeRegistry() {
        if (biomeRegistry == null) {
            biomeRegistry = GameRegistry.findRegistry(Biome.class);
        }
        return biomeRegistry;
    }

    private void printStats() {
        if (!this.fileHandler.disableLogging) {
            int total = this.stats.NumCreated + this.stats.LevelingFails;
            RuinsMod.LOGGER.info("Current Stats:");
            RuinsMod.LOGGER.info("    Total Tries:                 " + total);
            RuinsMod.LOGGER.info("    Number Created:              " + this.stats.NumCreated);
            RuinsMod.LOGGER.info("    Min Dist fail:               " + this.stats.minDistFails);
            RuinsMod.LOGGER.info("    Leveling:                    " + this.stats.LevelingFails);
            for (ResourceLocation rl : this.getBiomeRegistry().getKeys()) {
                Integer i;
                Biome bgb = (Biome)this.getBiomeRegistry().getValue(rl);
                if (bgb == null || (i = this.stats.biomes.get(bgb.getRegistryName().func_110623_a())) == null) continue;
                RuinsMod.LOGGER.info(bgb.getRegistryName().func_110623_a() + ": " + i + " Biome building attempts");
            }
            RuinsMod.LOGGER.info("Any-Biome: " + this.stats.biomes.get("generic") + " building attempts");
            RuinsMod.LOGGER.info("");
        }
    }

    private boolean checkMinDistance(World world, RuinTemplate ruinTemplate, RuinData ruinData) {
        if (world.func_201675_m() instanceof OverworldDimension) {
            BlockPos spawn = world.func_175694_M();
            int min_distance = Math.max(this.fileHandler.anySpawnMinDistance, ruinTemplate.spawnMinDistance);
            if (ruinData.xMin - spawn.func_177958_n() < min_distance && spawn.func_177958_n() - ruinData.xMax < min_distance && ruinData.zMin - spawn.func_177952_p() < min_distance && spawn.func_177952_p() - ruinData.zMax < min_distance) {
                return false;
            }
            int max_distance = Math.min(this.fileHandler.anySpawnMaxDistance, ruinTemplate.spawnMaxDistance);
            if (ruinData.xMax - spawn.func_177958_n() > max_distance || spawn.func_177958_n() - ruinData.xMin > max_distance || ruinData.zMax - spawn.func_177952_p() > max_distance || spawn.func_177952_p() - ruinData.zMin > max_distance) {
                return false;
            }
        }
        int bbExtension = (int)(ruinTemplate.uniqueMinDistance == 0 ? this.fileHandler.templateInstancesMinDistance : (float)ruinTemplate.uniqueMinDistance);
        RuinData checkSelfMinDist = new RuinData(ruinData.xMin - bbExtension, ruinData.xMax + bbExtension, ruinData.yMin - bbExtension, ruinData.yMax + bbExtension, ruinData.zMin - bbExtension, ruinData.zMax + bbExtension, ruinData.name);
        bbExtension = (int)this.fileHandler.anyRuinsMinDistance;
        RuinData checkOtherMinDist = new RuinData(ruinData.xMin - bbExtension, ruinData.xMax + bbExtension, ruinData.yMin - bbExtension, ruinData.yMax + bbExtension, ruinData.zMin - bbExtension, ruinData.zMax + bbExtension, ruinData.name);
        for (RuinData r : this.registeredRuins) {
            boolean tooClose = r.name.equals(ruinData.name) ? checkSelfMinDist.intersectsWith(r) : checkOtherMinDist.intersectsWith(r);
            if (!tooClose) continue;
            return false;
        }
        return true;
    }

    private int findSuitableY(World world, RuinTemplate r, int x, int z, boolean nether) {
        if (!nether) {
            for (int y = 255; y > 7; --y) {
                BlockPos pos = new BlockPos(x, y, z);
                if (!world.func_195588_v(pos)) {
                    return -1;
                }
                BlockState b = world.func_180495_p(pos);
                if (r.isIgnoredBlock(b)) continue;
                if (r.isAcceptableSurface(b)) {
                    return y + 1;
                }
                return -1;
            }
        } else if (x % 2 == 1 ^ z % 2 == 1) {
            for (int y = 255; y > -1; --y) {
                BlockPos basePos = new BlockPos(x, y, z);
                if (!world.func_195588_v(basePos)) {
                    return -1;
                }
                BlockState b = world.func_180495_p(basePos);
                if (b.func_177230_c() != Blocks.field_150350_a) continue;
                while (y > -1) {
                    BlockPos pos = new BlockPos(x, y, z);
                    if (!r.isIgnoredBlock(world.func_180495_p(pos))) {
                        if (r.isAcceptableSurface(b)) {
                            return y + 1;
                        }
                        return -1;
                    }
                    --y;
                }
            }
        } else {
            boolean accept = false;
            for (int y = 0; y < 256; ++y) {
                BlockPos pos = new BlockPos(x, y, z);
                if (!world.func_195588_v(pos)) {
                    return -1;
                }
                BlockState b = world.func_180495_p(pos);
                if (r.isIgnoredBlock(b)) {
                    return accept ? y : -1;
                }
                accept = r.isAcceptableSurface(b);
            }
        }
        return -1;
    }

    private class FlushThread
    extends Thread {
        private FlushThread() {
        }

        @Override
        public void run() {
            try {
                this.doFlush();
            }
            finally {
                RuinGenerator.this.flushing.set(false);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void doFlush() {
            if (RuinGenerator.this.ruinsDataFileWriting.exists() && !RuinGenerator.this.ruinsDataFileWriting.delete()) {
                throw new RuntimeException("Ruins crashed trying to access file " + RuinGenerator.this.ruinsDataFileWriting);
            }
            try {
                if (!RuinGenerator.this.ruinsDataFileWriting.createNewFile()) {
                    System.err.println("Ruins could not create new file: " + RuinGenerator.this.ruinsDataFileWriting.getAbsolutePath());
                }
                PrintWriter pw = new PrintWriter(new BufferedWriter(new FileWriter(RuinGenerator.this.ruinsDataFileWriting)));
                pw.println("# Ruins data management file. Below, you see all data accumulated by AtomicStrykers Ruins during the last run of this World.");
                pw.println("# Data is noted as follows: Each line stands for one successfull Ruin spawn. Data syntax is:");
                pw.println("# xMin yMin zMin xMax yMax zMax templateName");
                pw.println("# everything but the last value is an integer value. Template name equals the template file name.");
                pw.println("#");
                pw.println("# DO NOT EDIT THIS FILE UNLESS YOU ARE SURE OF WHAT YOU ARE DOING");
                pw.println("#");
                pw.println("# The primary function of this file is to lock areas you do not want Ruins spawning in. Put them here before worldgen.");
                pw.println("# It should also prevent Ruins re-spawning under any circumstances. Areas registered in here block any overlapping new Ruins.");
                pw.println("# Empty lines and those prefixed by '#' are ignored by the parser. Don't save notes in here, file gets wiped upon flushing.");
                pw.println("#");
                for (RuinData r : RuinGenerator.this.registeredRuins) {
                    pw.println(r.toString());
                }
                pw.flush();
                pw.close();
                File file = RuinGenerator.this.ruinsDataFile;
                synchronized (file) {
                    if (RuinGenerator.this.ruinsDataFile.exists() && !RuinGenerator.this.ruinsDataFile.delete()) {
                        throw new RuntimeException("Ruins crashed trying to access file " + RuinGenerator.this.ruinsDataFileWriting);
                    }
                    if (!RuinGenerator.this.ruinsDataFileWriting.renameTo(RuinGenerator.this.ruinsDataFile)) {
                        throw new RuntimeException("Ruins crashed trying to access file " + RuinGenerator.this.ruinsDataFileWriting);
                    }
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private class LoadThread
    extends Thread {
        private LoadThread() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            File file = RuinGenerator.this.ruinsDataFile;
            synchronized (file) {
                RuinGenerator.this.loadPosFile(RuinGenerator.this.ruinsDataFile);
            }
        }
    }
}

