/*
 * Decompiled with CFR 0.152.
 */
package atomicstryker.ruins.common;

import atomicstryker.ruins.common.RuinsMod;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;

public class ConfigFolderPreparator {
    public static void copyFromJarIfNotPresent(RuinsMod ruinsMod, File targetDir) {
        if (targetDir.exists()) {
            RuinsMod.LOGGER.info("config/ruins_config exists, not extracting");
            return;
        }
        targetDir.mkdir();
        try {
            InputStream inputStream = RuinsMod.class.getClassLoader().getResourceAsStream("assets\\ruins_config.zip");
            byte[] buffer = new byte[1024];
            ZipInputStream zis = new ZipInputStream(inputStream);
            ZipEntry zipEntry = zis.getNextEntry();
            while (zipEntry != null) {
                RuinsMod.LOGGER.info("extracting {}", (Object)zipEntry);
                if (!zipEntry.isDirectory()) {
                    int len;
                    File newFile = new File(targetDir, zipEntry.getName());
                    FileOutputStream fos = new FileOutputStream(newFile);
                    while ((len = zis.read(buffer)) > 0) {
                        fos.write(buffer, 0, len);
                    }
                    fos.close();
                } else {
                    File directory = new File(targetDir, zipEntry.toString());
                    directory.mkdirs();
                    RuinsMod.LOGGER.info("created subdirectory");
                }
                zipEntry = zis.getNextEntry();
            }
            zis.closeEntry();
            zis.close();
        }
        catch (Exception e) {
            System.err.println("Ruins couldn't prepare template defaults for some reason:");
            e.printStackTrace();
        }
    }
}

