/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.blaze3d.platform;

import com.mojang.blaze3d.platform.GLX;
import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.util.stream.IntStream;
import javax.annotation.Nullable;
import org.lwjgl.opengl.GL;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GL14;
import org.lwjgl.system.MemoryUtil;

public class GlStateManager {
    private static final int LIGHT_COUNT = 8;
    private static final int TEXTURE_COUNT = 8;
    private static final FloatBuffer MATRIX_BUFFER = GLX.make(MemoryUtil.memAllocFloat((int)16), floatBuffer -> cub.a(MemoryUtil.memAddress((FloatBuffer)floatBuffer)));
    private static final FloatBuffer COLOR_BUFFER = GLX.make(MemoryUtil.memAllocFloat((int)4), floatBuffer -> cub.a(MemoryUtil.memAddress((FloatBuffer)floatBuffer)));
    private static final a ALPHA_TEST = new a();
    private static final c LIGHTING = new c(2896);
    private static final c[] LIGHT_ENABLE = (c[])IntStream.range(0, 8).mapToObj(n2 -> new c(16384 + n2)).toArray(c[]::new);
    private static final h COLOR_MATERIAL = new h();
    private static final b BLEND = new b();
    private static final k DEPTH = new k();
    private static final m FOG = new m();
    private static final j CULL = new j();
    private static final o POLY_OFFSET = new o();
    private static final f COLOR_LOGIC = new f();
    private static final u TEX_GEN = new u();
    private static final d CLEAR = new d();
    private static final r STENCIL = new r();
    private static final c NORMALIZE = new c(2977);
    private static int activeTexture;
    private static final v[] TEXTURES;
    private static int shadeModel;
    private static final c RESCALE_NORMAL;
    private static final g COLOR_MASK;
    private static final e COLOR;
    private static final float DEFAULTALPHACUTOFF = 0.1f;

    public static void pushLightingAttributes() {
        GL11.glPushAttrib((int)8256);
    }

    public static void pushTextureAttributes() {
        GL11.glPushAttrib((int)270336);
    }

    public static void popAttributes() {
        GL11.glPopAttrib();
    }

    public static void disableAlphaTest() {
        GlStateManager.ALPHA_TEST.a.a();
    }

    public static void enableAlphaTest() {
        GlStateManager.ALPHA_TEST.a.b();
    }

    public static void alphaFunc(int n2, float f2) {
        if (n2 != GlStateManager.ALPHA_TEST.b || f2 != GlStateManager.ALPHA_TEST.c) {
            GlStateManager.ALPHA_TEST.b = n2;
            GlStateManager.ALPHA_TEST.c = f2;
            GL11.glAlphaFunc((int)n2, (float)f2);
        }
    }

    public static void enableLighting() {
        LIGHTING.b();
    }

    public static void disableLighting() {
        LIGHTING.a();
    }

    public static void enableLight(int n2) {
        LIGHT_ENABLE[n2].b();
    }

    public static void disableLight(int n2) {
        LIGHT_ENABLE[n2].a();
    }

    public static void enableColorMaterial() {
        GlStateManager.COLOR_MATERIAL.a.b();
    }

    public static void disableColorMaterial() {
        GlStateManager.COLOR_MATERIAL.a.a();
    }

    public static void colorMaterial(int n2, int n3) {
        if (n2 != GlStateManager.COLOR_MATERIAL.b || n3 != GlStateManager.COLOR_MATERIAL.c) {
            GlStateManager.COLOR_MATERIAL.b = n2;
            GlStateManager.COLOR_MATERIAL.c = n3;
            GL11.glColorMaterial((int)n2, (int)n3);
        }
    }

    public static void light(int n2, int n3, FloatBuffer floatBuffer) {
        GL11.glLightfv((int)n2, (int)n3, (FloatBuffer)floatBuffer);
    }

    public static void lightModel(int n2, FloatBuffer floatBuffer) {
        GL11.glLightModelfv((int)n2, (FloatBuffer)floatBuffer);
    }

    public static void normal3f(float f2, float f3, float f4) {
        GL11.glNormal3f((float)f2, (float)f3, (float)f4);
    }

    public static void disableDepthTest() {
        GlStateManager.DEPTH.a.a();
    }

    public static void enableDepthTest() {
        GlStateManager.DEPTH.a.b();
    }

    public static void depthFunc(int n2) {
        if (n2 != GlStateManager.DEPTH.c) {
            GlStateManager.DEPTH.c = n2;
            GL11.glDepthFunc((int)n2);
        }
    }

    public static void depthMask(boolean bl2) {
        if (bl2 != GlStateManager.DEPTH.b) {
            GlStateManager.DEPTH.b = bl2;
            GL11.glDepthMask((boolean)bl2);
        }
    }

    public static void disableBlend() {
        GlStateManager.BLEND.a.a();
    }

    public static void enableBlend() {
        GlStateManager.BLEND.a.b();
    }

    public static void blendFunc(SourceFactor sourceFactor, DestFactor destFactor) {
        GlStateManager.blendFunc(sourceFactor.value, destFactor.value);
    }

    public static void blendFunc(int n2, int n3) {
        if (n2 != GlStateManager.BLEND.b || n3 != GlStateManager.BLEND.c) {
            GlStateManager.BLEND.b = n2;
            GlStateManager.BLEND.c = n3;
            GL11.glBlendFunc((int)n2, (int)n3);
        }
    }

    public static void blendFuncSeparate(SourceFactor sourceFactor, DestFactor destFactor, SourceFactor sourceFactor2, DestFactor destFactor2) {
        GlStateManager.blendFuncSeparate(sourceFactor.value, destFactor.value, sourceFactor2.value, destFactor2.value);
    }

    public static void blendFuncSeparate(int n2, int n3, int n4, int n5) {
        if (n2 != GlStateManager.BLEND.b || n3 != GlStateManager.BLEND.c || n4 != GlStateManager.BLEND.d || n5 != GlStateManager.BLEND.e) {
            GlStateManager.BLEND.b = n2;
            GlStateManager.BLEND.c = n3;
            GlStateManager.BLEND.d = n4;
            GlStateManager.BLEND.e = n5;
            GLX.glBlendFuncSeparate(n2, n3, n4, n5);
        }
    }

    public static void blendEquation(int n2) {
        GL14.glBlendEquation((int)n2);
    }

    public static void setupSolidRenderingTextureCombine(int n2) {
        COLOR_BUFFER.put(0, (float)(n2 >> 16 & 0xFF) / 255.0f);
        COLOR_BUFFER.put(1, (float)(n2 >> 8 & 0xFF) / 255.0f);
        COLOR_BUFFER.put(2, (float)(n2 >> 0 & 0xFF) / 255.0f);
        COLOR_BUFFER.put(3, (float)(n2 >> 24 & 0xFF) / 255.0f);
        GlStateManager.texEnv(8960, 8705, COLOR_BUFFER);
        GlStateManager.texEnv(8960, 8704, 34160);
        GlStateManager.texEnv(8960, 34161, 7681);
        GlStateManager.texEnv(8960, 34176, 34166);
        GlStateManager.texEnv(8960, 34192, 768);
        GlStateManager.texEnv(8960, 34162, 7681);
        GlStateManager.texEnv(8960, 34184, 5890);
        GlStateManager.texEnv(8960, 34200, 770);
    }

    public static void tearDownSolidRenderingTextureCombine() {
        GlStateManager.texEnv(8960, 8704, 8448);
        GlStateManager.texEnv(8960, 34161, 8448);
        GlStateManager.texEnv(8960, 34162, 8448);
        GlStateManager.texEnv(8960, 34176, 5890);
        GlStateManager.texEnv(8960, 34184, 5890);
        GlStateManager.texEnv(8960, 34192, 768);
        GlStateManager.texEnv(8960, 34200, 770);
    }

    public static void enableFog() {
        GlStateManager.FOG.a.b();
    }

    public static void disableFog() {
        GlStateManager.FOG.a.a();
    }

    public static void fogMode(l l2) {
        GlStateManager.fogMode(l2.d);
    }

    private static void fogMode(int n2) {
        if (n2 != GlStateManager.FOG.b) {
            GlStateManager.FOG.b = n2;
            GL11.glFogi((int)2917, (int)n2);
        }
    }

    public static void fogDensity(float f2) {
        if (f2 != GlStateManager.FOG.c) {
            GlStateManager.FOG.c = f2;
            GL11.glFogf((int)2914, (float)f2);
        }
    }

    public static void fogStart(float f2) {
        if (f2 != GlStateManager.FOG.d) {
            GlStateManager.FOG.d = f2;
            GL11.glFogf((int)2915, (float)f2);
        }
    }

    public static void fogEnd(float f2) {
        if (f2 != GlStateManager.FOG.e) {
            GlStateManager.FOG.e = f2;
            GL11.glFogf((int)2916, (float)f2);
        }
    }

    public static void fog(int n2, FloatBuffer floatBuffer) {
        GL11.glFogfv((int)n2, (FloatBuffer)floatBuffer);
    }

    public static void fogi(int n2, int n3) {
        GL11.glFogi((int)n2, (int)n3);
    }

    public static void enableCull() {
        GlStateManager.CULL.a.b();
    }

    public static void disableCull() {
        GlStateManager.CULL.a.a();
    }

    public static void cullFace(i i2) {
        GlStateManager.cullFace(i2.d);
    }

    private static void cullFace(int n2) {
        if (n2 != GlStateManager.CULL.b) {
            GlStateManager.CULL.b = n2;
            GL11.glCullFace((int)n2);
        }
    }

    public static void polygonMode(int n2, int n3) {
        GL11.glPolygonMode((int)n2, (int)n3);
    }

    public static void enablePolygonOffset() {
        GlStateManager.POLY_OFFSET.a.b();
    }

    public static void disablePolygonOffset() {
        GlStateManager.POLY_OFFSET.a.a();
    }

    public static void enableLineOffset() {
        GlStateManager.POLY_OFFSET.b.b();
    }

    public static void disableLineOffset() {
        GlStateManager.POLY_OFFSET.b.a();
    }

    public static void polygonOffset(float f2, float f3) {
        if (f2 != GlStateManager.POLY_OFFSET.c || f3 != GlStateManager.POLY_OFFSET.d) {
            GlStateManager.POLY_OFFSET.c = f2;
            GlStateManager.POLY_OFFSET.d = f3;
            GL11.glPolygonOffset((float)f2, (float)f3);
        }
    }

    public static void enableColorLogicOp() {
        GlStateManager.COLOR_LOGIC.a.b();
    }

    public static void disableColorLogicOp() {
        GlStateManager.COLOR_LOGIC.a.a();
    }

    public static void logicOp(n n2) {
        GlStateManager.logicOp(n2.q);
    }

    public static void logicOp(int n2) {
        if (n2 != GlStateManager.COLOR_LOGIC.b) {
            GlStateManager.COLOR_LOGIC.b = n2;
            GL11.glLogicOp((int)n2);
        }
    }

    public static void enableTexGen(s s2) {
        GlStateManager.getTexGen((s)s2).a.b();
    }

    public static void disableTexGen(s s2) {
        GlStateManager.getTexGen((s)s2).a.a();
    }

    public static void texGenMode(s s2, int n2) {
        t t2 = GlStateManager.getTexGen(s2);
        if (n2 != t2.c) {
            t2.c = n2;
            GL11.glTexGeni((int)t2.b, (int)9472, (int)n2);
        }
    }

    public static void texGenParam(s s2, int n2, FloatBuffer floatBuffer) {
        GL11.glTexGenfv((int)GlStateManager.getTexGen((s)s2).b, (int)n2, (FloatBuffer)floatBuffer);
    }

    private static t getTexGen(s s2) {
        switch (s2) {
            case a: {
                return GlStateManager.TEX_GEN.a;
            }
            case b: {
                return GlStateManager.TEX_GEN.b;
            }
            case c: {
                return GlStateManager.TEX_GEN.c;
            }
            case d: {
                return GlStateManager.TEX_GEN.d;
            }
        }
        return GlStateManager.TEX_GEN.a;
    }

    public static void activeTexture(int n2) {
        if (activeTexture != n2 - GLX.GL_TEXTURE0) {
            activeTexture = n2 - GLX.GL_TEXTURE0;
            GLX.glActiveTexture(n2);
        }
    }

    public static void enableTexture() {
        GlStateManager.TEXTURES[GlStateManager.activeTexture].a.b();
    }

    public static void disableTexture() {
        GlStateManager.TEXTURES[GlStateManager.activeTexture].a.a();
    }

    public static void texEnv(int n2, int n3, FloatBuffer floatBuffer) {
        GL11.glTexEnvfv((int)n2, (int)n3, (FloatBuffer)floatBuffer);
    }

    public static void texEnv(int n2, int n3, int n4) {
        GL11.glTexEnvi((int)n2, (int)n3, (int)n4);
    }

    public static void texEnv(int n2, int n3, float f2) {
        GL11.glTexEnvf((int)n2, (int)n3, (float)f2);
    }

    public static void texParameter(int n2, int n3, float f2) {
        GL11.glTexParameterf((int)n2, (int)n3, (float)f2);
    }

    public static void texParameter(int n2, int n3, int n4) {
        GL11.glTexParameteri((int)n2, (int)n3, (int)n4);
    }

    public static int getTexLevelParameter(int n2, int n3, int n4) {
        return GL11.glGetTexLevelParameteri((int)n2, (int)n3, (int)n4);
    }

    public static int genTexture() {
        return GL11.glGenTextures();
    }

    public static void deleteTexture(int n2) {
        GL11.glDeleteTextures((int)n2);
        for (v v2 : TEXTURES) {
            if (v2.b != n2) continue;
            v2.b = -1;
        }
    }

    public static void bindTexture(int n2) {
        if (n2 != GlStateManager.TEXTURES[GlStateManager.activeTexture].b) {
            GlStateManager.TEXTURES[GlStateManager.activeTexture].b = n2;
            GL11.glBindTexture((int)3553, (int)n2);
        }
    }

    public static void texImage2D(int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, @Nullable IntBuffer intBuffer) {
        GL11.glTexImage2D((int)n2, (int)n3, (int)n4, (int)n5, (int)n6, (int)n7, (int)n8, (int)n9, (IntBuffer)intBuffer);
    }

    public static void texSubImage2D(int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, long l2) {
        GL11.glTexSubImage2D((int)n2, (int)n3, (int)n4, (int)n5, (int)n6, (int)n7, (int)n8, (int)n9, (long)l2);
    }

    public static void copyTexSubImage2D(int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9) {
        GL11.glCopyTexSubImage2D((int)n2, (int)n3, (int)n4, (int)n5, (int)n6, (int)n7, (int)n8, (int)n9);
    }

    public static void getTexImage(int n2, int n3, int n4, int n5, long l2) {
        GL11.glGetTexImage((int)n2, (int)n3, (int)n4, (int)n5, (long)l2);
    }

    public static void enableNormalize() {
        NORMALIZE.b();
    }

    public static void disableNormalize() {
        NORMALIZE.a();
    }

    public static void shadeModel(int n2) {
        if (n2 != shadeModel) {
            shadeModel = n2;
            GL11.glShadeModel((int)n2);
        }
    }

    public static void enableRescaleNormal() {
        RESCALE_NORMAL.b();
    }

    public static void disableRescaleNormal() {
        RESCALE_NORMAL.a();
    }

    public static void viewport(int n2, int n3, int n4, int n5) {
        w.a.b = n2;
        w.a.c = n3;
        w.a.d = n4;
        w.a.e = n5;
        GL11.glViewport((int)n2, (int)n3, (int)n4, (int)n5);
    }

    public static void colorMask(boolean bl2, boolean bl3, boolean bl4, boolean bl5) {
        if (bl2 != GlStateManager.COLOR_MASK.a || bl3 != GlStateManager.COLOR_MASK.b || bl4 != GlStateManager.COLOR_MASK.c || bl5 != GlStateManager.COLOR_MASK.d) {
            GlStateManager.COLOR_MASK.a = bl2;
            GlStateManager.COLOR_MASK.b = bl3;
            GlStateManager.COLOR_MASK.c = bl4;
            GlStateManager.COLOR_MASK.d = bl5;
            GL11.glColorMask((boolean)bl2, (boolean)bl3, (boolean)bl4, (boolean)bl5);
        }
    }

    public static void stencilFunc(int n2, int n3, int n4) {
        if (n2 != GlStateManager.STENCIL.a.a || n2 != GlStateManager.STENCIL.a.b || n2 != GlStateManager.STENCIL.a.c) {
            GlStateManager.STENCIL.a.a = n2;
            GlStateManager.STENCIL.a.b = n3;
            GlStateManager.STENCIL.a.c = n4;
            GL11.glStencilFunc((int)n2, (int)n3, (int)n4);
        }
    }

    public static void stencilMask(int n2) {
        if (n2 != GlStateManager.STENCIL.b) {
            GlStateManager.STENCIL.b = n2;
            GL11.glStencilMask((int)n2);
        }
    }

    public static void stencilOp(int n2, int n3, int n4) {
        if (n2 != GlStateManager.STENCIL.c || n3 != GlStateManager.STENCIL.d || n4 != GlStateManager.STENCIL.e) {
            GlStateManager.STENCIL.c = n2;
            GlStateManager.STENCIL.d = n3;
            GlStateManager.STENCIL.e = n4;
            GL11.glStencilOp((int)n2, (int)n3, (int)n4);
        }
    }

    public static void clearDepth(double d2) {
        if (d2 != GlStateManager.CLEAR.a) {
            GlStateManager.CLEAR.a = d2;
            GL11.glClearDepth((double)d2);
        }
    }

    public static void clearColor(float f2, float f3, float f4, float f5) {
        if (f2 != GlStateManager.CLEAR.b.a || f3 != GlStateManager.CLEAR.b.b || f4 != GlStateManager.CLEAR.b.c || f5 != GlStateManager.CLEAR.b.d) {
            GlStateManager.CLEAR.b.a = f2;
            GlStateManager.CLEAR.b.b = f3;
            GlStateManager.CLEAR.b.c = f4;
            GlStateManager.CLEAR.b.d = f5;
            GL11.glClearColor((float)f2, (float)f3, (float)f4, (float)f5);
        }
    }

    public static void clearStencil(int n2) {
        if (n2 != GlStateManager.CLEAR.c) {
            GlStateManager.CLEAR.c = n2;
            GL11.glClearStencil((int)n2);
        }
    }

    public static void clear(int n2, boolean bl2) {
        GL11.glClear((int)n2);
        if (bl2) {
            GlStateManager.getError();
        }
    }

    public static void matrixMode(int n2) {
        GL11.glMatrixMode((int)n2);
    }

    public static void loadIdentity() {
        GL11.glLoadIdentity();
    }

    public static void pushMatrix() {
        GL11.glPushMatrix();
    }

    public static void popMatrix() {
        GL11.glPopMatrix();
    }

    public static void getMatrix(int n2, FloatBuffer floatBuffer) {
        GL11.glGetFloatv((int)n2, (FloatBuffer)floatBuffer);
    }

    public static cve getMatrix4f(int n2) {
        GL11.glGetFloatv((int)n2, (FloatBuffer)MATRIX_BUFFER);
        MATRIX_BUFFER.rewind();
        cve cve2 = new cve();
        cve2.a(MATRIX_BUFFER);
        MATRIX_BUFFER.rewind();
        return cve2;
    }

    public static void ortho(double d2, double d3, double d4, double d5, double d6, double d7) {
        GL11.glOrtho((double)d2, (double)d3, (double)d4, (double)d5, (double)d6, (double)d7);
    }

    public static void rotatef(float f2, float f3, float f4, float f5) {
        GL11.glRotatef((float)f2, (float)f3, (float)f4, (float)f5);
    }

    public static void rotated(double d2, double d3, double d4, double d5) {
        GL11.glRotated((double)d2, (double)d3, (double)d4, (double)d5);
    }

    public static void scalef(float f2, float f3, float f4) {
        GL11.glScalef((float)f2, (float)f3, (float)f4);
    }

    public static void scaled(double d2, double d3, double d4) {
        GL11.glScaled((double)d2, (double)d3, (double)d4);
    }

    public static void translatef(float f2, float f3, float f4) {
        GL11.glTranslatef((float)f2, (float)f3, (float)f4);
    }

    public static void translated(double d2, double d3, double d4) {
        GL11.glTranslated((double)d2, (double)d3, (double)d4);
    }

    public static void multMatrix(FloatBuffer floatBuffer) {
        GL11.glMultMatrixf((FloatBuffer)floatBuffer);
    }

    public static void multMatrix(cve cve2) {
        cve2.b(MATRIX_BUFFER);
        MATRIX_BUFFER.rewind();
        GL11.glMultMatrixf((FloatBuffer)MATRIX_BUFFER);
    }

    public static void color4f(float f2, float f3, float f4, float f5) {
        if (f2 != GlStateManager.COLOR.a || f3 != GlStateManager.COLOR.b || f4 != GlStateManager.COLOR.c || f5 != GlStateManager.COLOR.d) {
            GlStateManager.COLOR.a = f2;
            GlStateManager.COLOR.b = f3;
            GlStateManager.COLOR.c = f4;
            GlStateManager.COLOR.d = f5;
            GL11.glColor4f((float)f2, (float)f3, (float)f4, (float)f5);
        }
    }

    public static void color3f(float f2, float f3, float f4) {
        GlStateManager.color4f(f2, f3, f4, 1.0f);
    }

    public static void texCoord2f(float f2, float f3) {
        GL11.glTexCoord2f((float)f2, (float)f3);
    }

    public static void vertex3f(float f2, float f3, float f4) {
        GL11.glVertex3f((float)f2, (float)f3, (float)f4);
    }

    public static void clearCurrentColor() {
        GlStateManager.COLOR.a = -1.0f;
        GlStateManager.COLOR.b = -1.0f;
        GlStateManager.COLOR.c = -1.0f;
        GlStateManager.COLOR.d = -1.0f;
    }

    public static void normalPointer(int n2, int n3, int n4) {
        GL11.glNormalPointer((int)n2, (int)n3, (long)n4);
    }

    public static void normalPointer(int n2, int n3, ByteBuffer byteBuffer) {
        GL11.glNormalPointer((int)n2, (int)n3, (ByteBuffer)byteBuffer);
    }

    public static void texCoordPointer(int n2, int n3, int n4, int n5) {
        GL11.glTexCoordPointer((int)n2, (int)n3, (int)n4, (long)n5);
    }

    public static void texCoordPointer(int n2, int n3, int n4, ByteBuffer byteBuffer) {
        GL11.glTexCoordPointer((int)n2, (int)n3, (int)n4, (ByteBuffer)byteBuffer);
    }

    public static void vertexPointer(int n2, int n3, int n4, int n5) {
        GL11.glVertexPointer((int)n2, (int)n3, (int)n4, (long)n5);
    }

    public static void vertexPointer(int n2, int n3, int n4, ByteBuffer byteBuffer) {
        GL11.glVertexPointer((int)n2, (int)n3, (int)n4, (ByteBuffer)byteBuffer);
    }

    public static void colorPointer(int n2, int n3, int n4, int n5) {
        GL11.glColorPointer((int)n2, (int)n3, (int)n4, (long)n5);
    }

    public static void colorPointer(int n2, int n3, int n4, ByteBuffer byteBuffer) {
        GL11.glColorPointer((int)n2, (int)n3, (int)n4, (ByteBuffer)byteBuffer);
    }

    public static void disableClientState(int n2) {
        GL11.glDisableClientState((int)n2);
    }

    public static void enableClientState(int n2) {
        GL11.glEnableClientState((int)n2);
    }

    public static void begin(int n2) {
        GL11.glBegin((int)n2);
    }

    public static void end() {
        GL11.glEnd();
    }

    public static void drawArrays(int n2, int n3, int n4) {
        GL11.glDrawArrays((int)n2, (int)n3, (int)n4);
    }

    public static void lineWidth(float f2) {
        GL11.glLineWidth((float)f2);
    }

    public static void callList(int n2) {
        GL11.glCallList((int)n2);
    }

    public static void deleteLists(int n2, int n3) {
        GL11.glDeleteLists((int)n2, (int)n3);
    }

    public static void newList(int n2, int n3) {
        GL11.glNewList((int)n2, (int)n3);
    }

    public static void endList() {
        GL11.glEndList();
    }

    public static int genLists(int n2) {
        return GL11.glGenLists((int)n2);
    }

    public static void pixelStore(int n2, int n3) {
        GL11.glPixelStorei((int)n2, (int)n3);
    }

    public static void pixelTransfer(int n2, float f2) {
        GL11.glPixelTransferf((int)n2, (float)f2);
    }

    public static void readPixels(int n2, int n3, int n4, int n5, int n6, int n7, ByteBuffer byteBuffer) {
        GL11.glReadPixels((int)n2, (int)n3, (int)n4, (int)n5, (int)n6, (int)n7, (ByteBuffer)byteBuffer);
    }

    public static void readPixels(int n2, int n3, int n4, int n5, int n6, int n7, long l2) {
        GL11.glReadPixels((int)n2, (int)n3, (int)n4, (int)n5, (int)n6, (int)n7, (long)l2);
    }

    public static int getError() {
        return GL11.glGetError();
    }

    public static String getString(int n2) {
        return GL11.glGetString((int)n2);
    }

    public static void getInteger(int n2, IntBuffer intBuffer) {
        GL11.glGetIntegerv((int)n2, (IntBuffer)intBuffer);
    }

    public static int getInteger(int n2) {
        return GL11.glGetInteger((int)n2);
    }

    public static void setProfile(p p2) {
        p2.a();
    }

    public static void unsetProfile(p p2) {
        p2.b();
    }

    static {
        TEXTURES = (v[])IntStream.range(0, 8).mapToObj(n2 -> new v()).toArray(v[]::new);
        shadeModel = 7425;
        RESCALE_NORMAL = new c(32826);
        COLOR_MASK = new g();
        COLOR = new e();
    }

    public static enum p {
        a{

            @Override
            public void a() {
                GlStateManager.disableAlphaTest();
                GlStateManager.alphaFunc(519, 0.0f);
                GlStateManager.disableLighting();
                GlStateManager.lightModel(2899, cuf.a(0.2f, 0.2f, 0.2f, 1.0f));
                for (int i2 = 0; i2 < 8; ++i2) {
                    GlStateManager.disableLight(i2);
                    GlStateManager.light(16384 + i2, 4608, cuf.a(0.0f, 0.0f, 0.0f, 1.0f));
                    GlStateManager.light(16384 + i2, 4611, cuf.a(0.0f, 0.0f, 1.0f, 0.0f));
                    if (i2 == 0) {
                        GlStateManager.light(16384 + i2, 4609, cuf.a(1.0f, 1.0f, 1.0f, 1.0f));
                        GlStateManager.light(16384 + i2, 4610, cuf.a(1.0f, 1.0f, 1.0f, 1.0f));
                        continue;
                    }
                    GlStateManager.light(16384 + i2, 4609, cuf.a(0.0f, 0.0f, 0.0f, 1.0f));
                    GlStateManager.light(16384 + i2, 4610, cuf.a(0.0f, 0.0f, 0.0f, 1.0f));
                }
                GlStateManager.disableColorMaterial();
                GlStateManager.colorMaterial(1032, 5634);
                GlStateManager.disableDepthTest();
                GlStateManager.depthFunc(513);
                GlStateManager.depthMask(true);
                GlStateManager.disableBlend();
                GlStateManager.blendFunc(SourceFactor.ONE, DestFactor.ZERO);
                GlStateManager.blendFuncSeparate(SourceFactor.ONE, DestFactor.ZERO, SourceFactor.ONE, DestFactor.ZERO);
                GlStateManager.blendEquation(32774);
                GlStateManager.disableFog();
                GlStateManager.fogi(2917, 2048);
                GlStateManager.fogDensity(1.0f);
                GlStateManager.fogStart(0.0f);
                GlStateManager.fogEnd(1.0f);
                GlStateManager.fog(2918, cuf.a(0.0f, 0.0f, 0.0f, 0.0f));
                if (GL.getCapabilities().GL_NV_fog_distance) {
                    GlStateManager.fogi(2917, 34140);
                }
                GlStateManager.polygonOffset(0.0f, 0.0f);
                GlStateManager.disableColorLogicOp();
                GlStateManager.logicOp(5379);
                GlStateManager.disableTexGen(s.a);
                GlStateManager.texGenMode(s.a, 9216);
                GlStateManager.texGenParam(s.a, 9474, cuf.a(1.0f, 0.0f, 0.0f, 0.0f));
                GlStateManager.texGenParam(s.a, 9217, cuf.a(1.0f, 0.0f, 0.0f, 0.0f));
                GlStateManager.disableTexGen(s.b);
                GlStateManager.texGenMode(s.b, 9216);
                GlStateManager.texGenParam(s.b, 9474, cuf.a(0.0f, 1.0f, 0.0f, 0.0f));
                GlStateManager.texGenParam(s.b, 9217, cuf.a(0.0f, 1.0f, 0.0f, 0.0f));
                GlStateManager.disableTexGen(s.c);
                GlStateManager.texGenMode(s.c, 9216);
                GlStateManager.texGenParam(s.c, 9474, cuf.a(0.0f, 0.0f, 0.0f, 0.0f));
                GlStateManager.texGenParam(s.c, 9217, cuf.a(0.0f, 0.0f, 0.0f, 0.0f));
                GlStateManager.disableTexGen(s.d);
                GlStateManager.texGenMode(s.d, 9216);
                GlStateManager.texGenParam(s.d, 9474, cuf.a(0.0f, 0.0f, 0.0f, 0.0f));
                GlStateManager.texGenParam(s.d, 9217, cuf.a(0.0f, 0.0f, 0.0f, 0.0f));
                GlStateManager.activeTexture(0);
                GlStateManager.texParameter(3553, 10240, 9729);
                GlStateManager.texParameter(3553, 10241, 9986);
                GlStateManager.texParameter(3553, 10242, 10497);
                GlStateManager.texParameter(3553, 10243, 10497);
                GlStateManager.texParameter(3553, 33085, 1000);
                GlStateManager.texParameter(3553, 33083, 1000);
                GlStateManager.texParameter(3553, 33082, -1000);
                GlStateManager.texParameter(3553, 34049, 0.0f);
                GlStateManager.texEnv(8960, 8704, 8448);
                GlStateManager.texEnv(8960, 8705, cuf.a(0.0f, 0.0f, 0.0f, 0.0f));
                GlStateManager.texEnv(8960, 34161, 8448);
                GlStateManager.texEnv(8960, 34162, 8448);
                GlStateManager.texEnv(8960, 34176, 5890);
                GlStateManager.texEnv(8960, 34177, 34168);
                GlStateManager.texEnv(8960, 34178, 34166);
                GlStateManager.texEnv(8960, 34184, 5890);
                GlStateManager.texEnv(8960, 34185, 34168);
                GlStateManager.texEnv(8960, 34186, 34166);
                GlStateManager.texEnv(8960, 34192, 768);
                GlStateManager.texEnv(8960, 34193, 768);
                GlStateManager.texEnv(8960, 34194, 770);
                GlStateManager.texEnv(8960, 34200, 770);
                GlStateManager.texEnv(8960, 34201, 770);
                GlStateManager.texEnv(8960, 34202, 770);
                GlStateManager.texEnv(8960, 34163, 1.0f);
                GlStateManager.texEnv(8960, 3356, 1.0f);
                GlStateManager.disableNormalize();
                GlStateManager.shadeModel(7425);
                GlStateManager.disableRescaleNormal();
                GlStateManager.colorMask(true, true, true, true);
                GlStateManager.clearDepth(1.0);
                GlStateManager.lineWidth(1.0f);
                GlStateManager.normal3f(0.0f, 0.0f, 1.0f);
                GlStateManager.polygonMode(1028, 6914);
                GlStateManager.polygonMode(1029, 6914);
            }

            @Override
            public void b() {
            }
        }
        ,
        b{

            @Override
            public void a() {
                GlStateManager.enableBlend();
                GlStateManager.blendFuncSeparate(770, 771, 1, 0);
            }

            @Override
            public void b() {
                GlStateManager.disableBlend();
            }
        }
        ,
        c{

            @Override
            public void a() {
                GlStateManager.color4f(1.0f, 1.0f, 1.0f, 0.15f);
                GlStateManager.depthMask(false);
                GlStateManager.enableBlend();
                GlStateManager.blendFunc(SourceFactor.SRC_ALPHA, DestFactor.ONE_MINUS_SRC_ALPHA);
                GlStateManager.alphaFunc(516, 0.003921569f);
            }

            @Override
            public void b() {
                GlStateManager.disableBlend();
                GlStateManager.alphaFunc(516, 0.1f);
                GlStateManager.depthMask(true);
            }
        };


        public abstract void a();

        public abstract void b();
    }

    public static enum DestFactor {
        CONSTANT_ALPHA(32771),
        CONSTANT_COLOR(32769),
        DST_ALPHA(772),
        DST_COLOR(774),
        ONE(1),
        ONE_MINUS_CONSTANT_ALPHA(32772),
        ONE_MINUS_CONSTANT_COLOR(32770),
        ONE_MINUS_DST_ALPHA(773),
        ONE_MINUS_DST_COLOR(775),
        ONE_MINUS_SRC_ALPHA(771),
        ONE_MINUS_SRC_COLOR(769),
        SRC_ALPHA(770),
        SRC_COLOR(768),
        ZERO(0);

        public final int value;

        private DestFactor(int n3) {
            this.value = n3;
        }
    }

    public static enum SourceFactor {
        CONSTANT_ALPHA(32771),
        CONSTANT_COLOR(32769),
        DST_ALPHA(772),
        DST_COLOR(774),
        ONE(1),
        ONE_MINUS_CONSTANT_ALPHA(32772),
        ONE_MINUS_CONSTANT_COLOR(32770),
        ONE_MINUS_DST_ALPHA(773),
        ONE_MINUS_DST_COLOR(775),
        ONE_MINUS_SRC_ALPHA(771),
        ONE_MINUS_SRC_COLOR(769),
        SRC_ALPHA(770),
        SRC_ALPHA_SATURATE(776),
        SRC_COLOR(768),
        ZERO(0);

        public final int value;

        private SourceFactor(int n3) {
            this.value = n3;
        }
    }

    static class c {
        private final int a;
        private boolean b;

        public c(int n2) {
            this.a = n2;
        }

        public void a() {
            this.a(false);
        }

        public void b() {
            this.a(true);
        }

        public void a(boolean bl2) {
            if (bl2 != this.b) {
                this.b = bl2;
                if (bl2) {
                    GL11.glEnable((int)this.a);
                } else {
                    GL11.glDisable((int)this.a);
                }
            }
        }
    }

    static class e {
        public float a = 1.0f;
        public float b = 1.0f;
        public float c = 1.0f;
        public float d = 1.0f;

        public e() {
            this(1.0f, 1.0f, 1.0f, 1.0f);
        }

        public e(float f2, float f3, float f4, float f5) {
            this.a = f2;
            this.b = f3;
            this.c = f4;
            this.d = f5;
        }
    }

    static class g {
        public boolean a = true;
        public boolean b = true;
        public boolean c = true;
        public boolean d = true;

        private g() {
        }
    }

    public static enum s {
        a,
        b,
        c,
        d;

    }

    static class t {
        public final c a;
        public final int b;
        public int c = -1;

        public t(int n2, int n3) {
            this.b = n2;
            this.a = new c(n3);
        }
    }

    static class u {
        public final t a = new t(8192, 3168);
        public final t b = new t(8193, 3169);
        public final t c = new t(8194, 3170);
        public final t d = new t(8195, 3171);

        private u() {
        }
    }

    static class r {
        public final q a = new q();
        public int b = -1;
        public int c = 7680;
        public int d = 7680;
        public int e = 7680;

        private r() {
        }
    }

    static class q {
        public int a = 519;
        public int b;
        public int c = -1;

        private q() {
        }
    }

    static class d {
        public double a = 1.0;
        public final e b = new e(0.0f, 0.0f, 0.0f, 0.0f);
        public int c;

        private d() {
        }
    }

    static class f {
        public final c a = new c(3058);
        public int b = 5379;

        private f() {
        }
    }

    static class o {
        public final c a = new c(32823);
        public final c b = new c(10754);
        public float c;
        public float d;

        private o() {
        }
    }

    static class j {
        public final c a = new c(2884);
        public int b = 1029;

        private j() {
        }
    }

    static class m {
        public final c a = new c(2912);
        public int b = 2048;
        public float c = 1.0f;
        public float d;
        public float e = 1.0f;

        private m() {
        }
    }

    static class k {
        public final c a = new c(2929);
        public boolean b = true;
        public int c = 513;

        private k() {
        }
    }

    static class b {
        public final c a = new c(3042);
        public int b = 1;
        public int c = 0;
        public int d = 1;
        public int e = 0;

        private b() {
        }
    }

    static class h {
        public final c a = new c(2903);
        public int b = 1032;
        public int c = 5634;

        private h() {
        }
    }

    static class a {
        public final c a = new c(3008);
        public int b = 519;
        public float c = -1.0f;

        private a() {
        }
    }

    static class v {
        public final c a = new c(3553);
        public int b;

        private v() {
        }
    }

    public static enum w {
        a;

        protected int b;
        protected int c;
        protected int d;
        protected int e;
    }

    public static enum n {
        a(5377),
        b(5380),
        c(5378),
        d(5376),
        e(5379),
        f(5388),
        g(5385),
        h(5386),
        i(5390),
        j(5381),
        k(5384),
        l(5383),
        m(5389),
        n(5387),
        o(5391),
        p(5382);

        public final int q;

        private n(int n3) {
            this.q = n3;
        }
    }

    public static enum i {
        a(1028),
        b(1029),
        c(1032);

        public final int d;

        private i(int n3) {
            this.d = n3;
        }
    }

    public static enum l {
        a(9729),
        b(2048),
        c(2049);

        public final int d;

        private l(int n3) {
            this.d = n3;
        }
    }
}

