/*
 * Decompiled with CFR 0.152.
 */
package net.telepathicgrunt.ultraamplified.world.generation.layers;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.minecraft.util.WeightedRandom;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.Biomes;
import net.minecraft.world.gen.INoiseRandom;
import net.minecraft.world.gen.layer.traits.IC0Transformer;
import net.minecraftforge.common.BiomeManager;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.ForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import net.telepathicgrunt.ultraamplified.config.ConfigUA;
import net.telepathicgrunt.ultraamplified.world.biome.BiomeInit;
import net.telepathicgrunt.ultraamplified.world.generation.BiomeGenHelper;

public class BiomeLayerUA
implements IC0Transformer {
    private List<BiomeManager.BiomeEntry>[] biomes = new ArrayList[BiomeManager.BiomeType.values().length];
    private List<BiomeManager.BiomeEntry> jungleReplacedBiomes = new ArrayList<BiomeManager.BiomeEntry>();
    private List<BiomeManager.BiomeEntry> megaTaigaReplacedBiomes = new ArrayList<BiomeManager.BiomeEntry>();
    private List<BiomeManager.BiomeEntry> mesaReplacedBiomes = new ArrayList<BiomeManager.BiomeEntry>();
    private List<BiomeManager.BiomeEntry> oceanReplacedBiomes = new ArrayList<BiomeManager.BiomeEntry>();
    private boolean noOcean = false;
    private static ForgeRegistry<Biome> BiomeRegistry = (ForgeRegistry)ForgeRegistries.BIOMES;

    public BiomeLayerUA() {
        int i;
        for (BiomeManager.BiomeType type : BiomeManager.BiomeType.values()) {
            ImmutableList biomesToAdd = BiomeManager.getBiomes((BiomeManager.BiomeType)type);
            int idx = type.ordinal();
            if (this.biomes[idx] == null) {
                this.biomes[idx] = new ArrayList<BiomeManager.BiomeEntry>();
            }
            if (biomesToAdd == null) continue;
            this.biomes[idx].addAll((Collection<BiomeManager.BiomeEntry>)biomesToAdd);
        }
        int desertIdx = BiomeManager.BiomeType.DESERT.ordinal();
        int warmIdx = BiomeManager.BiomeType.WARM.ordinal();
        int coolIdx = BiomeManager.BiomeType.COOL.ordinal();
        int icyIdx = BiomeManager.BiomeType.ICY.ordinal();
        for (i = 0; i < 6; ++i) {
            this.biomes[warmIdx].remove(0);
        }
        for (i = 0; i < 4; ++i) {
            this.biomes[coolIdx].remove(0);
        }
        for (i = 0; i < 2; ++i) {
            this.biomes[icyIdx].remove(0);
        }
        if (ConfigUA.desert) {
            this.biomes[desertIdx].add(new BiomeManager.BiomeEntry(BiomeInit.DESERT, 50));
        }
        if (ConfigUA.savanna) {
            this.biomes[desertIdx].add(new BiomeManager.BiomeEntry(BiomeInit.SAVANNA, 50));
        }
        if (ConfigUA.plains) {
            this.biomes[desertIdx].add(new BiomeManager.BiomeEntry(BiomeInit.PLAINS, 20));
        }
        if (ConfigUA.nether) {
            this.biomes[desertIdx].add(new BiomeManager.BiomeEntry(BiomeInit.NETHER, 26));
        }
        if (ConfigUA.mushroom) {
            this.biomes[desertIdx].add(new BiomeManager.BiomeEntry(BiomeInit.MUSHROOM_FIELDS, 10));
        }
        if (ConfigUA.forest) {
            this.biomes[warmIdx].add(new BiomeManager.BiomeEntry(BiomeInit.FOREST, 26));
        }
        if (ConfigUA.darkForest) {
            this.biomes[warmIdx].add(new BiomeManager.BiomeEntry(BiomeInit.DARK_FOREST, 26));
        }
        if (ConfigUA.mountains) {
            this.biomes[warmIdx].add(new BiomeManager.BiomeEntry(BiomeInit.MOUNTAINS, 26));
        }
        if (ConfigUA.plains) {
            this.biomes[warmIdx].add(new BiomeManager.BiomeEntry(BiomeInit.PLAINS, 26));
        }
        if (ConfigUA.birchForest) {
            this.biomes[warmIdx].add(new BiomeManager.BiomeEntry(BiomeInit.BIRCH_FOREST, 26));
        }
        if (ConfigUA.swamplands) {
            this.biomes[warmIdx].add(new BiomeManager.BiomeEntry(BiomeInit.SWAMP, 26));
        }
        if (ConfigUA.mushroom) {
            this.biomes[warmIdx].add(new BiomeManager.BiomeEntry(BiomeInit.MUSHROOM_FIELDS, 10));
        }
        if (ConfigUA.forest) {
            this.biomes[coolIdx].add(new BiomeManager.BiomeEntry(BiomeInit.FOREST, 30));
        }
        if (ConfigUA.mountains) {
            this.biomes[coolIdx].add(new BiomeManager.BiomeEntry(BiomeInit.MOUNTAINS, 30));
        }
        if (ConfigUA.taiga) {
            this.biomes[coolIdx].add(new BiomeManager.BiomeEntry(BiomeInit.TAIGA, 30));
        }
        if (ConfigUA.plains) {
            this.biomes[coolIdx].add(new BiomeManager.BiomeEntry(BiomeInit.PLAINS, 13));
        }
        if (ConfigUA.stoneBeach) {
            this.biomes[coolIdx].add(new BiomeManager.BiomeEntry(BiomeInit.STONE_SHORE, 10));
        }
        if (ConfigUA.end) {
            this.biomes[coolIdx].add(new BiomeManager.BiomeEntry(BiomeInit.END, 20));
        }
        if (ConfigUA.mushroom) {
            this.biomes[coolIdx].add(new BiomeManager.BiomeEntry(BiomeInit.MUSHROOM_FIELDS, 10));
        }
        if (ConfigUA.snowyTundra) {
            this.biomes[icyIdx].add(new BiomeManager.BiomeEntry(BiomeInit.SNOWY_TUNDRA, 65));
        } else {
            if (ConfigUA.iceSpike) {
                this.biomes[icyIdx].add(new BiomeManager.BiomeEntry(BiomeInit.ICE_SPIKES, 26));
            }
            if (ConfigUA.iceMountain) {
                this.biomes[icyIdx].add(new BiomeManager.BiomeEntry(BiomeInit.ICE_MOUNTAIN, 26));
            }
        }
        if (ConfigUA.iceMountain) {
            this.biomes[icyIdx].add(new BiomeManager.BiomeEntry(BiomeInit.ICE_MOUNTAIN, 17));
        }
        if (ConfigUA.snowyTaiga) {
            this.biomes[icyIdx].add(new BiomeManager.BiomeEntry(BiomeInit.SNOWY_TAIGA, 30));
        }
        if (ConfigUA.coldBeach) {
            this.biomes[icyIdx].add(new BiomeManager.BiomeEntry(BiomeInit.SNOWY_BEACH, 10));
        }
        if (ConfigUA.mushroom) {
            this.biomes[icyIdx].add(new BiomeManager.BiomeEntry(BiomeInit.MUSHROOM_FIELDS, 10));
        }
        if (ConfigUA.jungle) {
            this.jungleReplacedBiomes.add(new BiomeManager.BiomeEntry(BiomeInit.JUNGLE, 70));
        }
        if (ConfigUA.bambooJungle) {
            this.jungleReplacedBiomes.add(new BiomeManager.BiomeEntry(BiomeInit.BAMBOO_JUNGLE, 30));
        }
        if (ConfigUA.giantTreeTaiga) {
            this.megaTaigaReplacedBiomes.add(new BiomeManager.BiomeEntry(BiomeInit.GIANT_TREE_TAIGA, 10));
        }
        if (ConfigUA.badlands) {
            this.mesaReplacedBiomes.add(new BiomeManager.BiomeEntry(BiomeInit.BADLANDS_PLATEAU, 20));
            this.mesaReplacedBiomes.add(new BiomeManager.BiomeEntry(BiomeInit.WOODED_BADLANDS_PLATEAU, 10));
        } else if (ConfigUA.erodedBadlands) {
            this.mesaReplacedBiomes.add(new BiomeManager.BiomeEntry(BiomeInit.ERODED_BADLANDS, 10));
        }
        ArrayList<BiomeManager.BiomeEntry> temporaryBiomeList = new ArrayList<BiomeManager.BiomeEntry>();
        if (this.biomes[warmIdx].size() != 0) {
            temporaryBiomeList.addAll(this.biomes[warmIdx]);
        }
        if (this.biomes[desertIdx].size() != 0) {
            temporaryBiomeList.addAll(this.biomes[desertIdx]);
        }
        if (this.biomes[coolIdx].size() != 0) {
            temporaryBiomeList.addAll(this.biomes[coolIdx]);
        }
        if (this.biomes[icyIdx].size() != 0) {
            temporaryBiomeList.addAll(this.biomes[icyIdx]);
        }
        if (this.jungleReplacedBiomes.size() != 0) {
            temporaryBiomeList.addAll(this.jungleReplacedBiomes);
        }
        if (this.megaTaigaReplacedBiomes.size() != 0) {
            temporaryBiomeList.addAll(this.megaTaigaReplacedBiomes);
        }
        if (this.mesaReplacedBiomes.size() != 0) {
            temporaryBiomeList.addAll(this.mesaReplacedBiomes);
        }
        this.oceanReplacedBiomes.addAll(temporaryBiomeList);
        while (temporaryBiomeList.size() > 5) {
            temporaryBiomeList.remove(temporaryBiomeList.size() - 1);
        }
        if (temporaryBiomeList.size() == 0) {
            this.biomes[desertIdx].add(new BiomeManager.BiomeEntry(Biomes.field_76771_b, 10));
            this.biomes[warmIdx].add(new BiomeManager.BiomeEntry(Biomes.field_76771_b, 10));
            this.biomes[coolIdx].add(new BiomeManager.BiomeEntry(Biomes.field_76771_b, 10));
            this.biomes[icyIdx].add(new BiomeManager.BiomeEntry(Biomes.field_76771_b, 10));
            this.jungleReplacedBiomes.add(new BiomeManager.BiomeEntry(Biomes.field_76771_b, 10));
            this.megaTaigaReplacedBiomes.add(new BiomeManager.BiomeEntry(Biomes.field_76771_b, 10));
            this.mesaReplacedBiomes.add(new BiomeManager.BiomeEntry(Biomes.field_76771_b, 10));
            this.oceanReplacedBiomes.add(new BiomeManager.BiomeEntry(Biomes.field_76771_b, 10));
        } else {
            if (this.biomes[desertIdx].size() == 0) {
                this.biomes[desertIdx] = temporaryBiomeList;
            }
            if (this.biomes[warmIdx].size() == 0) {
                this.biomes[warmIdx] = temporaryBiomeList;
            }
            if (this.biomes[coolIdx].size() == 0) {
                this.biomes[coolIdx] = temporaryBiomeList;
            }
            if (this.biomes[icyIdx].size() == 0) {
                this.biomes[icyIdx] = temporaryBiomeList;
            }
            if (this.jungleReplacedBiomes.size() == 0) {
                this.jungleReplacedBiomes = temporaryBiomeList;
            }
            if (this.megaTaigaReplacedBiomes.size() == 0) {
                this.megaTaigaReplacedBiomes = temporaryBiomeList;
            }
            if (this.mesaReplacedBiomes.size() == 0) {
                this.mesaReplacedBiomes = temporaryBiomeList;
            }
        }
        if (!(ConfigUA.ocean || ConfigUA.coldOcean || ConfigUA.frozenOcean || ConfigUA.lukewarmOcean || ConfigUA.warmOcean)) {
            this.noOcean = true;
        }
    }

    public int func_202726_a(INoiseRandom context, int value) {
        int i = (value & 0xF00) >> 8;
        if (!BiomeGenHelper.isOcean(value &= 0xFFFFF0FF) && value != BiomeGenHelper.MUSHROOM_FIELDS) {
            switch (value) {
                case 1: {
                    if (i > 0) {
                        return BiomeRegistry.getID((IForgeRegistryEntry)this.getWeightedSpecialBiomeEntry(this.mesaReplacedBiomes, (INoiseRandom)context).biome);
                    }
                    return BiomeRegistry.getID((IForgeRegistryEntry)this.getWeightedBiomeEntry((BiomeManager.BiomeType)BiomeManager.BiomeType.DESERT, (INoiseRandom)context).biome);
                }
                case 2: {
                    if (i > 0) {
                        return BiomeRegistry.getID((IForgeRegistryEntry)this.getWeightedSpecialBiomeEntry(this.jungleReplacedBiomes, (INoiseRandom)context).biome);
                    }
                    return BiomeRegistry.getID((IForgeRegistryEntry)this.getWeightedBiomeEntry((BiomeManager.BiomeType)BiomeManager.BiomeType.WARM, (INoiseRandom)context).biome);
                }
                case 3: {
                    if (i > 0) {
                        return BiomeRegistry.getID((IForgeRegistryEntry)this.getWeightedSpecialBiomeEntry(this.megaTaigaReplacedBiomes, (INoiseRandom)context).biome);
                    }
                    return BiomeRegistry.getID((IForgeRegistryEntry)this.getWeightedBiomeEntry((BiomeManager.BiomeType)BiomeManager.BiomeType.COOL, (INoiseRandom)context).biome);
                }
                case 4: {
                    return BiomeRegistry.getID((IForgeRegistryEntry)this.getWeightedBiomeEntry((BiomeManager.BiomeType)BiomeManager.BiomeType.ICY, (INoiseRandom)context).biome);
                }
            }
            if (this.noOcean) {
                return BiomeRegistry.getID((IForgeRegistryEntry)this.getWeightedSpecialBiomeEntry(this.oceanReplacedBiomes, (INoiseRandom)context).biome);
            }
            return value;
        }
        if (this.noOcean) {
            return BiomeRegistry.getID((IForgeRegistryEntry)this.getWeightedSpecialBiomeEntry(this.oceanReplacedBiomes, (INoiseRandom)context).biome);
        }
        return value;
    }

    protected BiomeManager.BiomeEntry getWeightedBiomeEntry(BiomeManager.BiomeType type, INoiseRandom context) {
        List<BiomeManager.BiomeEntry> biomeList = this.biomes[type.ordinal()];
        int totalWeight = WeightedRandom.func_76272_a(biomeList);
        int weight = BiomeManager.isTypeListModded((BiomeManager.BiomeType)type) ? context.func_202696_a(totalWeight) : context.func_202696_a(totalWeight / 10) * 10;
        return (BiomeManager.BiomeEntry)WeightedRandom.func_180166_a(biomeList, (int)weight);
    }

    protected BiomeManager.BiomeEntry getWeightedSpecialBiomeEntry(List<BiomeManager.BiomeEntry> list, INoiseRandom context) {
        List<BiomeManager.BiomeEntry> biomeList = list;
        int totalWeight = WeightedRandom.func_76272_a(biomeList);
        int weight = list.size() != 0 ? context.func_202696_a(totalWeight) : context.func_202696_a(totalWeight / 10) * 10;
        return (BiomeManager.BiomeEntry)WeightedRandom.func_180166_a(biomeList, (int)weight);
    }
}

