/*
 * Decompiled with CFR 0.152.
 */
package net.telepathicgrunt.ultraamplified.world.feature.structure;

import java.util.List;
import java.util.Random;
import net.minecraft.block.Blocks;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.LockableLootTileEntity;
import net.minecraft.util.Mirror;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.gen.feature.structure.ShipwreckConfig;
import net.minecraft.world.gen.feature.structure.StructurePiece;
import net.minecraft.world.gen.feature.structure.TemplateStructurePiece;
import net.minecraft.world.gen.feature.template.BlockIgnoreStructureProcessor;
import net.minecraft.world.gen.feature.template.PlacementSettings;
import net.minecraft.world.gen.feature.template.StructureProcessor;
import net.minecraft.world.gen.feature.template.Template;
import net.minecraft.world.gen.feature.template.TemplateManager;
import net.minecraft.world.storage.loot.LootTables;
import net.telepathicgrunt.ultraamplified.config.ConfigUA;
import net.telepathicgrunt.ultraamplified.world.feature.structure.StructureInit;

public class ShipwreckPiecesUA {
    private static final BlockPos STRUCTURE_OFFSET = new BlockPos(4, 0, 15);
    private static final ResourceLocation[] BEACHED_SHIPS = new ResourceLocation[]{new ResourceLocation("shipwreck/with_mast"), new ResourceLocation("shipwreck/sideways_full"), new ResourceLocation("shipwreck/sideways_fronthalf"), new ResourceLocation("shipwreck/sideways_backhalf"), new ResourceLocation("shipwreck/rightsideup_full"), new ResourceLocation("shipwreck/rightsideup_fronthalf"), new ResourceLocation("shipwreck/rightsideup_backhalf"), new ResourceLocation("shipwreck/with_mast_degraded"), new ResourceLocation("shipwreck/rightsideup_full_degraded"), new ResourceLocation("shipwreck/rightsideup_fronthalf_degraded"), new ResourceLocation("shipwreck/rightsideup_backhalf_degraded")};
    private static final ResourceLocation[] NOT_BEACHED_SHIPS = new ResourceLocation[]{new ResourceLocation("shipwreck/with_mast"), new ResourceLocation("shipwreck/upsidedown_full"), new ResourceLocation("shipwreck/upsidedown_fronthalf"), new ResourceLocation("shipwreck/upsidedown_backhalf"), new ResourceLocation("shipwreck/sideways_full"), new ResourceLocation("shipwreck/sideways_fronthalf"), new ResourceLocation("shipwreck/sideways_backhalf"), new ResourceLocation("shipwreck/rightsideup_full"), new ResourceLocation("shipwreck/rightsideup_fronthalf"), new ResourceLocation("shipwreck/rightsideup_backhalf"), new ResourceLocation("shipwreck/with_mast_degraded"), new ResourceLocation("shipwreck/upsidedown_full_degraded"), new ResourceLocation("shipwreck/upsidedown_fronthalf_degraded"), new ResourceLocation("shipwreck/upsidedown_backhalf_degraded"), new ResourceLocation("shipwreck/sideways_full_degraded"), new ResourceLocation("shipwreck/sideways_fronthalf_degraded"), new ResourceLocation("shipwreck/sideways_backhalf_degraded"), new ResourceLocation("shipwreck/rightsideup_full_degraded"), new ResourceLocation("shipwreck/rightsideup_fronthalf_degraded"), new ResourceLocation("shipwreck/rightsideup_backhalf_degraded")};
    private static int heightOffset = 0;

    public static void beginGeneration(TemplateManager templateManager, BlockPos pos, Rotation rotation, List<StructurePiece> piecesList, Random random, ShipwreckConfig config) {
        ResourceLocation resourcelocation = config.field_204753_a ? BEACHED_SHIPS[random.nextInt(BEACHED_SHIPS.length)] : NOT_BEACHED_SHIPS[random.nextInt(NOT_BEACHED_SHIPS.length)];
        piecesList.add((StructurePiece)new Piece(templateManager, resourcelocation, pos, rotation, config.field_204753_a));
    }

    public static class Piece
    extends TemplateStructurePiece {
        private Rotation rotation;
        private ResourceLocation resourceLocation;
        private boolean isBeached;

        public Piece(TemplateManager p_i48904_1_, ResourceLocation p_i48904_2_, BlockPos p_i48904_3_, Rotation p_i48904_4_, boolean p_i48904_5_) {
            super(StructureInit.SHIPWRECKUA, 0);
            this.field_186178_c = p_i48904_3_;
            this.rotation = p_i48904_4_;
            this.resourceLocation = p_i48904_2_;
            this.isBeached = p_i48904_5_;
            this.func_204754_a(p_i48904_1_);
        }

        public Piece(TemplateManager p_i50445_1_, CompoundNBT p_i50445_2_) {
            super(StructureInit.SHIPWRECKUA, p_i50445_2_);
            this.resourceLocation = new ResourceLocation(p_i50445_2_.func_74779_i("Template"));
            this.isBeached = p_i50445_2_.func_74767_n("isBeached");
            this.rotation = Rotation.valueOf((String)p_i50445_2_.func_74779_i("Rot"));
            this.func_204754_a(p_i50445_1_);
        }

        protected void func_143011_b(CompoundNBT tagCompound) {
            super.func_143011_b(tagCompound);
            tagCompound.func_74778_a("Template", this.resourceLocation.toString());
            tagCompound.func_74757_a("isBeached", this.isBeached);
            tagCompound.func_74778_a("Rot", this.rotation.name());
        }

        private void func_204754_a(TemplateManager templateManager) {
            Template template = templateManager.func_200220_a(this.resourceLocation);
            PlacementSettings placementsettings = new PlacementSettings().func_186220_a(this.rotation).func_186214_a(Mirror.NONE).func_207665_a(STRUCTURE_OFFSET).func_215222_a((StructureProcessor)BlockIgnoreStructureProcessor.field_215206_c);
            this.func_186173_a(template, this.field_186178_c, placementsettings);
        }

        protected void func_186175_a(String function, BlockPos pos, IWorld worldIn, Random rand, MutableBoundingBox sbb) {
            if (ConfigUA.chestGeneration) {
                if ("map_chest".equals(function)) {
                    LockableLootTileEntity.func_195479_a((IBlockReader)worldIn, (Random)rand, (BlockPos)pos.func_177977_b(), (ResourceLocation)LootTables.field_204771_s);
                } else if ("treasure_chest".equals(function)) {
                    LockableLootTileEntity.func_195479_a((IBlockReader)worldIn, (Random)rand, (BlockPos)pos.func_177977_b(), (ResourceLocation)LootTables.field_204773_u);
                } else if ("supply_chest".equals(function)) {
                    LockableLootTileEntity.func_195479_a((IBlockReader)worldIn, (Random)rand, (BlockPos)pos.func_177977_b(), (ResourceLocation)LootTables.field_204772_t);
                }
            } else if (worldIn.func_180495_p(pos.func_177977_b()).func_204520_s().func_206888_e()) {
                worldIn.func_180501_a(pos.func_177977_b(), Blocks.field_150350_a.func_176223_P(), 2);
            } else {
                worldIn.func_180501_a(pos.func_177977_b(), Blocks.field_150355_j.func_176223_P(), 2);
            }
        }

        public boolean func_74875_a(IWorld worldIn, Random randomIn, MutableBoundingBox structureBoundingBoxIn, ChunkPos p_74875_4_) {
            if (heightOffset == 0) {
                int randHeight;
                int xOffset = 8;
                int zOffset = 8;
                if (this.rotation == Rotation.CLOCKWISE_90) {
                    zOffset = 16;
                } else if (this.rotation == Rotation.CLOCKWISE_180) {
                    xOffset = 0;
                    zOffset = 16;
                } else if (this.rotation == Rotation.COUNTERCLOCKWISE_90) {
                    xOffset = 0;
                    zOffset = 16;
                }
                BlockPos blockpos = new BlockPos(this.field_186178_c.func_177958_n() + xOffset, 0, this.field_186178_c.func_177952_p() + zOffset);
                for (randHeight = randomIn.nextInt(130) + 90; randHeight > 65 && worldIn.func_180495_p(blockpos.func_177981_b(randHeight)).func_204520_s().func_206888_e(); --randHeight) {
                }
                while (randHeight > 65 && !worldIn.func_180495_p(blockpos.func_177981_b(randHeight)).func_204520_s().func_206888_e()) {
                    --randHeight;
                }
                heightOffset = randHeight - 2;
            }
            this.field_186178_c = new BlockPos(this.field_186178_c.func_177958_n(), heightOffset, this.field_186178_c.func_177952_p());
            return super.func_74875_a(worldIn, randomIn, structureBoundingBoxIn, p_74875_4_);
        }
    }
}

