/*
 * Decompiled with CFR 0.152.
 */
package net.telepathicgrunt.ultraamplified.world.feature.structure;

import com.google.common.collect.Lists;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.EndRodBlock;
import net.minecraft.block.LogBlock;
import net.minecraft.block.RailBlock;
import net.minecraft.block.RotatedPillarBlock;
import net.minecraft.block.WallTorchBlock;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.item.minecart.ChestMinecartEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.state.IProperty;
import net.minecraft.state.properties.RailShape;
import net.minecraft.tileentity.MobSpawnerTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.gen.feature.structure.IStructurePieceType;
import net.minecraft.world.gen.feature.structure.StructurePiece;
import net.minecraft.world.gen.feature.template.TemplateManager;
import net.minecraft.world.storage.loot.LootTables;
import net.telepathicgrunt.ultraamplified.config.ConfigUA;
import net.telepathicgrunt.ultraamplified.world.feature.structure.MineshaftUA;
import net.telepathicgrunt.ultraamplified.world.feature.structure.StructureInit;

public class MineshaftPiecesUA {
    private static Piece createRandomShaftPiece(List<StructurePiece> p_189940_0_, Random p_189940_1_, int p_189940_2_, int p_189940_3_, int p_189940_4_, @Nullable Direction p_189940_5_, int p_189940_6_, MineshaftUA.Type p_189940_7_) {
        int i = p_189940_1_.nextInt(100);
        if (i >= 80) {
            MutableBoundingBox MutableBoundingBox2 = Cross.findCrossing(p_189940_0_, p_189940_1_, p_189940_2_, p_189940_3_, p_189940_4_, p_189940_5_);
            if (MutableBoundingBox2 != null) {
                return new Cross(p_189940_6_, MutableBoundingBox2, p_189940_5_, p_189940_7_);
            }
        } else if (i >= 70) {
            MutableBoundingBox MutableBoundingBox1 = Stairs.findStairs(p_189940_0_, p_189940_1_, p_189940_2_, p_189940_3_, p_189940_4_, p_189940_5_);
            if (MutableBoundingBox1 != null) {
                return new Stairs(p_189940_6_, MutableBoundingBox1, p_189940_5_, p_189940_7_);
            }
        } else {
            MutableBoundingBox MutableBoundingBox2 = Corridor.findCorridorSize(p_189940_0_, p_189940_1_, p_189940_2_, p_189940_3_, p_189940_4_, p_189940_5_);
            if (MutableBoundingBox2 != null) {
                return new Corridor(p_189940_6_, p_189940_1_, MutableBoundingBox2, p_189940_5_, p_189940_7_);
            }
        }
        return null;
    }

    private static Piece generateAndAddPiece(StructurePiece p_189938_0_, List<StructurePiece> p_189938_1_, Random p_189938_2_, int p_189938_3_, int p_189938_4_, int p_189938_5_, Direction p_189938_6_, int p_189938_7_) {
        if (p_189938_7_ > 8) {
            return null;
        }
        if (Math.abs(p_189938_3_ - p_189938_0_.func_74874_b().field_78897_a) <= 80 && Math.abs(p_189938_5_ - p_189938_0_.func_74874_b().field_78896_c) <= 80) {
            MineshaftUA.Type mapgenmineshaft$type = ((Piece)p_189938_0_).mineShaftType;
            Piece structuremineshaftpieces$peice = MineshaftPiecesUA.createRandomShaftPiece(p_189938_1_, p_189938_2_, p_189938_3_, p_189938_4_, p_189938_5_, p_189938_6_, p_189938_7_ + 1, mapgenmineshaft$type);
            if (structuremineshaftpieces$peice != null) {
                p_189938_1_.add(structuremineshaftpieces$peice);
                structuremineshaftpieces$peice.func_74861_a(p_189938_0_, p_189938_1_, p_189938_2_);
            }
            return structuremineshaftpieces$peice;
        }
        return null;
    }

    public static class Stairs
    extends Piece {
        public Stairs(int p_i50449_1_, MutableBoundingBox p_i50449_2_, Direction p_i50449_3_, MineshaftUA.Type p_i50449_4_) {
            super(StructureInit.MSSTAIRSUA, p_i50449_1_, p_i50449_4_);
            this.func_186164_a(p_i50449_3_);
            this.field_74887_e = p_i50449_2_;
        }

        public Stairs(TemplateManager p_i50450_1_, CompoundNBT p_i50450_2_) {
            super(StructureInit.MSSTAIRSUA, p_i50450_2_);
        }

        public static MutableBoundingBox findStairs(List<StructurePiece> listIn, Random rand, int x, int y, int z, Direction facing) {
            MutableBoundingBox MutableBoundingBox2 = new MutableBoundingBox(x, y - 5, z, x, y + 2, z);
            switch (facing) {
                default: {
                    MutableBoundingBox2.field_78893_d = x + 2;
                    MutableBoundingBox2.field_78896_c = z - 8;
                    break;
                }
                case SOUTH: {
                    MutableBoundingBox2.field_78893_d = x + 2;
                    MutableBoundingBox2.field_78892_f = z + 8;
                    break;
                }
                case WEST: {
                    MutableBoundingBox2.field_78897_a = x - 8;
                    MutableBoundingBox2.field_78892_f = z + 2;
                    break;
                }
                case EAST: {
                    MutableBoundingBox2.field_78893_d = x + 8;
                    MutableBoundingBox2.field_78892_f = z + 2;
                }
            }
            return StructurePiece.func_74883_a(listIn, (MutableBoundingBox)MutableBoundingBox2) != null ? null : MutableBoundingBox2;
        }

        public void func_74861_a(StructurePiece componentIn, List<StructurePiece> listIn, Random rand) {
            int i = this.func_74877_c();
            Direction enumfacing = this.func_186165_e();
            if (enumfacing != null) {
                switch (enumfacing) {
                    default: {
                        MineshaftPiecesUA.generateAndAddPiece(componentIn, listIn, rand, this.field_74887_e.field_78897_a, this.field_74887_e.field_78895_b, this.field_74887_e.field_78896_c - 1, Direction.NORTH, i);
                        break;
                    }
                    case SOUTH: {
                        MineshaftPiecesUA.generateAndAddPiece(componentIn, listIn, rand, this.field_74887_e.field_78897_a, this.field_74887_e.field_78895_b, this.field_74887_e.field_78892_f + 1, Direction.SOUTH, i);
                        break;
                    }
                    case WEST: {
                        MineshaftPiecesUA.generateAndAddPiece(componentIn, listIn, rand, this.field_74887_e.field_78897_a - 1, this.field_74887_e.field_78895_b, this.field_74887_e.field_78896_c, Direction.WEST, i);
                        break;
                    }
                    case EAST: {
                        MineshaftPiecesUA.generateAndAddPiece(componentIn, listIn, rand, this.field_74887_e.field_78893_d + 1, this.field_74887_e.field_78895_b, this.field_74887_e.field_78896_c, Direction.EAST, i);
                    }
                }
            }
        }

        public boolean func_74875_a(IWorld worldIn, Random randomIn, MutableBoundingBox MutableBoundingBoxIn, ChunkPos p_74875_4_) {
            if (this.func_74860_a((IBlockReader)worldIn, MutableBoundingBoxIn)) {
                return false;
            }
            this.func_175804_a(worldIn, MutableBoundingBoxIn, 0, 5, 0, 2, 7, 1, field_202556_l, field_202556_l, false);
            this.func_175804_a(worldIn, MutableBoundingBoxIn, 0, 0, 7, 2, 2, 8, field_202556_l, field_202556_l, false);
            for (int i = 0; i < 5; ++i) {
                this.func_175804_a(worldIn, MutableBoundingBoxIn, 0, 5 - i - (i < 4 ? 1 : 0), 2 + i, 2, 7 - i, 2 + i, field_202556_l, field_202556_l, false);
            }
            return true;
        }
    }

    public static class Room
    extends Piece {
        private final List<MutableBoundingBox> roomsLinkedToTheRoom = Lists.newLinkedList();
        private final boolean normalRoom;

        public Room(int p_i47137_1_, Random p_i47137_2_, int p_i47137_3_, int p_i47137_4_, MineshaftUA.Type p_i47137_5_) {
            super(StructureInit.MSROOMUA, p_i47137_1_, p_i47137_5_);
            this.mineShaftType = p_i47137_5_;
            this.normalRoom = ConfigUA.mineshaftUndergroundAllowed ? (ConfigUA.mineshaftAbovegroundAllowed ? p_i47137_2_.nextInt(5) < 3 : false) : true;
            if (this.normalRoom) {
                this.field_74887_e = new MutableBoundingBox(p_i47137_3_, 20, p_i47137_4_, p_i47137_3_ + 7 + p_i47137_2_.nextInt(6), 30, p_i47137_4_ + 7 + p_i47137_2_.nextInt(6));
            } else {
                int height = p_i47137_2_.nextInt(90);
                this.field_74887_e = new MutableBoundingBox(p_i47137_3_, 20, p_i47137_4_, p_i47137_3_ + 7 + p_i47137_2_.nextInt(6), 150 + height, p_i47137_4_ + 7 + p_i47137_2_.nextInt(6));
            }
        }

        public Room(TemplateManager p_i50451_1_, CompoundNBT p_i50451_2_) {
            super(StructureInit.MSROOMUA, p_i50451_2_);
            ListNBT listnbt = p_i50451_2_.func_150295_c("Entrances", 11);
            for (int i = 0; i < listnbt.size(); ++i) {
                this.roomsLinkedToTheRoom.add(new MutableBoundingBox(listnbt.func_150306_c(i)));
            }
            this.normalRoom = p_i50451_2_.func_74767_n("NormalRoom");
        }

        @Override
        protected void func_143011_b(CompoundNBT tagCompound) {
            super.func_143011_b(tagCompound);
            ListNBT listnbt = new ListNBT();
            for (MutableBoundingBox mutableboundingbox : this.roomsLinkedToTheRoom) {
                listnbt.add((Object)mutableboundingbox.func_151535_h());
            }
            tagCompound.func_218657_a("Entrances", (INBT)listnbt);
            tagCompound.func_74757_a("NormalRoom", this.normalRoom);
        }

        public void func_74861_a(StructurePiece componentIn, List<StructurePiece> listIn, Random rand) {
            int l;
            int k;
            int i = this.func_74877_c();
            int y = k = this.field_74887_e.func_78882_c() - 3 - 1;
            int groundTunnel = rand.nextInt(4) + 1;
            if (!this.normalRoom) {
                k /= 2;
            }
            if (k <= 0) {
                k = 1;
            }
            int j = 0;
            while (j < this.field_74887_e.func_78883_b() && (l = j + rand.nextInt(this.field_74887_e.func_78883_b())) + 3 <= this.field_74887_e.func_78883_b()) {
                y = groundTunnel == 1 ? 1 : k;
                Piece structuremineshaftpieces$peice = MineshaftPiecesUA.generateAndAddPiece(componentIn, listIn, rand, this.field_74887_e.field_78897_a + l, this.field_74887_e.field_78895_b + rand.nextInt(y) + 1, this.field_74887_e.field_78896_c - 1, Direction.NORTH, i);
                if (structuremineshaftpieces$peice != null) {
                    MutableBoundingBox MutableBoundingBox2 = structuremineshaftpieces$peice.func_74874_b();
                    this.roomsLinkedToTheRoom.add(new MutableBoundingBox(MutableBoundingBox2.field_78897_a, MutableBoundingBox2.field_78895_b, this.field_74887_e.field_78896_c, MutableBoundingBox2.field_78893_d, MutableBoundingBox2.field_78894_e, this.field_74887_e.field_78896_c + 1));
                }
                j = l + 4;
            }
            int i1 = 0;
            while (i1 < this.field_74887_e.func_78883_b() && (l = i1 + rand.nextInt(this.field_74887_e.func_78883_b())) + 3 <= this.field_74887_e.func_78883_b()) {
                y = groundTunnel == 2 ? 1 : k;
                Piece structuremineshaftpieces$peice1 = MineshaftPiecesUA.generateAndAddPiece(componentIn, listIn, rand, this.field_74887_e.field_78897_a + l, this.field_74887_e.field_78895_b + rand.nextInt(y) + 1, this.field_74887_e.field_78892_f + 1, Direction.SOUTH, i);
                if (structuremineshaftpieces$peice1 != null) {
                    MutableBoundingBox MutableBoundingBox1 = structuremineshaftpieces$peice1.func_74874_b();
                    this.roomsLinkedToTheRoom.add(new MutableBoundingBox(MutableBoundingBox1.field_78897_a, MutableBoundingBox1.field_78895_b, this.field_74887_e.field_78892_f - 1, MutableBoundingBox1.field_78893_d, MutableBoundingBox1.field_78894_e, this.field_74887_e.field_78892_f));
                }
                i1 = l + 4;
            }
            int j1 = 0;
            while (j1 < this.field_74887_e.func_78880_d() && (l = j1 + rand.nextInt(this.field_74887_e.func_78880_d())) + 3 <= this.field_74887_e.func_78880_d()) {
                y = groundTunnel == 3 ? 1 : k;
                Piece structuremineshaftpieces$peice2 = MineshaftPiecesUA.generateAndAddPiece(componentIn, listIn, rand, this.field_74887_e.field_78897_a - 1, this.field_74887_e.field_78895_b + rand.nextInt(y) + 1, this.field_74887_e.field_78896_c + l, Direction.WEST, i);
                if (structuremineshaftpieces$peice2 != null) {
                    MutableBoundingBox MutableBoundingBox2 = structuremineshaftpieces$peice2.func_74874_b();
                    this.roomsLinkedToTheRoom.add(new MutableBoundingBox(this.field_74887_e.field_78897_a, MutableBoundingBox2.field_78895_b, MutableBoundingBox2.field_78896_c, this.field_74887_e.field_78897_a + 1, MutableBoundingBox2.field_78894_e, MutableBoundingBox2.field_78892_f));
                }
                j1 = l + 4;
            }
            int k1 = 0;
            while (k1 < this.field_74887_e.func_78880_d() && (l = k1 + rand.nextInt(this.field_74887_e.func_78880_d())) + 3 <= this.field_74887_e.func_78880_d()) {
                y = groundTunnel == 4 ? 1 : k;
                Piece StructurePiece2 = MineshaftPiecesUA.generateAndAddPiece(componentIn, listIn, rand, this.field_74887_e.field_78893_d + 1, this.field_74887_e.field_78895_b + rand.nextInt(y) + 1, this.field_74887_e.field_78896_c + l, Direction.EAST, i);
                if (StructurePiece2 != null) {
                    MutableBoundingBox MutableBoundingBox3 = StructurePiece2.func_74874_b();
                    this.roomsLinkedToTheRoom.add(new MutableBoundingBox(this.field_74887_e.field_78893_d - 1, MutableBoundingBox3.field_78895_b, MutableBoundingBox3.field_78896_c, this.field_74887_e.field_78893_d, MutableBoundingBox3.field_78894_e, MutableBoundingBox3.field_78892_f));
                }
                k1 = l + 4;
            }
        }

        public boolean func_74875_a(IWorld worldIn, Random randomIn, MutableBoundingBox MutableBoundingBoxIn, ChunkPos p_74875_4_) {
            BlockState flooring = this.mineShaftType == MineshaftUA.Type.HELL ? Blocks.field_150425_aM.func_176223_P() : Blocks.field_196660_k.func_176223_P();
            if (this.field_74887_e.func_78882_c() > 100) {
                this.func_175804_a(worldIn, MutableBoundingBoxIn, this.field_74887_e.field_78897_a - 10, this.field_74887_e.field_78895_b, this.field_74887_e.field_78896_c - 10, this.field_74887_e.field_78893_d + 7, this.field_74887_e.field_78895_b, this.field_74887_e.field_78892_f + 10, flooring, field_202556_l, false);
                this.func_175804_a(worldIn, MutableBoundingBoxIn, this.field_74887_e.field_78897_a - 3, this.field_74887_e.field_78895_b + 1, this.field_74887_e.field_78896_c - 3, this.field_74887_e.field_78893_d + 1, Math.min(this.field_74887_e.field_78895_b + 3, this.field_74887_e.field_78894_e), this.field_74887_e.field_78892_f + 3, field_202556_l, field_202556_l, false);
                for (MutableBoundingBox MutableBoundingBox2 : this.roomsLinkedToTheRoom) {
                    this.func_175804_a(worldIn, MutableBoundingBoxIn, MutableBoundingBox2.field_78897_a, MutableBoundingBox2.field_78894_e - 2, MutableBoundingBox2.field_78896_c, MutableBoundingBox2.field_78893_d, MutableBoundingBox2.field_78894_e, MutableBoundingBox2.field_78892_f, field_202556_l, field_202556_l, false);
                }
                this.func_180777_a(worldIn, MutableBoundingBoxIn, this.field_74887_e.field_78897_a - 3, this.field_74887_e.field_78895_b + 4, this.field_74887_e.field_78896_c - 3, this.field_74887_e.field_78893_d + 1, this.field_74887_e.field_78894_e, this.field_74887_e.field_78892_f + 3, field_202556_l, false);
                return true;
            }
            this.func_175804_a(worldIn, MutableBoundingBoxIn, this.field_74887_e.field_78897_a, this.field_74887_e.field_78895_b, this.field_74887_e.field_78896_c, this.field_74887_e.field_78893_d, this.field_74887_e.field_78895_b, this.field_74887_e.field_78892_f, flooring, field_202556_l, false);
            this.func_175804_a(worldIn, MutableBoundingBoxIn, this.field_74887_e.field_78897_a, this.field_74887_e.field_78895_b + 1, this.field_74887_e.field_78896_c, this.field_74887_e.field_78893_d, Math.min(this.field_74887_e.field_78895_b + 3, this.field_74887_e.field_78894_e), this.field_74887_e.field_78892_f, field_202556_l, field_202556_l, false);
            for (MutableBoundingBox MutableBoundingBox3 : this.roomsLinkedToTheRoom) {
                this.func_175804_a(worldIn, MutableBoundingBoxIn, MutableBoundingBox3.field_78897_a, MutableBoundingBox3.field_78894_e - 2, MutableBoundingBox3.field_78896_c, MutableBoundingBox3.field_78893_d, MutableBoundingBox3.field_78894_e, MutableBoundingBox3.field_78892_f, field_202556_l, field_202556_l, false);
            }
            this.func_180777_a(worldIn, MutableBoundingBoxIn, this.field_74887_e.field_78897_a, this.field_74887_e.field_78895_b + 4, this.field_74887_e.field_78896_c, this.field_74887_e.field_78893_d, this.field_74887_e.field_78894_e, this.field_74887_e.field_78892_f, field_202556_l, false);
            return true;
        }

        public void func_181138_a(int x, int y, int z) {
            super.func_181138_a(x, y, z);
            for (MutableBoundingBox MutableBoundingBox2 : this.roomsLinkedToTheRoom) {
                MutableBoundingBox2.func_78886_a(x, y, z);
            }
        }
    }

    static abstract class Piece
    extends StructurePiece {
        protected MineshaftUA.Type mineShaftType;

        public Piece(IStructurePieceType p_i50452_1_, int p_i50452_2_, MineshaftUA.Type p_i50452_3_) {
            super(p_i50452_1_, p_i50452_2_);
            this.mineShaftType = p_i50452_3_;
        }

        public Piece(IStructurePieceType p_i50453_1_, CompoundNBT p_i50453_2_) {
            super(p_i50453_1_, p_i50453_2_);
            this.mineShaftType = MineshaftUA.Type.byId(p_i50453_2_.func_74762_e("MST"));
        }

        protected void func_143011_b(CompoundNBT tagCompound) {
            tagCompound.func_74768_a("MST", this.mineShaftType.ordinal());
        }

        protected BlockState getArchBlock() {
            switch (this.mineShaftType) {
                case MESA: {
                    return (BlockState)Blocks.field_196623_P.func_176223_P().func_206870_a((IProperty)LogBlock.field_176298_M, (Comparable)Direction.Axis.X);
                }
                case ICEY: {
                    return Blocks.field_150403_cj.func_176223_P();
                }
                case COLDORBIRCH: {
                    return (BlockState)Blocks.field_203206_T.func_176223_P().func_206870_a((IProperty)LogBlock.field_176298_M, (Comparable)Direction.Axis.X);
                }
                case JUNGLE: {
                    return (BlockState)Blocks.field_196620_N.func_176223_P().func_206870_a((IProperty)LogBlock.field_176298_M, (Comparable)Direction.Axis.X);
                }
                case TAIGA: {
                    return (BlockState)Blocks.field_203205_S.func_176223_P().func_206870_a((IProperty)LogBlock.field_176298_M, (Comparable)Direction.Axis.X);
                }
                case DESERT: {
                    return Blocks.field_196583_aj.func_176223_P();
                }
                case END: {
                    return (BlockState)Blocks.field_185768_cU.func_176223_P().func_206870_a((IProperty)RotatedPillarBlock.field_176298_M, (Comparable)Direction.Axis.Z);
                }
                case HELL: {
                    return Blocks.field_196653_dH.func_176223_P();
                }
                case OCEAN: {
                    return Blocks.field_196781_gR.func_176223_P();
                }
                case STONE: {
                    return Blocks.field_150348_b.func_176223_P();
                }
                case SAVANNA: {
                    return (BlockState)Blocks.field_196621_O.func_176223_P().func_206870_a((IProperty)LogBlock.field_176298_M, (Comparable)Direction.Axis.X);
                }
                case SWAMPORDARKFOREST: {
                    return Blocks.field_196672_s.func_176223_P();
                }
            }
            return (BlockState)Blocks.field_203204_R.func_176223_P().func_206870_a((IProperty)LogBlock.field_176298_M, (Comparable)Direction.Axis.X);
        }

        protected BlockState getPlanksBlock() {
            switch (this.mineShaftType) {
                case MESA: {
                    return Blocks.field_196672_s.func_176223_P();
                }
                case ICEY: {
                    return Blocks.field_150432_aD.func_176223_P();
                }
                case COLDORBIRCH: {
                    return Blocks.field_196666_p.func_176223_P();
                }
                case JUNGLE: {
                    return Blocks.field_196668_q.func_176223_P();
                }
                case TAIGA: {
                    return Blocks.field_196664_o.func_176223_P();
                }
                case DESERT: {
                    return Blocks.field_196580_bH.func_176223_P();
                }
                case END: {
                    return Blocks.field_185767_cT.func_176223_P();
                }
                case HELL: {
                    return Blocks.field_196653_dH.func_176223_P();
                }
                case OCEAN: {
                    return Blocks.field_196779_gQ.func_176223_P();
                }
                case STONE: {
                    return Blocks.field_196656_g.func_176223_P();
                }
                case SAVANNA: {
                    return Blocks.field_196670_r.func_176223_P();
                }
                case SWAMPORDARKFOREST: {
                    return Blocks.field_196658_i.func_176223_P();
                }
            }
            return Blocks.field_196662_n.func_176223_P();
        }

        protected BlockState getFenceBlock() {
            switch (this.mineShaftType) {
                case MESA: {
                    return Blocks.field_180406_aS.func_176223_P();
                }
                case ICEY: {
                    return Blocks.field_150432_aD.func_176223_P();
                }
                case COLDORBIRCH: {
                    return Blocks.field_180404_aQ.func_176223_P();
                }
                case JUNGLE: {
                    return Blocks.field_180403_aR.func_176223_P();
                }
                case TAIGA: {
                    return Blocks.field_180408_aP.func_176223_P();
                }
                case DESERT: {
                    return Blocks.field_222417_lF.func_176223_P();
                }
                case END: {
                    return (BlockState)Blocks.field_185768_cU.func_176223_P().func_206870_a((IProperty)RotatedPillarBlock.field_176298_M, (Comparable)Direction.Axis.Y);
                }
                case HELL: {
                    return Blocks.field_222414_lC.func_176223_P();
                }
                case OCEAN: {
                    return Blocks.field_180397_cI.func_176223_P();
                }
                case STONE: {
                    return Blocks.field_150463_bK.func_176223_P();
                }
                case SAVANNA: {
                    return Blocks.field_180405_aT.func_176223_P();
                }
                case SWAMPORDARKFOREST: {
                    return (BlockState)Blocks.field_196623_P.func_176223_P().func_206870_a((IProperty)LogBlock.field_176298_M, (Comparable)Direction.Axis.Y);
                }
            }
            return Blocks.field_180407_aO.func_176223_P();
        }
    }

    public static class Cross
    extends Piece {
        private Direction corridorDirection;
        private boolean isMultipleFloors;

        public Cross(TemplateManager p_i50454_1_, CompoundNBT p_i50454_2_) {
            super(StructureInit.MSCROSSINGUA, p_i50454_2_);
            this.isMultipleFloors = p_i50454_2_.func_74767_n("tf");
            this.corridorDirection = Direction.func_176731_b((int)p_i50454_2_.func_74762_e("D"));
        }

        @Override
        protected void func_143011_b(CompoundNBT tagCompound) {
            super.func_143011_b(tagCompound);
            tagCompound.func_74757_a("tf", this.isMultipleFloors);
            tagCompound.func_74768_a("D", this.corridorDirection.func_176736_b());
        }

        public Cross(int p_i50455_1_, MutableBoundingBox p_i50455_2_, @Nullable Direction p_i50455_3_, MineshaftUA.Type p_i50455_4_) {
            super(StructureInit.MSCROSSINGUA, p_i50455_1_, p_i50455_4_);
            this.corridorDirection = p_i50455_3_;
            this.field_74887_e = p_i50455_2_;
            this.isMultipleFloors = p_i50455_2_.func_78882_c() > 3;
        }

        public static MutableBoundingBox findCrossing(List<StructurePiece> listIn, Random rand, int x, int y, int z, Direction facing) {
            MutableBoundingBox MutableBoundingBox2 = new MutableBoundingBox(x, y, z, x, y + 2, z);
            if (rand.nextInt(4) == 0) {
                MutableBoundingBox2.field_78894_e += 4;
            }
            switch (facing) {
                default: {
                    MutableBoundingBox2.field_78897_a = x - 1;
                    MutableBoundingBox2.field_78893_d = x + 3;
                    MutableBoundingBox2.field_78896_c = z - 4;
                    break;
                }
                case SOUTH: {
                    MutableBoundingBox2.field_78897_a = x - 1;
                    MutableBoundingBox2.field_78893_d = x + 3;
                    MutableBoundingBox2.field_78892_f = z + 3 + 1;
                    break;
                }
                case WEST: {
                    MutableBoundingBox2.field_78897_a = x - 4;
                    MutableBoundingBox2.field_78896_c = z - 1;
                    MutableBoundingBox2.field_78892_f = z + 3;
                    break;
                }
                case EAST: {
                    MutableBoundingBox2.field_78893_d = x + 3 + 1;
                    MutableBoundingBox2.field_78896_c = z - 1;
                    MutableBoundingBox2.field_78892_f = z + 3;
                }
            }
            return StructurePiece.func_74883_a(listIn, (MutableBoundingBox)MutableBoundingBox2) != null ? null : MutableBoundingBox2;
        }

        public void func_74861_a(StructurePiece componentIn, List<StructurePiece> listIn, Random rand) {
            int i = this.func_74877_c();
            switch (this.corridorDirection) {
                default: {
                    MineshaftPiecesUA.generateAndAddPiece(componentIn, listIn, rand, this.field_74887_e.field_78897_a + 1, this.field_74887_e.field_78895_b, this.field_74887_e.field_78896_c - 1, Direction.NORTH, i);
                    MineshaftPiecesUA.generateAndAddPiece(componentIn, listIn, rand, this.field_74887_e.field_78897_a - 1, this.field_74887_e.field_78895_b, this.field_74887_e.field_78896_c + 1, Direction.WEST, i);
                    MineshaftPiecesUA.generateAndAddPiece(componentIn, listIn, rand, this.field_74887_e.field_78893_d + 1, this.field_74887_e.field_78895_b, this.field_74887_e.field_78896_c + 1, Direction.EAST, i);
                    break;
                }
                case SOUTH: {
                    MineshaftPiecesUA.generateAndAddPiece(componentIn, listIn, rand, this.field_74887_e.field_78897_a + 1, this.field_74887_e.field_78895_b, this.field_74887_e.field_78892_f + 1, Direction.SOUTH, i);
                    MineshaftPiecesUA.generateAndAddPiece(componentIn, listIn, rand, this.field_74887_e.field_78897_a - 1, this.field_74887_e.field_78895_b, this.field_74887_e.field_78896_c + 1, Direction.WEST, i);
                    MineshaftPiecesUA.generateAndAddPiece(componentIn, listIn, rand, this.field_74887_e.field_78893_d + 1, this.field_74887_e.field_78895_b, this.field_74887_e.field_78896_c + 1, Direction.EAST, i);
                    break;
                }
                case WEST: {
                    MineshaftPiecesUA.generateAndAddPiece(componentIn, listIn, rand, this.field_74887_e.field_78897_a + 1, this.field_74887_e.field_78895_b, this.field_74887_e.field_78896_c - 1, Direction.NORTH, i);
                    MineshaftPiecesUA.generateAndAddPiece(componentIn, listIn, rand, this.field_74887_e.field_78897_a + 1, this.field_74887_e.field_78895_b, this.field_74887_e.field_78892_f + 1, Direction.SOUTH, i);
                    MineshaftPiecesUA.generateAndAddPiece(componentIn, listIn, rand, this.field_74887_e.field_78897_a - 1, this.field_74887_e.field_78895_b, this.field_74887_e.field_78896_c + 1, Direction.WEST, i);
                    break;
                }
                case EAST: {
                    MineshaftPiecesUA.generateAndAddPiece(componentIn, listIn, rand, this.field_74887_e.field_78897_a + 1, this.field_74887_e.field_78895_b, this.field_74887_e.field_78896_c - 1, Direction.NORTH, i);
                    MineshaftPiecesUA.generateAndAddPiece(componentIn, listIn, rand, this.field_74887_e.field_78897_a + 1, this.field_74887_e.field_78895_b, this.field_74887_e.field_78892_f + 1, Direction.SOUTH, i);
                    MineshaftPiecesUA.generateAndAddPiece(componentIn, listIn, rand, this.field_74887_e.field_78893_d + 1, this.field_74887_e.field_78895_b, this.field_74887_e.field_78896_c + 1, Direction.EAST, i);
                }
            }
            if (this.isMultipleFloors) {
                if (rand.nextBoolean()) {
                    MineshaftPiecesUA.generateAndAddPiece(componentIn, listIn, rand, this.field_74887_e.field_78897_a + 1, this.field_74887_e.field_78895_b + 3 + 1, this.field_74887_e.field_78896_c - 1, Direction.NORTH, i);
                }
                if (rand.nextBoolean()) {
                    MineshaftPiecesUA.generateAndAddPiece(componentIn, listIn, rand, this.field_74887_e.field_78897_a - 1, this.field_74887_e.field_78895_b + 3 + 1, this.field_74887_e.field_78896_c + 1, Direction.WEST, i);
                }
                if (rand.nextBoolean()) {
                    MineshaftPiecesUA.generateAndAddPiece(componentIn, listIn, rand, this.field_74887_e.field_78893_d + 1, this.field_74887_e.field_78895_b + 3 + 1, this.field_74887_e.field_78896_c + 1, Direction.EAST, i);
                }
                if (rand.nextBoolean()) {
                    MineshaftPiecesUA.generateAndAddPiece(componentIn, listIn, rand, this.field_74887_e.field_78897_a + 1, this.field_74887_e.field_78895_b + 3 + 1, this.field_74887_e.field_78892_f + 1, Direction.SOUTH, i);
                }
            }
        }

        public boolean func_74875_a(IWorld worldIn, Random randomIn, MutableBoundingBox MutableBoundingBoxIn, ChunkPos p_74875_4_) {
            if (this.func_74860_a((IBlockReader)worldIn, MutableBoundingBoxIn)) {
                return false;
            }
            BlockState iblockstate = this.getPlanksBlock();
            if (this.isMultipleFloors) {
                this.func_175804_a(worldIn, MutableBoundingBoxIn, this.field_74887_e.field_78897_a + 1, this.field_74887_e.field_78895_b, this.field_74887_e.field_78896_c, this.field_74887_e.field_78893_d - 1, this.field_74887_e.field_78895_b + 3 - 1, this.field_74887_e.field_78892_f, field_202556_l, field_202556_l, false);
                this.func_175804_a(worldIn, MutableBoundingBoxIn, this.field_74887_e.field_78897_a, this.field_74887_e.field_78895_b, this.field_74887_e.field_78896_c + 1, this.field_74887_e.field_78893_d, this.field_74887_e.field_78895_b + 3 - 1, this.field_74887_e.field_78892_f - 1, field_202556_l, field_202556_l, false);
                this.func_175804_a(worldIn, MutableBoundingBoxIn, this.field_74887_e.field_78897_a + 1, this.field_74887_e.field_78894_e - 2, this.field_74887_e.field_78896_c, this.field_74887_e.field_78893_d - 1, this.field_74887_e.field_78894_e, this.field_74887_e.field_78892_f, field_202556_l, field_202556_l, false);
                this.func_175804_a(worldIn, MutableBoundingBoxIn, this.field_74887_e.field_78897_a, this.field_74887_e.field_78894_e - 2, this.field_74887_e.field_78896_c + 1, this.field_74887_e.field_78893_d, this.field_74887_e.field_78894_e, this.field_74887_e.field_78892_f - 1, field_202556_l, field_202556_l, false);
                this.func_175804_a(worldIn, MutableBoundingBoxIn, this.field_74887_e.field_78897_a + 1, this.field_74887_e.field_78895_b + 3, this.field_74887_e.field_78896_c + 1, this.field_74887_e.field_78893_d - 1, this.field_74887_e.field_78895_b + 3, this.field_74887_e.field_78892_f - 1, field_202556_l, field_202556_l, false);
            } else {
                this.func_175804_a(worldIn, MutableBoundingBoxIn, this.field_74887_e.field_78897_a + 1, this.field_74887_e.field_78895_b, this.field_74887_e.field_78896_c, this.field_74887_e.field_78893_d - 1, this.field_74887_e.field_78894_e, this.field_74887_e.field_78892_f, field_202556_l, field_202556_l, false);
                this.func_175804_a(worldIn, MutableBoundingBoxIn, this.field_74887_e.field_78897_a, this.field_74887_e.field_78895_b, this.field_74887_e.field_78896_c + 1, this.field_74887_e.field_78893_d, this.field_74887_e.field_78894_e, this.field_74887_e.field_78892_f - 1, field_202556_l, field_202556_l, false);
            }
            this.placeSupportPillar(worldIn, MutableBoundingBoxIn, this.field_74887_e.field_78897_a + 1, this.field_74887_e.field_78895_b, this.field_74887_e.field_78896_c + 1, this.field_74887_e.field_78894_e);
            this.placeSupportPillar(worldIn, MutableBoundingBoxIn, this.field_74887_e.field_78897_a + 1, this.field_74887_e.field_78895_b, this.field_74887_e.field_78892_f - 1, this.field_74887_e.field_78894_e);
            this.placeSupportPillar(worldIn, MutableBoundingBoxIn, this.field_74887_e.field_78893_d - 1, this.field_74887_e.field_78895_b, this.field_74887_e.field_78896_c + 1, this.field_74887_e.field_78894_e);
            this.placeSupportPillar(worldIn, MutableBoundingBoxIn, this.field_74887_e.field_78893_d - 1, this.field_74887_e.field_78895_b, this.field_74887_e.field_78892_f - 1, this.field_74887_e.field_78894_e);
            for (int i = this.field_74887_e.field_78897_a; i <= this.field_74887_e.field_78893_d; ++i) {
                for (int j = this.field_74887_e.field_78896_c; j <= this.field_74887_e.field_78892_f; ++j) {
                    if (this.func_175807_a((IBlockReader)worldIn, i, this.field_74887_e.field_78895_b - 1, j, MutableBoundingBoxIn).func_185904_a() != Material.field_151579_a || !this.func_189916_b((IWorldReader)worldIn, i, this.field_74887_e.field_78895_b - 1, j, MutableBoundingBoxIn)) continue;
                    this.func_175811_a(worldIn, iblockstate, i, this.field_74887_e.field_78895_b - 1, j, MutableBoundingBoxIn);
                }
            }
            return true;
        }

        private void placeSupportPillar(IWorld p_189923_1_, MutableBoundingBox p_189923_2_, int p_189923_3_, int p_189923_4_, int p_189923_5_, int p_189923_6_) {
            if (this.func_175807_a((IBlockReader)p_189923_1_, p_189923_3_, p_189923_6_ + 1, p_189923_5_, p_189923_2_).func_185904_a() != Material.field_151579_a) {
                this.func_175804_a(p_189923_1_, p_189923_2_, p_189923_3_, p_189923_4_, p_189923_5_, p_189923_3_, p_189923_6_, p_189923_5_, this.getPlanksBlock(), field_202556_l, false);
            }
        }
    }

    public static class Corridor
    extends Piece {
        private boolean hasRails;
        private boolean hasSpiders;
        private boolean spawnerPlaced;
        private int sectionCount;

        public Corridor(TemplateManager p_i50456_1_, CompoundNBT p_i50456_2_) {
            super(StructureInit.MSCORRIDORUA, p_i50456_2_);
            this.hasRails = p_i50456_2_.func_74767_n("hr");
            this.hasSpiders = p_i50456_2_.func_74767_n("sc");
            this.spawnerPlaced = p_i50456_2_.func_74767_n("hps");
            this.sectionCount = p_i50456_2_.func_74762_e("Num");
        }

        @Override
        protected void func_143011_b(CompoundNBT tagCompound) {
            super.func_143011_b(tagCompound);
            tagCompound.func_74757_a("hr", this.hasRails);
            tagCompound.func_74757_a("sc", this.hasSpiders);
            tagCompound.func_74757_a("hps", this.spawnerPlaced);
            tagCompound.func_74768_a("Num", this.sectionCount);
        }

        public Corridor(int p_i47140_1_, Random p_i47140_2_, MutableBoundingBox p_i47140_3_, Direction p_i47140_4_, MineshaftUA.Type p_i47140_5_) {
            super(StructureInit.MSCORRIDORUA, p_i47140_1_, p_i47140_5_);
            this.func_186164_a(p_i47140_4_);
            this.field_74887_e = p_i47140_3_;
            this.hasRails = p_i47140_2_.nextInt(3) == 0;
            this.hasSpiders = !this.hasRails && p_i47140_2_.nextInt(23) == 0;
            this.sectionCount = this.func_186165_e().func_176740_k() == Direction.Axis.Z ? p_i47140_3_.func_78880_d() / 5 : p_i47140_3_.func_78883_b() / 5;
        }

        public static MutableBoundingBox findCorridorSize(List<StructurePiece> p_175814_0_, Random rand, int x, int y, int z, Direction facing) {
            int i;
            MutableBoundingBox MutableBoundingBox2 = new MutableBoundingBox(x, y, z, x, y + 2, z);
            for (i = rand.nextInt(3) + 2; i > 0; --i) {
                int j = i * 5;
                switch (facing) {
                    default: {
                        MutableBoundingBox2.field_78893_d = x + 2;
                        MutableBoundingBox2.field_78896_c = z - (j - 1);
                        break;
                    }
                    case SOUTH: {
                        MutableBoundingBox2.field_78893_d = x + 2;
                        MutableBoundingBox2.field_78892_f = z + (j - 1);
                        break;
                    }
                    case WEST: {
                        MutableBoundingBox2.field_78897_a = x - (j - 1);
                        MutableBoundingBox2.field_78892_f = z + 2;
                        break;
                    }
                    case EAST: {
                        MutableBoundingBox2.field_78893_d = x + (j - 1);
                        MutableBoundingBox2.field_78892_f = z + 2;
                    }
                }
                if (StructurePiece.func_74883_a(p_175814_0_, (MutableBoundingBox)MutableBoundingBox2) == null) break;
            }
            return i > 0 ? MutableBoundingBox2 : null;
        }

        public void func_74861_a(StructurePiece componentIn, List<StructurePiece> listIn, Random rand) {
            block24: {
                int i = this.func_74877_c();
                int j = rand.nextInt(4);
                Direction enumfacing = this.func_186165_e();
                if (enumfacing != null) {
                    switch (enumfacing) {
                        default: {
                            if (j <= 1) {
                                MineshaftPiecesUA.generateAndAddPiece(componentIn, listIn, rand, this.field_74887_e.field_78897_a, this.field_74887_e.field_78895_b - 1 + rand.nextInt(3), this.field_74887_e.field_78896_c - 1, enumfacing, i);
                                break;
                            }
                            if (j == 2) {
                                MineshaftPiecesUA.generateAndAddPiece(componentIn, listIn, rand, this.field_74887_e.field_78897_a - 1, this.field_74887_e.field_78895_b - 1 + rand.nextInt(3), this.field_74887_e.field_78896_c, Direction.WEST, i);
                                break;
                            }
                            MineshaftPiecesUA.generateAndAddPiece(componentIn, listIn, rand, this.field_74887_e.field_78893_d + 1, this.field_74887_e.field_78895_b - 1 + rand.nextInt(3), this.field_74887_e.field_78896_c, Direction.EAST, i);
                            break;
                        }
                        case SOUTH: {
                            if (j <= 1) {
                                MineshaftPiecesUA.generateAndAddPiece(componentIn, listIn, rand, this.field_74887_e.field_78897_a, this.field_74887_e.field_78895_b - 1 + rand.nextInt(3), this.field_74887_e.field_78892_f + 1, enumfacing, i);
                                break;
                            }
                            if (j == 2) {
                                MineshaftPiecesUA.generateAndAddPiece(componentIn, listIn, rand, this.field_74887_e.field_78897_a - 1, this.field_74887_e.field_78895_b - 1 + rand.nextInt(3), this.field_74887_e.field_78892_f - 3, Direction.WEST, i);
                                break;
                            }
                            MineshaftPiecesUA.generateAndAddPiece(componentIn, listIn, rand, this.field_74887_e.field_78893_d + 1, this.field_74887_e.field_78895_b - 1 + rand.nextInt(3), this.field_74887_e.field_78892_f - 3, Direction.EAST, i);
                            break;
                        }
                        case WEST: {
                            if (j <= 1) {
                                MineshaftPiecesUA.generateAndAddPiece(componentIn, listIn, rand, this.field_74887_e.field_78897_a - 1, this.field_74887_e.field_78895_b - 1 + rand.nextInt(3), this.field_74887_e.field_78896_c, enumfacing, i);
                                break;
                            }
                            if (j == 2) {
                                MineshaftPiecesUA.generateAndAddPiece(componentIn, listIn, rand, this.field_74887_e.field_78897_a, this.field_74887_e.field_78895_b - 1 + rand.nextInt(3), this.field_74887_e.field_78896_c - 1, Direction.NORTH, i);
                                break;
                            }
                            MineshaftPiecesUA.generateAndAddPiece(componentIn, listIn, rand, this.field_74887_e.field_78897_a, this.field_74887_e.field_78895_b - 1 + rand.nextInt(3), this.field_74887_e.field_78892_f + 1, Direction.SOUTH, i);
                            break;
                        }
                        case EAST: {
                            if (j <= 1) {
                                MineshaftPiecesUA.generateAndAddPiece(componentIn, listIn, rand, this.field_74887_e.field_78893_d + 1, this.field_74887_e.field_78895_b - 1 + rand.nextInt(3), this.field_74887_e.field_78896_c, enumfacing, i);
                                break;
                            }
                            if (j == 2) {
                                MineshaftPiecesUA.generateAndAddPiece(componentIn, listIn, rand, this.field_74887_e.field_78893_d - 3, this.field_74887_e.field_78895_b - 1 + rand.nextInt(3), this.field_74887_e.field_78896_c - 1, Direction.NORTH, i);
                                break;
                            }
                            MineshaftPiecesUA.generateAndAddPiece(componentIn, listIn, rand, this.field_74887_e.field_78893_d - 3, this.field_74887_e.field_78895_b - 1 + rand.nextInt(3), this.field_74887_e.field_78892_f + 1, Direction.SOUTH, i);
                        }
                    }
                }
                if (i >= 8) break block24;
                if (enumfacing != Direction.NORTH && enumfacing != Direction.SOUTH) {
                    int i1 = this.field_74887_e.field_78897_a + 3;
                    while (i1 + 3 <= this.field_74887_e.field_78893_d) {
                        int j1 = rand.nextInt(5);
                        if (j1 == 0) {
                            MineshaftPiecesUA.generateAndAddPiece(componentIn, listIn, rand, i1, this.field_74887_e.field_78895_b, this.field_74887_e.field_78896_c - 1, Direction.NORTH, i + 1);
                        } else if (j1 == 1) {
                            MineshaftPiecesUA.generateAndAddPiece(componentIn, listIn, rand, i1, this.field_74887_e.field_78895_b, this.field_74887_e.field_78892_f + 1, Direction.SOUTH, i + 1);
                        }
                        i1 += 5;
                    }
                } else {
                    int k = this.field_74887_e.field_78896_c + 3;
                    while (k + 3 <= this.field_74887_e.field_78892_f) {
                        int l = rand.nextInt(5);
                        if (l == 0) {
                            MineshaftPiecesUA.generateAndAddPiece(componentIn, listIn, rand, this.field_74887_e.field_78897_a - 1, this.field_74887_e.field_78895_b, k, Direction.WEST, i + 1);
                        } else if (l == 1) {
                            MineshaftPiecesUA.generateAndAddPiece(componentIn, listIn, rand, this.field_74887_e.field_78893_d + 1, this.field_74887_e.field_78895_b, k, Direction.EAST, i + 1);
                        }
                        k += 5;
                    }
                }
            }
        }

        protected boolean func_186167_a(IWorld worldIn, MutableBoundingBox structurebb, Random randomIn, int x, int y, int z, ResourceLocation loot) {
            BlockPos blockpos = new BlockPos(this.func_74865_a(x, z), this.func_74862_a(y), this.func_74873_b(x, z));
            if (structurebb.func_175898_b((Vec3i)blockpos) && worldIn.func_180495_p(blockpos).func_185904_a() == Material.field_151579_a) {
                BlockState iblockstate = (BlockState)Blocks.field_150448_aq.func_176223_P().func_206870_a((IProperty)RailBlock.field_176565_b, (Comparable)(randomIn.nextBoolean() ? RailShape.NORTH_SOUTH : RailShape.EAST_WEST));
                this.func_175811_a(worldIn, iblockstate, x, y, z, structurebb);
                ChestMinecartEntity entityminecartchest = new ChestMinecartEntity(worldIn.func_201672_e(), (double)((float)blockpos.func_177958_n() + 0.5f), (double)((float)blockpos.func_177956_o() + 0.5f), (double)((float)blockpos.func_177952_p() + 0.5f));
                entityminecartchest.func_184289_a(loot, randomIn.nextLong());
                worldIn.func_217376_c((Entity)entityminecartchest);
                return true;
            }
            return false;
        }

        public boolean func_74875_a(IWorld worldIn, Random randomIn, MutableBoundingBox MutableBoundingBoxIn, ChunkPos p_74875_4_) {
            if (this.func_74860_a((IBlockReader)worldIn, MutableBoundingBoxIn)) {
                return false;
            }
            int i1 = this.sectionCount * 5 - 1;
            BlockState iblockstate = this.getPlanksBlock();
            this.func_175804_a(worldIn, MutableBoundingBoxIn, 0, 0, 0, 2, 1, i1, field_202556_l, field_202556_l, false);
            this.func_189914_a(worldIn, MutableBoundingBoxIn, randomIn, 0.8f, 0, 2, 0, 2, 2, i1, field_202556_l, field_202556_l, false, false);
            if (this.hasSpiders) {
                this.func_189914_a(worldIn, MutableBoundingBoxIn, randomIn, 0.6f, 0, 0, 0, 2, 1, i1, Blocks.field_196553_aF.func_176223_P(), field_202556_l, false, true);
            }
            for (int j1 = 0; j1 < this.sectionCount; ++j1) {
                int k2;
                int k1 = 2 + j1 * 5;
                this.placeSupport(worldIn, MutableBoundingBoxIn, 0, 0, k1, 2, 2, randomIn);
                this.placeCobWeb(worldIn, MutableBoundingBoxIn, randomIn, 0.1f, 0, 2, k1 - 1);
                this.placeCobWeb(worldIn, MutableBoundingBoxIn, randomIn, 0.1f, 2, 2, k1 - 1);
                this.placeCobWeb(worldIn, MutableBoundingBoxIn, randomIn, 0.1f, 0, 2, k1 + 1);
                this.placeCobWeb(worldIn, MutableBoundingBoxIn, randomIn, 0.1f, 2, 2, k1 + 1);
                this.placeCobWeb(worldIn, MutableBoundingBoxIn, randomIn, 0.05f, 0, 2, k1 - 2);
                this.placeCobWeb(worldIn, MutableBoundingBoxIn, randomIn, 0.05f, 2, 2, k1 - 2);
                this.placeCobWeb(worldIn, MutableBoundingBoxIn, randomIn, 0.05f, 0, 2, k1 + 2);
                this.placeCobWeb(worldIn, MutableBoundingBoxIn, randomIn, 0.05f, 2, 2, k1 + 2);
                if (ConfigUA.chestGeneration) {
                    if (randomIn.nextInt(50) == 0) {
                        this.func_186167_a(worldIn, MutableBoundingBoxIn, randomIn, 2, 0, k1 - 1, LootTables.field_186424_f);
                    }
                    if (randomIn.nextInt(50) == 0) {
                        this.func_186167_a(worldIn, MutableBoundingBoxIn, randomIn, 0, 0, k1 + 1, LootTables.field_186424_f);
                    }
                }
                if (!this.hasSpiders || this.spawnerPlaced) continue;
                int l1 = this.func_74862_a(0);
                int i2 = k1 - 1 + randomIn.nextInt(3);
                int j2 = this.func_74865_a(1, i2);
                BlockPos blockpos = new BlockPos(j2, l1, k2 = this.func_74873_b(1, i2));
                if (!MutableBoundingBoxIn.func_175898_b((Vec3i)blockpos) || !this.func_189916_b((IWorldReader)worldIn, 1, 0, i2, MutableBoundingBoxIn)) continue;
                this.spawnerPlaced = true;
                worldIn.func_180501_a(blockpos, Blocks.field_150474_ac.func_176223_P(), 2);
                TileEntity tileentity = worldIn.func_175625_s(blockpos);
                if (!(tileentity instanceof MobSpawnerTileEntity)) continue;
                ((MobSpawnerTileEntity)tileentity).func_145881_a().func_200876_a(EntityType.field_200794_h);
            }
            for (int l2 = 0; l2 <= 2; ++l2) {
                for (int i3 = 0; i3 <= i1; ++i3) {
                    BlockState iblockstate3 = this.func_175807_a((IBlockReader)worldIn, l2, -1, i3, MutableBoundingBoxIn);
                    if (iblockstate3.func_185904_a() != Material.field_151579_a) continue;
                    this.func_175811_a(worldIn, iblockstate, l2, -1, i3, MutableBoundingBoxIn);
                }
            }
            if (this.hasRails) {
                BlockState iblockstate1 = (BlockState)Blocks.field_150448_aq.func_176223_P().func_206870_a((IProperty)RailBlock.field_176565_b, (Comparable)RailShape.NORTH_SOUTH);
                for (int j3 = 0; j3 <= i1; ++j3) {
                    BlockState iblockstate2 = this.func_175807_a((IBlockReader)worldIn, 1, -1, j3, MutableBoundingBoxIn);
                    if (iblockstate2.func_185904_a() == Material.field_151579_a) continue;
                    float f = this.func_189916_b((IWorldReader)worldIn, 1, 0, j3, MutableBoundingBoxIn) ? 0.7f : 0.9f;
                    this.func_175809_a(worldIn, MutableBoundingBoxIn, randomIn, f, 1, 0, j3, iblockstate1);
                }
            }
            return true;
        }

        private void placeSupport(IWorld worldIn, MutableBoundingBox boundingBox, int x, int y2, int z, int y, int x2, Random random) {
            BlockState iblockstate = this.getArchBlock();
            BlockState iblockstate1 = this.getFenceBlock();
            BlockState iblockstate2 = field_202556_l;
            this.func_175804_a(worldIn, boundingBox, x, y2, z, x, y - 1, z, iblockstate1, iblockstate2, false);
            this.func_175804_a(worldIn, boundingBox, x2, y2, z, x2, y - 1, z, iblockstate1, iblockstate2, false);
            this.func_175804_a(worldIn, boundingBox, x, y, z, x2, y, z, iblockstate, iblockstate2, false);
            if (this.mineShaftType == MineshaftUA.Type.END) {
                if (random.nextFloat() < 0.08f) {
                    this.func_175809_a(worldIn, boundingBox, random, 1.0f, x, y, z - 1, (BlockState)Blocks.field_185764_cQ.func_176223_P().func_206870_a((IProperty)EndRodBlock.field_176387_N, (Comparable)Direction.SOUTH));
                    this.func_175809_a(worldIn, boundingBox, random, 1.0f, x, y, z + 1, (BlockState)Blocks.field_185764_cQ.func_176223_P().func_206870_a((IProperty)EndRodBlock.field_176387_N, (Comparable)Direction.NORTH));
                }
                if (random.nextFloat() < 0.08f) {
                    this.func_175809_a(worldIn, boundingBox, random, 1.0f, x + 2, y, z - 1, (BlockState)Blocks.field_185764_cQ.func_176223_P().func_206870_a((IProperty)EndRodBlock.field_176387_N, (Comparable)Direction.SOUTH));
                    this.func_175809_a(worldIn, boundingBox, random, 1.0f, x + 2, y, z + 1, (BlockState)Blocks.field_185764_cQ.func_176223_P().func_206870_a((IProperty)EndRodBlock.field_176387_N, (Comparable)Direction.NORTH));
                }
            } else if (this.mineShaftType == MineshaftUA.Type.HELL) {
                this.func_175809_a(worldIn, boundingBox, random, 0.1f, x + 1, y, z, Blocks.field_150379_bu.func_176223_P());
                this.func_175809_a(worldIn, boundingBox, random, 0.1f, x + 1, y, z - 1, (BlockState)Blocks.field_196677_cy.func_176223_P().func_206870_a((IProperty)WallTorchBlock.field_196532_a, (Comparable)Direction.SOUTH));
                this.func_175809_a(worldIn, boundingBox, random, 0.1f, x + 1, y, z + 1, (BlockState)Blocks.field_196677_cy.func_176223_P().func_206870_a((IProperty)WallTorchBlock.field_196532_a, (Comparable)Direction.NORTH));
            } else if (this.mineShaftType == MineshaftUA.Type.OCEAN) {
                this.func_175809_a(worldIn, boundingBox, random, 0.2f, x + 1, y, z, Blocks.field_180398_cJ.func_176223_P());
            } else if (this.mineShaftType == MineshaftUA.Type.ICEY) {
                this.func_175809_a(worldIn, boundingBox, random, 0.08f, x + 1, y, z - 1, (BlockState)Blocks.field_196677_cy.func_176223_P().func_206870_a((IProperty)WallTorchBlock.field_196532_a, (Comparable)Direction.SOUTH));
                this.func_175809_a(worldIn, boundingBox, random, 0.08f, x + 1, y, z + 1, (BlockState)Blocks.field_196677_cy.func_176223_P().func_206870_a((IProperty)WallTorchBlock.field_196532_a, (Comparable)Direction.NORTH));
            } else {
                this.func_175809_a(worldIn, boundingBox, random, 0.08f, x + 1, y, z - 1, (BlockState)Blocks.field_196591_bQ.func_176223_P().func_206870_a((IProperty)WallTorchBlock.field_196532_a, (Comparable)Direction.SOUTH));
                this.func_175809_a(worldIn, boundingBox, random, 0.08f, x + 1, y, z + 1, (BlockState)Blocks.field_196591_bQ.func_176223_P().func_206870_a((IProperty)WallTorchBlock.field_196532_a, (Comparable)Direction.NORTH));
            }
        }

        private void placeCobWeb(IWorld p_189922_1_, MutableBoundingBox p_189922_2_, Random p_189922_3_, float p_189922_4_, int p_189922_5_, int p_189922_6_, int p_189922_7_) {
            if (this.func_189916_b((IWorldReader)p_189922_1_, p_189922_5_, p_189922_6_, p_189922_7_, p_189922_2_)) {
                this.func_175809_a(p_189922_1_, p_189922_2_, p_189922_3_, p_189922_4_, p_189922_5_, p_189922_6_, p_189922_7_, Blocks.field_196553_aF.func_176223_P());
            }
        }
    }
}

