/*
 * Decompiled with CFR 0.152.
 */
package net.telepathicgrunt.ultraamplified.world.feature.structure;

import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import net.minecraft.block.Blocks;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.ChestTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Mirror;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IWorld;
import net.minecraft.world.gen.Heightmap;
import net.minecraft.world.gen.feature.structure.StructurePiece;
import net.minecraft.world.gen.feature.structure.TemplateStructurePiece;
import net.minecraft.world.gen.feature.template.PlacementSettings;
import net.minecraft.world.gen.feature.template.Template;
import net.minecraft.world.gen.feature.template.TemplateManager;
import net.minecraft.world.storage.loot.LootTables;
import net.telepathicgrunt.ultraamplified.config.ConfigUA;
import net.telepathicgrunt.ultraamplified.world.feature.structure.StructureInit;

public class IglooPiecesUA {
    private static final ResourceLocation IGLOO_TOP = new ResourceLocation("igloo/top");
    private static final ResourceLocation IGLOO_MIDDLE = new ResourceLocation("igloo/middle");
    private static final ResourceLocation IGLOO_BOTTOM = new ResourceLocation("igloo/bottom");
    private static final Map<ResourceLocation, BlockPos> OFFSET1 = ImmutableMap.of((Object)IGLOO_TOP, (Object)new BlockPos(3, 5, 5), (Object)IGLOO_MIDDLE, (Object)new BlockPos(1, 3, 1), (Object)IGLOO_BOTTOM, (Object)new BlockPos(3, 6, 7));
    private static final Map<ResourceLocation, BlockPos> OFFSET2 = ImmutableMap.of((Object)IGLOO_TOP, (Object)new BlockPos(0, 0, 0), (Object)IGLOO_MIDDLE, (Object)new BlockPos(2, -3, 4), (Object)IGLOO_BOTTOM, (Object)new BlockPos(0, -3, -2));

    public static void start(TemplateManager p_207617_0_, BlockPos p_207617_1_, Rotation p_207617_2_, List<StructurePiece> p_207617_3_, Random p_207617_4_) {
        int i = p_207617_4_.nextInt(8) + 4;
        p_207617_3_.add((StructurePiece)new Piece(p_207617_0_, IGLOO_BOTTOM, p_207617_1_, p_207617_2_, i * 3));
        for (int j = 0; j < i - 1; ++j) {
            p_207617_3_.add((StructurePiece)new Piece(p_207617_0_, IGLOO_MIDDLE, p_207617_1_, p_207617_2_, j * 3));
        }
        p_207617_3_.add((StructurePiece)new Piece(p_207617_0_, IGLOO_TOP, p_207617_1_, p_207617_2_, 0));
    }

    public static class Piece
    extends TemplateStructurePiece {
        private ResourceLocation resourceLocation;
        private Rotation rotation;

        public Piece(TemplateManager templateManager, ResourceLocation resourceLocation, BlockPos pos, Rotation rotation, int downDepth) {
            super(StructureInit.IGLUUA, 0);
            this.resourceLocation = resourceLocation;
            BlockPos blockpos = (BlockPos)OFFSET2.get(resourceLocation);
            this.field_186178_c = pos.func_177982_a(blockpos.func_177958_n(), blockpos.func_177956_o() - downDepth, blockpos.func_177952_p());
            this.rotation = rotation;
            this.setupPiece(templateManager);
        }

        public Piece(TemplateManager p_i50566_1_, CompoundNBT p_i50566_2_) {
            super(StructureInit.IGLUUA, p_i50566_2_);
            this.resourceLocation = new ResourceLocation(p_i50566_2_.func_74779_i("Template"));
            this.rotation = Rotation.valueOf((String)p_i50566_2_.func_74779_i("Rot"));
            this.setupPiece(p_i50566_1_);
        }

        private void setupPiece(TemplateManager templateManager) {
            Template template = templateManager.func_200220_a(this.resourceLocation);
            PlacementSettings placementsettings = new PlacementSettings().func_186220_a(this.rotation).func_186214_a(Mirror.NONE).func_207665_a((BlockPos)OFFSET1.get(this.resourceLocation));
            this.func_186173_a(template, this.field_186178_c, placementsettings);
        }

        protected void func_143011_b(CompoundNBT tagCompound) {
            super.func_143011_b(tagCompound);
            tagCompound.func_74778_a("Template", this.resourceLocation.toString());
            tagCompound.func_74778_a("Rot", this.rotation.name());
        }

        protected void func_186175_a(String function, BlockPos pos, IWorld worldIn, Random rand, MutableBoundingBox sbb) {
            if ("chest".equals(function)) {
                worldIn.func_180501_a(pos, Blocks.field_150350_a.func_176223_P(), 3);
                TileEntity tileentity = worldIn.func_175625_s(pos.func_177977_b());
                if (tileentity instanceof ChestTileEntity) {
                    if (ConfigUA.chestGeneration) {
                        ((ChestTileEntity)tileentity).func_189404_a(LootTables.field_186431_m, rand.nextLong());
                    } else {
                        worldIn.func_180501_a(pos.func_177977_b(), Blocks.field_150350_a.func_176223_P(), 2);
                    }
                }
            }
        }

        public boolean func_74875_a(IWorld worldIn, Random randomIn, MutableBoundingBox structureBoundingBoxIn, ChunkPos chunkPos) {
            BlockPos blockpos;
            PlacementSettings placementsettings = new PlacementSettings().func_186220_a(this.rotation).func_186214_a(Mirror.NONE).func_207665_a((BlockPos)OFFSET1.get(this.resourceLocation));
            BlockPos blockpos1 = this.field_186178_c.func_177971_a((Vec3i)Template.func_186266_a((PlacementSettings)placementsettings, (BlockPos)new BlockPos(3 - (blockpos = (BlockPos)OFFSET2.get(this.resourceLocation)).func_177958_n(), 0, 0 - blockpos.func_177952_p())));
            int i = worldIn.func_201676_a(Heightmap.Type.WORLD_SURFACE_WG, blockpos1.func_177958_n(), blockpos1.func_177952_p());
            if (i > 244) {
                i = 244;
            }
            BlockPos blockpos2 = this.field_186178_c;
            this.field_186178_c = this.field_186178_c.func_177982_a(0, i - 90 - 1, 0);
            boolean flag = super.func_74875_a(worldIn, randomIn, structureBoundingBoxIn, chunkPos);
            this.field_186178_c = blockpos2;
            return flag;
        }
    }
}

