/*
 * Decompiled with CFR 0.152.
 */
package net.telepathicgrunt.ultraamplified.world.feature.placement;

import com.mojang.datafixers.Dynamic;
import java.util.Random;
import java.util.function.Function;
import java.util.stream.Stream;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorld;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.GenerationSettings;
import net.minecraft.world.gen.Heightmap;
import net.minecraft.world.gen.placement.Placement;
import net.telepathicgrunt.ultraamplified.config.ConfigUA;
import net.telepathicgrunt.ultraamplified.world.feature.config.CountRangeAndTypeConfig;

public class LakePlacementUA
extends Placement<CountRangeAndTypeConfig> {
    public LakePlacementUA(Function<Dynamic<?>, ? extends CountRangeAndTypeConfig> configFactoryIn) {
        super(configFactoryIn);
    }

    public Stream<BlockPos> getPositions(IWorld worldIn, ChunkGenerator<? extends GenerationSettings> chunkGenerator, Random random, CountRangeAndTypeConfig lakeConfig, BlockPos pos) {
        int x = random.nextInt(16) - 8;
        int z = random.nextInt(16) - 8;
        switch (lakeConfig.type) {
            case LAVA: {
                int y;
                if (!ConfigUA.lavaLakeGen) {
                    return Stream.empty();
                }
                if (random.nextInt(lakeConfig.chance / 10) == 0 && ((y = random.nextInt(random.nextInt(chunkGenerator.func_207511_e() - 8) + 8)) < worldIn.func_181545_F() || random.nextInt(lakeConfig.chance / 8) == 0)) {
                    return Stream.of(pos.func_177982_a(x, y, z));
                }
            }
            case WATER: {
                int y;
                if (!ConfigUA.waterLakeGen) {
                    return Stream.empty();
                }
                if (random.nextInt(lakeConfig.chance) == 0) {
                    y = random.nextInt(chunkGenerator.func_207511_e());
                    return Stream.of(pos.func_177982_a(x, y, z));
                }
            }
            case SLIME: {
                int y;
                if (!ConfigUA.slimeLakeGen) {
                    return Stream.empty();
                }
                if (random.nextInt(lakeConfig.chance) != 0 || (y = worldIn.func_201676_a(Heightmap.Type.WORLD_SURFACE, pos.func_177958_n() + (x += 8), pos.func_177952_p() + (z += 8))) <= worldIn.func_181545_F() || y > 170) break;
                return Stream.of(new BlockPos(pos.func_177958_n() + x, y - 2, pos.func_177952_p() + z));
            }
        }
        return Stream.empty();
    }
}

