/*
 * Decompiled with CFR 0.152.
 */
package net.telepathicgrunt.ultraamplified.world.feature.placement;

import com.mojang.datafixers.Dynamic;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Objects;
import java.util.Random;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorld;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.GenerationSettings;
import net.minecraft.world.gen.placement.Placement;
import net.telepathicgrunt.ultraamplified.world.feature.config.PercentageAndFrequencyConfig;

public class ChanceOnAllLiquidBottomsUA
extends Placement<PercentageAndFrequencyConfig> {
    protected static final Set<BlockState> UNACCEPTABLE_BLOCKS = Stream.of(Blocks.field_180397_cI.func_176223_P(), Blocks.field_196779_gQ.func_176223_P(), Blocks.field_196781_gR.func_176223_P(), Blocks.field_180398_cJ.func_176223_P()).collect(Collectors.toCollection(HashSet::new));

    public ChanceOnAllLiquidBottomsUA(Function<Dynamic<?>, ? extends PercentageAndFrequencyConfig> configFactoryIn) {
        super(configFactoryIn);
    }

    public Stream<BlockPos> getPositions(IWorld worldIn, ChunkGenerator<? extends GenerationSettings> chunkGenerator, Random random, PercentageAndFrequencyConfig pfConfig, BlockPos pos) {
        int lowestHeight = 40;
        ArrayList<BlockPos> blockPosList = new ArrayList<BlockPos>();
        block0: for (int i = 0; i < pfConfig.frequency; ++i) {
            int height = 255;
            while (height > lowestHeight) {
                BlockState currentBlock;
                int x = random.nextInt(16);
                int z = random.nextInt(16);
                while (height > lowestHeight && worldIn.func_180495_p(pos.func_177982_a(x, height, z)).func_204520_s().func_206888_e()) {
                    --height;
                }
                while (height > lowestHeight && (!(currentBlock = worldIn.func_180495_p(pos.func_177982_a(x, height, z))).func_204520_s().func_206888_e() || UNACCEPTABLE_BLOCKS.contains(currentBlock))) {
                    --height;
                }
                if (height <= lowestHeight) continue block0;
                if (!(random.nextFloat() < pfConfig.percentage)) continue;
                blockPosList.add(pos.func_177982_a(x, height + 1, z));
            }
        }
        return IntStream.range(0, blockPosList.size()).mapToObj(p_215051_3_ -> (BlockPos)blockPosList.remove(0)).filter(Objects::nonNull);
    }
}

