/*
 * Decompiled with CFR 0.152.
 */
package net.telepathicgrunt.ultraamplified.world.feature;

import com.google.common.collect.ImmutableSet;
import com.mojang.datafixers.Dynamic;
import java.util.BitSet;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Function;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.material.Material;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.chunk.IChunk;
import net.minecraft.world.gen.carver.CaveWorldCarver;
import net.minecraft.world.gen.carver.WorldCarver;
import net.minecraft.world.gen.feature.ProbabilityConfig;

public class UnderwaterCaveCarver
extends CaveWorldCarver {
    protected static final Set<BlockState> CARVABLE_BLOCKS = ImmutableSet.of((Object)Blocks.field_150348_b.func_176223_P(), (Object)Blocks.field_196650_c.func_176223_P(), (Object)Blocks.field_196654_e.func_176223_P(), (Object)Blocks.field_196656_g.func_176223_P(), (Object)Blocks.field_150346_d.func_176223_P(), (Object)Blocks.field_196660_k.func_176223_P(), (Object[])new BlockState[]{Blocks.field_196661_l.func_176223_P(), Blocks.field_196658_i.func_176223_P(), Blocks.field_150405_ch.func_176223_P(), Blocks.field_196777_fo.func_176223_P(), Blocks.field_196778_fp.func_176223_P(), Blocks.field_196780_fq.func_176223_P(), Blocks.field_196782_fr.func_176223_P(), Blocks.field_196783_fs.func_176223_P(), Blocks.field_196785_ft.func_176223_P(), Blocks.field_196787_fu.func_176223_P(), Blocks.field_196789_fv.func_176223_P(), Blocks.field_196791_fw.func_176223_P(), Blocks.field_196793_fx.func_176223_P(), Blocks.field_196795_fy.func_176223_P(), Blocks.field_196797_fz.func_176223_P(), Blocks.field_196719_fA.func_176223_P(), Blocks.field_196720_fB.func_176223_P(), Blocks.field_196721_fC.func_176223_P(), Blocks.field_196722_fD.func_176223_P(), Blocks.field_150322_A.func_176223_P(), Blocks.field_180395_cM.func_176223_P(), Blocks.field_150391_bh.func_176223_P(), Blocks.field_150433_aE.func_176223_P(), Blocks.field_150354_m.func_176223_P(), Blocks.field_150351_n.func_176223_P(), Blocks.field_150355_j.func_176223_P(), Blocks.field_150353_l.func_176223_P(), Blocks.field_150343_Z.func_176223_P(), Blocks.field_150350_a.func_176223_P(), Blocks.field_201941_jj.func_176223_P(), Blocks.field_150403_cj.func_176223_P()});
    private static final BlockState STONE = Blocks.field_150348_b.func_176223_P();

    public UnderwaterCaveCarver(Function<Dynamic<?>, ? extends ProbabilityConfig> probabilityConfig) {
        super(probabilityConfig, 73);
    }

    protected boolean func_222700_a(IChunk chunkIn, int chunkX, int chunkZ, int minX, int maxX, int minY, int maxY, int minZ, int maxZ) {
        return false;
    }

    protected boolean func_222703_a(IChunk chunkIn, BitSet carvingMask, Random randomIn, BlockPos.MutableBlockPos mutableBlockPosIn, BlockPos.MutableBlockPos p_222703_5_, BlockPos.MutableBlockPos p_222703_6_, int minHeight, int chunkX, int chunkZ, int x, int z, int maskY, int y, int atomicBoolean, AtomicBoolean p_222703_15_) {
        return UnderwaterCaveCarver.carvingBlock(this, chunkIn, carvingMask, randomIn, mutableBlockPosIn, minHeight, chunkX, chunkZ, x, z, maskY, y, atomicBoolean);
    }

    protected static boolean carvingBlock(WorldCarver<?> worldCarver, IChunk chunkIn, BitSet carvingMask, Random randomIn, BlockPos.MutableBlockPos mutableBlockPosIn, int minHeight, int chunkX, int chunkZ, int xStart, int zStart, int maskY, int y, int atomicBoolean) {
        if (y >= minHeight) {
            return false;
        }
        int maskFlag = maskY | atomicBoolean << 4 | y << 8;
        if (carvingMask.get(maskFlag)) {
            return false;
        }
        carvingMask.set(maskFlag);
        mutableBlockPosIn.func_181079_c(xStart, y, zStart);
        BlockState blockstate = chunkIn.func_180495_p((BlockPos)mutableBlockPosIn);
        if (!CARVABLE_BLOCKS.contains(blockstate)) {
            return false;
        }
        if (y == 10) {
            float f = randomIn.nextFloat();
            if ((double)f < 0.25) {
                chunkIn.func_177436_a((BlockPos)mutableBlockPosIn, Blocks.field_196814_hQ.func_176223_P(), false);
                chunkIn.func_205218_i_().func_205360_a((BlockPos)mutableBlockPosIn, (Object)Blocks.field_196814_hQ, 0);
            } else {
                chunkIn.func_177436_a((BlockPos)mutableBlockPosIn, Blocks.field_150343_Z.func_176223_P(), false);
            }
            return true;
        }
        if (y < 10) {
            chunkIn.func_177436_a((BlockPos)mutableBlockPosIn, Blocks.field_150353_l.func_176223_P(), false);
            return false;
        }
        mutableBlockPosIn.func_181079_c(xStart, y, zStart);
        boolean bordersAir = false;
        for (Direction direction : Direction.Plane.HORIZONTAL) {
            if (chunkIn.func_180495_p(mutableBlockPosIn.func_177972_a(direction)).func_185904_a() != Material.field_151579_a) continue;
            bordersAir = true;
        }
        if (chunkIn.func_180495_p(mutableBlockPosIn.func_177977_b()).func_185904_a() == Material.field_151579_a) {
            bordersAir = true;
        }
        if (bordersAir) {
            chunkIn.func_177436_a((BlockPos)mutableBlockPosIn, STONE, false);
        } else {
            chunkIn.func_177436_a((BlockPos)mutableBlockPosIn, field_222716_h.func_206883_i(), false);
        }
        return true;
    }
}

