/*
 * Decompiled with CFR 0.152.
 */
package net.telepathicgrunt.ultraamplified.world.feature;

import com.mojang.datafixers.Dynamic;
import com.telepathicgrunt.ultraamplified.UltraAmplified;
import java.util.HashSet;
import java.util.Random;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.util.Mirror;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.IWorld;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.GenerationSettings;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.NoFeatureConfig;
import net.minecraft.world.gen.feature.template.PlacementSettings;
import net.minecraft.world.gen.feature.template.Template;
import net.minecraft.world.gen.feature.template.TemplateManager;
import net.minecraft.world.server.ServerWorld;
import net.telepathicgrunt.ultraamplified.config.ConfigUA;
import net.telepathicgrunt.ultraamplified.world.biome.BiomeInit;

public class Stonehenge
extends Feature<NoFeatureConfig> {
    private static int perfectStoneCount = 0;
    private static boolean markedForPerfection = false;
    private static BlockState AIR = Blocks.field_150350_a.func_176223_P();
    protected static final Set<BlockState> unAcceptableBlocks = Stream.of(Blocks.field_150350_a.func_176223_P(), Blocks.field_150348_b.func_176223_P(), Blocks.field_150355_j.func_176223_P(), Blocks.field_150353_l.func_176223_P(), Blocks.field_180399_cE.func_176223_P(), Blocks.field_201941_jj.func_176223_P()).collect(Collectors.toCollection(HashSet::new));

    public Stonehenge(Function<Dynamic<?>, ? extends NoFeatureConfig> configFactoryIn) {
        super(configFactoryIn);
    }

    public boolean place(IWorld worldIn, ChunkGenerator<? extends GenerationSettings> changedBlock, Random rand, BlockPos position, NoFeatureConfig p_212245_5_) {
        if (!ConfigUA.miniStructureGeneration) {
            return false;
        }
        if (position.func_177956_o() < 248) {
            for (int x = -10; x <= 10; x += 10) {
                for (int z = -10; z <= 10; z += 10) {
                    if ((!unAcceptableBlocks.contains(worldIn.func_180495_p(position.func_177979_c(2).func_177985_f(x).func_177964_d(z))) || !unAcceptableBlocks.contains(worldIn.func_180495_p(position.func_177985_f(x).func_177964_d(z)))) && (worldIn.func_180494_b(position) != BiomeInit.DESERT_HILLS || worldIn.func_180495_p(position.func_177985_f((int)((double)x * 1.2)).func_177964_d((int)((double)z * 1.2))) != AIR && worldIn.func_180495_p(position.func_177979_c(1).func_177985_f((int)((double)x * 1.2)).func_177964_d((int)((double)z * 1.2))) != AIR && worldIn.func_180495_p(position.func_177979_c(2).func_177985_f((int)((double)x * 1.2)).func_177964_d((int)((double)z * 1.2))) != AIR && worldIn.func_180495_p(position.func_177979_c(3).func_177985_f((int)((double)x * 1.2)).func_177964_d((int)((double)z * 1.2))) != AIR)) continue;
                    return false;
                }
            }
            markedForPerfection = rand.nextInt(15) == 0;
            perfectStoneCount = 0;
            TemplateManager templatemanager = ((ServerWorld)worldIn.func_201672_e()).func_217485_w().func_186340_h();
            BlockState iblockstate = worldIn.func_180495_p(position);
            worldIn.func_180501_a(position, iblockstate, 3);
            Template template = this.pickStonehengeStyle(StoneHengeType.SIDE, rand, templatemanager);
            if (template == null) {
                UltraAmplified.LOGGER.warn("a side stonehenge NTB does not exist!");
                return false;
            }
            PlacementSettings placementsettings = new PlacementSettings().func_186214_a(Mirror.NONE).func_186220_a(Rotation.NONE).func_186222_a(false).func_186218_a((ChunkPos)null);
            template.func_186253_b(worldIn, position.func_177979_c(2).func_177964_d(11).func_177985_f(2), placementsettings);
            template = this.pickStonehengeStyle(StoneHengeType.SIDE, rand, templatemanager);
            if (template == null) {
                UltraAmplified.LOGGER.warn("a side stonehenge NTB does not exist!");
                return false;
            }
            placementsettings = new PlacementSettings().func_186214_a(Mirror.NONE).func_186220_a(Rotation.CLOCKWISE_90).func_186222_a(false).func_186218_a((ChunkPos)null);
            template.func_186253_b(worldIn, position.func_177979_c(2).func_177964_d(2).func_177965_g(11), placementsettings);
            template = this.pickStonehengeStyle(StoneHengeType.SIDE, rand, templatemanager);
            if (template == null) {
                UltraAmplified.LOGGER.warn("a side stonehenge NTB does not exist!");
                return false;
            }
            placementsettings = new PlacementSettings().func_186214_a(Mirror.NONE).func_186220_a(Rotation.CLOCKWISE_180).func_186222_a(false).func_186218_a((ChunkPos)null);
            template.func_186253_b(worldIn, position.func_177979_c(2).func_177970_e(11).func_177965_g(2), placementsettings);
            template = this.pickStonehengeStyle(StoneHengeType.SIDE, rand, templatemanager);
            if (template == null) {
                UltraAmplified.LOGGER.warn("a side stonehenge NTB does not exist!");
                return false;
            }
            placementsettings = new PlacementSettings().func_186214_a(Mirror.NONE).func_186220_a(Rotation.COUNTERCLOCKWISE_90).func_186222_a(false).func_186218_a((ChunkPos)null);
            template.func_186253_b(worldIn, position.func_177979_c(2).func_177970_e(2).func_177985_f(11), placementsettings);
            template = this.pickStonehengeStyle(StoneHengeType.CORNER, rand, templatemanager);
            if (template == null) {
                UltraAmplified.LOGGER.warn("a corner stonehenge NTB does not exist!");
                return false;
            }
            placementsettings = new PlacementSettings().func_186214_a(Mirror.NONE).func_186220_a(Rotation.NONE).func_186222_a(false).func_186218_a((ChunkPos)null);
            template.func_186253_b(worldIn, position.func_177979_c(2).func_177964_d(9).func_177985_f(9), placementsettings);
            template = this.pickStonehengeStyle(StoneHengeType.CORNER, rand, templatemanager);
            if (template == null) {
                UltraAmplified.LOGGER.warn("a corner stonehenge NTB does not exist!");
                return false;
            }
            placementsettings = new PlacementSettings().func_186214_a(Mirror.NONE).func_186220_a(Rotation.CLOCKWISE_90).func_186222_a(false).func_186218_a((ChunkPos)null);
            template.func_186253_b(worldIn, position.func_177979_c(2).func_177964_d(9).func_177965_g(9), placementsettings);
            template = this.pickStonehengeStyle(StoneHengeType.CORNER, rand, templatemanager);
            if (template == null) {
                UltraAmplified.LOGGER.warn("a corner stonehenge NTB does not exist!");
                return false;
            }
            placementsettings = new PlacementSettings().func_186214_a(Mirror.NONE).func_186220_a(Rotation.CLOCKWISE_180).func_186222_a(false).func_186218_a((ChunkPos)null);
            template.func_186253_b(worldIn, position.func_177979_c(2).func_177970_e(9).func_177965_g(9), placementsettings);
            template = this.pickStonehengeStyle(StoneHengeType.CORNER, rand, templatemanager);
            if (template == null) {
                UltraAmplified.LOGGER.warn("a corner stonehenge NTB does not exist!");
                return false;
            }
            placementsettings = new PlacementSettings().func_186214_a(Mirror.NONE).func_186220_a(Rotation.COUNTERCLOCKWISE_90).func_186222_a(false).func_186218_a((ChunkPos)null);
            template.func_186253_b(worldIn, position.func_177979_c(2).func_177970_e(9).func_177985_f(9), placementsettings);
            template = perfectStoneCount == 8 ? templatemanager.func_200219_b(new ResourceLocation("ultra_amplified_mod:stonehengeperfectcenter")) : templatemanager.func_200219_b(new ResourceLocation("ultra_amplified_mod:stonehengecenter"));
            if (template == null) {
                UltraAmplified.LOGGER.warn("a center stonehenge NTB does not exist!");
                return false;
            }
            placementsettings = new PlacementSettings().func_186214_a(Mirror.NONE).func_186220_a(Rotation.NONE).func_186222_a(false).func_186218_a((ChunkPos)null);
            template.func_186253_b(worldIn, position.func_177977_b().func_177964_d(2).func_177985_f(2), placementsettings);
            return true;
        }
        return false;
    }

    private Template pickStonehengeStyle(StoneHengeType type, Random rand, TemplateManager templatemanager) {
        int hengeType;
        if (markedForPerfection || rand.nextInt(8 - perfectStoneCount) == 0) {
            ++perfectStoneCount;
            hengeType = 0;
        } else {
            hengeType = rand.nextInt(3) + 1;
        }
        if (type == StoneHengeType.SIDE) {
            if (hengeType == 0) {
                return templatemanager.func_200219_b(new ResourceLocation("ultra_amplified_mod:stonehenge1"));
            }
            if (hengeType == 1) {
                return templatemanager.func_200219_b(new ResourceLocation("ultra_amplified_mod:stonehenge2"));
            }
            if (hengeType == 2) {
                return templatemanager.func_200219_b(new ResourceLocation("ultra_amplified_mod:stonehenge3"));
            }
            return templatemanager.func_200219_b(new ResourceLocation("ultra_amplified_mod:stonehenge4"));
        }
        if (hengeType == 0) {
            return templatemanager.func_200219_b(new ResourceLocation("ultra_amplified_mod:stonehenge5"));
        }
        if (hengeType == 1) {
            return templatemanager.func_200219_b(new ResourceLocation("ultra_amplified_mod:stonehenge6"));
        }
        if (hengeType == 2) {
            return templatemanager.func_200219_b(new ResourceLocation("ultra_amplified_mod:stonehenge7"));
        }
        return templatemanager.func_200219_b(new ResourceLocation("ultra_amplified_mod:stonehenge8"));
    }

    private static enum StoneHengeType {
        SIDE,
        CORNER;

    }
}

