/*
 * Decompiled with CFR 0.152.
 */
package net.telepathicgrunt.ultraamplified.world.feature;

import com.mojang.datafixers.Dynamic;
import java.util.BitSet;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import java.util.function.Function;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.IChunk;
import net.minecraft.world.gen.carver.WorldCarver;
import net.minecraft.world.gen.feature.ProbabilityConfig;
import net.telepathicgrunt.ultraamplified.world.biome.BiomeInit;

public class RavineCarver
extends WorldCarver<ProbabilityConfig> {
    private final float[] field_202536_i = new float[1024];
    protected static final BlockState STONE = Blocks.field_150348_b.func_176223_P();
    protected BlockState fillerBlock = Blocks.field_150348_b.func_176223_P();
    protected static final BlockState WATER = Blocks.field_150355_j.func_176223_P();
    protected static final BlockState LAVA = Blocks.field_150353_l.func_176223_P();
    private static final Map<BlockState, BlockState> fillerMap = RavineCarver.createMap();

    public RavineCarver(Function<Dynamic<?>, ? extends ProbabilityConfig> p_i49921_1_, int p_i49921_2_) {
        super(p_i49921_1_, p_i49921_2_);
    }

    private static Map<BlockState, BlockState> createMap() {
        HashMap<BlockState, BlockState> result = new HashMap<BlockState, BlockState>();
        result.put(Blocks.field_150424_aL.func_176223_P(), Blocks.field_150424_aL.func_176223_P());
        result.put(Blocks.field_150432_aD.func_176223_P(), Blocks.field_150432_aD.func_176223_P());
        result.put(Blocks.field_196604_cC.func_176223_P(), Blocks.field_150432_aD.func_176223_P());
        result.put(Blocks.field_150377_bs.func_176223_P(), Blocks.field_150377_bs.func_176223_P());
        return Collections.unmodifiableMap(result);
    }

    public boolean shouldCarve(Random p_212246_2_, int chunkX, int chunkZ, ProbabilityConfig config) {
        return p_212246_2_.nextFloat() <= config.field_203622_a;
    }

    public boolean carve(IChunk region, Random random, int seaLevel, int chunkX, int chunkZ, int originalX, int originalZ, BitSet mask, ProbabilityConfig config) {
        Biome biome = region.func_217309_c(new BlockPos(originalX * 16, 100, originalZ * 16));
        int i = (this.func_222704_c() * 2 - 1) * 16;
        double xpos = chunkX * 16 + random.nextInt(16);
        double height = biome == BiomeInit.NETHER ? 25.0 : (double)(random.nextInt(random.nextInt(2) + 1) + 42);
        double zpos = chunkZ * 16 + random.nextInt(16);
        float f = random.nextFloat() * ((float)Math.PI * 2);
        float f1 = (random.nextFloat() - 0.5f) / 8.0f;
        float f2 = (random.nextFloat() * 2.0f + random.nextFloat()) * 2.0f;
        int j = i - random.nextInt(i / 4);
        this.func_202535_a(region, random.nextLong(), originalX, originalZ, xpos, height, zpos, f2, f, f1, 0, j, biome == BiomeInit.NETHER ? random.nextDouble() + 2.5 : random.nextDouble() / 3.0 + 1.9, mask);
        return true;
    }

    private void func_202535_a(IChunk worldIn, long randomSeed, int mainChunkX, int mainChunkZ, double randomBlockX, double randomBlockY, double randomBlockZ, float p_202535_12_, float p_202535_13_, float p_202535_14_, int p_202535_15_, int p_202535_16_, double heightMultiplier, BitSet mask) {
        Random random = new Random(randomSeed);
        float f = 1.0f;
        for (int i = 0; i < 256; ++i) {
            if (i == 0 || random.nextInt(3) == 0) {
                f = 1.0f + random.nextFloat() * random.nextFloat();
            }
            this.field_202536_i[i] = f * f;
        }
        float f4 = 0.0f;
        float f1 = 0.0f;
        for (int j = p_202535_15_; j < p_202535_16_; ++j) {
            double placementXZBound = 2.0 + (double)(MathHelper.func_76126_a((float)((float)j * (float)Math.PI / (float)p_202535_16_)) * p_202535_12_);
            double placementYBound = placementXZBound * heightMultiplier;
            placementXZBound *= (double)random.nextFloat() * 0.15 + 0.65;
            placementYBound *= 0.8;
            float f2 = MathHelper.func_76134_b((float)p_202535_14_);
            randomBlockX += (double)(MathHelper.func_76134_b((float)p_202535_13_) * f2);
            randomBlockZ += (double)(MathHelper.func_76126_a((float)p_202535_13_) * f2);
            p_202535_14_ *= 0.8f;
            p_202535_14_ += f1 * 0.08f;
            p_202535_13_ += f4 * 0.1f;
            f1 *= 0.8f;
            f4 *= 0.5f;
            f1 += (random.nextFloat() - random.nextFloat()) * random.nextFloat() * 1.5f;
            f4 += (random.nextFloat() - random.nextFloat()) * random.nextFloat() * 3.0f;
            if (random.nextInt(4) == 0) continue;
            if (!this.func_222702_a(mainChunkX, mainChunkZ, randomBlockX, randomBlockZ, j, p_202535_16_, p_202535_12_)) {
                return;
            }
            this.carveAtTarget(worldIn, randomSeed, mainChunkX, mainChunkZ, randomBlockX, randomBlockY, randomBlockZ, placementXZBound, placementYBound, mask);
        }
    }

    protected boolean carveAtTarget(IChunk worldIn, long seed, int mainChunkX, int mainChunkZ, double xRange, double yRange, double zRange, double placementXZBound, double placementYBound, BitSet mask) {
        double d0 = mainChunkX * 16 + 8;
        double d1 = mainChunkZ * 16 + 8;
        if (!(xRange < d0 - 16.0 - placementXZBound * 2.0 || zRange < d1 - 16.0 - placementXZBound * 2.0 || xRange > d0 + 16.0 + placementXZBound * 2.0 || zRange > d1 + 16.0 + placementXZBound * 2.0)) {
            int i = Math.max(MathHelper.func_76128_c((double)(xRange - placementXZBound)) - mainChunkX * 16 - 1, 0);
            int j = Math.min(MathHelper.func_76128_c((double)(xRange + placementXZBound)) - mainChunkX * 16 + 1, 16);
            int k = Math.max(MathHelper.func_76128_c((double)(yRange - placementYBound)) - 1, 9);
            int l = Math.min(MathHelper.func_76128_c((double)(yRange + placementYBound)) + 1, this.field_222720_l);
            int i1 = Math.max(MathHelper.func_76128_c((double)(zRange - placementXZBound)) - mainChunkZ * 16 - 1, 0);
            int j1 = Math.min(MathHelper.func_76128_c((double)(zRange + placementXZBound)) - mainChunkZ * 16 + 1, 16);
            if (i <= j && k <= l && i1 <= j1) {
                boolean flag = false;
                BlockPos.MutableBlockPos blockpos$mutableblockpos = new BlockPos.MutableBlockPos();
                BlockPos.MutableBlockPos blockpos$mutableblockpos1 = new BlockPos.MutableBlockPos();
                BlockPos.MutableBlockPos blockpos$mutableblockpos2 = new BlockPos.MutableBlockPos();
                for (int k1 = i; k1 < j; ++k1) {
                    int l1 = k1 + mainChunkX * 16;
                    double d2 = ((double)l1 + 0.5 - xRange) / placementXZBound;
                    for (int i2 = i1; i2 < j1; ++i2) {
                        int j2 = i2 + mainChunkZ * 16;
                        double d3 = ((double)j2 + 0.5 - zRange) / placementXZBound;
                        if (!(d2 * d2 + d3 * d3 < 1.0)) continue;
                        blockpos$mutableblockpos.func_181079_c(l1, 60, j2);
                        this.fillerBlock = fillerMap.get(worldIn.func_217309_c((BlockPos)blockpos$mutableblockpos).func_203944_q().func_204108_a());
                        if (this.fillerBlock == null) {
                            this.fillerBlock = STONE;
                        }
                        for (int k2 = l; k2 > k; --k2) {
                            int l2;
                            double d4 = ((double)(k2 - 1) + 0.5 - yRange) / placementYBound;
                            if (!((d2 * d2 + d3 * d3) * (double)this.field_202536_i[k2 - 1] + d4 * d4 / 6.0 < 1.0) || mask.get(l2 = k1 | i2 << 4 | k2 << 8)) continue;
                            mask.set(l2);
                            blockpos$mutableblockpos.func_181079_c(l1, k2, j2);
                            BlockState iblockstate = worldIn.func_180495_p((BlockPos)blockpos$mutableblockpos);
                            blockpos$mutableblockpos1.func_189533_g((Vec3i)blockpos$mutableblockpos).func_189536_c(Direction.UP);
                            blockpos$mutableblockpos2.func_189533_g((Vec3i)blockpos$mutableblockpos).func_189536_c(Direction.DOWN);
                            BlockState iblockstate1 = worldIn.func_180495_p((BlockPos)blockpos$mutableblockpos1);
                            if (!iblockstate1.func_204520_s().func_206888_e()) {
                                worldIn.func_177436_a((BlockPos)blockpos$mutableblockpos, this.fillerBlock, false);
                                worldIn.func_177436_a((BlockPos)blockpos$mutableblockpos1, this.fillerBlock, false);
                                worldIn.func_177436_a((BlockPos)blockpos$mutableblockpos2, this.fillerBlock, false);
                                flag = true;
                                continue;
                            }
                            if (!this.func_222707_a(iblockstate, iblockstate1) && !fillerMap.containsKey(iblockstate)) continue;
                            if (k2 - 1 < 10) {
                                worldIn.func_177436_a((BlockPos)blockpos$mutableblockpos, LAVA.getBlockState(), false);
                            } else {
                                boolean bordersFluid = false;
                                for (Direction direction : Direction.Plane.HORIZONTAL) {
                                    if (worldIn.func_180495_p(blockpos$mutableblockpos.func_177972_a(direction)).func_204520_s().func_206888_e()) continue;
                                    bordersFluid = true;
                                }
                                if (!worldIn.func_180495_p(blockpos$mutableblockpos.func_177984_a()).func_204520_s().func_206888_e()) {
                                    bordersFluid = true;
                                }
                                if (bordersFluid) {
                                    worldIn.func_177436_a((BlockPos)blockpos$mutableblockpos, this.fillerBlock, false);
                                } else {
                                    worldIn.func_177436_a((BlockPos)blockpos$mutableblockpos, field_222715_g.getBlockState(), false);
                                }
                            }
                            flag = true;
                        }
                    }
                }
                return flag;
            }
            return false;
        }
        return false;
    }

    protected boolean func_222708_a(double p_222708_1_, double p_222708_3_, double p_222708_5_, int p_222708_7_) {
        return (p_222708_1_ * p_222708_1_ + p_222708_5_ * p_222708_5_) * (double)this.field_202536_i[p_222708_7_ - 1] + p_222708_3_ * p_222708_3_ / 6.0 >= 1.0;
    }
}

