/*
 * Decompiled with CFR 0.152.
 */
package net.telepathicgrunt.ultraamplified.world.feature;

import com.mojang.datafixers.Dynamic;
import java.util.Random;
import java.util.function.Function;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.material.Material;
import net.minecraft.util.SharedSeedRandom;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorld;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.GenerationSettings;
import net.minecraft.world.gen.OctavesNoiseGenerator;
import net.minecraft.world.gen.feature.Feature;
import net.telepathicgrunt.ultraamplified.config.ConfigUA;
import net.telepathicgrunt.ultraamplified.world.feature.config.ColumnBlocksConfig;

public class RampColumnUA
extends Feature<ColumnBlocksConfig> {
    protected OctavesNoiseGenerator noiseGen;
    protected long seed;
    private final BlockState AIR = Blocks.field_150350_a.func_176223_P();

    public void setSeed(long seed) {
        if (this.noiseGen == null) {
            this.noiseGen = new OctavesNoiseGenerator((Random)new SharedSeedRandom(seed), 4);
        }
        this.seed = seed;
    }

    public RampColumnUA(Function<Dynamic<?>, ? extends ColumnBlocksConfig> configFactoryIn) {
        super(configFactoryIn);
    }

    public boolean place(IWorld worldIn, ChunkGenerator<? extends GenerationSettings> changedBlock, Random rand, BlockPos position, ColumnBlocksConfig blocksConfig) {
        int currentHeight;
        if (!ConfigUA.pillarGen) {
            return false;
        }
        this.setSeed(rand.nextLong());
        BlockPos.MutableBlockPos blockpos$mutableblockpos = new BlockPos.MutableBlockPos(position);
        int minWidth = 4;
        int ceilingHeight = currentHeight = 0;
        int bottomFloorHeight = currentHeight;
        int topFloorHeight = currentHeight;
        int heightDiff = 0;
        while (!worldIn.func_180495_p(blockpos$mutableblockpos.func_177981_b(currentHeight)).func_200132_m()) {
            if (blockpos$mutableblockpos.func_177981_b(currentHeight).func_177956_o() > 254) {
                return false;
            }
            currentHeight += 2;
        }
        ceilingHeight = blockpos$mutableblockpos.func_177981_b(currentHeight).func_177956_o();
        while (worldIn.func_180495_p(blockpos$mutableblockpos.func_177981_b(currentHeight)).func_200132_m()) {
            if (blockpos$mutableblockpos.func_177981_b(currentHeight).func_177956_o() > 254) {
                return false;
            }
            ++currentHeight;
        }
        topFloorHeight = blockpos$mutableblockpos.func_177981_b(currentHeight).func_177956_o();
        if (topFloorHeight - ceilingHeight > 7 || topFloorHeight - ceilingHeight < 2) {
            return false;
        }
        currentHeight = 0;
        while (!worldIn.func_180495_p(blockpos$mutableblockpos.func_177981_b(currentHeight)).func_200132_m()) {
            if (blockpos$mutableblockpos.func_177981_b(currentHeight).func_177956_o() < 70) {
                return false;
            }
            currentHeight -= 2;
        }
        bottomFloorHeight = blockpos$mutableblockpos.func_177981_b(currentHeight).func_177956_o();
        heightDiff = ceilingHeight - bottomFloorHeight;
        if (heightDiff > 27 || heightDiff < 8) {
            return false;
        }
        float randFloat = rand.nextFloat();
        float xTurningValue = (float)Math.sin((double)randFloat * Math.PI * 2.0);
        float zTurningValue = (float)Math.cos((double)randFloat * Math.PI * 2.0);
        int widthAtHeight = 0;
        widthAtHeight = this.getWidthAtHeight(0, heightDiff + 5, minWidth);
        for (int x = position.func_177958_n() - widthAtHeight; x <= position.func_177958_n() + widthAtHeight; x += 3) {
            for (int z = position.func_177952_p() - widthAtHeight; z <= position.func_177952_p() + widthAtHeight; z += 3) {
                int zDiff;
                int xDiff = x - position.func_177958_n();
                if (xDiff * xDiff + (zDiff = z - position.func_177952_p()) * zDiff > widthAtHeight * widthAtHeight) continue;
                BlockState block1 = worldIn.func_180495_p((BlockPos)blockpos$mutableblockpos.func_181079_c(x + this.getOffsetAtHeight(heightDiff + 1, heightDiff, xTurningValue), ceilingHeight + 2, z + this.getOffsetAtHeight(0, heightDiff, zTurningValue)));
                BlockState block2 = worldIn.func_180495_p((BlockPos)blockpos$mutableblockpos.func_181079_c(x - this.getOffsetAtHeight(-1, heightDiff, xTurningValue), bottomFloorHeight - 2, z - this.getOffsetAtHeight(0, heightDiff, zTurningValue)));
                if (block1.func_200132_m() && block2.func_200132_m()) continue;
                return false;
            }
        }
        for (int y = -2; y <= heightDiff + 5; ++y) {
            widthAtHeight = this.getWidthAtHeight(y, heightDiff + 5, minWidth);
            int xOffset = this.getOffsetAtHeight(y, heightDiff, xTurningValue);
            int zOffset = this.getOffsetAtHeight(y, heightDiff, zTurningValue);
            for (int x = position.func_177958_n() - widthAtHeight - 1; x <= position.func_177958_n() + widthAtHeight + 1; ++x) {
                for (int z = position.func_177952_p() - widthAtHeight - 1; z <= position.func_177952_p() + widthAtHeight + 1; ++z) {
                    BlockState block;
                    int xDiff = x - position.func_177958_n();
                    int zDiff = z - position.func_177952_p();
                    blockpos$mutableblockpos.func_181079_c(x + xOffset, y + bottomFloorHeight, z + zOffset);
                    int xzDiffSquaredStretched = xDiff * xDiff + zDiff * zDiff;
                    if (y <= heightDiff && (float)xzDiffSquaredStretched <= (float)((widthAtHeight - 1) * (widthAtHeight - 1)) - 0.5f) {
                        BlockState block2 = worldIn.func_180495_p((BlockPos)blockpos$mutableblockpos);
                        if (!block2.func_200132_m()) {
                            worldIn.func_180501_a((BlockPos)blockpos$mutableblockpos, blocksConfig.insideBlock, 2);
                        }
                    } else if (y > heightDiff || xzDiffSquaredStretched <= (widthAtHeight + 3) * (widthAtHeight + 3)) {
                        for (int downward = 0; downward < 6 && y - downward >= -3; ++downward) {
                            block = worldIn.func_180495_p(blockpos$mutableblockpos.func_177979_c(downward));
                            BlockState blockBelow = worldIn.func_180495_p(blockpos$mutableblockpos.func_177979_c(downward + 1));
                            if (block != blocksConfig.insideBlock) continue;
                            if (downward == 1 && (blocksConfig.topBlock.func_185904_a() != Material.field_151595_p || blockBelow.func_185904_a() != Material.field_151579_a)) {
                                worldIn.func_180501_a(blockpos$mutableblockpos.func_177979_c(downward), blocksConfig.topBlock, 2);
                                continue;
                            }
                            worldIn.func_180501_a(blockpos$mutableblockpos.func_177979_c(downward), blocksConfig.middleBlock, 2);
                        }
                    }
                    int holeHeight = 5;
                    block = worldIn.func_180495_p(blockpos$mutableblockpos.func_177981_b(holeHeight));
                    if (block.func_185904_a() == Material.field_151579_a || !((float)xzDiffSquaredStretched <= (float)((widthAtHeight - 1) * (widthAtHeight - 1)) - 0.5f)) continue;
                    worldIn.func_180501_a(blockpos$mutableblockpos.func_177981_b(holeHeight), this.AIR, 2);
                    BlockState blockBelowAir = worldIn.func_180495_p(blockpos$mutableblockpos.func_177981_b(holeHeight - 1));
                    BlockState blockBelowBelowAir = worldIn.func_180495_p(blockpos$mutableblockpos.func_177981_b(holeHeight - 2));
                    if (!blockBelowAir.func_200132_m()) continue;
                    if (blocksConfig.topBlock.func_185904_a() == Material.field_151595_p && blockBelowBelowAir.func_185904_a() == Material.field_151579_a) {
                        worldIn.func_180501_a(blockpos$mutableblockpos.func_177981_b(holeHeight - 1), blocksConfig.middleBlock, 2);
                        continue;
                    }
                    worldIn.func_180501_a(blockpos$mutableblockpos.func_177981_b(holeHeight - 1), blocksConfig.topBlock, 2);
                }
            }
        }
        return true;
    }

    private int getWidthAtHeight(int y, int heightDiff, int thinnestWidth) {
        float yFromCenter = (float)y - (float)heightDiff * 0.5f;
        yFromCenter = Math.abs(yFromCenter * 0.4f) + 3.0f;
        return thinnestWidth + (int)(yFromCenter * yFromCenter / 8.0f);
    }

    private int getOffsetAtHeight(int y, int heightDiff, float turningValue) {
        float yFromCenter = (float)y - (float)heightDiff / 2.0f;
        return (int)(turningValue * yFromCenter);
    }
}

