/*
 * Decompiled with CFR 0.152.
 */
package net.telepathicgrunt.ultraamplified.world.feature;

import com.mojang.datafixers.Dynamic;
import java.util.Random;
import java.util.Set;
import java.util.function.Function;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.material.Material;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldWriter;
import net.minecraft.world.gen.IWorldGenerationReader;
import net.minecraft.world.gen.feature.HugeTreesFeature;
import net.minecraft.world.gen.feature.NoFeatureConfig;
import net.minecraftforge.common.IPlantable;

public class MegaPineTreeUA
extends HugeTreesFeature<NoFeatureConfig> {
    private static final BlockState TRUNK = Blocks.field_196618_L.func_176223_P();
    private static final BlockState LEAF = Blocks.field_196645_X.func_176223_P();
    private static final BlockState PODZOL = Blocks.field_196661_l.func_176223_P();
    private final boolean useBaseHeight;

    public MegaPineTreeUA(Function<Dynamic<?>, ? extends NoFeatureConfig> configFactoryIn, boolean doBlockNotifyOnPlace, boolean useBaseHeightIn) {
        super(configFactoryIn, doBlockNotifyOnPlace, 13, 50, TRUNK, LEAF);
        this.useBaseHeight = useBaseHeightIn;
        this.setSapling((IPlantable)Blocks.field_196675_u);
    }

    public boolean func_208519_a(Set<BlockPos> changedBlocks, IWorldGenerationReader worldIn, Random rand, BlockPos position, MutableBoundingBox p_208519_5_) {
        int height = this.func_150533_a(rand);
        IWorld world = (IWorld)worldIn;
        if (!this.func_203427_a(worldIn, position, height)) {
            return false;
        }
        this.createCrown(worldIn, position.func_177958_n(), position.func_177952_p(), position.func_177956_o() + height, 0, rand, p_208519_5_, changedBlocks);
        for (int currentHeight = 0; currentHeight < height; ++currentHeight) {
            BlockState iblockstate = world.func_180495_p(position.func_177981_b(currentHeight));
            if (iblockstate.func_185904_a() == Material.field_151579_a || iblockstate.func_185904_a() == Material.field_151584_j) {
                this.func_208520_a(changedBlocks, (IWorldWriter)worldIn, position.func_177981_b(currentHeight), TRUNK, p_208519_5_);
            }
            if (currentHeight >= height - 1) continue;
            iblockstate = world.func_180495_p(position.func_177982_a(1, currentHeight, 0));
            if (iblockstate.func_185904_a() == Material.field_151579_a || iblockstate.func_185904_a() == Material.field_151584_j) {
                this.func_208520_a(changedBlocks, (IWorldWriter)worldIn, position.func_177982_a(1, currentHeight, 0), TRUNK, p_208519_5_);
            }
            if ((iblockstate = world.func_180495_p(position.func_177982_a(1, currentHeight, 1))).func_185904_a() == Material.field_151579_a || iblockstate.func_185904_a() == Material.field_151584_j) {
                this.func_208520_a(changedBlocks, (IWorldWriter)worldIn, position.func_177982_a(1, currentHeight, 1), TRUNK, p_208519_5_);
            }
            if ((iblockstate = world.func_180495_p(position.func_177982_a(0, currentHeight, 1))).func_185904_a() != Material.field_151579_a && iblockstate.func_185904_a() != Material.field_151584_j) continue;
            this.func_208520_a(changedBlocks, (IWorldWriter)worldIn, position.func_177982_a(0, currentHeight, 1), TRUNK, p_208519_5_);
        }
        return true;
    }

    private void createCrown(IWorldGenerationReader worldIn, int x, int z, int y, int extraRadiusSize, Random rand, MutableBoundingBox p_214596_7_, Set<BlockPos> p_214596_8_) {
        int height = rand.nextInt(5) + (this.useBaseHeight ? this.field_76522_a : 3);
        int prevRadius = 0;
        for (int currentHeight = y - height; currentHeight <= y + 20; ++currentHeight) {
            int heightDiff = y - currentHeight;
            int radius = extraRadiusSize + MathHelper.func_76141_d((float)((float)heightDiff / (float)height * 3.5f));
            this.func_222839_a(worldIn, new BlockPos(x, currentHeight, z), radius + (heightDiff > 0 && radius == prevRadius && (currentHeight & 1) == 0 ? 1 : 0) * 2, p_214596_7_, p_214596_8_);
            prevRadius = radius;
        }
    }

    public void generateSaplings(IWorld worldIn, Random random, BlockPos pos) {
        this.placePodzolCircle(worldIn, pos.func_177976_e().func_177978_c());
        this.placePodzolCircle(worldIn, pos.func_177965_g(2).func_177978_c());
        this.placePodzolCircle(worldIn, pos.func_177976_e().func_177970_e(2));
        this.placePodzolCircle(worldIn, pos.func_177965_g(2).func_177970_e(2));
        for (int currentCount = 0; currentCount < 5; ++currentCount) {
            int randNum = random.nextInt(64);
            int x = randNum % 8;
            int z = randNum / 8;
            if (x != 0 && x != 7 && z != 0 && z != 7) continue;
            this.placePodzolCircle(worldIn, pos.func_177982_a(-3 + x, 0, -3 + z));
        }
    }

    private void placePodzolCircle(IWorld worldIn, BlockPos center) {
        for (int i = -2; i <= 2; ++i) {
            for (int j = -2; j <= 2; ++j) {
                if (Math.abs(i) == 2 && Math.abs(j) == 2) continue;
                this.placePodzolAt(worldIn, center.func_177982_a(i, 0, j));
            }
        }
    }

    private void placePodzolAt(IWorld worldIn, BlockPos pos) {
        for (int i = 2; i >= -3; --i) {
            BlockPos blockpos = pos.func_177981_b(i);
            BlockState iblockstate = worldIn.func_180495_p(blockpos);
            Block block = iblockstate.func_177230_c();
            if (block == Blocks.field_150349_c || Block.func_196245_f((Block)block)) {
                this.func_202278_a((IWorldWriter)worldIn, blockpos, PODZOL);
                break;
            }
            if (iblockstate.func_185904_a() != Material.field_151579_a && i < 0) break;
        }
    }
}

