/*
 * Decompiled with CFR 0.152.
 */
package net.telepathicgrunt.ultraamplified.world.feature;

import com.mojang.datafixers.Dynamic;
import java.util.Random;
import java.util.function.Function;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.material.Material;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldWriter;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.GenerationSettings;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.IcebergConfig;

public class IcebergUA
extends Feature<IcebergConfig> {
    private static final BlockState PACKED_ICE = Blocks.field_150403_cj.func_176223_P();
    private static final BlockState AIR = Blocks.field_150350_a.func_176223_P();
    private static final BlockState WATER = Blocks.field_150355_j.func_176223_P();
    private static final BlockState STONE = Blocks.field_150348_b.func_176223_P();
    private static final BlockState SNOW_BLOCK = Blocks.field_196604_cC.func_176223_P();

    public IcebergUA(Function<Dynamic<?>, ? extends IcebergConfig> configFactoryIn) {
        super(configFactoryIn);
    }

    public boolean place(IWorld worldIn, ChunkGenerator<? extends GenerationSettings> chunkSettings, Random random, BlockPos pos, IcebergConfig icebergConfig) {
        boolean flag2;
        int y;
        int z;
        int x;
        int upperHeight;
        boolean flag = random.nextDouble() > 0.7;
        BlockState iblockstate = icebergConfig.field_205191_a;
        double d0 = random.nextDouble() * 2.0 * Math.PI;
        int i = 11 - random.nextInt(5);
        int j = 3 + random.nextInt(3);
        boolean flag1 = random.nextDouble() > 0.7;
        int n = upperHeight = flag1 ? random.nextInt(6) + 6 : random.nextInt(15) + 3;
        if (!flag1 && random.nextDouble() > 0.9) {
            upperHeight += random.nextInt(19) + 7;
        }
        int downHeight = Math.min(upperHeight + random.nextInt(11), 18);
        int j1 = Math.min(upperHeight + random.nextInt(7) - random.nextInt(5), 11);
        int radius = flag1 ? i : 11;
        for (x = -radius; x < radius; ++x) {
            for (z = -radius; z < radius; ++z) {
                for (y = 0; y < upperHeight; ++y) {
                    int k2;
                    int n2 = k2 = flag1 ? this.func_205178_b(y, upperHeight, j1) : this.func_205183_a(random, y, upperHeight, j1);
                    if (!flag1 && x >= k2) continue;
                    this.func_205181_a(worldIn, random, pos, upperHeight, x, y, z, k2, radius, flag1, j, d0, flag, iblockstate);
                }
            }
        }
        this.func_205186_a(worldIn, pos, j1, upperHeight, flag1, i);
        for (x = -radius; x < radius; ++x) {
            for (z = -radius; z < radius; ++z) {
                for (y = -1; y > -downHeight; --y) {
                    int l3 = flag1 ? MathHelper.func_76123_f((float)((float)radius * (1.0f - (float)Math.pow(y, 2.0) / ((float)downHeight * 8.0f)))) : radius;
                    int l2 = this.func_205187_b(random, -y, downHeight, j1);
                    if (x >= l2) continue;
                    this.func_205181_a(worldIn, random, pos, downHeight, x, y, z, l2, l3, flag1, j, d0, flag, iblockstate);
                }
            }
        }
        boolean bl = flag1 ? random.nextDouble() > 0.1 : (flag2 = random.nextDouble() > 0.7);
        if (flag2) {
            this.func_205184_a(random, worldIn, j1, upperHeight, pos, flag1, i, d0, j);
        }
        return true;
    }

    private void func_205184_a(Random random, IWorld worldIn, int p_205184_3_, int height, BlockPos pos, boolean flag, int p_205184_7_, double p_205184_8_, int p_205184_10_) {
        int i = random.nextBoolean() ? -1 : 1;
        int j = random.nextBoolean() ? -1 : 1;
        int k = random.nextInt(Math.max(p_205184_3_ / 2 - 2, 1));
        if (random.nextBoolean()) {
            k = p_205184_3_ / 2 + 1 - random.nextInt(Math.max(p_205184_3_ - p_205184_3_ / 2 - 1, 1));
        }
        int l = random.nextInt(Math.max(p_205184_3_ / 2 - 2, 1));
        if (random.nextBoolean()) {
            l = p_205184_3_ / 2 + 1 - random.nextInt(Math.max(p_205184_3_ - p_205184_3_ / 2 - 1, 1));
        }
        if (flag) {
            k = l = random.nextInt(Math.max(p_205184_7_ - 5, 1));
        }
        BlockPos blockpos = new BlockPos(0, 0, 0).func_177982_a(i * k, 0, j * l);
        double d0 = flag ? p_205184_8_ + 1.5707963267948966 : random.nextDouble() * 2.0 * Math.PI;
        for (int i1 = 0; i1 < height - 3; ++i1) {
            int j1 = this.func_205183_a(random, i1, height, p_205184_3_);
            this.func_205174_a(j1, i1, pos, worldIn, false, d0, blockpos, p_205184_7_, p_205184_10_);
        }
        for (int k1 = -1; k1 > -height + random.nextInt(5); --k1) {
            int l1 = this.func_205187_b(random, -k1, height, p_205184_3_);
            this.func_205174_a(l1, k1, pos, worldIn, true, d0, blockpos, p_205184_7_, p_205184_10_);
        }
    }

    private void func_205174_a(int p_205174_1_, int p_205174_2_, BlockPos pos, IWorld worldIn, boolean placeWater, double p_205174_6_, BlockPos pos2, int p_205174_9_, int p_205174_10_) {
        int i = p_205174_1_ + 1 + p_205174_9_ / 3;
        int j = Math.min(p_205174_1_ - 3, 3) + p_205174_10_ / 2 - 1;
        for (int k = -i; k < i; ++k) {
            for (int l = -i; l < i; ++l) {
                BlockPos blockpos;
                Block block;
                double d0 = this.func_205180_a(k, l, pos2, i, j, p_205174_6_);
                if (!(d0 < 0.0) || !this.isIce(block = worldIn.func_180495_p(blockpos = pos.func_177982_a(k, p_205174_2_, l)).func_177230_c()) && block != Blocks.field_196604_cC) continue;
                if (placeWater) {
                    worldIn.func_180501_a(blockpos, this.appropriateBlockForNeighbors(worldIn, pos), 3);
                    continue;
                }
                this.func_202278_a((IWorldWriter)worldIn, blockpos, this.appropriateBlockForNeighbors(worldIn, pos));
                this.removeSnowLayer(worldIn, blockpos);
            }
        }
    }

    private void removeSnowLayer(IWorld worldIn, BlockPos pos) {
        if (worldIn.func_180495_p(pos.func_177984_a()).func_177230_c() == Blocks.field_150433_aE) {
            this.func_202278_a((IWorldWriter)worldIn, pos.func_177984_a(), this.appropriateBlockForNeighbors(worldIn, pos));
        }
    }

    private void func_205181_a(IWorld p_205181_1_, Random p_205181_2_, BlockPos p_205181_3_, int p_205181_4_, int xPos, int yPos, int zPos, int p_205181_8_, int p_205181_9_, boolean p_205181_10_, int p_205181_11_, double p_205181_12_, boolean p_205181_14_, BlockState p_205181_15_) {
        double d0;
        BlockPos blockpos = new BlockPos(0, 0, 0);
        double d = d0 = p_205181_10_ ? this.func_205180_a(xPos, zPos, blockpos, p_205181_9_, this.func_205176_a(yPos, p_205181_4_, p_205181_11_), p_205181_12_) : this.func_205177_a(xPos, zPos, blockpos, p_205181_8_, p_205181_2_);
        if (d0 < 0.0) {
            double d1;
            BlockPos blockpos1 = p_205181_3_.func_177982_a(xPos, yPos, zPos);
            double d2 = d1 = p_205181_10_ ? -0.5 : (double)(-6 - p_205181_2_.nextInt(3));
            if (d0 > d1 && p_205181_2_.nextDouble() > 0.9) {
                return;
            }
            this.func_205175_a(blockpos1, p_205181_1_, p_205181_2_, p_205181_4_ - yPos, p_205181_4_, p_205181_10_, p_205181_14_, p_205181_15_);
        }
    }

    private void func_205175_a(BlockPos p_205175_1_, IWorld p_205175_2_, Random p_205175_3_, int p_205175_4_, int p_205175_5_, boolean p_205175_6_, boolean p_205175_7_, BlockState p_205175_8_) {
        BlockState iblockstate = p_205175_2_.func_180495_p(p_205175_1_);
        Block block = iblockstate.func_177230_c();
        if (iblockstate.func_185904_a() == Material.field_151579_a || block == Blocks.field_196604_cC || block == Blocks.field_150432_aD || block == Blocks.field_150355_j || block == Blocks.field_150353_l) {
            int i;
            boolean flag = !p_205175_6_ || p_205175_3_.nextDouble() > 0.05;
            int n = i = p_205175_6_ ? 3 : 2;
            if (p_205175_7_ && block != Blocks.field_150355_j || block != Blocks.field_150353_l && (double)p_205175_4_ <= (double)p_205175_3_.nextInt(Math.max(1, p_205175_5_ / i)) + (double)p_205175_5_ * 0.6 && flag) {
                this.func_202278_a((IWorldWriter)p_205175_2_, p_205175_1_, SNOW_BLOCK);
            } else {
                this.func_202278_a((IWorldWriter)p_205175_2_, p_205175_1_, p_205175_8_);
            }
        }
    }

    private int func_205176_a(int p_205176_1_, int p_205176_2_, int p_205176_3_) {
        int i = p_205176_3_;
        if (p_205176_1_ > 0 && p_205176_2_ - p_205176_1_ <= 3) {
            i = p_205176_3_ - (4 - (p_205176_2_ - p_205176_1_));
        }
        return i;
    }

    private double func_205177_a(int p_205177_1_, int p_205177_2_, BlockPos p_205177_3_, int p_205177_4_, Random p_205177_5_) {
        float f = 10.0f * MathHelper.func_76131_a((float)p_205177_5_.nextFloat(), (float)0.2f, (float)0.8f) / (float)p_205177_4_;
        return (double)f + Math.pow(p_205177_1_ - p_205177_3_.func_177958_n(), 2.0) + Math.pow(p_205177_2_ - p_205177_3_.func_177952_p(), 2.0) - Math.pow(p_205177_4_, 2.0);
    }

    private double func_205180_a(int p_205180_1_, int p_205180_2_, BlockPos p_205180_3_, int p_205180_4_, int p_205180_5_, double p_205180_6_) {
        return Math.pow(((double)(p_205180_1_ - p_205180_3_.func_177958_n()) * Math.cos(p_205180_6_) - (double)(p_205180_2_ - p_205180_3_.func_177952_p()) * Math.sin(p_205180_6_)) / (double)p_205180_4_, 2.0) + Math.pow(((double)(p_205180_1_ - p_205180_3_.func_177958_n()) * Math.sin(p_205180_6_) + (double)(p_205180_2_ - p_205180_3_.func_177952_p()) * Math.cos(p_205180_6_)) / (double)p_205180_5_, 2.0) - 1.0;
    }

    private int func_205183_a(Random p_205183_1_, int p_205183_2_, int p_205183_3_, int p_205183_4_) {
        float f = 3.5f - p_205183_1_.nextFloat();
        float f1 = (1.0f - (float)Math.pow(p_205183_2_, 2.0) / ((float)p_205183_3_ * f)) * (float)p_205183_4_;
        if (p_205183_3_ > 15 + p_205183_1_.nextInt(5)) {
            int i = p_205183_2_ < 3 + p_205183_1_.nextInt(6) ? p_205183_2_ / 2 : p_205183_2_;
            f1 = (1.0f - (float)i / ((float)p_205183_3_ * f * 0.4f)) * (float)p_205183_4_;
        }
        return MathHelper.func_76123_f((float)(f1 / 2.0f));
    }

    private int func_205178_b(int y, int upperHeight, int p_205178_3_) {
        float f1 = (1.0f - (float)Math.pow(y, 2.0) / ((float)upperHeight * 1.0f)) * (float)p_205178_3_;
        return MathHelper.func_76123_f((float)(f1 / 2.0f));
    }

    private int func_205187_b(Random random, int p_205187_2_, int p_205187_3_, int p_205187_4_) {
        float f = 1.0f + random.nextFloat() / 2.0f;
        float f1 = (1.0f - (float)p_205187_2_ / ((float)p_205187_3_ * f)) * (float)p_205187_4_;
        return MathHelper.func_76123_f((float)(f1 / 2.0f));
    }

    private boolean isIce(Block block) {
        return block == Blocks.field_150403_cj || block == Blocks.field_196604_cC || block == Blocks.field_205164_gk;
    }

    private boolean isAirBelow(IBlockReader reader, BlockPos pos) {
        return reader.func_180495_p(pos.func_177977_b()).func_185904_a() == Material.field_151579_a;
    }

    private BlockState appropriateBlockForNeighbors(IWorld worldIn, BlockPos pos) {
        boolean bordersWater = false;
        boolean bordersAir = false;
        BlockState[] blockArray = new BlockState[5];
        int i = 0;
        for (Direction face : Direction.values()) {
            BlockState iblockstate;
            if (face == Direction.UP) continue;
            blockArray[i] = iblockstate = worldIn.func_180495_p(pos.func_177972_a(face));
            ++i;
            if (this.isIce(iblockstate.func_177230_c())) continue;
            if (iblockstate.func_185904_a() == Material.field_151579_a) {
                bordersAir = true;
                continue;
            }
            if (iblockstate.func_204520_s().func_206888_e()) continue;
            bordersWater = true;
        }
        if (bordersWater && bordersAir) {
            return STONE;
        }
        if (bordersWater) {
            return WATER;
        }
        if (bordersAir) {
            return AIR;
        }
        return PACKED_ICE;
    }

    private void func_205186_a(IWorld worldIn, BlockPos pos, int smallRadiusIn, int height, boolean flag, int largeRadiusIn) {
        int radius = flag ? largeRadiusIn : smallRadiusIn / 2;
        for (int j = -radius; j <= radius; ++j) {
            for (int k = -radius; k <= radius; ++k) {
                for (int l = 0; l <= height; ++l) {
                    BlockPos blockpos = pos.func_177982_a(j, l, k);
                    Block block = worldIn.func_180495_p(blockpos).func_177230_c();
                    if (!this.isIce(block) && block != Blocks.field_150433_aE) continue;
                    if (this.isAirBelow((IBlockReader)worldIn, blockpos)) {
                        this.func_202278_a((IWorldWriter)worldIn, blockpos, this.appropriateBlockForNeighbors(worldIn, blockpos));
                        this.func_202278_a((IWorldWriter)worldIn, blockpos.func_177984_a(), this.appropriateBlockForNeighbors(worldIn, blockpos));
                        continue;
                    }
                    if (!this.isIce(block)) continue;
                    Block[] ablock = new Block[]{worldIn.func_180495_p(blockpos.func_177976_e()).func_177230_c(), worldIn.func_180495_p(blockpos.func_177974_f()).func_177230_c(), worldIn.func_180495_p(blockpos.func_177978_c()).func_177230_c(), worldIn.func_180495_p(blockpos.func_177968_d()).func_177230_c()};
                    int i1 = 0;
                    for (Block block1 : ablock) {
                        if (this.isIce(block1)) continue;
                        ++i1;
                    }
                    if (i1 < 3) continue;
                    this.func_202278_a((IWorldWriter)worldIn, blockpos, this.appropriateBlockForNeighbors(worldIn, blockpos));
                }
            }
        }
    }
}

