/*
 * Decompiled with CFR 0.152.
 */
package net.telepathicgrunt.ultraamplified.world.feature;

import com.mojang.datafixers.Dynamic;
import java.util.HashSet;
import java.util.Random;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldWriter;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.GenerationSettings;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.NoFeatureConfig;
import net.telepathicgrunt.ultraamplified.config.ConfigUA;

public class IceSpikeUA
extends Feature<NoFeatureConfig> {
    protected static final Set<BlockState> ALLOWED_BLOCKS = Stream.of(Blocks.field_150350_a.func_176223_P(), Blocks.field_201941_jj.func_176223_P(), Blocks.field_150432_aD.func_176223_P(), Blocks.field_150403_cj.func_176223_P(), Blocks.field_150433_aE.func_176223_P(), Blocks.field_196604_cC.func_176223_P(), Blocks.field_150346_d.func_176223_P(), Blocks.field_196660_k.func_176223_P(), Blocks.field_150355_j.func_176223_P()).collect(Collectors.toCollection(HashSet::new));
    private static final BlockState WATER = Blocks.field_150355_j.func_176223_P();
    private static final BlockState ICE = Blocks.field_150432_aD.func_176223_P();
    private static final BlockState PACKED_ICE = Blocks.field_150403_cj.func_176223_P();

    public IceSpikeUA(Function<Dynamic<?>, ? extends NoFeatureConfig> configFactoryIn) {
        super(configFactoryIn);
    }

    public boolean place(IWorld worldIn, ChunkGenerator<? extends GenerationSettings> changedBlock, Random rand, BlockPos position, NoFeatureConfig p_212245_5_) {
        while ((worldIn.func_175623_d(position) || worldIn.func_180495_p(position) == Blocks.field_150355_j.func_176223_P()) && position.func_177956_o() > 2) {
            position = position.func_177977_b();
        }
        if (worldIn.func_180495_p(position).func_177230_c() != Blocks.field_196604_cC) {
            return false;
        }
        position = position.func_177981_b(rand.nextInt(4));
        int i = rand.nextInt(4) + 7;
        int j = i / 4 + rand.nextInt(2);
        if (j > 1 && rand.nextInt(40) == 0) {
            position = position.func_177956_o() + 130 > 245 ? position.func_177981_b(245 - position.func_177956_o()) : position.func_177981_b(30 + rand.nextInt(100));
        }
        for (int y = 0; y < i; ++y) {
            float f = (1.0f - (float)y / (float)i) * (float)j;
            int l = MathHelper.func_76123_f((float)f);
            for (int x = -l; x <= l; ++x) {
                float f1 = (float)MathHelper.func_76130_a((int)x) - 0.25f;
                for (int z = -l; z <= l; ++z) {
                    float f2 = (float)MathHelper.func_76130_a((int)z) - 0.25f;
                    if ((x != 0 || z != 0) && !(f1 * f1 + f2 * f2 <= f * f) || (x == -l || x == l || z == -l || z == l) && !(rand.nextFloat() <= 0.75f)) continue;
                    BlockState iblockstate = worldIn.func_180495_p(position.func_177982_a(x, y, z));
                    if (ALLOWED_BLOCKS.contains(iblockstate) && position.func_177982_a(x, y, z).func_177956_o() > ConfigUA.seaLevel - 2) {
                        this.func_202278_a((IWorldWriter)worldIn, position.func_177982_a(x, y, z), PACKED_ICE);
                    } else if (iblockstate == WATER) {
                        this.func_202278_a((IWorldWriter)worldIn, position.func_177982_a(x, y, z), ICE);
                    }
                    if (y == 0 || l <= 1) continue;
                    iblockstate = worldIn.func_180495_p(position.func_177982_a(x, -y, z));
                    if (ALLOWED_BLOCKS.contains(iblockstate) && position.func_177982_a(x, -y, z).func_177956_o() > ConfigUA.seaLevel - 2) {
                        this.func_202278_a((IWorldWriter)worldIn, position.func_177982_a(x, -y, z), PACKED_ICE);
                        continue;
                    }
                    if (iblockstate != WATER) continue;
                    this.func_202278_a((IWorldWriter)worldIn, position.func_177982_a(x, -y, z), ICE);
                }
            }
        }
        int k1 = j - 1;
        if (k1 < 0) {
            k1 = 0;
        } else if (k1 > 1) {
            k1 = 1;
        }
        for (int x = -k1; x <= k1; ++x) {
            for (int z = -k1; z <= k1; ++z) {
                BlockState iblockstate1;
                BlockPos blockpos = position.func_177982_a(x, -1, z);
                int j2 = 50;
                if (Math.abs(x) == 1 && Math.abs(z) == 1) {
                    j2 = rand.nextInt(5);
                }
                while (blockpos.func_177956_o() > 5 && ALLOWED_BLOCKS.contains(iblockstate1 = worldIn.func_180495_p(blockpos))) {
                    if (iblockstate1 == WATER || iblockstate1 == ICE) {
                        this.func_202278_a((IWorldWriter)worldIn, blockpos, Blocks.field_150432_aD.func_176223_P());
                    } else {
                        this.func_202278_a((IWorldWriter)worldIn, blockpos, Blocks.field_150403_cj.func_176223_P());
                    }
                    blockpos = blockpos.func_177977_b();
                    if (--j2 > 0) continue;
                    blockpos = blockpos.func_177979_c(rand.nextInt(5) + 1);
                    j2 = rand.nextInt(5);
                }
            }
        }
        return true;
    }
}

