/*
 * Decompiled with CFR 0.152.
 */
package net.telepathicgrunt.ultraamplified.world.feature;

import com.mojang.datafixers.Dynamic;
import java.util.Random;
import java.util.function.Function;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorld;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.GenerationSettings;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.NoFeatureConfig;

public class GreenPowConcretePatch
extends Feature<NoFeatureConfig> {
    private final BlockState greenConcretePowder = Blocks.field_196882_jf.func_176223_P();
    private final int maximumRadius = 6;

    public GreenPowConcretePatch(Function<Dynamic<?>, ? extends NoFeatureConfig> configFactoryIn) {
        super(configFactoryIn);
    }

    public boolean place(IWorld worldIn, ChunkGenerator<? extends GenerationSettings> changedBlock, Random rand, BlockPos position, NoFeatureConfig p_212245_5_) {
        int radius = rand.nextInt(this.maximumRadius - 2) + 2;
        for (int x = position.func_177958_n() - radius; x <= position.func_177958_n() + radius; ++x) {
            for (int z = position.func_177952_p() - radius; z <= position.func_177952_p() + radius; ++z) {
                int zDiff;
                int xDiff = x - position.func_177958_n();
                if (xDiff * xDiff + (zDiff = z - position.func_177952_p()) * zDiff > radius * radius) continue;
                for (int y = position.func_177956_o() - 2; y <= position.func_177956_o() + 2; ++y) {
                    BlockPos blockpos = new BlockPos(x, y, z);
                    Block block = worldIn.func_180495_p(blockpos).func_177230_c();
                    if (block != Blocks.field_150346_d && block != Blocks.field_196658_i) continue;
                    worldIn.func_180501_a(blockpos, this.greenConcretePowder, 2);
                }
            }
        }
        return true;
    }
}

