/*
 * Decompiled with CFR 0.152.
 */
package net.telepathicgrunt.ultraamplified.world.feature;

import com.mojang.datafixers.Dynamic;
import java.util.HashSet;
import java.util.Random;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IWorld;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.GenerationSettings;
import net.minecraft.world.gen.feature.BlockBlobConfig;
import net.minecraft.world.gen.feature.Feature;
import net.telepathicgrunt.ultraamplified.config.ConfigUA;

public class GiantStackableBoulder
extends Feature<BlockBlobConfig> {
    private static final BlockState mossyCobblestone = Blocks.field_150341_Y.func_176223_P();
    private static final BlockState cobblestone = Blocks.field_150347_e.func_176223_P();
    private static final BlockState andesite = Blocks.field_196656_g.func_176223_P();
    private static final BlockState coalOre = Blocks.field_150365_q.func_176223_P();
    private static final BlockState ironOre = Blocks.field_150366_p.func_176223_P();
    private static final BlockState diamondOre = Blocks.field_150482_ag.func_176223_P();
    private static final int startRadius = 4;
    protected static final Set<BlockState> acceptableBlocks = Stream.of(Blocks.field_150346_d.func_176223_P(), Blocks.field_196658_i.func_176223_P(), Blocks.field_185774_da.func_176223_P(), Blocks.field_196661_l.func_176223_P(), mossyCobblestone, cobblestone, andesite, coalOre, ironOre, diamondOre).collect(Collectors.toCollection(HashSet::new));

    public GiantStackableBoulder(Function<Dynamic<?>, ? extends BlockBlobConfig> configFactoryIn) {
        super(configFactoryIn);
    }

    public boolean place(IWorld worldIn, ChunkGenerator<? extends GenerationSettings> p_212245_2_, Random rand, BlockPos position, BlockBlobConfig p_212245_5_) {
        BlockState block;
        BlockPos tempPos = new BlockPos(position.func_177958_n() + rand.nextInt(3), 249, position.func_177952_p() + rand.nextInt(3));
        for (int boulderSpawned = 0; boulderSpawned < 15 && !acceptableBlocks.contains(block = worldIn.func_180495_p(tempPos)); ++boulderSpawned) {
            while (tempPos.func_177956_o() > 7) {
                if ((tempPos = tempPos.func_177977_b()).func_177956_o() <= 8 || tempPos.func_177956_o() >= 250) {
                    return false;
                }
                block = worldIn.func_180495_p(tempPos.func_177977_b());
                if (!acceptableBlocks.contains(block)) continue;
            }
            for (int currentCount = 0; currentCount < 3; ++currentCount) {
                int x = 4 + rand.nextInt(2);
                int y = 4 + rand.nextInt(2);
                int z = 4 + rand.nextInt(2);
                float calculatedDistance = (float)(x + y + z) * 0.333f + 0.5f;
                for (BlockPos blockpos : BlockPos.func_218278_a((BlockPos)tempPos.func_177982_a(-x, -y, -z), (BlockPos)tempPos.func_177982_a(x, y, z))) {
                    if (!(blockpos.func_177951_i((Vec3i)tempPos) <= (double)(calculatedDistance * calculatedDistance))) continue;
                    int randomChance = rand.nextInt(1400);
                    if (ConfigUA.diamondOreSpawnrate != 0 && randomChance <= 1) {
                        worldIn.func_180501_a(blockpos, diamondOre, 4);
                        continue;
                    }
                    if (ConfigUA.ironOreSpawnrate != 0 && randomChance <= 50) {
                        worldIn.func_180501_a(blockpos, ironOre, 4);
                        continue;
                    }
                    if (ConfigUA.coalOreSpawnrate != 0 && randomChance <= 130) {
                        worldIn.func_180501_a(blockpos, coalOre, 4);
                        continue;
                    }
                    if (randomChance <= 480) {
                        worldIn.func_180501_a(blockpos, andesite, 4);
                        continue;
                    }
                    if (randomChance <= 750) {
                        worldIn.func_180501_a(blockpos, cobblestone, 4);
                        continue;
                    }
                    worldIn.func_180501_a(blockpos, mossyCobblestone, 4);
                }
                tempPos = tempPos.func_177982_a(-5 + rand.nextInt(4), 0 - rand.nextInt(2), -5 + rand.nextInt(4));
            }
            tempPos = new BlockPos(position.func_177958_n() + rand.nextInt(3), 249, position.func_177952_p() + rand.nextInt(3));
        }
        return true;
    }
}

