/*
 * Decompiled with CFR 0.152.
 */
package net.telepathicgrunt.ultraamplified.world.feature;

import com.mojang.datafixers.Dynamic;
import java.util.Random;
import java.util.Set;
import java.util.function.Function;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.material.Material;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldWriter;
import net.minecraft.world.gen.IWorldGenerationBaseReader;
import net.minecraft.world.gen.IWorldGenerationReader;
import net.minecraft.world.gen.feature.AbstractTreeFeature;
import net.minecraft.world.gen.feature.NoFeatureConfig;
import net.minecraftforge.common.IPlantable;

public class EndTreeUA
extends AbstractTreeFeature<NoFeatureConfig> {
    private static final BlockState LOG = Blocks.field_196619_M.func_176223_P();
    private static final BlockState LEAF = Blocks.field_196574_ab.func_176223_P();
    private static final BlockState PURPLE_TERRACOTTA = Blocks.field_196797_fz.func_176223_P();

    public EndTreeUA(Function<Dynamic<?>, ? extends NoFeatureConfig> configIn, boolean doBlockNotifyIn) {
        super(configIn, doBlockNotifyIn);
        this.setSapling((IPlantable)Blocks.field_196676_v);
    }

    public boolean func_208519_a(Set<BlockPos> changedBlocks, IWorldGenerationReader worldIn, Random rand, BlockPos position, MutableBoundingBox p_208519_5_) {
        int i = rand.nextInt(3) + 5;
        boolean flag = true;
        if (position.func_177956_o() >= 1 && position.func_177956_o() + i + 1 <= worldIn.getMaxHeight()) {
            for (int j = position.func_177956_o(); j <= position.func_177956_o() + 1 + i; ++j) {
                int k = 1;
                if (j == position.func_177956_o()) {
                    k = 0;
                }
                if (j >= position.func_177956_o() + 1 + i - 2) {
                    k = 2;
                }
                BlockPos.MutableBlockPos blockpos$mutableblockpos = new BlockPos.MutableBlockPos();
                for (int l = position.func_177958_n() - k; l <= position.func_177958_n() + k && flag; ++l) {
                    for (int i1 = position.func_177952_p() - k; i1 <= position.func_177952_p() + k && flag; ++i1) {
                        if (j >= 0 && j < worldIn.getMaxHeight()) {
                            if (EndTreeUA.func_214587_a((IWorldGenerationBaseReader)worldIn, (BlockPos)blockpos$mutableblockpos.func_181079_c(l, j, i1))) continue;
                            flag = false;
                            continue;
                        }
                        flag = false;
                    }
                }
            }
            if (!flag) {
                return false;
            }
            if (EndTreeUA.isSoil((IWorldGenerationBaseReader)worldIn, (BlockPos)position.func_177977_b(), (IPlantable)this.getSapling()) && position.func_177956_o() < worldIn.getMaxHeight() - i - 1) {
                this.placeTerracottaCircle((IWorld)worldIn, position.func_177977_b());
                for (int l1 = position.func_177956_o() - 3 + i; l1 <= position.func_177956_o() + i; ++l1) {
                    int j2 = l1 - (position.func_177956_o() + i);
                    int k2 = 1 - j2 / 2;
                    for (int l2 = position.func_177958_n() - k2; l2 <= position.func_177958_n() + k2; ++l2) {
                        int i3 = l2 - position.func_177958_n();
                        for (int j1 = position.func_177952_p() - k2; j1 <= position.func_177952_p() + k2; ++j1) {
                            BlockPos blockpos;
                            int k1 = j1 - position.func_177952_p();
                            if (Math.abs(i3) == k2 && Math.abs(k1) == k2 && (rand.nextInt(2) == 0 || j2 == 0) || !EndTreeUA.func_214572_g((IWorldGenerationBaseReader)worldIn, (BlockPos)(blockpos = new BlockPos(l2, l1, j1)))) continue;
                            this.func_208520_a(changedBlocks, (IWorldWriter)worldIn, blockpos, LEAF, p_208519_5_);
                        }
                    }
                }
                for (int i2 = 0; i2 < i; ++i2) {
                    if (!EndTreeUA.func_214572_g((IWorldGenerationBaseReader)worldIn, (BlockPos)position.func_177981_b(i2))) continue;
                    this.func_208520_a(changedBlocks, (IWorldWriter)worldIn, position.func_177981_b(i2), LOG, p_208519_5_);
                }
                return true;
            }
            return false;
        }
        return false;
    }

    private void placeTerracottaCircle(IWorld worldIn, BlockPos center) {
        for (int x = -2; x <= 2; ++x) {
            for (int z = -2; z <= 2; ++z) {
                if (Math.abs(x) + Math.abs(z) >= 3) continue;
                this.placeTerracottaAt(worldIn, center.func_177982_a(x, 0, z));
            }
        }
    }

    private void placeTerracottaAt(IWorld worldIn, BlockPos pos) {
        for (int level = 2; level >= -3; --level) {
            BlockPos blockpos = pos.func_177981_b(level);
            BlockState iblockstate = worldIn.func_180495_p(blockpos);
            Block block = iblockstate.func_177230_c();
            if (block == Blocks.field_196658_i || block == Blocks.field_150346_d) {
                this.func_202278_a((IWorldWriter)worldIn, blockpos, PURPLE_TERRACOTTA);
                break;
            }
            if (iblockstate.func_185904_a() != Material.field_151579_a && level < 0) break;
        }
    }
}

