/*
 * Decompiled with CFR 0.152.
 */
package net.telepathicgrunt.ultraamplified.world.feature;

import com.mojang.datafixers.Dynamic;
import java.util.BitSet;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import java.util.function.Function;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.util.Direction;
import net.minecraft.util.SharedSeedRandom;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.chunk.IChunk;
import net.minecraft.world.gen.OctavesNoiseGenerator;
import net.minecraft.world.gen.carver.WorldCarver;
import net.minecraft.world.gen.feature.ProbabilityConfig;

public class CaveCavityCarver
extends WorldCarver<ProbabilityConfig> {
    private final float[] field_202536_i = new float[1024];
    protected long seed;
    protected OctavesNoiseGenerator noiseGen;
    protected BlockState fillerBlock = Blocks.field_150348_b.func_176223_P();
    protected static final BlockState STONE = Blocks.field_150348_b.func_176223_P();
    protected static final BlockState LAVA = Blocks.field_150353_l.func_176223_P();
    protected static final BlockState WATER = Blocks.field_150355_j.func_176223_P();
    protected static final BlockState MAGMA = Blocks.field_196814_hQ.func_176223_P();
    protected static final BlockState OBSIDIAN = Blocks.field_150343_Z.func_176223_P();
    private static final Map<BlockState, BlockState> fillerMap = CaveCavityCarver.createMap();

    private static Map<BlockState, BlockState> createMap() {
        HashMap<BlockState, BlockState> result = new HashMap<BlockState, BlockState>();
        result.put(Blocks.field_150424_aL.func_176223_P(), Blocks.field_150424_aL.func_176223_P());
        result.put(Blocks.field_150432_aD.func_176223_P(), Blocks.field_150432_aD.func_176223_P());
        result.put(Blocks.field_196604_cC.func_176223_P(), Blocks.field_150432_aD.func_176223_P());
        result.put(Blocks.field_150377_bs.func_176223_P(), Blocks.field_150377_bs.func_176223_P());
        result.put(Blocks.field_150353_l.func_176223_P(), Blocks.field_150353_l.func_176223_P());
        return Collections.unmodifiableMap(result);
    }

    public CaveCavityCarver(Function<Dynamic<?>, ? extends ProbabilityConfig> probabilityConfig, int maximumHeight) {
        super(probabilityConfig, maximumHeight);
    }

    public void setSeed(long seed) {
        if (this.noiseGen == null) {
            this.noiseGen = new OctavesNoiseGenerator((Random)new SharedSeedRandom(seed), 4);
        }
        this.seed = seed;
    }

    public boolean shouldCarve(Random randomIn, int chunkX, int chunkZ, ProbabilityConfig config) {
        return randomIn.nextFloat() <= config.field_203622_a;
    }

    public boolean carve(IChunk region, Random random, int seaLevel, int chunkX, int chunkZ, int originalX, int originalZ, BitSet mask, ProbabilityConfig config) {
        int i = (this.func_222704_c() * 2 - 1) * 16;
        double xpos = chunkX * 16 + random.nextInt(16);
        double height = random.nextInt(random.nextInt(2) + 1) + 34;
        double zpos = chunkZ * 16 + random.nextInt(16);
        float xzNoise2 = random.nextFloat() * (float)Math.PI;
        float xzCosNoise = (random.nextFloat() - 0.5f) / 16.0f;
        float widthHeightBase = (random.nextFloat() + random.nextFloat()) / 16.0f;
        this.func_222729_a(region, random.nextLong(), seaLevel, originalX, originalZ, xpos, height, zpos, widthHeightBase, xzNoise2, xzCosNoise, 0, i, random.nextDouble() + 20.0, mask);
        return true;
    }

    private void func_222729_a(IChunk worldIn, long randomSeed, int seaLevel, int mainChunkX, int mainChunkZ, double randomBlockX, double randomBlockY, double randomBlockZ, float widthHeightBase, float xzNoise2, float xzCosNoise, int startIteration, int maxIteration, double heightMultiplier, BitSet mask) {
        this.setSeed(randomSeed);
        Random random = new Random(randomSeed);
        float f = 1.0f;
        for (int i = 0; i < 256; ++i) {
            if (i == 0 || random.nextInt(3) == 0) {
                f = 1.0f + random.nextFloat() * 0.5f;
            }
            this.field_202536_i[i] = f;
        }
        float f4 = 0.0f;
        float f1 = 0.0f;
        for (int currentRoom = startIteration; currentRoom < maxIteration; ++currentRoom) {
            double placementXZBound = 2.0 + (double)(MathHelper.func_76126_a((float)((float)currentRoom * (float)Math.PI / (float)maxIteration)) * widthHeightBase);
            double placementYBound = placementXZBound * heightMultiplier;
            placementXZBound *= 23.0;
            placementYBound *= 2.2;
            float f2 = MathHelper.func_76134_b((float)xzCosNoise);
            randomBlockX += (double)(MathHelper.func_76134_b((float)xzNoise2) * f2);
            randomBlockZ += (double)(MathHelper.func_76126_a((float)xzNoise2) * f2);
            xzCosNoise *= 0.5f;
            xzCosNoise += f1 * 0.04f;
            xzNoise2 += f4 * 0.05f;
            f1 *= 0.8f;
            f4 *= 0.5f;
            f1 += (random.nextFloat() - random.nextFloat()) * random.nextFloat() * 1.5f;
            f4 += (random.nextFloat() - random.nextFloat()) * random.nextFloat() * 3.0f;
            if (!this.func_222702_a(mainChunkX, mainChunkZ, randomBlockX, randomBlockZ, currentRoom, maxIteration, widthHeightBase)) {
                return;
            }
            this.carveAtTarget(worldIn, random, randomSeed, mainChunkX, mainChunkZ, randomBlockX, randomBlockY, randomBlockZ, placementXZBound, placementYBound, mask);
        }
    }

    protected boolean carveAtTarget(IChunk worldIn, Random random, long seed, int mainChunkX, int mainChunkZ, double xRange, double yRange, double zRange, double placementXZBound, double placementYBound, BitSet mask) {
        double xPos = mainChunkX * 16 + 8;
        double zPos = mainChunkZ * 16 + 8;
        double targetedHeight = 14.0;
        if (!(xRange < xPos - 16.0 - placementXZBound * 2.0 || zRange < zPos - 16.0 - placementXZBound * 2.0 || xRange > xPos + 16.0 + placementXZBound * 2.0 || zRange > zPos + 16.0 + placementXZBound * 2.0)) {
            int xMin = Math.max(MathHelper.func_76128_c((double)(xRange - placementXZBound)) - mainChunkX * 16 - 1, 0);
            int xMax = Math.min(MathHelper.func_76128_c((double)(xRange + placementXZBound)) - mainChunkX * 16 + 1, 16);
            int yMin = Math.max(MathHelper.func_76128_c((double)(yRange - placementYBound)) - 1, 5);
            int yMax = Math.min(MathHelper.func_76128_c((double)(yRange + placementYBound)) + 1, this.field_222720_l);
            int zMin = Math.max(MathHelper.func_76128_c((double)(zRange - placementXZBound)) - mainChunkZ * 16 - 1, 0);
            int zMax = Math.min(MathHelper.func_76128_c((double)(zRange + placementXZBound)) - mainChunkZ * 16 + 1, 16);
            if (xMin <= xMax && yMin <= yMax && zMin <= zMax) {
                boolean flag = false;
                BlockPos.MutableBlockPos blockpos$mutableblockpos = new BlockPos.MutableBlockPos();
                BlockPos.MutableBlockPos blockpos$mutableblockpos1 = new BlockPos.MutableBlockPos();
                BlockPos.MutableBlockPos blockpos$mutableblockpos2 = new BlockPos.MutableBlockPos();
                for (int smallX = xMin; smallX < xMax; ++smallX) {
                    int x = smallX + mainChunkX * 16;
                    double d2 = ((double)x + 0.5 - xRange) / placementXZBound;
                    for (int smallZ = zMin; smallZ < zMax; ++smallZ) {
                        int yMaxSum;
                        int z = smallZ + mainChunkZ * 16;
                        double d3 = ((double)z + 0.5 - zRange) / placementXZBound;
                        if (!(d2 * d2 + d3 * d3 < 1.0) || (yMaxSum = (int)((float)yMax - (1.0f + random.nextFloat()) * random.nextFloat() * 20.0f)) < yMin) continue;
                        blockpos$mutableblockpos.func_181079_c(x, 60, z);
                        this.fillerBlock = fillerMap.get(worldIn.func_217309_c((BlockPos)blockpos$mutableblockpos).func_203944_q().func_204108_a());
                        if (this.fillerBlock == null) {
                            this.fillerBlock = STONE;
                        }
                        for (int y = yMaxSum; y > yMin; --y) {
                            int l2;
                            boolean flagStalagmites;
                            double d4 = ((double)(y - 1) + 0.5 - yRange) / placementYBound;
                            double yModified = (double)y - 6.4;
                            if (y < 10) {
                                yModified += 1.0;
                            } else if (yModified <= 0.0) {
                                yModified = 1.0E-5;
                            }
                            boolean flagPillars = this.noiseGen.func_205563_a((double)x * 0.2, (double)z * 0.2, (double)y * 0.035) - targetedHeight / yModified + random.nextDouble() * 0.1 > -3.5;
                            boolean bl = flagStalagmites = this.noiseGen.func_205563_a((double)x * 0.63125, (double)z * 0.63125, (double)y * 0.04) + (double)(360 / y) + random.nextDouble() * 0.1 > 2.8;
                            if (!flagPillars || !flagStalagmites || !((d2 * d2 + d3 * d3) * (double)this.field_202536_i[y - 1] + d4 * d4 / 6.0 < 1.0) || mask.get(l2 = smallX | smallZ << 4 | y << 8)) continue;
                            mask.set(l2);
                            blockpos$mutableblockpos.func_181079_c(x, y, z);
                            BlockState iblockstate = worldIn.func_180495_p((BlockPos)blockpos$mutableblockpos);
                            blockpos$mutableblockpos1.func_189533_g((Vec3i)blockpos$mutableblockpos).func_189536_c(Direction.UP);
                            blockpos$mutableblockpos2.func_189533_g((Vec3i)blockpos$mutableblockpos).func_189536_c(Direction.DOWN);
                            BlockState iblockstate1 = worldIn.func_180495_p((BlockPos)blockpos$mutableblockpos1);
                            if (!iblockstate.func_204520_s().func_206888_e()) {
                                worldIn.func_177436_a((BlockPos)blockpos$mutableblockpos, this.fillerBlock, false);
                                continue;
                            }
                            if (y >= 11 && !iblockstate1.func_204520_s().func_206888_e()) {
                                worldIn.func_177436_a((BlockPos)blockpos$mutableblockpos, this.fillerBlock, false);
                                worldIn.func_177436_a((BlockPos)blockpos$mutableblockpos1, this.fillerBlock, false);
                                worldIn.func_177436_a((BlockPos)blockpos$mutableblockpos2, this.fillerBlock, false);
                                flag = true;
                                continue;
                            }
                            if (!this.func_222707_a(iblockstate, iblockstate1) && !fillerMap.containsKey(iblockstate)) continue;
                            if (y < 11) {
                                worldIn.func_177436_a((BlockPos)blockpos$mutableblockpos, LAVA, false);
                            } else {
                                boolean bordersFluid = false;
                                for (Direction direction : Direction.Plane.HORIZONTAL) {
                                    if (worldIn.func_180495_p(blockpos$mutableblockpos.func_177972_a(direction)).func_204520_s().func_206888_e()) continue;
                                    bordersFluid = true;
                                }
                                if (y != 11 && !worldIn.func_180495_p(blockpos$mutableblockpos.func_177977_b()).func_204520_s().func_206888_e()) {
                                    bordersFluid = true;
                                }
                                if (!worldIn.func_180495_p(blockpos$mutableblockpos.func_177984_a()).func_204520_s().func_206888_e()) {
                                    bordersFluid = true;
                                }
                                if (bordersFluid) {
                                    worldIn.func_177436_a((BlockPos)blockpos$mutableblockpos, this.fillerBlock, false);
                                } else {
                                    worldIn.func_177436_a((BlockPos)blockpos$mutableblockpos, field_222715_g.getBlockState(), false);
                                }
                            }
                            flag = true;
                        }
                    }
                }
                return flag;
            }
            return false;
        }
        return false;
    }

    protected boolean func_222708_a(double p_222708_1_, double p_222708_3_, double p_222708_5_, int p_222708_7_) {
        return (p_222708_1_ * p_222708_1_ + p_222708_5_ * p_222708_5_) * (double)this.field_202536_i[p_222708_7_ - 1] + p_222708_3_ * p_222708_3_ / 6.0 >= 1.0;
    }
}

