/*
 * Decompiled with CFR 0.152.
 */
package net.telepathicgrunt.ultraamplified.world.dimension;

import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.dimension.Dimension;
import net.minecraft.world.dimension.DimensionType;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.ChunkGeneratorType;
import net.minecraft.world.gen.GenerationSettings;
import net.minecraft.world.gen.Heightmap;
import net.minecraft.world.gen.OverworldGenSettings;
import net.minecraft.world.gen.feature.IFeatureConfig;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.telepathicgrunt.ultraamplified.blocks.BlocksInit;
import net.telepathicgrunt.ultraamplified.config.ConfigUA;
import net.telepathicgrunt.ultraamplified.world.feature.AmplifiedPortalFrame;
import net.telepathicgrunt.ultraamplified.world.generation.BiomeProviderUA;
import net.telepathicgrunt.ultraamplified.world.generation.UAChunkGenerator;

public class UltraAmplifiedWorldProvider
extends Dimension {
    private boolean generatedPortal = false;

    public UltraAmplifiedWorldProvider(World worldIn, DimensionType typeIn) {
        super(worldIn, typeIn);
    }

    public BlockPos func_206920_a(ChunkPos chunkPosIn, boolean checkValid) {
        BlockPos blockpos = this.field_76579_a.func_205770_a(Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, new BlockPos(10, 90, 8));
        return this.field_76579_a.func_184141_c(blockpos).func_185904_a().func_76230_c() ? blockpos : null;
    }

    public BlockPos func_206921_a(int posX, int posZ, boolean checkValid) {
        return this.func_206920_a(new ChunkPos(posX, posZ), checkValid);
    }

    public float func_76563_a(long worldTime, float partialTicks) {
        double d0 = MathHelper.func_181162_h((double)((double)worldTime / 24000.0 - 0.25));
        double d1 = 0.5 - Math.cos(d0 * Math.PI) / 2.0;
        return (float)(d0 * 2.0 + d1) / 3.0f;
    }

    @OnlyIn(value=Dist.CLIENT)
    public float func_76571_f() {
        return ConfigUA.yMaximum + 2;
    }

    public int getActualHeight() {
        return 256;
    }

    public boolean func_76569_d() {
        return true;
    }

    public Vec3d func_76562_b(float celestialAngle, float partialTicks) {
        float f = MathHelper.func_76134_b((float)(celestialAngle * ((float)Math.PI * 2))) * 2.0f + 0.5f;
        f = MathHelper.func_76131_a((float)f, (float)0.0f, (float)1.0f);
        float f1 = 0.7529412f;
        float f2 = 0.84705883f;
        float f3 = 1.0f;
        float multiplierOfBrightness = ((float)Minecraft.func_71410_x().field_71439_g.func_174824_e((float)partialTicks).field_72448_b - 85.0f) / (float)(ConfigUA.yMaximum - 85);
        Math.min(Math.max(multiplierOfBrightness, 0.0f), 1.0f);
        f1 = f1 * (f * 0.94f + 0.06f) * multiplierOfBrightness;
        f2 = f2 * (f * 0.94f + 0.06f) * multiplierOfBrightness;
        f3 = f3 * (f * 0.91f + 0.09f) * multiplierOfBrightness;
        return new Vec3d((double)f1, (double)f2, (double)f3);
    }

    @OnlyIn(value=Dist.CLIENT)
    public double func_76565_k() {
        return 70.0;
    }

    public boolean func_76567_e() {
        return false;
    }

    public boolean func_76568_b(int x, int z) {
        return false;
    }

    public ChunkGenerator<?> func_186060_c() {
        return new UAChunkGenerator((IWorld)this.field_76579_a, new BiomeProviderUA(this.field_76579_a), (OverworldGenSettings)ChunkGeneratorType.field_206911_b.func_205483_a());
    }

    public void func_186059_r() {
        if (!this.generatedPortal) {
            if (!this.checkForGeneratedPortal()) {
                this.generatePortal();
            }
            this.generatedPortal = true;
        }
    }

    private boolean checkForGeneratedPortal() {
        BlockPos pos = new BlockPos(8, 255, 8);
        this.field_76579_a.func_175726_f(pos);
        while (pos.func_177956_o() >= 0) {
            if (this.field_76579_a.func_180495_p(pos) == BlocksInit.AMPLIFIEDPORTAL.func_176223_P()) {
                return true;
            }
            pos = pos.func_177977_b();
        }
        return false;
    }

    private void generatePortal() {
        AmplifiedPortalFrame amplifiedportalfeature = new AmplifiedPortalFrame();
        BlockPos pos = new BlockPos(8, 255, 8);
        this.field_76579_a.func_175726_f(pos);
        pos = this.field_76579_a.func_205770_a(Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, pos);
        if (pos.func_177956_o() > 252) {
            pos = pos.func_177979_c(3);
        } else if (pos.func_177956_o() < 6) {
            pos = new BlockPos(pos.func_177958_n(), 6, pos.func_177952_p());
        }
        amplifiedportalfeature.place((IWorld)this.field_76579_a, (ChunkGenerator<? extends GenerationSettings>)this.field_76579_a.func_72863_F().func_201711_g(), new Random(), pos, IFeatureConfig.field_202429_e);
    }
}

