/*
 * Decompiled with CFR 0.152.
 */
package net.telepathicgrunt.ultraamplified.world.dimension;

import com.google.common.collect.ImmutableList;
import com.telepathicgrunt.ultraamplified.UltraAmplified;
import java.lang.reflect.Field;
import java.util.function.BiFunction;
import java.util.function.IntSupplier;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraft.world.dimension.Dimension;
import net.minecraft.world.dimension.DimensionType;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.common.ModDimension;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.event.world.RegisterDimensionsEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.network.FMLHandshakeMessages;
import net.minecraftforge.fml.network.FMLNetworkConstants;
import net.minecraftforge.fml.network.NetworkEvent;
import net.minecraftforge.fml.network.simple.SimpleChannel;
import net.minecraftforge.registries.ForgeRegistries;
import net.telepathicgrunt.ultraamplified.world.dimension.RegUtil;
import net.telepathicgrunt.ultraamplified.world.dimension.UltraAmplifiedWorldProvider;
import org.apache.commons.lang3.tuple.Pair;

@Mod.EventBusSubscriber(modid="ultra_amplified_mod", bus=Mod.EventBusSubscriber.Bus.MOD)
public class UltraAmplifiedDimension {
    public static final ModDimension ULTRAAMPLIFIED = new ModDimension(){

        public BiFunction<World, DimensionType, ? extends Dimension> getFactory() {
            return UltraAmplifiedWorldProvider::new;
        }
    };
    private static final ResourceLocation ULTRAAMPLIFIED_ID = new ResourceLocation("ultra_amplified_mod", "ultraamplified");

    @SubscribeEvent
    public static void registerModDimensions(RegistryEvent.Register<ModDimension> event) {
        RegUtil.generic(event.getRegistry()).add("ultraamplified", ULTRAAMPLIFIED);
    }

    public static DimensionType ultraamplified() {
        return DimensionType.func_193417_a((ResourceLocation)ULTRAAMPLIFIED_ID);
    }

    static {
        try {
            Field channelField = FMLNetworkConstants.class.getDeclaredField("handshakeChannel");
            channelField.setAccessible(true);
            SimpleChannel handshakeChannel = (SimpleChannel)channelField.get(null);
            handshakeChannel.messageBuilder(S2CDimensionSync.class, 100).loginIndex(S2CDimensionSync::getLoginIndex, S2CDimensionSync::setLoginIndex).decoder(S2CDimensionSync::decode).encoder(S2CDimensionSync::encode).buildLoginPacketList(isLocal -> {
                if (isLocal.booleanValue()) {
                    return ImmutableList.of();
                }
                return ImmutableList.of((Object)Pair.of((Object)"Ultra Amplified Dim Sync", (Object)new S2CDimensionSync(UltraAmplifiedDimension.ultraamplified())));
            }).consumer((msg, ctx) -> {
                if (DimensionManager.getRegistry().func_148745_a(msg.id) == null) {
                    DimensionManager.registerDimensionInternal((int)msg.id, (ResourceLocation)msg.name, (ModDimension)msg.dimension, null, (boolean)msg.skyLight);
                }
                ((NetworkEvent.Context)ctx.get()).setPacketHandled(true);
                handshakeChannel.reply((Object)new FMLHandshakeMessages.C2SAcknowledge(), (NetworkEvent.Context)ctx.get());
            }).add();
        }
        catch (ReflectiveOperationException e) {
            UltraAmplified.LOGGER.error("Failed to add dimension sync to handshake channel", (Throwable)e);
        }
    }

    public static class S2CDimensionSync
    implements IntSupplier {
        final int id;
        final ResourceLocation name;
        final ModDimension dimension;
        final boolean skyLight;
        private int loginIndex;

        public S2CDimensionSync(DimensionType dimensionType) {
            this.id = dimensionType.func_186068_a() + 1;
            this.name = DimensionType.func_212678_a((DimensionType)dimensionType);
            this.dimension = dimensionType.getModType();
            this.skyLight = dimensionType.func_218272_d();
        }

        S2CDimensionSync(int id, ResourceLocation name, ModDimension dimension, boolean skyLight) {
            this.id = id;
            this.name = name;
            this.dimension = dimension;
            this.skyLight = skyLight;
        }

        void setLoginIndex(int loginIndex) {
            this.loginIndex = loginIndex;
        }

        int getLoginIndex() {
            return this.loginIndex;
        }

        void encode(PacketBuffer buffer) {
            buffer.writeInt(this.id);
            buffer.func_192572_a(this.name);
            buffer.func_192572_a(this.dimension.getRegistryName());
            buffer.writeBoolean(this.skyLight);
        }

        public static S2CDimensionSync decode(PacketBuffer buffer) {
            int id = buffer.readInt();
            ResourceLocation name = buffer.func_192575_l();
            ModDimension dimension = (ModDimension)ForgeRegistries.MOD_DIMENSIONS.getValue(buffer.func_192575_l());
            boolean skyLight = buffer.readBoolean();
            return new S2CDimensionSync(id, name, dimension, skyLight);
        }

        @Override
        public int getAsInt() {
            return this.getLoginIndex();
        }
    }

    @Mod.EventBusSubscriber(modid="ultra_amplified_mod")
    private static class ForgeEvents {
        private ForgeEvents() {
        }

        @SubscribeEvent
        public static void registerDimensions(RegisterDimensionsEvent event) {
            if (DimensionType.func_193417_a((ResourceLocation)ULTRAAMPLIFIED_ID) == null) {
                DimensionManager.registerDimension((ResourceLocation)ULTRAAMPLIFIED_ID, (ModDimension)ULTRAAMPLIFIED, null, (boolean)true);
            }
        }
    }
}

